#ifndef lint
#ifdef sccs
static char     sccsid[] = "@(#)XSunIMCore.h	2.5 94/08/08 SMI";
#endif
#endif

/******************************************************************

              Copyright 1990, 1991, by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Hideki Hiura (hhiura@Sun.COM)
	  				     Sun Microsystems, Inc.
******************************************************************/

/*
 *  Base class "imlogic_session" declaration
 */

#ifndef xim_iml_session_DEFIND
#define xim_iml_session_DEFIND
#ifndef xim_iml_inheritance_DEFIND
typedef struct _iml_session {
#endif /* xim_iml_inheritance_DEFIND */

    struct _iml_session *next ;
    unsigned char *classname ; 
    unsigned char *enginename ;
    unsigned char *locale ;    /* locale for this IC */
    int language_engine ;/* ENGINE ID: to support multiple language engine */
    int session_id ;	/* to keep self identification. */
    int public_status ; /* This status can be set/got by IML_SET/GET_STATUS */
    int initial_public_status ;/* will be copied from public status per call */
    int private_status ;
    iml_inst        *remainder ; /* awaiting event put back returning */
    iml_inst        *remainder2 ;/* awaiting recall by RESULTS_REQUIRED */
    iml_inst       **rrv ;
    iml_inst_slot_t *short_term_slot; /* for new/delete */
    iml_inst_slot_t *long_term_slot;  /* for new2/delete2 */
    int active_regions ; /* used only for double check in post_proc */
    int current_active_region ; /* used during building iml_inst */

    XKeyEvent *event;
    KeySym     keysym;
    unsigned char      *XLookupBuf ;
    int        XLookupBuflen ;
    Status     status;
    void      *ic ;
    iml_if_t  *If ;
/*
 * Region Specific data
 *
 * Preedit region
 */
    int PreEditTextBufferSize ;
    int PreEditAttrBufferSize ;
    XIMPreeditDrawCallbackStruct PreEditTextInfo ; /* allocate once */
    int PreEditBufferSizeInCallback ;
/*
 * Status region
 */

    status_cache_t status_cache ;

/*
 * Lookup Choice region
 */

    WhoIsMaster 	whoIsMaster ;
    LayoutInfo		XIMPreference ;
    LayoutInfo		CBPreference ;
    XIMLookupDrawCallbackStruct *ld ; /* As a terminal */

/*
 * Caret negotiation. 
 */
#ifndef NO_CARET_NEGO
#define IM_CARET_NOT_NEGOTIATED			0x00
#define IM_CARET_SHAPE_NEGOTIATED		0x01
#define IM_CARET_COLOR_NEGOTIATED		0x02
#define IM_CARET_SHAPE_AND_COLOR_NEGOTIATED	0x03

#define IM_CARET_I_BEAM_STYLE			0
#define IM_CARET_TRIANGLE_STYLE			1
#define IM_CARET_SOLID_BLOCK_STYLE		2
#define IM_CARET_CLOSED_FIGURE_OF_ENGINE	3
#define IM_CARET_BITMAP_OF_ENGINE		4
#define IM_CARET_EMPTY				5

    unsigned char	caret_negotiated;
    unsigned char	caret_style;
    XPoint		*caret_figure_points;
    int			caret_figure_points_num;
    int			caret_figure_hotspot_index;
    char		*caret_bitmap_data;
    int			caret_bitmap_x_hot, caret_bitmap_y_hot;
    unsigned int	caret_bitmap_width, caret_bitmap_height;
    XIMTextColorBits	caret_color;
#endif /* NO_CARET_NEGO */

#ifndef xim_iml_inheritance_DEFIND
} iml_session_t;

typedef struct _iml_aux {
    int current_active_region ; /* used during building iml_inst */
    /* AUX */
    union {
	XIMAuxStartCallbackStruct start;	/* AuxStart */
	XIMAuxDrawCallbackStruct draw;		/* AuxDraw */
	XIMAuxDoneCallbackStruct done;		/* AuxDone */
    } aux;
} iml_aux_t;
#endif /* xim_iml_inheritance_DEFIND */
#endif /* xim_iml_session_DEFIND */
