#ifndef lint
#ident	"@(#)XSunIMSubr.c	2.9    94/08/08 SMI"
#endif

/******************************************************************

              Copyright 1990, 1991, by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Hideki Hiura (hhiura@Sun.COM)
	  				     Sun Microsystems, Inc.
******************************************************************/

#include <stdio.h>
#include <ctype.h>
#ifdef X_LOCALE
#include <X11/Xlocale.h>
#else
#include <locale.h>
#endif
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xlibint.h>
#if XlibSpecificationRelease < 5
#include <X11/XlibR5.h>
#endif /* XlibSpecificationRelease */
#include "XSunExt.h"
#include <X11/keysym.h>
#include <X11/Xutil.h>
#define XK_LATIN1
#define XK_PUBLISHING
#define XK_KATAKANA
#include <X11/keysymdef.h>
#include <X11/Sunkeysym.h>
#include <pwd.h>
#include <grp.h>
#include "XSunIMProt.h"
#include "XSunIMPriv.h"
#include "XSunIMMMan.h"
#include "XSunIMMthd.h"
#include "XSunIMCore.h"
#include "XSunIMPub.h"
#include "XSunIMTrans.h"
#include "XSunIMTransP.h"
#include <stdlib.h>
#include <string.h>
#include <wchar.h>

Public int i18nXView2_COMPAT
#ifdef I18NXVIEW_COMPAT
 = 1 /* For run time switch */
#else
 = 0
#endif
;
#define IMSERVER

#ifdef IMLTRACE
#define SPECIAL_MALLOC 1
#define DEBUG 1
Private int imlogic_trace = 0x40 ;
#endif

Private int XmuLookupString(XKeyEvent*, char*, int,
			    KeySym*, XComposeStatus*, unsigned long);

Private iml_inst *	   iml_make_preedit_start_inst();
Private iml_inst *	   iml_make_preedit_draw_inst();
Private iml_inst *	   iml_make_preedit_erase_inst();
Private iml_inst *	   iml_make_preedit_caret_inst();
Private iml_inst *	   iml_make_preedit_done_inst();
Private iml_inst *	   iml_make_status_start_inst();
Private iml_inst *	   iml_make_status_draw_inst();
Private iml_inst *	   iml_make_status_done_inst();
Private iml_inst *	   iml_make_lookup_start_inst();
Private iml_inst *	   iml_make_lookup_draw_inst();
Private iml_inst *	   iml_make_lookup_process_inst();
Private iml_inst *	   iml_make_lookup_done_inst();
Private iml_inst *	   iml_make_aux_start_inst();
Private iml_inst *	   iml_make_aux_draw_inst();
Private iml_inst *	   iml_make_aux_done_inst();
Private iml_inst *	   iml_make_status_notify_inst();
Private iml_inst *	   iml_make_nop_inst();
Private iml_inst *	   iml_make_commit_inst();
Private iml_inst *	   iml_make_keypress_inst();
Private iml_inst *	   iml_make_reset_return_inst();
Public  iml_inst *         iml_execute();
Private int		   iml_lookupString();
Private iml_inst *	   iml_link_inst_tail();
Private void		   iml_destruct_session();
Private void *             iml_construct_session();
Private Bool               iml_tm_init_translation_manager();
Private Bool               iml_tm_init_binding_table();
Private void               iml_tm_destroy_binding_table();
Private Bool               iml_tm_parse_translation();
Private Bool               iml_tm_parse_id_translation();
Private void               iml_tm_destroy_translation();
Private Bool               iml_tm_add_action_table();
Private void               iml_tm_destroy_action_table();
Private int	           iml_tm_lookup_binding();
Private void               iml_tm_destroy_binding_result();
Private void               iml_tm_reset_binding_state();

Public iml_methods_t _iml_methods = {
    iml_make_preedit_start_inst,
    iml_make_preedit_draw_inst,
    iml_make_preedit_erase_inst,
    iml_make_preedit_caret_inst,
    iml_make_preedit_done_inst,
    iml_make_status_start_inst,
    iml_make_status_draw_inst,
    iml_make_status_done_inst,
    iml_make_lookup_start_inst,
    iml_make_lookup_draw_inst,
    iml_make_lookup_process_inst,
    iml_make_lookup_done_inst,

    iml_make_status_notify_inst,
    iml_make_nop_inst,
    iml_make_commit_inst,
    iml_make_keypress_inst,
    iml_make_reset_return_inst,
    iml_execute,
    iml_lookupString,
    iml_link_inst_tail,
    iml_destruct_session,
    iml_construct_session,
    iml_tm_init_translation_manager,
    iml_tm_init_binding_table,
    iml_tm_destroy_binding_table,
    iml_tm_parse_translation,
    iml_tm_parse_id_translation,
    iml_tm_destroy_translation,
    iml_tm_add_action_table,
    iml_tm_destroy_action_table,
    iml_tm_lookup_binding,
    iml_tm_destroy_binding_result,
    iml_tm_reset_binding_state,

    iml_make_aux_start_inst,
    iml_make_aux_draw_inst,
    iml_make_aux_done_inst,
} ;

/*-----------------------------------------------------------------
 * Translation manager method
 *----------------------------------------------------------------*/

/*
 * Set up the internal data of TM. This should be called 
 * before any other TM functions.
 */
Private Bool               
iml_tm_init_translation_manager()
{
    return  (Bool)XimTMInitializeTM();
}

/*
 * Allocate the IMBindTable data structure.
 */
Private Bool
iml_tm_init_binding_table(s, return_bind_table)
iml_session_t	*s;
IMBindTable	*return_bind_table;
{
    if ((*return_bind_table = (IMBindTable)XimTMInitBindingTable()) == NULL)
	return False;
    return True;
}

/*
 * Destroy the IMBindTable data structure.
 */
Private void
iml_tm_destroy_binding_table(s, bind_table, destroy_translations)
iml_session_t	*s;
IMBindTable	bind_table;
Bool		destroy_translations;
{
    XimTMDestroyBindingTable(bind_table, destroy_translations);
}

/*
 * Compile the translation.
 */
Private Bool
iml_tm_parse_translation(s, bind_table, translation, return_tm_id)
iml_session_t	*s;
IMBindTable	bind_table;
char		*translation;
IMTMid		*return_tm_id;
{
    return (Bool)XimTMParseTranslation(bind_table, translation, return_tm_id);
}

/*
 * Compile the translation by the compiled translation.
 */
Private Bool
iml_tm_parse_id_translation(s, bind_table, tm_id, return_tm_id)
iml_session_t	*s;
IMBindTable	bind_table;
IMTMid		tm_id;
IMTMid		*return_tm_id;
{
    return (Bool)XimTMParseIDTranslation(bind_table, tm_id, return_tm_id);
}

/*
 * Destroy the translation.
 */
Private void
iml_tm_destroy_translation(s, bind_table, tm_id)
iml_session_t	*s;
IMBindTable	bind_table;
IMTMid		tm_id;
{
    XimTMDestroyTranslation(bind_table, tm_id);
}

/*
 * Declare the action table.
 */
Private Bool
iml_tm_add_action_table(s, actions, num_actions, return_action_table)
iml_session_t	*s;
IMActionsList	actions;
int		num_actions;
IMActionTable	*return_action_table;
{
    if ((*return_action_table = (IMActionTable)XimTMAddActionsTable(
	actions, num_actions)) == NULL)
	return False;
    return True;
}

/*
 * Destroy the action table.
 */
Private void
iml_tm_destroy_action_table(s, action_table)
iml_session_t	*s;
IMActionTable	action_table;
{
    XimTMDestroyActionsTable(action_table);
}

/*
 * Look up the comming event.
 */
Private int               
iml_tm_lookup_binding(s, events, bind_table, action_table, tm_id, result_return)
iml_session_t	*s;
XEvent		*events;
IMBindTable	bind_table;
IMActionTable	action_table;
IMTMid		tm_id;
IMBindResult	*result_return;
{
    return (int)XimTMLookupBinding(events, bind_table, action_table, 
	tm_id, result_return);
}

/*
 * Free the binding result structure.
 */
Private void
iml_tm_destroy_binding_result(s, bind_result)
iml_session_t	*s;
IMBindResult	*bind_result;
{
    XimTMDestroyBindResult(bind_result);
}

/*
 * Reset the binding state.
 */
Private void
iml_tm_reset_binding_state(s, bind_table, tm_id)
iml_session_t	*s;
IMBindTable	bind_table;
IMTMid		tm_id;
{
    XimTMResetBinding(bind_table, tm_id);
}

/*-----------------------------------------------------------------
 * Making instance for Preedit region drawing method
 *----------------------------------------------------------------*/
Private iml_inst *
iml_make_preedit_start_inst(s)
iml_session_t *s;
{
    iml_inst *lp ;

    lp = (iml_inst*)_iml_new(s, sizeof(iml_inst)+sizeof(int));
    _imm_trace("IMM_PREEDIT_START",0,0);
    ACTIVATE_REGION(s, PREEDIT) ;
#ifdef  XSF_PREEDIT_RETURN_USED
    lp->opcode = IMM_PREEDIT_START | IMM_CB_RESULT_REQUIRED;
#else
    lp->opcode = IMM_PREEDIT_START ;
#endif  /* XSF_PREEDIT_RETURN_USED */
    lp->next = NULL ;
    lp->size_of_operand = 0 ;
    return lp ;
}

#ifndef NO_COLOR_FEEDBACK
Private iml_inst *iml_make_preedit_draw_inst(s, cws, cfb, cffg, cfbg)
iml_session_t *s;
wchar_t     *cws ;               /* current wstr */
XIMFeedback *cfb ;               /* current fb */
XIMTextColorFeedback	*cffg;	 /* current color feedback foreground */
XIMTextColorFeedback	*cfbg;	 /* current color feedback background */
#else
Private iml_inst *
iml_make_preedit_draw_inst(s, cws, cfb)
iml_session_t *s;
wchar_t     *cws ;               /* current wstr */
XIMFeedback *cfb ;               /* current fb */
#endif  /* NO_COLOR_FEEDBACK */
{
    iml_inst *lp ;
    XIMPreeditDrawCallbackStruct *p ;

    wchar_t *pws = s->PreEditTextInfo.text->string.wide_char;/* prev str */
    int      pwl = s->PreEditTextInfo.text->length ;         /* prev len */
    XIMFeedback *pfb = s->PreEditTextInfo.text->feedback ;   /* prev fb */
#ifndef NO_COLOR_FEEDBACK
    XIMTextColorFeedback *pcffg = s->PreEditTextInfo.text->string_foreground;
    XIMTextColorFeedback *pcfbg = s->PreEditTextInfo.text->string_background;
#endif  /* NO_COLOR_FEEDBACK */
    int      cwl ;                                          /* current len */
    int si ;                                            /* str index */
    int sri ;                                           /* str reverse index */
    int fbi ;                                           /* fb index */
    int fbri ;                                          /* fb reverse index */
    int i ;                                             /* index */

    int ri = pwl;                                       /* index */

    cwl = wcslen(cws);
    if(cwl <= 0){
	return(iml_make_preedit_erase_inst(s));
    }
    lp = (iml_inst*)_iml_new(s,sizeof(iml_inst)+sizeof(XIMPreeditDrawCallbackStruct));
    lp->opcode = IMM_PREEDIT_DRAW ;
    lp->next = NULL ;
    for(si = 0 ; si < pwl ; si++) if(pws[si] != cws[si]) break ;
    if(cwl && (pwl == cwl)){
	for(sri = pwl-1 ; sri >= 0 ; sri--) if(pws[sri] != cws[sri]) break ;
	for(fbri = pwl-1 ; fbri >= 0 ; fbri--) if(pfb[fbri] != cfb[fbri])break;
	ri = max(sri, fbri);
    }
    for(fbi = 0 ; fbi < pwl ; fbi++) if(pfb[fbi] != cfb[fbi]) break ;
    i = min(si, fbi);

    if(pwl == cwl && i == cwl) {	/* Current preedit is the same as previous */
	return(iml_make_nop_inst(s));
    }
    p = (XIMPreeditDrawCallbackStruct*)&(lp->operand);
    p->text = (XIMText *)_iml_new(s, sizeof(XIMText));
    p->text->encoding_is_wchar = True ;
    p->text->feedback = cfb + i ;
#ifndef NO_COLOR_FEEDBACK
    if (cffg && cfbg)
    {
        p->text->string_foreground = cffg + i;
        p->text->string_background = cfbg + i;
    }
    else
    {
        p->text->string_foreground = (XIMTextColorFeedback *)NULL;
        p->text->string_background = (XIMTextColorFeedback *)NULL;
    }
#endif  /* NO_COLOR_FEEDBACK */
    if((p->text->length = cwl - i)<=0) {
	if(cwl < pwl ){
	    p->text = NULL ;
	} else {
	    p->text->string.wide_char = NULL ;
	}
    } else {
	p->text->string.wide_char = cws +i ;
    }
    p->chg_first = i ;

#undef BUGFIX1064538
#ifdef BUGFIX1064538
    p->chg_length = ri - i ; /* More optimization for drawing */
#else
    p->chg_length = pwl - i ;
#endif
    /* Bug ID: 4113799, was: p->caret = cwl - 1;, now: */
    p->caret = cwl;

#ifdef DEBUG
#define P dbg_printf(
P "--------------------------------------------------------------\n");
P "pws|%ws|pwl%d|cws|%ws|cwl%d|si%d|sri%d|fbi%d|fbri%d|i%d|ri%d|\n",
   pws,    pwl,  cws,    cwl,  si,  sri,  fbi,  fbri,  i,  ri);
_iml_xdmem(pfb,pfb*sizefo(XIMFeedback));
_iml_xdmem(cfb,cfb*sizefo(XIMFeedback));
    P "chg_first%d|chg_len%d|caret%d|",p->chg_first,p->chg_length,p->caret);
if(p->text){
  wchar_t dummy = (wchar_t)0;
    P "length%d|string%ws\n",p->text->length, (p->text->string.wide_char)?(p->text->string.wide_char):&dummy);
    _iml_xdmem(p->text->feedback, p->text->length * sizeof(XIMFeedback));
} else {
    P "\n");
}
#undef P
#endif

    /*
     * save current string as previous string
     */
    if((cwl + 1) > s->PreEditTextBufferSize){
#ifndef NO_COLOR_FEEDBACK
	if (s->PreEditTextInfo.text->string_foreground &&
	    s->PreEditTextInfo.text->string_background)
		for (i = 0; i < pwl; i++)
		    if (s->PreEditTextInfo.text->feedback[i] & XIMTextColorName)
		    {
			free(s->PreEditTextInfo.text->string_foreground->colorname);
			free(s->PreEditTextInfo.text->string_background->colorname);
		    }
	free(s->PreEditTextInfo.text->string_foreground);
	free(s->PreEditTextInfo.text->string_background);
	s->PreEditTextInfo.text->string_foreground =
	  (XIMTextColorFeedback *)calloc(sizeof(XIMTextColorFeedback), cwl);
	s->PreEditTextInfo.text->string_background =
	  (XIMTextColorFeedback *)calloc(sizeof(XIMTextColorFeedback), cwl);
#endif  /* NO_COLOR_FEEDBACK */
	free(s->PreEditTextInfo.text->string.wide_char);
	free(s->PreEditTextInfo.text->feedback);
	s->PreEditTextInfo.text->string.multi_byte =
	  calloc(sizeof(wchar_t),cwl + 1);
	s->PreEditTextInfo.text->feedback =
	  (XIMFeedback *)calloc(sizeof(XIMFeedback),cwl);
	s->PreEditTextBufferSize = cwl +1 ;
	s->PreEditAttrBufferSize = cwl +1 ;
    }
    s->PreEditTextInfo.text->length =  cwl ;
    wcscpy(s->PreEditTextInfo.text->string.wide_char, cws) ;
    bcopy(cfb, s->PreEditTextInfo.text->feedback, cwl * sizeof(XIMFeedback));
#ifndef NO_COLOR_FEEDBACK
    if (cffg && cfbg)
    {
        for (i = 0; i < cwl; i++)
	    if (cfb[i] & XIMTextColorName)
	    {
	        s->PreEditTextInfo.text->string_foreground[i].colorname = 
	        	(char *)malloc(strlen(cffg[i].colorname));
	        s->PreEditTextInfo.text->string_background[i].colorname = 
	        	(char *)malloc(strlen(cfbg[i].colorname));
	        strcpy(s->PreEditTextInfo.text->string_foreground[i].colorname, 
	        	(cffg + i)->colorname);
	        strcpy(s->PreEditTextInfo.text->string_background[i].colorname,
	        	(cfbg + i)->colorname);
	    }
	    else
	    {
	        s->PreEditTextInfo.text->string_foreground[i] = cffg[i];
	        s->PreEditTextInfo.text->string_background[i] = cfbg[i];
	    }
    }
    else
    {
	s->PreEditTextInfo.text->string_foreground=(XIMTextColorFeedback *)NULL;
	s->PreEditTextInfo.text->string_background=(XIMTextColorFeedback *)NULL;
    }
#endif  /* NO_COLOR_FEEDBACK */

    _imm_trace("IMM_PREEDIT_DRAW(Draw All)",ws,p->text->length);

    return lp;
}
Private iml_inst *
iml_make_preedit_erase_inst(s)
iml_session_t *s;
{
    XIMPreeditDrawCallbackStruct *p ;
    iml_inst *lp;

    lp=(iml_inst*)_iml_new(s,sizeof(iml_inst)+sizeof(XIMPreeditDrawCallbackStruct));
    lp->opcode = IMM_PREEDIT_DRAW ;
    lp->next = NULL ;
    p = (XIMPreeditDrawCallbackStruct*)&(lp->operand);
    p->chg_first = 0 ;
#ifndef before_public_review_xim_compat
#ifdef nelson_no_tako
    p->text = (XIMText *)_iml_new(s, sizeof(XIMText));
    p->text->length = 0;
    p->text->feedback = (XIMFeedback *)NULL;
    p->text->string.wide_char = (wchar_t *)NULL;
    p->text->encoding_is_wchar = True ;
    s->PreEditTextInfo.text->length =  p->text->length ;
    p->chg_length = s->PreEditTextInfo.text->length ;
#else
    p->text = NULL ;
    p->chg_length = s->PreEditTextInfo.text->length ; /* previous length */
    s->PreEditTextInfo.text->length =  0 ;
#endif
#else
    p->chg_length = s->PreEditTextInfo.text.length ;
    p->text.length = 0;
    p->text.feedback = (XIMFeedback *)NULL;
    p->text.string.wide_char = (wchar_t *)NULL;
    p->text.encoding_is_wchar = True ;
    p->text.visible_pos = 0;
    s->PreEditTextInfo.text.length =  p->text.length ;
#endif
    p->caret = 0 ;
    _imm_trace("IMM_PREEDIT_DRAW(pseudo:erase)",0,p->chg_length);
    return lp ;
}
Private iml_inst *
iml_make_preedit_caret_inst(s)
iml_session_t *s;
{
/*
 * TO BE IMPLEMENTED
 */
    return(iml_inst*)0;
}
Private iml_inst *
iml_make_preedit_done_inst(s)
iml_session_t *s;
{
    iml_inst *lp ;

    lp = (iml_inst*)_iml_new(s, sizeof(iml_inst));
    lp->opcode = IMM_PREEDIT_DONE ;
    lp->next = NULL ;
    lp->size_of_operand = 0 ;
    _imm_trace("IMM_PREEDIT_DONE(pseudo)",0,p->chg_length);
    INACTIVATE_REGION(s, PREEDIT);
    return lp ;
}
/*-----------------------------------------------------------------
 * Making instance for Status region drawing method
 *----------------------------------------------------------------*/
Private iml_inst *
iml_make_status_start_inst(s)
iml_session_t *s;
{
    iml_inst *lp ;

    lp=(iml_inst *)_iml_new(s,sizeof(iml_inst));
    _imm_trace("IMM_SET_REGION(STATUS)",0,0);
    ACTIVATE_REGION(s, STATUS) ;
    lp->opcode = IMM_STATUS_START ;
    lp->next = NULL ;
    return lp ;
}

#ifndef NO_COLOR_FEEDBACK
Private iml_inst *iml_make_status_draw_inst(s, cws, cfb, cffg, cfbg)
iml_session_t *s;
wchar_t     *cws ;               /* current wstr */
XIMFeedback *cfb ;               /* current fb */
XIMTextColorFeedback *cffg;	 /* current color text feedback */
XIMTextColorFeedback *cfbg;	 /* current color text feedback */
#else
Private iml_inst *
iml_make_status_draw_inst(s, cws, cfb)
iml_session_t *s;
wchar_t     *cws ;               /* current wstr */
XIMFeedback *cfb ;               /* current fb */
#endif  /* NO_COLOR_FEEDBACK */
{
    iml_inst *lp ;
    XIMStatusDrawCallbackStruct *q ;
    XIMText *t ;
    register	i, j = wcslen(cws)*sizeof(XIMFeedback) ;

    for(i = 0; i< j; i++) {
	s->status_cache.sfb[i] |= XIMTertiary;
    }
    lp = (iml_inst*)_iml_new(s, sizeof(iml_inst)+sizeof(XIMStatusDrawCallbackStruct));
    t = (XIMText *)_iml_new(s, sizeof(XIMText));
    lp->opcode = IMM_STATUS_DRAW ;
    lp->next = NULL ;
    q = (XIMStatusDrawCallbackStruct *)&lp->operand ;
    q->type = XIMTextType ;
    q->data.text = t ;
    t->length = wcslen(cws);
    t->string.wide_char = cws ;
    t->encoding_is_wchar = True ;
    t->feedback = cfb?cfb:(XIMFeedback *)_iml_new(s, wcslen(cws)*sizeof(XIMFeedback));
#ifndef NO_COLOR_FEEDBACK
    if (cfb && cffg && cfbg)
    {
	t->string_foreground = (XIMTextColorFeedback *)malloc(
		t->length * sizeof(XIMTextColorFeedback));
	t->string_background = (XIMTextColorFeedback *)malloc(
		t->length * sizeof(XIMTextColorFeedback));
	
	for (i = 0; i < (int)t->length; i++)
	    if (cfb[i] & XIMTextColorName)
	    {
		t->string_foreground[i].colorname = (char *)malloc(
						strlen(cffg[i].colorname));
		t->string_background[i].colorname = (char *)malloc(
						strlen(cfbg[i].colorname));
		strcpy(t->string_foreground[i].colorname, cffg[i].colorname);
		strcpy(t->string_background[i].colorname, cfbg[i].colorname);
	    }
	    else
	    {
		t->string_foreground[i] = cffg[i];
		t->string_background[i] = cfbg[i];
	    }
    }
    else
        t->string_foreground=t->string_background=(XIMTextColorFeedback *)NULL;
#endif  /* NO_COLOR_FEEDBACK */

    return lp ;
}
Private iml_inst *
iml_make_status_done_inst(s)
iml_session_t *s;
{
    iml_inst *lp ;

    lp = (iml_inst*)_iml_new(s, sizeof(iml_inst));
    lp->opcode = IMM_STATUS_DONE ;
    lp->next = NULL ;
    lp->size_of_operand = 0 ;
    _imm_trace("IMM_STATUS_DONE",0,0);
    INACTIVATE_REGION(s, STATUS);
    return lp ;
}
/*-----------------------------------------------------------------
 * Making instance for Aux region drawing method
 *----------------------------------------------------------------*/
Private iml_inst *
iml_make_aux_start_inst(iml_session_t *s, iml_aux_t *a) {
    iml_inst *lp = (iml_inst*)0;
    XIMAuxStartCallbackStruct *ls;

    lp=(iml_inst *)_iml_new(s,sizeof(iml_inst)+
			    sizeof(XIMAuxStartCallbackStruct));
    lp->opcode = IMM_AUX_START_2;
    lp->next = NULL ;
    ACTIVATE_REGION(a, AUX) ;
    ls = (XIMAuxStartCallbackStruct *)&lp->operand ;
    ls->engine_name = (char*)a->aux.start.engine_name ;
    ls->engine_class_index = a->aux.start.engine_class_index;
    _imm_trace("IMM_AUX_START_2",0,0);
    return lp ;
}

Private iml_inst *
iml_make_aux_draw_inst(iml_session_t *s, iml_aux_t *a) {
    iml_inst *lp = (iml_inst*)0;
    XIMAuxDrawCallbackStruct *ls;
    lp=(iml_inst *)_iml_new(s,sizeof(iml_inst)+
                            sizeof(XIMAuxDrawCallbackStruct));
    lp->opcode = IMM_AUX_DRAW_2;
    lp->next = NULL ;
    ACTIVATE_REGION(a, AUX) ;
    ls = (XIMAuxDrawCallbackStruct *)&lp->operand ;

    ls->engine_name = (char*)a->aux.draw.engine_name ;
    ls->engine_class_index = a->aux.draw.engine_class_index;
    ls->count_integer_values = a->aux.draw.count_integer_values;
    ls->integer_values = a->aux.draw.integer_values;
    ls->count_string_values = a->aux.draw.count_string_values;
    ls->string_values = a->aux.draw.string_values;
    _imm_trace("IMM_AUX_DRAW_2",0,0);

    return lp;
}

Private iml_inst *
iml_make_aux_done_inst(iml_session_t *s, iml_aux_t *a) {
    iml_inst *lp = (iml_inst*)0;
    XIMAuxDoneCallbackStruct *ls;
    lp=(iml_inst *)_iml_new(s,sizeof(iml_inst)+
                            sizeof(XIMAuxDoneCallbackStruct));
    lp->opcode = IMM_AUX_DONE_2;
    lp->next = NULL ;
    ACTIVATE_REGION(a, AUX) ;
    ls = (XIMAuxDoneCallbackStruct *)&lp->operand ;

    ls->engine_name = (char*)a->aux.done.engine_name ;
    ls->engine_class_index = a->aux.done.engine_class_index;

    _imm_trace("IMM_AUX_DONE_2",0,0);

    return lp;
}

/*-----------------------------------------------------------------
 * Making instance for Lookup choice region drawing method
 *----------------------------------------------------------------*/
Private iml_inst *
iml_make_lookup_start_inst(s)
iml_session_t *s;
{
    iml_inst *lp ;
    XIMLookupStartCallbackStruct *ls;

    lp=(iml_inst *)_iml_new(s,sizeof(iml_inst)+
			    sizeof(XIMLookupStartCallbackStruct));
    lp->opcode = IMM_LOOKUP_START | IMM_CB_RESULT_REQUIRED;
    lp->next = NULL ;
    ACTIVATE_REGION(s, LOOKUP) ;
    ls = (XIMLookupStartCallbackStruct *)&lp->operand ;
    ls->event = s->event ;
    ls->whoIsMaster = s->whoIsMaster ;
    ls->XIMPreference = &s->XIMPreference ;
    ls->CBPreference = &s->CBPreference ;
    _imm_trace("IMM_SET_REGION(LOOKUP)",0,0);
    return lp ;
}

Private iml_inst *
iml_make_lookup_draw_inst(s, candidate, ncandidate)
iml_session_t *s;
unsigned char **candidate ; /* in multi bytes */
int ncandidate ;
{
    iml_inst *lp ;
    register XIMLookupDrawCallbackStruct *ld ;
    register XIMText *t ;
    register wchar_t *w ;
    register l ;
    register i ;

    switch(s->whoIsMaster){
      case HasNotBeenNegotiated:
	/* Not yet */
	break;
      case XIMIsMaster:
      case CBIsMaster:
	lp=(iml_inst*)_iml_new2(s,
			sizeof(iml_inst)+sizeof(XIMLookupDrawCallbackStruct));
	lp->opcode = IMM_LOOKUP_DRAW ;
	lp->next = NULL;
	ld = (XIMLookupDrawCallbackStruct*) &lp->operand;
	ld->n_choices = ncandidate ;
	ld->index_of_first_candidate = 0 ;
	ld->index_of_last_candidate = ld->n_choices - 1;
	ld->choices = (XIMChoiceObject *)_iml_new2(s,
			   ld->n_choices * sizeof(XIMChoiceObject)) ;
	ld->max_len = 0 ;
	if (s->whoIsMaster == XIMIsMaster && s->ld) {
	    ld->title = s->ld->title;
	} else {
	    ld->title = (XIMText *)NULL;
	}
	for(i = 0 ; i < ld->n_choices ; i++){
	    l = (strlen((char*)candidate[i])+sizeof(char))*sizeof(wchar_t) ;
	    w = (wchar_t *)_iml_new2(s, l);
#ifdef SVR4
	    mbstowcs(w, (const char *)candidate[i], l);
#else /* SVR4 */
	    mbstowcs(w, candidate[i], l);
#endif /* SVR4 */
	    t = (ld->choices)[i].value = (XIMText *)
	      _iml_new2(s, sizeof(XIMText));
	    if (s->whoIsMaster == XIMIsMaster && s->ld && s->ld->choices) {
		(ld->choices)[i].label = s->ld->choices[i].label;
	    } else {
		(ld->choices)[i].label = (XIMText*)NULL;
	    }
	    t->length = wcslen(w);
#ifdef SVR4
	    if(t->length > (unsigned short)ld->max_len) {
#else /* SVR4 */
	    if(t->length > ld->max_len) {
#endif /* SVR4 */
		ld->max_len = t->length ;
	    }
	    t->feedback = (XIMFeedback*)_iml_new2(s,
					t->length * sizeof(XIMFeedback));
	    t->encoding_is_wchar = True ;
	    t->string.wide_char = w ;
	}
	s->ld = ld ;
	break;
    }
    _imm_trace("IMM_LOOKUP_DRAW",0,ld->n_choices);
    return lp;
}

Private iml_inst *
iml_make_lookup_process_inst(s, results_required, controll)
iml_session_t *s;
Bool results_required ;
int controll ; /* commit/next/prev: NOT IMPLEMENTED YET */
{
    iml_inst *lp ;

    if(s->whoIsMaster == CBIsMaster){
	XIMLookupProcessCallbackStruct *lup ;
	lp = (iml_inst *)_iml_new(s,
		  sizeof(XIMLookupProcessCallbackStruct) + sizeof(iml_inst) );
	if(results_required){
	    lp->opcode = IMM_LOOKUP_PROCESS | IMM_CB_RESULT_REQUIRED;
	} else {
	    lp->opcode = IMM_LOOKUP_PROCESS ;
	}
	lp->next = NULL ;
	lup = (XIMLookupProcessCallbackStruct *)&lp->operand ;
	lup->event = s->event ;
	lp->size_of_operand =  sizeof(XIMLookupProcessCallbackStruct) ;
	_imm_trace("IMM_LOOKUP_PROCESS:CBM)",0,0);
    } else if(s->whoIsMaster == XIMIsMaster){
	/*
	 * Not Implemented Yet.
	 * This code is same as CBIsMaster
	 */
	XIMLookupProcessCallbackStruct *lup ;
	lp = (iml_inst *)_iml_new(s,
		  sizeof(XIMLookupProcessCallbackStruct) + sizeof(iml_inst) );
	if(results_required){
	    lp->opcode = IMM_LOOKUP_PROCESS | IMM_CB_RESULT_REQUIRED;
	} else {
	    lp->opcode = IMM_LOOKUP_PROCESS ;
	}
	lp->next = NULL ;
	lup = (XIMLookupProcessCallbackStruct *)&lp->operand ;
	lup->event = s->event ;
	lp->size_of_operand =  sizeof(XIMLookupProcessCallbackStruct) ;
	_imm_trace("IMM_LOOKUP_PROCESS:IMM)",0,0);
    } else {
	/*
	 * This must be that the Lookup Callback is not registerd!!
	 */
	lp = s->If->m->iml_make_nop_inst(s) ;
    }
    return lp ;
}

Private iml_inst *
iml_make_lookup_done_inst(s)
iml_session_t *s;
{
    iml_inst *lp ;

    lp = (iml_inst*)_iml_new(s, sizeof(iml_inst));
    lp->opcode = IMM_LOOKUP_DONE ;
    lp->next = NULL ;
    lp->size_of_operand = 0 ;
    _imm_trace("IMM_LOOKUP_DONE",0,0);
    INACTIVATE_REGION(s, LOOKUP);
    return lp ;
}
/*-----------------------------------------------------------------
 *  Making instance for another method
 *----------------------------------------------------------------*/
/*
 * public_status $B$r(B set $B$9$k(B iml_inst $B$r:n$k(B
 */
Private iml_inst *
iml_make_status_notify_inst(s)
iml_session_t *s ;
{
    iml_status_t *status ;
    iml_inst *lp ;

    lp=(iml_inst*)_iml_new(s, sizeof(iml_inst) + sizeof(iml_status_t));
    lp->opcode = IMM_SET_STATUS ;
    lp->next = NULL ;
    status =  (iml_status_t *) &(lp->operand);
    *status = s->public_status ;
    _imm_trace("IMM_SET_STATUS",*status,0);
    return lp ;
}
Private iml_inst *
iml_make_nop_inst(s)
iml_session_t *s;
{
    iml_inst *lp ;

    lp = (iml_inst*)_iml_new(s, sizeof(iml_inst));
    lp->opcode = IMM_NOP ;
    lp->next = NULL ;
    lp->size_of_operand = 0 ;
    _imm_trace("IMM_NOP",0,0);
    return lp ;
}
/*
 * $B3NDjJ8;zNs$rJV$9(B iml_inst $B$r:n$k(B
 * session $B$NCf$K!"3NDjJ8;zNs$,3JG<$5$l$F$$$k$3$H$,A0Ds!#(B
 */
Private iml_inst *
iml_make_commit_inst(s, l, mbcs)
iml_session_t *s ;
int l ; /* length of Lookuped string */
unsigned char *mbcs ; /* Multi byte committed string */
{
    iml_inst *rv ;
    int sz = l+sizeof(committed_string_t)+1;
    committed_string_t *cs ;
    int i, mbl ;
    unsigned char *tmbcs ; 
    
    if(l<0){
	return s->If->m->iml_make_nop_inst(s);
    }
    tmbcs = mbcs ;
    for(i=0 ; i<l ; i+= mbl, tmbcs+=mbl) { /* Check if mbcs is corrupted */
	if((mbl = mblen((char *)tmbcs, 4)) <= 0)
	    return s->If->m->iml_make_nop_inst(s);
    }
    if((l == 1) && (mblen((char *)mbcs,4) == 1)){
	if(mbcs[0] < 0x20 || mbcs[0] == 0x7f){
	    return s->If->m->iml_make_keypress_inst(s, (char*)mbcs);
	}
    }
    rv = (iml_inst*)_iml_new(s,sizeof(iml_inst) + sz );
    rv->opcode = IMM_COMMIT ;
    rv->next = NULL ;
    rv->size_of_operand = sz ;
    cs = (committed_string_t *)&rv->operand ;
    if( l != 0 ){
	if(s->keysym == NoSymbol){
	    cs->status = XLookupChars ;
	} else {
	    cs->status = XLookupBoth ;
	}
    } else if(l == 0){
	if(s->initial_public_status & IMLSTATUS_Henkan_Mode) {
	    s->keysym = cs->keysym = NoSymbol ;
	    cs->status = XLookupNone ;
	    _imm_trace("IMM_COMIT",cs->string,sz);
	    return 0;
	} else {
	    if(s->keysym == NoSymbol){
		cs->status = XLookupNone ;
	    } else {
		cs->status = XLookupKeySym ;
	    }
	}
    } else {
	cs->status = XLookupNone ;
    }
    cs->keysym = s->keysym ;
    tmbcs = mbcs ;
    for(i=0 ; i<l ; i+= mbl, tmbcs+=mbl) {
	if ((mbl = mblen((char *)tmbcs, 4)) == 1 && (*tmbcs < 0x20 || *tmbcs == 0x7f)){
	    if (i > 0) {
		strncpy(cs->string, (char*)mbcs, i) ;
		cs->string[i] = '\0' ;
		rv->next = iml_make_commit_inst(s, l-i, tmbcs);
		break ;
	    }
	}
    }
    if(i == l ){
	strncpy(cs->string, (char*)mbcs, l) ;
	cs->string[l] = '\0' ;
    }
    _imm_trace("IMM_COMIT",cs->string,sz);

    return rv ;
}
Private iml_inst *
iml_make_keypress_inst(s, mbcs)
iml_session_t *s ;
char *mbcs ;
{
    iml_inst *rv ;
    int sz = sizeof(imm_keypress_t)+1;
    imm_keypress_t *kp ;
#ifdef notdef
    KeySym keysym, keysym2 ;
    KeyCode keycode ;
    char buffer[4];
    static XComposeStatus NotSupported ;
#endif

    rv = (iml_inst*)_iml_new(s,sizeof(iml_inst) + sz );
    rv->opcode = IMM_KEYPRESS ;
    rv->next = NULL ;
    rv->size_of_operand = sz ;

    kp = (imm_keypress_t *)&rv->operand ;

#ifdef notdef
    if(XLookupString(s->event, buffer, 4, &keysym2, &NotSupported) == 1){
	if(*buffer == *mbcs){
	    kp->keycode = s->event->keycode ;
	    kp->state = s->event->state ;
	    kp->time = s->event->time ;
	    return rv ;
	}
    }
    /*
     * $B$I$&$;$b$H$h$j(B 1 byte ascii $B$H2>Dj$7$F$$$k$N$G!"(Bhack $B$b$d$`$rF@$^$$(B
     */
    keysym = XStringToKeysym(s->event->display, mbcs);
    keycode = XKeysymToKeycode(s->event->display, keysym);
    kp->keycode = keycode ;
    if(*mbcs > 0x20)
	kp->state = (s->event->state & ~(ControlMask));
    else
	kp->state = (s->event->state | ControlMask);
#else
    kp->keycode = s->event->keycode ;
    kp->state = s->event->state ;
#endif    
    kp->time = s->event->time ;
    return rv ;
}
/*
 * $B3NDjJ8;zNs$r(B reset data $B$H$7$FJV$9(B iml_inst $B$r:n$k(B
 */
Private iml_inst *
iml_make_reset_return_inst(s, l, mbcs)
iml_session_t *s ;
int l ; /* length of Lookuped string */
unsigned char *mbcs ; /* Multi byte committed string */
{
    iml_inst *rv ;
    int sz = l+sizeof(committed_string_t)+1;
    committed_string_t *cs ;

    rv = (iml_inst*)_iml_new(s,sizeof(iml_inst) + sz );
    rv->opcode = IMM_RESET_RETURN ;
    rv->next = NULL ;
    rv->size_of_operand = sz ;
    cs = (committed_string_t *)&rv->operand ;
    if( mbcs && l != 0 ){
	cs->status = XLookupChars ;
	strncpy(cs->string, (char*)mbcs, l) ;
    }
    cs->string[l] = '\0' ;
    _imm_trace("IMM_RESET_RETURN",cs->string,sz);

    return rv ;
}

/*-----------------------------------------------------------------
 *  another convenient method
 *----------------------------------------------------------------*/
/*
 * IMLogic_session link terminal
 */
Private iml_session_t *imlogic_session = 0 ;

/*
 * Japanese only
 * generate string into b (max len l ) from keysym
 */
#define sLatin1		0
#define sLatin2		1
#define sLatin3		2
#define sLatin4		3
#define sKana		4
#define sX0201		0x01000004
#define sArabic		5
#define sCyrillic	6
#define sGreek		7
#define sAPL		11
#define sHebrew		12

Private Bool is_modified_key(XKeyEvent *kev, KeySym *ksym)
{
    if(kev->state & Mod2Mask) {         /* Mode_Switch applied? */
        switch(*ksym) {
          case XK_Cancel:
          case XK_Redo:
          case SunXK_Props:
          case XK_Undo:
          case SunXK_Front:
          case SunXK_Copy:
          case SunXK_Open:
          case SunXK_Paste:
          case XK_Find:
          case SunXK_Cut:
            return True;
          default:
            break;
        }
        if(kev->state & Mod1Mask) {     /* Meta key applied? */
            switch(*ksym) {
              case XK_kana_SO:
              case XK_kana_HA:
              case XK_kana_SE:
              case XK_kana_HI:
              case XK_kana_SA:
                return True;
              default:
                break;
            }
        }
    } else {
        switch(*ksym) {
          case XK_F11:
          case XK_F12:
          case XK_F13:
          case XK_F14:
          case XK_F16:
          case XK_F19:
            return True;
          default:
            break;
        }
        if(kev->state & Mod1Mask) {     /* Meta key applied? */
            switch(*ksym) {
              case XK_c:
              case XK_C:
              case XK_f:
              case XK_F:
              case XK_p:
              case XK_P:
              case XK_v:
              case XK_V:
              case XK_x:
              case XK_X:
                return True;
              default:
                break;
            }
        }
    }
    return False;
}

#define IsNeededKeypadKey(keysym) \
 (((unsigned)(keysym) == XK_KP_Space) || \
  ((unsigned)(keysym) == XK_KP_Tab)   || \
  ((unsigned)(keysym) == XK_KP_Enter) || \
  (((unsigned)(keysym) >= XK_KP_Multiply) && ((unsigned)(keysym) <= XK_KP_9))||\
  ((unsigned)(keysym) == XK_KP_Equal) )

Private int
iml_lookupString(e, b, l, keysym)
XKeyEvent  *e ;
char	*b ;
int	 l ;
KeySym   *keysym ;
{
    static char *num = " XXXXXXXX\tXXX\rXXXxxxxXXXXXXXXXXXXXXXXXXXXX*+,-./0123456789XXX=";
    static XComposeStatus NotSupported ;
    int count = 0 ;
    int n,i ; 
#if 0
    KeySym    ksym = XLookupKeysym(e, ShiftMapIndex);
#endif

    count = XmuLookupString (e, b, l, keysym, &NotSupported, sKana) ;
    if(is_modified_key(e, keysym)) {
	return 0; /* intercept and back to client */
    }
    if ((e->state & Mod3Mask) && (e->display != NULL)){
        for (i = 0; i < e->display->keysyms_per_keycode; i++) {
           if ((*keysym = XLookupKeysym(e, i)) != NoSymbol)
           if (IsNeededKeypadKey(*keysym)) {
	        n = *keysym-XK_KP_Space ;
	        if(n >= 0 && n < 65){
		    *b = num[n] ;
		    return 1 ;
	        }
	    }
        }
	e->state &= ~Mod3Mask;
	count = XmuLookupString(e, b, l, keysym, &NotSupported, sKana);
	e->state |= Mod3Mask;
	return count;
    }
    return count ;
}

/*
 * $BBh0l0z?t$N%j%s%/%j%9%H$N:G8e$KBhFs0z?t$rO"7k$9$k(B
 */
Private iml_inst *
iml_link_inst_tail(rrv, lp)
iml_inst **rrv ;
iml_inst  *lp ;
{
    register iml_inst *clp = *rrv ;

    if(!(*rrv)){
	*rrv = lp ;
    } else {
	if(clp){
	    while(clp->next){
		clp = clp->next ;
	    }
	    clp->next = lp ;
	} else {
	    clp = lp ;
	}
    }
#if	notdef
/* 
 *  ALERT!! 
 *  smatu commented out the next code on Jun/8 to solve the problem
 *  that lookupchoice cannot be brought up in ko, zh, zh_TW.
 *  In case that CM returns ENV_SELECT, IM should chain 
 *  LookupStart and LookupDraw. When this chain was passed
 *  to iml_link_inst_tail() via lp, the next commented out line
 *  threw away LookupDraw-inst.
 *  We are now depending on the fact that lp was bzero'ed each
 *  time it is created.
 */
    lp->next = NULL ;
#endif
    return *rrv ;
}
/*
 * generic destructor of imlogic session struct
 */

Private void
iml_destruct_session(s, private_destructor)
    iml_session_t *s ;
    int (*private_destructor)();
{
    (*private_destructor)(s);
    _iml_delete(s); /* caution!! already released */
    _iml_delete2(s);
    s->session_id = IML_SESSION_RECYCLE ;
}

Private iml_session_t * iml_init_session();

/*
 * generic constructor of imlogic session struct
 */

Private void *
iml_construct_session(If, ic, id, session_size, private_constructor)
    iml_if_t *If ;
    void *ic ;
    int id ;
    int session_size ;
    int (*private_constructor)();
{
    iml_session_t *s ;
    iml_session_t *ss = NULL ;
    int is_recycled = 0;
    int session_id ;

    s = iml_init_session(session_size);
    if(s->next != (void *)-1){
	while(s){
	    if(s->session_id == IML_SESSION_RECYCLE &&
	       s->language_engine == id) {
		is_recycled ++;
		break;
	    }
	    ss = s ;
	    s = ss->next ;
	}
	if(!s){
	    s = (iml_session_t *)calloc(1,session_size);
	}
	if(ss)
	  ss->next = s ;
    }
    s->If = If ;
    s->ic = ic ;
    s->classname = 0 ;
    s->enginename = 0 ;
    s->locale = 0 ;
    s->session_id = 0 ;
    s->public_status = 0 ;
    s->initial_public_status = 0 ;
    s->private_status = 0 ;
    s->remainder = 0 ;
    s->rrv = 0 ;
    s->short_term_slot = 0 ;
    s->long_term_slot = 0 ;
    s->active_regions = 0 ;
    s->event = 0 ;
    s->keysym = 0 ;
    s->status= 0 ;
    s->whoIsMaster = HasNotBeenNegotiated ;
    s->ld = 0 ;
    s->current_active_region = 0 ;
    if (is_recycled) {
#ifndef NO_COLOR_FEEDBACK
	register int i;

	for (i = 0; i < s->status_cache.size; i++)
	{
	    if (s->status_cache.fb[i] & XIMTextColorName)
	    {
		free(s->status_cache.cffg[i].colorname);
		free(s->status_cache.cfbg[i].colorname);
	    }
	    if (s->status_cache.sfb[i] & XIMTextColorName)
	    {
		free(s->status_cache.scffg[i].colorname);
		free(s->status_cache.scfbg[i].colorname);
	    }
	}
	bzero(s->status_cache.cffg, 
		sizeof(XIMTextColorFeedback) * s->status_cache.size);
	bzero(s->status_cache.cfbg,
		sizeof(XIMTextColorFeedback) * s->status_cache.size);
	bzero(s->status_cache.scffg, 
		sizeof(XIMTextColorFeedback) * s->status_cache.size);
	bzero(s->status_cache.scfbg,
		sizeof(XIMTextColorFeedback) * s->status_cache.size);
#endif  /* NO_COLOR_FEEDBACK */
	bzero(s->status_cache.ws,sizeof(wchar_t) * s->status_cache.size);
	bzero(s->status_cache.fb,sizeof(XIMFeedback) * s->status_cache.size);
	bzero(s->status_cache.sfb,sizeof(XIMFeedback) * s->status_cache.size);
	bzero(s->XLookupBuf, sizeof(char) * s->XLookupBuflen);
    } else {
	s->next = NULL;
	s->status_cache.ws = (wchar_t *)
	  calloc(sizeof(wchar_t), DEFAULTStatusCacheSize);
	s->status_cache.fb = (XIMFeedback *)
	  calloc(sizeof(XIMFeedback), DEFAULTStatusCacheSize);
	s->status_cache.sfb = (XIMFeedback *)
	  calloc(sizeof(XIMFeedback), DEFAULTStatusCacheSize);
#ifndef NO_COLOR_FEEDBACK
	s->status_cache.cffg = (XIMTextColorFeedback *)
	  calloc(sizeof(XIMTextColorFeedback), DEFAULTStatusCacheSize);
	s->status_cache.cfbg = (XIMTextColorFeedback *)
	  calloc(sizeof(XIMTextColorFeedback), DEFAULTStatusCacheSize);
	s->status_cache.scffg = (XIMTextColorFeedback *)
	  calloc(sizeof(XIMTextColorFeedback), DEFAULTStatusCacheSize);
	s->status_cache.scfbg = (XIMTextColorFeedback *)
	  calloc(sizeof(XIMTextColorFeedback), DEFAULTStatusCacheSize);
#endif  /* NO_COLOR_FEEDBACK */
	s->status_cache.size = DEFAULTStatusCacheSize;
	s->XLookupBuf = calloc(sizeof(char), DEFAULTXLookupStringBufferSize) ;
	s->XLookupBuflen = DEFAULTXLookupStringBufferSize ;
    }
#ifndef NO_CARET_NEGO
    s->caret_negotiated = IM_CARET_NOT_NEGOTIATED;
    s->caret_style = IM_CARET_I_BEAM_STYLE;
    s->caret_figure_points = (XPoint *)NULL;
    s->caret_figure_points_num = 0;
    s->caret_figure_hotspot_index = -1;
    s->caret_bitmap_data = (char *)NULL;
    s->caret_bitmap_x_hot = s->caret_bitmap_y_hot = 0;
    s->caret_bitmap_width = s->caret_bitmap_height = 0;
    s->caret_color = preedit_foreground;
#endif  /* NO_CARET_NEGO */
    session_id = (*private_constructor)(id, s, is_recycled);
    if(session_id < 0 ){
	if(ss)
	  ss->next = NULL ;
	free(s->status_cache.ws);
	free(s->status_cache.fb);
	free(s->status_cache.sfb);
#ifndef NO_COLOR_FEEDBACK
	free(s->status_cache.cffg);
	free(s->status_cache.cfbg);
	free(s->status_cache.scffg);
	free(s->status_cache.scfbg);
#endif  /* NO_COLOR_FEEDBACK */
	if(s == imlogic_session) {
	    imlogic_session = NULL;
	}
	free(s) ;
	return NULL ;
    } else if (is_recycled) {
#ifndef NO_COLOR_FEEDBACK
	if (s->PreEditTextInfo.text->feedback && 
	    s->PreEditTextInfo.text->string_foreground &&
	    s->PreEditTextInfo.text->string_background)
	{
	    register int i;

	    for (i = 0; i < s->PreEditTextBufferSize; i++)
		if (s->PreEditTextInfo.text->feedback[i] & XIMTextColorName)
		{
		  free(s->PreEditTextInfo.text->string_foreground[i].colorname);
		  free(s->PreEditTextInfo.text->string_background[i].colorname);
		}
	    bzero(s->PreEditTextInfo.text->string_foreground, 
		sizeof(XIMTextColorFeedback) * s->PreEditTextBufferSize);
	    bzero(s->PreEditTextInfo.text->string_background, 
		sizeof(XIMTextColorFeedback) * s->PreEditTextBufferSize);
	}
#endif  /* NO_COLOR_FEEDBACK */
	bzero(s->PreEditTextInfo.text->string.wide_char, 
		sizeof(wchar_t) * s->PreEditTextBufferSize);
	bzero(s->PreEditTextInfo.text->feedback, 
		sizeof(XIMFeedback) * s->PreEditAttrBufferSize);
	s->PreEditTextInfo.text->length = 0;
    } else {
	s->PreEditTextInfo.text = (XIMText *)calloc(sizeof(XIMText), 1);
	s->PreEditTextInfo.text->string.wide_char = (wchar_t *)
	  calloc(sizeof(wchar_t),DEFAULTPreEditTextBufferSize);
	s->PreEditTextInfo.text->feedback = (XIMFeedback *)
	  calloc(sizeof(XIMFeedback),DEFAULTPreEditAttrBufferSize);
#ifndef NO_COLOR_FEEDBACK
	s->PreEditTextInfo.text->string_foreground = (XIMTextColorFeedback *)
	  calloc(sizeof(XIMTextColorFeedback),DEFAULTPreEditAttrBufferSize);
	s->PreEditTextInfo.text->string_background = (XIMTextColorFeedback *)
	  calloc(sizeof(XIMTextColorFeedback),DEFAULTPreEditAttrBufferSize);
#endif  /* NO_COLOR_FEEDBACK */
        s->PreEditTextBufferSize = DEFAULTPreEditTextBufferSize ;
	s->PreEditAttrBufferSize = DEFAULTPreEditAttrBufferSize ;
    }
    s->language_engine = id ;
    s->session_id = session_id ;

#ifndef NO_CARET_NEGO
    if (s->caret_negotiated & IM_CARET_SHAPE_NEGOTIATED)
    {
	if (s->caret_style > IM_CARET_EMPTY ||
	    s->caret_style < IM_CARET_I_BEAM_STYLE)
		s->caret_style = IM_CARET_I_BEAM_STYLE;
	if (s->caret_style == IM_CARET_CLOSED_FIGURE_OF_ENGINE)
	{
	    if (s->caret_figure_points == (XPoint *)NULL ||
		s->caret_figure_points_num == 0)
	    {
		s->caret_style = IM_CARET_EMPTY;
		if (s->caret_figure_points)
		{
		    free((XPoint *)s->caret_figure_points);
		    s->caret_figure_points = (XPoint *)NULL;
		}
	    }
	    else
	    {
		if (s->caret_figure_hotspot_index < 0 ||
		    s->caret_figure_hotspot_index >= s->caret_figure_points_num)
		{
		    register int i;
		    int minx, miny, maxx, maxy;
		    int cx, cy, delta, tdx, tdy;

		    minx = miny = 100;
		    maxx = maxy = -100;
		    for (i = 0; i < s->caret_figure_points_num; i++)
		    {
			minx = (s->caret_figure_points[i].x < minx) ?
			    s->caret_figure_points[i].x : minx;
			maxx = (s->caret_figure_points[i].x > maxx) ?
			    s->caret_figure_points[i].x : maxx;
			miny = (s->caret_figure_points[i].y < miny) ?
			    s->caret_figure_points[i].y : miny;
			maxy = (s->caret_figure_points[i].y > maxy) ?
			    s->caret_figure_points[i].y : maxy;
		    }
		    cx = minx + (maxx - minx) / 2;
		    cy = miny + (maxy - miny) / 2;
		    delta = 20000;
		    for (i = 0; i < s->caret_figure_points_num; i++)
		    {
			if (cx > s->caret_figure_points[i].x)
			    tdx = cx - s->caret_figure_points[i].x;
			else
			    tdx = s->caret_figure_points[i].x - cx;
			if (cy > s->caret_figure_points[i].y)
			    tdy = cy - s->caret_figure_points[i].y;
			else
			    tdy = s->caret_figure_points[i].y - cy;
			tdx = tdx * tdx + tdy * tdy;
			s->caret_figure_hotspot_index = 0;
			if (tdx < delta)
			{
			    delta = tdx;
			    s->caret_figure_hotspot_index = i;
			}
		    }
		}
		if (s->caret_figure_points[0].x != 
		    s->caret_figure_points[s->caret_figure_points_num - 1].x ||
		    s->caret_figure_points[0].y != 
		    s->caret_figure_points[s->caret_figure_points_num - 1].y)
		{
		    XPoint *xp;

		    xp = (XPoint *)realloc((void *)s->caret_figure_points,
			sizeof(XPoint) * s->caret_figure_points_num + 1);
		    if (xp)
		    {
			s->caret_figure_points = xp;
			xp[s->caret_figure_points_num].x = xp[0].x;
			xp[s->caret_figure_points_num].y = xp[0].y;
			s->caret_figure_points_num++;
		    }
		    else
		    {
			s->caret_figure_points[s->caret_figure_points_num 
			    - 1].x = s->caret_figure_points[0].x;
			s->caret_figure_points[s->caret_figure_points_num 
			    - 1].y = s->caret_figure_points[0].y;
		    }
		}
	    }
	}
	else if (s->caret_style == IM_CARET_BITMAP_OF_ENGINE)
	{
	    if (s->caret_bitmap_data == (char *)NULL ||
		s->caret_bitmap_width == 0 || s->caret_bitmap_height == 0)
	    {
		s->caret_style = IM_CARET_EMPTY;
		if (s->caret_bitmap_data)
		{
		    free(s->caret_bitmap_data);
		    s->caret_bitmap_data = (char *)NULL;
		}
	    }
	    else if (s->caret_bitmap_x_hot > (s->caret_bitmap_width - 1) ||
		s->caret_bitmap_x_hot < 0 ||
		s->caret_bitmap_y_hot > (s->caret_bitmap_height - 1) ||
		s->caret_bitmap_y_hot < 0)
		s->caret_bitmap_x_hot = s->caret_bitmap_y_hot = 0;
	}
    }

    if ((s->caret_negotiated & IM_CARET_COLOR_NEGOTIATED) &&
	(s->caret_color < black || s->caret_color > preedit_foreground))
	s->caret_color = preedit_foreground;
#endif  /* NO_CARET_NEGO */

    return (void *) s ;
}


/*-----------------------------------------------------------------
 *  Public sub routines
 *----------------------------------------------------------------*/

Public iml_methods_t *
_iml_dup_iml_methods()
{
    iml_methods_t *m = (iml_methods_t *)malloc(sizeof(_iml_methods));
    bcopy(&_iml_methods, m, sizeof(_iml_methods));
    return m ;
}

Public void
_iml_error(s)
char * s;
{
    fprintf(stderr, "%s\n", s);
}

Public int
_iml_calc_visible_pos(bpos, mbs, maxlen)
int bpos;
char *mbs;
int maxlen;
{
    register i, j, l ;

    for(i=0, j=0; i<bpos && j <= (maxlen +1);i+=l, j++){
	l=mblen(mbs+i,4);
    }
    return(j);
}

/*-----------------------------------------------------------------
 *  Private sub routines
 *----------------------------------------------------------------*/
Private iml_session_t *
iml_init_session(session_size)
int session_size ;
{
    if(imlogic_session) return imlogic_session;
    imlogic_session=(iml_session_t *)calloc(1,session_size);
    imlogic_session->next = (void *)-1 ;
    return(imlogic_session);
}

#ifdef notdef
/*------------------------------------------------------------------
 * Region stack handling public routines
 *-----------------------------------------------------------------*/
Public IMM_Region
_iml_get_current_region(s)
iml_session_t *s ;
{
    iml_region_stack_t *cr = & s->current_region ;

    while(cr->next){
	cr = cr->next ;
    }
    return(cr->region);
}
Public int
_iml_put_current_region(s,r)
iml_session_t *s ;
IMM_Region r ;
{
    iml_region_stack_t *cr = & s->current_region ;
    int depth = 0 ;
    if(cr->region < 0) {
	/*
	 * current region has not been set
	 */
	cr->region = r ;
	return(1);
    }
    while(cr->next){
	cr = cr->next ;
	depth ++ ;
    }
    if(cr->region == PREEDIT && r == LOOKUP ){
	cr->next = (iml_region_stack_t *)
	    calloc(1, sizeof(iml_region_stack_t));
	cr->next->prev = cr ;
	cr->next->region = r ;
	return(depth +1 ) ;
    } else if (cr->region != r){
	if(cr->prev != 0 && cr->prev->region == r){
	    depth = _iml_pop_current_region(s);
	} else {
	    cr->region = r ;
	    depth++ ;
	}
    }

    return (depth);
}
Public int
_iml_pop_current_region(s)
iml_session_t *s;
{
    iml_region_stack_t *cr = & s->current_region ;
    int depth = 0 ;
    if(cr->region < 0) {
	/*
	 * current region has not been set
	 */
	return(-1);
    }
    while(cr->next){
	cr = cr->next ;
	depth ++ ;
    }
    if(depth){
	cr->prev->next = 0 ;
	free(cr);
	return(depth -1);
    } else {
	cr->region = -1 ;
	cr->next = 0 ;
	cr->prev = 0 ;
	return( -1 );
    }
}
#endif /* notdef region stack */

Private void
preedit_done_optim(s,tp,tpp,rrv)
iml_session_t *s ;
iml_inst *tp ;
iml_inst *tpp ;
iml_inst **rrv ;
{
    if(i18nXView2_COMPAT || !tp->next){
	return;
    } else {
	/*
	 * OPTIMIZATION
	 * If the series of packets contain done - commit - start
	 * sequence in a contiguous list, then done/start should be removed
	 * from the queue.
	 */
	iml_inst *is_commit_exist = NULL ;
	iml_inst *parent_of_commit = NULL ;
	iml_inst *is_erase_exist = NULL ;
	iml_inst *parent_of_erase = NULL ;
#if 0
	iml_inst *is_start_exist = NULL ;
#endif
	iml_inst *preedit_done = NULL ;
	while(tp){
	    switch((int)((tp->opcode)&(~IMM_CB_RESULT_REQUIRED))){
	      case IMM_PREEDIT_DONE:
		if(!preedit_done){
		    preedit_done = tp ;
		} else {
		    tp->opcode = IMM_NOP ;
		}
		break ;
	      case IMM_PREEDIT_DRAW:
		if(!is_commit_exist && !is_erase_exist){
		    XIMPreeditDrawCallbackStruct *pdcs = (XIMPreeditDrawCallbackStruct *)&tp->operand ;
		    if(!pdcs->text){
			is_erase_exist = tp ;
			parent_of_erase = tpp ;
		    }
		}
		break ;
	      case IMM_PREEDIT_START:
		preedit_done->opcode = tp->opcode = IMM_NOP ;
		s->active_regions |= ~PREEDIT_IS_ACTIVE;
#if 0
		is_start_exist = tp ;
#endif
		goto OUT_FROM_DONE_OPT;
		/* break ;*/
	      case IMM_COMMIT:
		is_commit_exist = tp ;
		parent_of_commit = tpp ;
		break ;
	      default:
		break ;
	    }
	    tpp=tp ;
	    tp=tp->next ;
	}
OUT_FROM_DONE_OPT:
	/*
	 * Following code is only for XViewV3.0.1 callbacks
	 * to make sure its independencies against the order
	 * of PreeditErase and Commit instruction.
	 * It should be removed when XViewV3.0.1 gets stable.
	 */

	if(is_commit_exist && is_erase_exist && (rand()&1)){
	    if(rrv && !parent_of_erase){
		*rrv = is_commit_exist ;
	    } else {
		parent_of_erase->next = is_commit_exist ;
	    }
	    parent_of_commit->next = is_erase_exist ;
	    tp = is_commit_exist->next ;
	    is_commit_exist->next = is_erase_exist->next ;
	    is_erase_exist->next = tp ;
	}
    }
}


/*
 * post processor of the packets which passes to immgr
 */
Public void
iml_post_proc(s, rrv)
iml_session_t *s ;
iml_inst **rrv;
{
    iml_inst *p = *rrv ;
    iml_inst *pp = 0;
    iml_inst *lp = 0;
    iml_inst *status_draw = 0 ;
    int HowManyPacket = 0 ;
    Bool KeysymShouldBeReturned = False ;

    while (p) {
	HowManyPacket ++ ;
	switch((p->opcode) & (~IMM_CB_RESULT_REQUIRED )){
 	  case IMM_NOP :
	    if(p->next){
		if(pp){
		    pp->next = p->next ;
		} else {
		    *rrv = p->next ;
		}
		p = p-> next ;
		continue ;
	    }
	    break ;
	  case IMM_RESET :
	    _iml_inst_trace(s->session_id," RESET");
	    break ;
	  case IMM_RESET_RETURN :
	  case IMM_COMMIT :
	    if(s->private_status & BEING_RESET){
		if(s->private_status & RESET_DATA_EXIST){
		    p->opcode = IMM_NOP ;
		} else {
		    _iml_inst_trace(s->session_id," RESET_RETURN");
		    p->opcode = IMM_RESET_RETURN ;
		    s->private_status |= RESET_DATA_EXIST ;
		}
		break ;
	    }
	    _iml_inst_trace(s->session_id," COMMIT");
	    KeysymShouldBeReturned = True ;
#ifndef IMSERVER
	    if(p->next){
		s->remainder = p->next ;
		p->next = (iml_inst*)_iml_new(s, sizeof(iml_inst));
		p = p->next ;
		p->opcode = IMM_PUT_QUEUE ;
		p->next = NULL ;
		_imm_trace(" PUT_QUEUE",0 ,0);
		return ;
	    }
#endif
	    break ;
	  case IMM_SET_STATUS :
	    _iml_inst_trace(s->session_id," SET_STATUS");
	    break ;
/* Obsolete
 *	  case IMM_CONVERSION_OFF :
 *	    _iml_inst_trace(s->session_id," CONVERSION_OFF");
 *	    break ;
 */
/*
 * PREEDIT REGION POST PROCCESS
 */
	  case IMM_PREEDIT_START :
	    if(s->active_regions & PREEDIT_IS_ACTIVE){
		p->opcode = IMM_NOP ;
		break ;
	    } else {
		_iml_inst_trace(s->session_id," PREEDIT_START");
		s->active_regions |= PREEDIT_IS_ACTIVE ;
	    }

	    /*
	     * OPTIMIZATION:
	     * If the series of packets contain complete start/draws/done
	     * sequence in a contiguous list, then it should be removed
	     * from the queue.
	     */
	    if(p->next){
		iml_inst *tp = p->next ;
		XIMPreeditDrawCallbackStruct *pdcs ;
		while(((tp->opcode)&(~IMM_CB_RESULT_REQUIRED)) == IMM_PREEDIT_DRAW){
		    if(!tp->next) goto OUT ;
		    tp = tp->next ;
		    pdcs = (XIMPreeditDrawCallbackStruct *)&tp->operand ;
		    if(pdcs->text) goto OUT ;
		}
		if(((tp->opcode)&(~IMM_CB_RESULT_REQUIRED)) == IMM_PREEDIT_DONE){
		    s->active_regions &= ~PREEDIT_IS_ACTIVE;
		    if(pp){
			if(tp->next){
			    pp->next = tp->next ;
			    p = tp->next ;
			} else {
			    tp->opcode = IMM_NOP ;
			    pp->next = p = tp ;
			}
			continue ;
		    } else {
			if(tp->next){
			    *rrv = p = tp->next ;
			    continue ;
			} else {
			    *rrv = p = tp ;
			    p->opcode = IMM_NOP ;
			}
			continue ;
		    }
		}
   OUT:
#ifdef NO_PREEDIT_RESULTS
		p->opcode &= (~IMM_CB_RESULT_REQUIRED) ;
#else
#ifdef XXXXIMSERVER
		if(p->next){
		    s->remainder2 = p->next ;
		    p->next = NULL ;
		    _imm_trace(" RESULTS REQUIRED",0 ,0);
		    return ;
		}
#else
		/*
		 * compiler bug!! Label needs any executable line!!
		 */
		HowManyPacket ;
#endif
#endif
	    }
	    break ;
	  case IMM_PREEDIT_CARET :
	    _iml_inst_trace(s->session_id," PREEDIT_CARET");
	    goto post_preedit;
	  case IMM_PREEDIT_DRAW :
	    _iml_inst_trace(s->session_id," PREEDIT_DRAW");
post_preedit:
	    if(!(s->active_regions & PREEDIT_IS_ACTIVE)){
		lp=(iml_inst*)_iml_new(s, sizeof(iml_inst));
		lp->operand = (caddr_t)IMM_PREEDIT_START ;
		lp->next = p ;
		if(pp){
		    pp->next = lp ;
		} else {
		    p = *rrv = lp ;
		}
		s->active_regions |= PREEDIT_IS_ACTIVE ;
	    }
	    if(p->next){
		iml_inst *tp = p->next ;
		XIMPreeditDrawCallbackStruct *pdcs = (XIMPreeditDrawCallbackStruct *)&p->operand ;
		if(!pdcs->text && tp->opcode == IMM_PREEDIT_DONE ){
		    if(pp){
			preedit_done_optim(s, p, pp, (iml_inst **)NULL);
		    } else {
			preedit_done_optim(s, p, (iml_inst *)NULL, rrv);
		    }
		}
	    }
	    break ;
	  case IMM_PREEDIT_DONE:
	    if(!(s->active_regions & PREEDIT_IS_ACTIVE)){
		p->opcode = IMM_NOP ;
	    } else {
		s->active_regions &= ~PREEDIT_IS_ACTIVE;
		_iml_inst_trace(s->session_id," PREEDIT_DONE");
		if(pp){
		    preedit_done_optim(s, p, pp, (iml_inst**)NULL);
		} else {
		    preedit_done_optim(s, p, (iml_inst*)NULL, rrv);
		}
	    }
	    break;
/*
 * LOOKUP REGION POST PROCCESS
 */
	  case IMM_LOOKUP_START :
	    _iml_inst_trace(s->session_id," LOOKUP_START");
	    if(s->active_regions & LOOKUP_IS_ACTIVE){
               /* Nothing */
	    } else {
		s->active_regions |= LOOKUP_IS_ACTIVE ;
#ifdef XXXXIMSERVER
		if(p->next){
		    s->remainder2 = p->next ;
		    p->next = NULL ;
		    _imm_trace(" RESULTS REQUIRED",0 ,0);
		    return ;
		}
#endif
	    }
	    break ;
	  case IMM_LOOKUP_DRAW :
	    _iml_inst_trace(s->session_id," LOOKUP_DRAW");
	    goto post_lookup;
	    /* break ;*/
	  case IMM_LOOKUP_PROCESS :
	    _iml_inst_trace(s->session_id," LOOKUP_PROCESS");
post_lookup:
	    if(!(s->active_regions & LOOKUP_IS_ACTIVE)){
		XIMLookupStartCallbackStruct *ls;

		/*
		 * XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		 * XXXXXXX Assume always CBIsMaster XXXXXXXXXXX
		 */
		_iml_inst_trace(s->session_id,"<It might be crash>");
		lp=(iml_inst *)_iml_new(s,sizeof(iml_inst) +
			sizeof(XIMLookupStartCallbackStruct));
		lp->opcode = IMM_LOOKUP_START | IMM_CB_RESULT_REQUIRED;
		lp->next = NULL ;
		ACTIVATE_REGION(s, LOOKUP) ;
		ls = (XIMLookupStartCallbackStruct *)&lp->operand ;
		ls->event = s->event ;
		ls->whoIsMaster = s->whoIsMaster ;
		ls->XIMPreference = &s->XIMPreference ;
		ls->CBPreference = &s->CBPreference ;
		if(pp){
		    pp->next = lp ;
		} else {
		    p = *rrv = lp ;
		}
		s->active_regions |= LOOKUP_IS_ACTIVE ;
	    }
#ifdef XXXXIMSERVER
	    if(p->next){
		s->remainder2 = p->next ;
		p->next = NULL ;
		_imm_trace(" RESULTS REQUIRED",0 ,0);
		return ;
	    }
#endif
	    break ;
	  case IMM_LOOKUP_DONE :
	    if(!(s->active_regions & LOOKUP_IS_ACTIVE)){
		p->opcode = IMM_NOP ;
	    } else {
		_iml_inst_trace(s->session_id," LOOKUP_DONE");
		s->active_regions &= ~LOOKUP_IS_ACTIVE;
	    }
	    break ;
/*
 * STATUS REGION POST PROCCESS
 */
	  case IMM_STATUS_START :
	    if(s->active_regions & STATUS_IS_ACTIVE){
		p->opcode = IMM_NOP ;
	    } else {
		_iml_inst_trace(s->session_id," STATUS_START");
		s->active_regions |= STATUS_IS_ACTIVE ;
	    }
	    break ;
	  case IMM_STATUS_DRAW :
            /*
             * possible optimization
	     * more than 1 draw for 1 sequence is waisting.
	     * just keep latest draw.
             */
            if(status_draw){
                status_draw->opcode = IMM_NOP ;
            }
            status_draw = p ;
	    _iml_inst_trace(s->session_id," STATUS_DRAW");
	    break ;
	  case IMM_STATUS_DONE :
	    if(!(s->active_regions & STATUS_IS_ACTIVE)){
		p->opcode = IMM_NOP ;
	    } else {
		_iml_inst_trace(s->session_id," STATUS_DONE");
		s->active_regions &= ~STATUS_IS_ACTIVE;
	    }
	    break ;
/*
 * MISCELLANEOUS POST PROCCESS
 */
	  case IMM_KEY_INFO :
	    _iml_inst_trace(s->session_id," KEY_INFO");
	    break ;
	  case IMM_PUT_QUEUE :
	    _iml_inst_trace(s->session_id," PUT_QUEUE");
	    break ;
	  case IMM_KEYPRESS:
	    _iml_inst_trace(s->session_id," KEYPRESS");
	    break ;

	case IMM_AUX_START_2:
	    _iml_inst_trace(s->session_id," AUX_START_2");
	    break ;

	case IMM_AUX_DRAW_2:
	    _iml_inst_trace(s->session_id," AUX_DRAW_2");
	    break ;

	case IMM_AUX_DONE_2:
	    _iml_inst_trace(s->session_id," AUX_DONE_2");
	    break ;

	  default:
	    fprintf(stderr, "Warning: iml_post_proc: UNKOWN opcode 0X%x\n",
		    (p->opcode) & (~IMM_CB_RESULT_REQUIRED ) );
	    _iml_inst_trace(s->session_id,"UNKNOWN");
	    p->opcode = IMM_NOP ;
	    break ;
	}
	pp = p ;
	p = p->next ;
    }

    if(!KeysymShouldBeReturned)
      s->keysym = NoSymbol ;

    _iml_inst_trace(s->session_id,"\n");
}
#ifdef notdef
Private int
iml_generic_send_event(s, rrv, event)
iml_session_t *s;
iml_inst **rrv;
XKeyEvent event ;
{

}
Private void
iml_generic_close(s, rrv)
iml_session_t *s;
iml_inst **rrv;
{

}
Private void
iml_generic_reset(s, rrv)
iml_session_t *s;
iml_inst **rrv;
{

}
Private void
iml_generic_send_results(s, rrv)
iml_session_t *s;
iml_inst **rrv;
{

}
Private void
iml_generic_conversion_on(s, rrv)
iml_session_t *s;
iml_inst **rrv;
{

}

Private void
iml_generic_get_status(s, rrv)
iml_session_t *s;
iml_inst **rrv;
{
    iml_status_t *status ;
    *rrv=(iml_inst*)_iml_new(s, sizeof(iml_inst) +
			     sizeof(iml_status_t));
    (*rrv)->opcode = IMM_SET_STATUS ;
    (*rrv)->next = NULL ;
    status =  (iml_status_t *) &((*rrv)->operand);
    *status = s->public_status ;
    _imm_trace("IMM_SET_STATUS",*status,0);

}
Private void
iml_generic_get_key_map(session, rrv)
iml_session_t *session;
iml_inst **rrv;
{

}

Private void
iml_generic_set_status(s, rrv, status)
iml_session_t *s;
iml_inst **rrv;
iml_status_t *status ;
{
    int prev_status = s->public_status ;
    s->public_status = *status ;
    if(((s->public_status & IMLSTATUS_Henkan_Mode) == IMLSTATUS_Henkan_Mode) &&
       ((prev_status & IMLSTATUS_Henkan_Mode) != IMLSTATUS_Henkan_Mode )){
	s->iml_conversion_on(s, rrv);
    }
}
Private void
iml_generic_set_key_map(s, rrv)
iml_session_t *s;
iml_inst **rrv;
{

}

Private void
iml_generic_set_keyboard_state(s, rrv, key_buttons)
iml_session_t *s ;
iml_inst **rrv;
IMKeyState *key_buttons;
{
    register i ;
    register iml_inst *lp, *clp;
    XIMStatusDrawCallbackStruct *q ;
    XIMText *p ;
    wchar_t *wc_text ;
    int	current_region ;

    _imm_trace("IMM_SET_KEYBOARD_STATE",0,key_buttons);
    current_region = _iml_get_current_region(s);
    if(*key_buttons == MODE_SWITCH_ON){

    } else {

    }

#ifdef ALWAYS_SET_REGION_REQUIRED
    *rrv = lp =(iml_inst *)_iml_new(s,
			      sizeof(IMM_Region)+sizeof(iml_inst));
    lp->opcode = IMM_SET_REGION ;
    _imm_trace("IMM_SET_REGION(pseudo STATUS)",0,0);
    lp->operand = (caddr_t)STATUS ;
    lp->next = (iml_inst*)_iml_new(s,
				   sizeof(iml_inst)+
				   sizeof(XIMStatusCBData));
    lp = lp->next ;
#else
    *rrv = lp = (iml_inst*)_iml_new(s,
				   sizeof(iml_inst)+
				   sizeof(XIMStatusDrawCallbackStruct));
#endif
    lp->next = NULL ;

    wc_text = s->status_cache.ws ;
    p = (XIMText *)_iml_new(s, sizeof(XIMText));
    lp->opcode = IMM_STATUS_DRAW  ;
    q = (XIMStatusDrawCallbackStruct *)&lp->operand ;
    q->type = XIMTextType ;
    q->data.text = p ;
    p->length = wcslen(wc_text);
    p->string.wide_char = wc_text ;
    p->encoding_is_wchar = True ;
    p->feedback = (XIMFeedback *)_iml_new(s,
			  p->length*sizeof(XIMFeedback));
    _imm_trace("IMM_STATUS_DRAW(UPDATE)",wc_text,p->length);

#ifdef  ALWAYS_SET_REGION_REQUIRED
    lp->next =(iml_inst *)_iml_new(s,
			      sizeof(IMM_Region)+sizeof(iml_inst));
    lp=lp->next ;
    lp->opcode = IMM_SET_REGION ;
    _imm_trace("IMM_SET_REGION(resume)",0,current_region);
    lp->operand = (caddr_t)current_region ;
#endif
    lp->next = 0 ;
}
#endif

/*----------------------------------------------------------
 * TRACE ROUTINES
 */
#ifdef IMLTRACE
Public void
_iml_inst_trace(id,s)
int id ;
char *s ;
{
    static neednl ;
    if(imlogic_trace & 0x40) {
	if(*s == '\n'){
	    if(neednl){
		fprintf(stderr,"%s",s);
	    }
	    neednl = 0 ;
	} else {
	    neednl++;
	    fprintf(stderr,"%s%d",s,id);
	}
    }
}

Public void
_iml_trace(id,s,s2)
int id ;
char *s ;
wchar_t *s2 ;
{
    if(imlogic_trace & 0x1) {
	fprintf(stderr,"M->L(%d): %s",id, s);
	if(s2){
	    fprintf(stderr," %ws - 0x%x ",s2, *s2);
	}
	fprintf(stderr,"\n");
    }
#ifdef CALL_MALLOC_VERIFY
    if(imlogic_trace & 0x10 )
	if(!malloc_verify())
	    fprintf(stderr,"MALLOC_VERIFY RETURNS 0\n");
#endif
}
Public void
_imm_trace(s1,s2,d)
char *s1 ;
wchar_t *s2 ;
unsigned short d;
{
    if(imlogic_trace & 0x1)  {
	fprintf(stderr,"L->M: %s ",s1);
	if(s2 == NULL){
	    fprintf(stderr,"- ");
	} else {
	    fprintf(stderr,"'%ws' ",s2);
	}
	fprintf(stderr,"0x%x\n",d);
    }
#ifdef CALL_MALLOC_VERIFY
    if(imlogic_trace & 0x10 )
	if(!malloc_verify())
	    fprintf(stderr,"MALLOC_VERIFY RETURNS 0\n");

#endif

}

Public void
_iml_slot_trace(s, session, new, ptr, size, link_depth)
char *s ;
iml_session_t *session ;
iml_inst_slot_t *new ;
char *ptr ;
{

    if(imlogic_trace & 0x4)
	fprintf(stderr,
		"%s session0x%x slot:0x%x adrress:0x%x size:0x%x link depth %d\n",
		s, session, new, ptr, size, link_depth
		);
#ifdef CALL_MALLOC_VERIFY
    if(imlogic_trace & 0x10 )
	if(!malloc_verify())
	    fprintf(stderr,"MALLOC_VERIFY RETURNS 0\n");

#endif
}

Private int byte_of_line = 16 ;
Private void fmtprt();

Public void
_iml_xdmem(top, len)
char *	top;
int	len;
{
    register	char *i,*j;
    register 	print_len ;

    if(!(imlogic_trace & 0x2)) return;
    j = top + len ;
    i = top ;
    while ( (print_len = j-i) >0 ) {
	if(print_len > byte_of_line){
	    fmtprt(i, i, byte_of_line);
	    i+=byte_of_line ;
	} else {
	    fmtprt(i, i, print_len);
	    break ;
	}
    }
    fflush(stderr);
}
Private void
fmtprt(data, offset, lsize)
char   *data;
long    offset;
short   lsize;
{
    short   n;
    char	linebuf[BUFSIZE];
    char	*line = linebuf, *p;

    sprintf(line, "  %08lx   ", offset);
    p = line + 13;
    for (n = 0; n < byte_of_line; n++) {
	*p++ = ' ';
	if (n >= lsize) {
	    sprintf(p, "    ");
	    p += 4;
	    ++n;
	} else {
	    sprintf(p, "%02x", *((unsigned char *)data + n));
	    p += 2;
	    if ((++n) == lsize)
		sprintf(p, "  ");
	    else
		sprintf(p, "%02x", *((unsigned char *)data + n));
	    p += 2;
	}
    }
    sprintf(p, "     ");
    p += 5;
    for (n = 0; n < byte_of_line; n++) {
	if (n >= lsize)
	    *p++ = ' ';
	else if (*(data + n) < 0x20 )
	    /*	else if (!isprint(*((unsigned char *)data + n)))*/
	    *p++ = '.';
	else
	    *p++ = *(data + n);
    }
    *p = '\0';
    fprintf(stderr,"%s\n", line);
}
Private long
htoi(p)
register char *p;		/* hex mojiretsu e no pointer */
{
    register long n = 0;

    if (upper(p) == -1)
	return (-1);
    while (*p >= '0' && *p <= '9' || *p >= 'A' && *p <= 'F')
	n = n * 16 + (*p++ >= 'A' ? *(p - 1) - 7 : *(p - 1)) - '0';
    return (n);
}

Private
upper(p)
register char *p;		/* hex mojiretsu e no pointer */
{
    register char *pp;

    for (pp = p; *pp; ++pp) {
	*pp = 'a' <= *pp && 'z' >= *pp ? *pp + 'A' - 'a' : *pp;
	if (!isxdigit(*pp))
	    return (-1);
    }
}

Private char   *
itoa(i, a)
int     i;		/* mojiretsu ni henkan suru binary (8-32 bit)  */
register char *a;	/* decimal mojiretsu o kakunou area no address */
{
    register int c = 0;
    register int b = 0;
    int     s;
    register char d;

    i = (s = i < 0) ? (-i) : i;
    do {
	*(a + c++) = i % 10 + '0';
    } while ((i /= 10) > 0);
    *(a + c++) = s ? '-' : '\0';
    *(a + c++) = '\0';
    for (c = strlen(a) - 1; b < c; d = *(a + b), *(a + b++) = *(a + c), *(a + c--) = d);
    return (a);
}
#endif


/* "$XConsortium: Lookup.c,v 1.12 90/12/11 13:19:10 rws Exp $"; */

/*
 * Copyright 1988, 1989 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission. M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 */

#if __STDC__
#ifndef Const
#define Const const
#endif
#else
#ifndef Const
#define Const /**/
#endif
#endif

/* bit (1<<i) means character is in codeset i */
static unsigned short Const latin1[128] =
  {0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x10ee, 0x0000, 0x1000, 0x1084, 0x102e, 0x1000, 0x1080, 0x108e, /* 10 */
   0x108e, 0x1080, 0x0000, 0x1080, 0x1080, 0x10ee, 0x1000, 0x1008,
   0x108e, 0x1080, 0x1084, 0x1084, 0x108e, 0x1004, 0x1000, 0x1084, /* 11 */
   0x100e, 0x1000, 0x0000, 0x1080, 0x1000, 0x1084, 0x1000, 0x0000,
   0x0004, 0x000e, 0x000e, 0x0008, 0x000e, 0x0008, 0x0008, 0x0006, /* 12 */
   0x0004, 0x000e, 0x0004, 0x000e, 0x0004, 0x000e, 0x000e, 0x0004,
   0x0000, 0x0004, 0x0004, 0x0006, 0x000e, 0x0008, 0x000e, 0x000e, /* 13 */
   0x0008, 0x0004, 0x000e, 0x000c, 0x000e, 0x0002, 0x0000, 0x000e,
   0x0004, 0x000e, 0x000e, 0x0008, 0x000e, 0x0008, 0x0008, 0x0006, /* 14 */
   0x0004, 0x000e, 0x0004, 0x000e, 0x0004, 0x000e, 0x000e, 0x0004,
   0x0000, 0x0004, 0x0004, 0x0006, 0x000e, 0x0008, 0x000e, 0x000e, /* 15 */
   0x0008, 0x0004, 0x000e, 0x000c, 0x000e, 0x0002, 0x0000, 0x0000};

/* bit (1<<i) means character is in codeset i */
static unsigned short Const latin2[128] =
  {0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0008, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 10 */
   0x0000, 0x0008, 0x0004, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004,
   0x0000, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, /* 11 */
   0x0000, 0x0008, 0x0004, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004,
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 12 */
   0x0008, 0x0000, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 13 */
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 14 */
   0x0008, 0x0000, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
   0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 15 */
   0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c};

/* maps Cyrillic keysyms to 8859-5 */
static unsigned char Const cyrillic[128] =
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xf2, 0xf3, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, /* 10 */
    0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0x00, 0xfe, 0xff,
    0xf0, 0xa2, 0xa3, 0xa1, 0xa4, 0xa5, 0xa6, 0xa7, /* 11 */
    0xa8, 0xa9, 0xaa, 0xab, 0xac, 0x00, 0xae, 0xaf,
    0xee, 0xd0, 0xd1, 0xe6, 0xd4, 0xd5, 0xe4, 0xd3, /* 12 */
    0xe5, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde,
    0xdf, 0xef, 0xe0, 0xe1, 0xe2, 0xe3, 0xd6, 0xd2, /* 13 */
    0xec, 0xeb, 0xd7, 0xe8, 0xed, 0xe9, 0xe7, 0xea,
    0xce, 0xb0, 0xb1, 0xc6, 0xb4, 0xb5, 0xc4, 0xb3, /* 14 */
    0xc5, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe,
    0xbf, 0xcf, 0xc0, 0xc1, 0xc2, 0xc3, 0xb6, 0xb2, /* 15 */
    0xcc, 0xcb, 0xb7, 0xc8, 0xcd, 0xc9, 0xc7, 0xca};

/* maps Greek keysyms to 8859-7 */
static unsigned char Const greek[128] =
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xb6, 0xb8, 0xb9, 0xba, 0xda, 0x00, 0xbc, /* 10 */
    0xbe, 0xdb, 0x00, 0xbf, 0x00, 0x00, 0xb5, 0xaf,
    0x00, 0xdc, 0xdd, 0xde, 0xdf, 0xfa, 0xc0, 0xfc, /* 11 */
    0xfd, 0xfb, 0xe0, 0xfe, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, /* 12 */
    0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
    0xd0, 0xd1, 0xd3, 0x00, 0xd4, 0xd5, 0xd6, 0xd7, /* 13 */
    0xd8, 0xd9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, /* 14 */
    0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
    0xf0, 0xf1, 0xf3, 0xf2, 0xf4, 0xf5, 0xf6, 0xf7, /* 15 */
    0xf8, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define sLatin1		0
#define sLatin2		1
#define sLatin3		2
#define sLatin4		3
#define sKana		4
#define sX0201		0x01000004
#define sArabic		5
#define sCyrillic	6
#define sGreek		7
#define sAPL		11
#define sHebrew		12

Private
int XmuLookupString (event, buffer, nbytes, keysym, status, keysymSet)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
    unsigned long keysymSet;
{
    int count;
    KeySym symbol;
    unsigned long kset;
    unsigned char c;

    kset = keysymSet & 0xffffff;
    if (event->display) {
	count = XLookupString(event, buffer, nbytes, &symbol, status);
	if (keysym) *keysym = symbol;
    } else {
	count = 1;
	c = event->keycode;
	if (event->state & ControlMask) {
	    if ((c >= (unsigned char)'\300' && c <= (unsigned char)'\377')) c &= 0x9F;
	    if ((c >= '@' && c < '\177') || c == ' ') c &= 0x1F;
	    else if (c == '2') c = '\000';
	    else if (c >= '3' && c <= '7') c -= ('3' - '\033');
	    else if (c == '8') c = '\177';
	    else if (c == '/') c = '_' & 0x1F;
	}
	buffer[0] = c;
	symbol = event->keycode;
	if (keysym) *keysym = symbol;
    }
    if ((nbytes == 0) || (symbol == NoSymbol)) {
	/* nothing */
    } else if ((count == 0) && ((symbol >> 8) == kset)) {
	count = 1;
	switch (keysymSet) {
	case sKana:
	    buffer[0] = (symbol & 0xff);
	    if (buffer[0] == 0x7e)
		count = 0;
	    break;
	case sCyrillic:
	    buffer[0] = cyrillic[symbol & 0x7f];
	    break;
	case sGreek:
	    buffer[0] = greek[symbol & 0x7f];
	    if (!buffer[0])
		count = 0;
	    break;
	default:
	    buffer[0] = (symbol & 0xff);
	    break;
	}
    } else if ((keysymSet != 0) && (count == 1) &&
	       (((unsigned char *)buffer)[0] == symbol) &&
	       (symbol & 0x80) &&
	       !(latin1[symbol & 0x7f] & (1 << kset))) {
	if ((keysymSet == sHebrew) && (symbol == XK_multiply))
	    buffer[0] = 0xaa;
	else if ((keysymSet == sHebrew) && (symbol == XK_division))
	    buffer[0] = 0xba;
	else if ((keysymSet == sCyrillic) && (symbol == XK_section))
	    buffer[0] = 0xfd;
	else if ((keysymSet == sX0201) && (symbol == XK_yen))
	    buffer[0] = 0x5c;
	else
	    count = 0;
    } else if (count != 0) {
	if ((keysymSet == sX0201) &&
	    ((symbol == XK_backslash) || (symbol == XK_asciitilde)))
	    count = 0;
    } else if (((symbol >> 8) == sLatin2) &&
	       (symbol & 0x80) && (latin2[symbol & 0x7f] & (1 << kset))) {
	buffer[0] = (symbol & 0xff);
	count = 1;
    } else if ((keysymSet == sGreek) &&
	       ((symbol == XK_leftsinglequotemark) ||
		(symbol == XK_rightsinglequotemark))) {
	buffer[0] = symbol - (XK_leftsinglequotemark - 0xa1);
	count = 1;
    }
    return count;
}

#ifdef USE_XMU
/* produces ISO 8859-1 encoding plus ASCII control */
Private
int XmuLookupLatin1 (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XLookupString(event, buffer, nbytes, keysym, status);
}

/* produces ISO 8859-2 encoding plus ASCII control */
Private
int XmuLookupLatin2 (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sLatin2);
}

/* produces ISO 8859-3 encoding plus ASCII control */
Private
int XmuLookupLatin3 (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sLatin3);
}

/* produces ISO 8859-4 encoding plus ASCII control */
Private
int XmuLookupLatin4 (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sLatin4);
}

/* produces ISO 8859-1 GL plus Katakana plus ASCII control */
Private
int XmuLookupKana (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sKana);
}

/* produces JIS X0201-1976 (8-bit) */
Private
int XmuLookupJISX0201 (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sX0201);
}

/* produces ISO 8859-6 encoding plus ASCII control */
Private
int XmuLookupArabic (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sArabic);
}

/* produces ISO/IEC 8859-5 encoding plus ASCII control */
Private
int XmuLookupCyrillic (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sCyrillic);
}

/* produces ISO 8859-7 encoding plus ASCII control */
Private
int XmuLookupGreek (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sGreek);
}

/* XXX this character set needs work */
Private
int XmuLookupAPL (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sAPL);
}

/* produces ISO 8859-8 encoding plus ASCII control */
Private
int XmuLookupHebrew (event, buffer, nbytes, keysym, status)
    register XKeyEvent *event;
    char *buffer;
    int nbytes;
    KeySym *keysym;
    XComposeStatus *status;
{
    return XmuLookupString(event, buffer, nbytes, keysym, status, sHebrew);
}
#endif /* USE_XMU */
