#ifndef lint
#ident	"@(#)XSunIMTrans.c	2.5	94/08/08 SMI"
#endif

/******************************************************************

              Copyright 1990, 1991, by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

                                             Sun Microsystems, Inc.
******************************************************************/

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#define INCLUDE_ALLOCA_H
#define SunJapanKeypad

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <malloc.h>

#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>

#if XlibSpecificationRelease < 5
#include <X11/XlibR5.h>
#endif /* XlibSpecificationRelease */

#ifdef sun
#include <X11/Sunkeysym.h>
#ifndef SunXK_Hangul
#define SunXK_Hangul            0xFF31
#endif
#ifndef SunXK_Hangul_Hanja
#define SunXK_Hangul_Hanja      0xFF34
#endif
#endif

#ifndef STANDALONE
#include "XSunExt.h"
#include "XSunIMProt.h"
#include "XSunIMPriv.h"
#include "XSunIMMMan.h"
#include "XSunIMMthd.h"
#include "XSunIMCore.h"
#endif /* STANDALONE */

#include "XSunIMTrans.h"
#include "XSunIMTransP.h"

/**************************** Global definitiosn ****************************/
#ifndef XtNumber
#define XtNumber(arr)           ((int) (sizeof(arr) / sizeof(arr[0])))
#endif
#ifndef TRUE
#define TRUE 	1
#endif
#ifndef FALSE
#define FALSE 	0
#endif

#define XtNew(type) ((type *) XimTMMalloc((unsigned) sizeof(type)))
#define XtNewString(str) \
    ((str) != NULL ? (strcpy(XimTMMalloc((unsigned)strlen(str) + 1), str)) : NULL)

#define XtWarningMsg(s1,s2) fprintf(stderr, "Htt: Warning: %s %s\n", s1, s2)

#ifdef INCLUDE_ALLOCA_H
#include <alloca.h>
#endif

#ifndef NO_ALLOCA

#ifdef __GNUC__
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#else /* ! __GNUC__ */
/*
 * warning: mips alloca is unsuitable, do not use.
 */
#if defined(vax) || defined(sun) || defined(apollo) || defined(stellar)
/*
 * Some System V boxes extract alloca.o from /lib/libPW.a; if you
 * decide that you don't want to use alloca, you might want to fix it here.
 */
#ifndef alloca
char *alloca();
#endif
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#endif /* who does alloca */
#endif /* __GNUC__ */
#endif /* NO_ALLOCA */

#ifndef ALLOCATE_LOCAL
#define ALLOCATE_LOCAL(size) XimTMMalloc((unsigned long)(size))
#define DEALLOCATE_LOCAL(ptr) XtFree((XtPointer)(ptr))
#endif /* ALLOCATE_LOCAL */


#define StringToQuark(string) XrmStringToQuark(string)
#define StringToName(string) XrmStringToName(string)
#define StringToClass(string) XrmStringToClass(string)

#define _XtEventTimerEventType ((TMLongCard)~0L)
#define KeysymModMask           (1L<<27) /* private to TM */
#define AnyButtonMask           (1L<<28) /* private to TM */

#define _XtKeyCode      unsigned int

typedef void* Opaque;

typedef void*           XtPointer;

typedef unsigned long EventMask;
typedef unsigned int Modifiers;

/*********************** Definitions from TranslateI.h *********************/

#define TM_NO_MATCH (-2)

#define TM_TYPE_SEGMENT_SIZE       16
#define TM_MOD_SEGMENT_SIZE        16

typedef unsigned char TMByteCard;
typedef unsigned short TMShortCard;
typedef unsigned long TMLongCard;
typedef short TMShortInt;

typedef Boolean (*MatchProc)();
    /* Event *parsed, TMEventPtr incoming */

typedef struct _ModToKeysymTable {
    Modifiers mask;
    int count;
    int idx;
} ModToKeysymTable;

typedef struct _LateBindings {
    unsigned int knot:1;
    unsigned int pair:1;
    unsigned short ref_count;   /* garbage collection */
    KeySym keysym;
} LateBindings, *LateBindingsPtr;

typedef short ModifierMask;

typedef struct _ActionsRec *ActionPtr;
typedef struct _ActionsRec {
    int idx;                    /* index into quarkTable to find proc */
    String *params;             /* pointer to array of params */
    Cardinal num_params;        /* number of params */
    ActionPtr next;             /* next action to perform */
} ActionRec;

typedef struct _XtStateRec *StatePtr;
typedef struct _XtStateRec {
    unsigned int        isCycleStart:1;
    unsigned int        isCycleEnd:1;
    TMShortCard         typeIndex;
    TMShortCard         modIndex;
    ActionPtr           actions;        /* rhs list of actions to perform */
    StatePtr            nextLevel;
}StateRec;

#define XtTableReplace  0
#define XtTableAugment  1
#define XtTableOverride 2
#define XtTableUnmerge  3

typedef unsigned int _XtTranslateOp;

/*
 * New Definitions
 */
typedef struct _TMModifierMatchRec{
    TMLongCard   modifiers;
    TMLongCard   modifierMask;
    LateBindingsPtr lateModifiers;
    Boolean      standard;
}TMModifierMatchRec, *TMModifierMatch;

typedef struct _TMTypeMatchRec{
    TMLongCard   eventType;
    TMLongCard   eventCode;
    TMLongCard   eventCodeMask;
    MatchProc    matchEvent;
}TMTypeMatchRec, *TMTypeMatch;

typedef struct _TMBranchHeadRec {
    unsigned int        isSimple:1;
    unsigned int        hasActions:1;
    unsigned int        hasCycles:1;
    int                 more:13;
    TMShortCard         typeIndex;
    TMShortCard         modIndex;
}TMBranchHeadRec, *TMBranchHead;

/* NOTE: elements of this structure must match those of
 * TMComplexStateTreeRec and TMParseStateTreeRec.
 */
typedef struct _TMSimpleStateTreeRec{
    unsigned int        isSimple:1;
    unsigned int        isAccelerator:1;
    unsigned int        mappingNotifyInterest:1;
    unsigned int        refCount:13;
    TMShortCard         numBranchHeads;
    TMShortCard         numQuarks;   /* # of entries in quarkTbl */
    TMShortCard         unused;      /* to ensure same alignment */
    TMBranchHeadRec     *branchHeadTbl;
    XrmQuark            *quarkTbl;  /* table of quarkified rhs*/
}TMSimpleStateTreeRec, *TMSimpleStateTree;

/* NOTE: elements of this structure must match those of
 * TMSimpleStateTreeRec and TMParseStateTreeRec.
 */
typedef struct _TMComplexStateTreeRec{
    unsigned int        isSimple:1;
    unsigned int        isAccelerator:1;
    unsigned int        mappingNotifyInterest:1;
    unsigned int        refCount:13;
    TMShortCard         numBranchHeads;
    TMShortCard         numQuarks;   /* # of entries in quarkTbl */
    TMShortCard         numComplexBranchHeads;
    TMBranchHeadRec     *branchHeadTbl;
    XrmQuark            *quarkTbl;  /* table of quarkified rhs*/
    StatePtr            *complexBranchHeadTbl;
}TMComplexStateTreeRec, *TMComplexStateTree;

/* NOTE: elements of this structure must match those of
 * TMSimpleStateTreeRec and TMComplexStateTreeRec.
 */
typedef struct _TMParseStateTreeRec{
    unsigned int        isSimple:1;
    unsigned int        isAccelerator:1;
    unsigned int        mappingNotifyInterest:1;
    unsigned int        isStackQuarks:1;
    unsigned int        isStackBranchHeads:1;
    unsigned int        isStackComplexBranchHeads:1;
    unsigned int        unused:10; /* to ensure correct alignment */
    TMShortCard         numBranchHeads;
    TMShortCard         numQuarks;   /* # of entries in quarkTbl */
    TMShortCard         numComplexBranchHeads;
    TMBranchHeadRec     *branchHeadTbl;
    XrmQuark            *quarkTbl;  /* table of quarkified rhs*/
    StatePtr            *complexBranchHeadTbl;
    TMShortCard         branchHeadTblSize;
    TMShortCard         quarkTblSize; /*total size of quarkTbl */
    TMShortCard         complexBranchHeadTblSize;
    StatePtr            head;
}TMParseStateTreeRec, *TMParseStateTree;

typedef union _TMStateTreeRec{
    TMSimpleStateTreeRec        simple;
    TMParseStateTreeRec         parse;
    TMComplexStateTreeRec       complex;
}*TMStateTree, **TMStateTreePtr, **TMStateTreeList;

typedef struct _TranslationData{
    unsigned char               hasBindings;    /* must be first */
    unsigned char               operation; /*replace,augment,override*/
    TMShortCard                 numStateTrees;
    struct _TranslationData     *composers[2];
    EventMask                   eventMask;
    TMStateTree                 stateTreeTbl[1]; /* variable length */
}TranslationData;

typedef struct _EventRec {
    TMLongCard modifiers;
    TMLongCard modifierMask;
    LateBindingsPtr lateModifiers;
    TMLongCard eventType;
    TMLongCard eventCode;
    TMLongCard eventCodeMask;
    MatchProc matchEvent;
    Boolean standard;
} Event;

typedef struct _EventSeqRec *EventSeqPtr;
typedef struct _EventSeqRec {
    Event event;        /* X event description */
    StatePtr state;     /* private to state table builder */
    EventSeqPtr next;   /* next event on line */
    ActionPtr actions;  /* r.h.s.   list of actions to perform */
} EventSeqRec;

typedef EventSeqRec EventRec;
typedef EventSeqPtr EventPtr;

typedef struct _TMEventRec {
    XEvent *xev;
    Event event;
}TMEventRec,*TMEventPtr;

typedef struct _TMGlobalRec{
    TMTypeMatchRec              **typeMatchSegmentTbl;
    TMShortCard                 numTypeMatches;
    TMShortCard                 numTypeMatchSegments;
    TMShortCard                 typeMatchSegmentTblSize;
    TMModifierMatchRec          **modMatchSegmentTbl;
    TMShortCard                 numModMatches;
    TMShortCard                 numModMatchSegments;
    TMShortCard                 modMatchSegmentTblSize;
    Boolean                     newMatchSemantics;
#ifdef TRACE_TM
    XtTranslations              *tmTbl;
    TMShortCard                 numTms;
    TMShortCard                 tmTblSize;
    struct _TMBindCacheRec      **bindCacheTbl;
    TMShortCard                 numBindCache;
    TMShortCard                 bindCacheTblSize;
    TMShortCard                 numLateBindings;
    TMShortCard                 numBranchHeads;
    TMShortCard                 numComplexStates;
    TMShortCard                 numComplexActions;
#endif /* TRACE_TM */
}TMGlobalRec;

static TMGlobalRec XimGlobalTM;


/* choose a number between 2 and 8 */
#define TMKEYCACHELOG2 6
#define TMKEYCACHESIZE (1<<TMKEYCACHELOG2)

typedef struct _KeyCacheRec {
    Modifiers modifiers_return; /* constant for a give XtKeyProc */
    KeyCode keycode[TMKEYCACHESIZE];
    unsigned short modifiers[TMKEYCACHESIZE];
    KeySym keysym[TMKEYCACHESIZE];
} TMKeyCache;

typedef struct _TMKeyContextRec {
    XEvent *event;
    unsigned long serial;
    KeySym keysym;
    Modifiers modifiers;
    TMKeyCache keycache;  /* keep this last, to keep offsets to others small */
} TMKeyContextRec, *TMKeyContext;

static void _XtBuildKeysymTables();

#define _InitializeKeysymTables(dpy, pd) \
    if (pd->keysyms == NULL) \
        _XtBuildKeysymTables(dpy, pd)

#define TMGetTypeMatch(idx) \
  ((TMTypeMatch) \
   &((XimGlobalTM.typeMatchSegmentTbl[((idx) >> 4)])[(idx) & 15]))
#define TMGetModifierMatch(idx) \
  ((TMModifierMatch) \
   &((XimGlobalTM.modMatchSegmentTbl[(idx) >> 4])[(idx) & 15]))

/* Useful Access Macros */
#define TMNewMatchSemantics() (XimGlobalTM.newMatchSemantics)
#define TMBranchMore(branch) (branch->more)
#define TMComplexBranchHead(tree, br) \
  (((TMComplexStateTree)tree)->complexBranchHeadTbl[TMBranchMore(br)])

typedef Boolean (*_XtTraversalProc)();


typedef int             EventType;

typedef char * (*ParseProc)(); /* str, closure, event ,error */
    /* char * str; */
    /* Opaque closure; */
    /* EventPtr event; */
    /* Boolean* error */

typedef void (*ModifierProc)();
typedef TMShortCard     Value;

typedef struct _ModifierRec {
    char*      name;
    XrmQuark   signature;
    ModifierProc modifierParseProc;
    Value      value;
} ModifierRec, *ModifierKeys;

typedef struct _EventKey {
    char        *event;
    XrmQuark    signature;
    EventType   eventType;
    ParseProc   parseDetail;
    Opaque      closure;
}EventKey, *EventKeys;

typedef struct {
    char        *name;
    XrmQuark    signature;
    Value       value;
} NameValueRec, *NameValueTable;

static void ParseModImmed();
static void ParseModSym();
static String PanicModeRecovery();
static String CheckForPoundSign();
static KeySym StringToKeySym();
static ModifierRec modifiers[] = {
    {"Ctrl",    0,      ParseModImmed,ControlMask},
    {"Meta",    0,      ParseModSym,  XK_Meta_L},
    {"Shift",   0,      ParseModImmed,ShiftMask},
    {"Alt",     0,      ParseModSym,  XK_Alt_L},
    {"Lock",    0,      ParseModImmed,LockMask},
    {"None",    0,      ParseModImmed,None},
    {"Mod1",    0,      ParseModImmed,Mod1Mask},
    {"Mod2",    0,      ParseModImmed,Mod2Mask},
    {"Mod3",    0,      ParseModImmed,Mod3Mask},
    {"Mod4",    0,      ParseModImmed,Mod4Mask},
    {"Mod5",    0,      ParseModImmed,Mod5Mask},
    {"m",       0,      ParseModSym,  XK_Meta_L},
    {"h",       0,      ParseModSym,  XK_Hyper_L},
    {"su",      0,      ParseModSym,  XK_Super_L},
    {"a",       0,      ParseModSym,  XK_Alt_L},
    {"Hyper",   0,      ParseModSym,  XK_Hyper_L},
    {"Super",   0,      ParseModSym,  XK_Super_L},

    {"Any",     0,      ParseModImmed,AnyModifier},

    {"c",       0,      ParseModImmed,ControlMask},
    {"s",       0,      ParseModImmed,ShiftMask},
    {"l",       0,      ParseModImmed,LockMask},
};

static String ParseKeySym();
# ifdef notdef
static String ParseKeyAndModifiers();
#endif

static EventKey events[] = {

/* Event Name,	  Quark, Event Type,	Detail Parser, Closure */

{"Key", 	    NULLQUARK, KeyPress,	ParseKeySym,	NULL},
{"KeyPress",	    NULLQUARK, KeyPress,	ParseKeySym,	NULL},
{"KeyUp",	    NULLQUARK, KeyRelease,	ParseKeySym,	NULL},
{"KeyDown",	    NULLQUARK, KeyPress,	ParseKeySym,	NULL},
{"KeyRelease",	    NULLQUARK, KeyRelease,	ParseKeySym,	NULL},
# ifdef notdef
{"Ctrl",            NULLQUARK, KeyPress, ParseKeyAndModifiers,(Opaque)ControlMask},
{"Shift",           NULLQUARK, KeyPress, ParseKeyAndModifiers,(Opaque)ShiftMask},
{"Meta",            NULLQUARK, KeyPress,   ParseKeyAndModifiers,(Opaque)NULL},
# endif /* notdef */

#ifdef DEBUG
# ifdef notdef
{"Timer",	    NULLQUARK, _XtTimerEventType,ParseNone,	NULL},
{"EventTimer",	    NULLQUARK, _XtEventTimerEventType,ParseNone,NULL},
# endif /* notdef */
#endif /* DEBUG */

/* Event Name,	  Quark, Event Type,	Detail Parser, Closure */

};

#define ScanFor(str, ch) \
    while ((*(str) != (ch)) && (*(str) != '\0') && (*(str) != '\n')) (str)++

#define ScanNumeric(str)  while ('0' <= *(str) && *(str) <= '9') (str)++

#define ScanAlphanumeric(str) \
    while (('A' <= *(str) && *(str) <= 'Z') || \
           ('a' <= *(str) && *(str) <= 'z') || \
           ('0' <= *(str) && *(str) <= '9')) (str)++

#define ScanWhitespace(str) \
    while (*(str) == ' ' || *(str) == '\t') (str)++


/*********************** Definitions from InitialI.h *********************/

#include <X11/Xfuncs.h>

#define XtBCopy(src, dst, size)         \
        bcopy((char *) (src), (char *) (dst), (int) (size));

#define XtBZero(dst, size) bzero((char *) (dst), (int) (size));

#define XtBCmp(b1, b2, size) bcmp((char *) (b1), (char *) (b2), (int) (size))


#ifndef MAX
#define MAX(a,b) (((a) > (b)) ? (a) : (b))
#endif

#ifndef MIN
#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#endif

typedef struct {
    char*       start;
    char*       current;
    int         bytes_remaining;
} Heap;

typedef struct _XtPerDisplayStruct {
    KeySym *keysyms;                   /* keycode to keysym table */
    int keysyms_per_keycode;           /* number of keysyms for each keycode*/
    int min_keycode, max_keycode;      /* range of keycodes */
    KeySym *modKeysyms;                /* keysym values for modToKeysysm */
    ModToKeysymTable *modsToKeysyms;   /* modifiers to Keysysms index table*/
    unsigned char isModifier[32];      /* key-is-modifier-p bit table */
    KeySym lock_meaning;               /* Lock modifier meaning */
    Modifiers mode_switch;             /* keyboard group modifiers */
    Heap heap;
    int multi_click_time;              /* for XtSetMultiClickTime */
    struct _TMKeyContextRec* tm_context;     /* for XtGetActionKeysym */
} XtPerDisplayStruct, *XtPerDisplay;

static XtPerDisplay _XtperDisplayList = NULL;

#define _XtGetPerDisplay() _XtperDisplayList

static void XtTranslateKeycode();
static void XtTranslateKey();

#ifndef Const
#ifdef __STDC__
#define Const const
#else
#define Const /**/
#endif
#endif

#define FLUSHKEYCACHE(ctx) bzero((char *)&ctx->keycache, sizeof(TMKeyCache))

/*
 * The following array reorders the modifier bits so that the most common ones
 * (used by a translator) are in the top-most bits with respect to the size of
 * the keycache.  The array currently just reverses the bits as a good guess.
 * This might be more trouble than it is worth, but it seems to help.
 */

#define FM(i) i >> (8 - TMKEYCACHELOG2)
static Const unsigned char modmix[256] = {
FM(0x00), FM(0x80), FM(0x40), FM(0xc0), FM(0x20), FM(0xa0), FM(0x60), FM(0xe0),
FM(0x10), FM(0x90), FM(0x50), FM(0xd0), FM(0x30), FM(0xb0), FM(0x70), FM(0xf0),
FM(0x08), FM(0x88), FM(0x48), FM(0xc8), FM(0x28), FM(0xa8), FM(0x68), FM(0xe8),
FM(0x18), FM(0x98), FM(0x58), FM(0xd8), FM(0x38), FM(0xb8), FM(0x78), FM(0xf8),
FM(0x04), FM(0x84), FM(0x44), FM(0xc4), FM(0x24), FM(0xa4), FM(0x64), FM(0xe4),
FM(0x14), FM(0x94), FM(0x54), FM(0xd4), FM(0x34), FM(0xb4), FM(0x74), FM(0xf4),
FM(0x0c), FM(0x8c), FM(0x4c), FM(0xcc), FM(0x2c), FM(0xac), FM(0x6c), FM(0xec),
FM(0x1c), FM(0x9c), FM(0x5c), FM(0xdc), FM(0x3c), FM(0xbc), FM(0x7c), FM(0xfc),
FM(0x02), FM(0x82), FM(0x42), FM(0xc2), FM(0x22), FM(0xa2), FM(0x62), FM(0xe2),
FM(0x12), FM(0x92), FM(0x52), FM(0xd2), FM(0x32), FM(0xb2), FM(0x72), FM(0xf2),
FM(0x0a), FM(0x8a), FM(0x4a), FM(0xca), FM(0x2a), FM(0xaa), FM(0x6a), FM(0xea),
FM(0x1a), FM(0x9a), FM(0x5a), FM(0xda), FM(0x3a), FM(0xba), FM(0x7a), FM(0xfa),
FM(0x06), FM(0x86), FM(0x46), FM(0xc6), FM(0x26), FM(0xa6), FM(0x66), FM(0xe6),
FM(0x16), FM(0x96), FM(0x56), FM(0xd6), FM(0x36), FM(0xb6), FM(0x76), FM(0xf6),
FM(0x0e), FM(0x8e), FM(0x4e), FM(0xce), FM(0x2e), FM(0xae), FM(0x6e), FM(0xee),
FM(0x1e), FM(0x9e), FM(0x5e), FM(0xde), FM(0x3e), FM(0xbe), FM(0x7e), FM(0xfe),
FM(0x01), FM(0x81), FM(0x41), FM(0xc1), FM(0x21), FM(0xa1), FM(0x61), FM(0xe1),
FM(0x11), FM(0x91), FM(0x51), FM(0xd1), FM(0x31), FM(0xb1), FM(0x71), FM(0xf1),
FM(0x09), FM(0x89), FM(0x49), FM(0xc9), FM(0x29), FM(0xa9), FM(0x69), FM(0xe9),
FM(0x19), FM(0x99), FM(0x59), FM(0xd9), FM(0x39), FM(0xb9), FM(0x79), FM(0xf9),
FM(0x05), FM(0x85), FM(0x45), FM(0xc5), FM(0x25), FM(0xa5), FM(0x65), FM(0xe5),
FM(0x15), FM(0x95), FM(0x55), FM(0xd5), FM(0x35), FM(0xb5), FM(0x75), FM(0xf5),
FM(0x0d), FM(0x8d), FM(0x4d), FM(0xcd), FM(0x2d), FM(0xad), FM(0x6d), FM(0xed),
FM(0x1d), FM(0x9d), FM(0x5d), FM(0xdd), FM(0x3d), FM(0xbd), FM(0x7d), FM(0xfd),
FM(0x03), FM(0x83), FM(0x43), FM(0xc3), FM(0x23), FM(0xa3), FM(0x63), FM(0xe3),
FM(0x13), FM(0x93), FM(0x53), FM(0xd3), FM(0x33), FM(0xb3), FM(0x73), FM(0xf3),
FM(0x0b), FM(0x8b), FM(0x4b), FM(0xcb), FM(0x2b), FM(0xab), FM(0x6b), FM(0xeb),
FM(0x1b), FM(0x9b), FM(0x5b), FM(0xdb), FM(0x3b), FM(0xbb), FM(0x7b), FM(0xfb),
FM(0x07), FM(0x87), FM(0x47), FM(0xc7), FM(0x27), FM(0xa7), FM(0x67), FM(0xe7),
FM(0x17), FM(0x97), FM(0x57), FM(0xd7), FM(0x37), FM(0xb7), FM(0x77), FM(0xf7),
FM(0x0f), FM(0x8f), FM(0x4f), FM(0xcf), FM(0x2f), FM(0xaf), FM(0x6f), FM(0xef),
FM(0x1f), FM(0x9f), FM(0x5f), FM(0xdf), FM(0x3f), FM(0xbf), FM(0x7f), FM(0xff)
};
#undef FM

#define TRANSLATE(ctx,pd,dpy,key,mod,mod_ret,sym_ret) \
{ \
    int _i_ = (((key) - (pd)->min_keycode + modmix[(mod) & 0xff]) & \
	       (TMKEYCACHESIZE-1)); \
    if ((key) != 0 && /* Xlib XIM composed input */ \
	(ctx)->keycache.keycode[_i_] == (key) && \
	(ctx)->keycache.modifiers[_i_] == (mod)) { \
	mod_ret = (ctx)->keycache.modifiers_return; \
	sym_ret = (ctx)->keycache.keysym[_i_]; \
    } else { \
	XtTranslateKeycode(dpy, key, mod, &mod_ret, &sym_ret); \
	(ctx)->keycache.keycode[_i_] = key; \
	(ctx)->keycache.modifiers[_i_] = (unsigned short)(mod); \
	(ctx)->keycache.keysym[_i_] = sym_ret; \
	(ctx)->keycache.modifiers_return = mod_ret; \
    } \
}

/************************** Functions definition ***************************/
static Boolean _XtMatchUsingStandardMods ();
static Boolean _XtMatchUsingDontCareMods();
static Boolean _XtComputeLateBindings();

static void Compile_XtModifierTable();
static void Compile_XtEventTable();

static void _xim_tm_free_reserved_event ();
static Bool _xim_tm_make_failed_result();
static Bool _xim_tm_add_reserved_event();
static Bool _xim_tm_make_succeeded_result();
static void _xim_tm_destroy_translations ();


#ifndef X_NOT_STDC_ENV
#include <stdlib.h>
#else
char *malloc(), *realloc(), *calloc();
#endif

#define Xmalloc(size) malloc((size))
#define Xrealloc(ptr, size) realloc((ptr), (size))
#define Xcalloc(nelem, elsize) calloc((nelem), (elsize))
#define Xfree(ptr) free(ptr)

static void
_XtHeapInit(heap)
    Heap*	heap;
{
    heap->start = NULL;
    heap->bytes_remaining = 0;
}

static char *
XimTMMalloc(size)
    unsigned size;
{
    char *ptr;
    if ((ptr = Xmalloc(size)) == NULL) {
	fprintf(stderr, "%s %s\n",
	    "Htt: Fatal error:",
	    "XimTMMalloc - Local memory allocation faild.");
	exit(1);
    }

    return(ptr);
}

static char *
XimTMRealloc(ptr, size)
    char     *ptr;
    unsigned size;
{
    if (ptr == NULL) return(XimTMMalloc(size));
    else if ((ptr = Xrealloc(ptr, size)) == NULL) {
	fprintf(stderr, "%s %s\n",
	    "Htt: Fatal error:",
	    "XimTMRealloc - Local memory allocation faild.");
	exit(1);
    }

   return(ptr);
}

static void
XtFree(ptr)
    char *ptr;
{
   if (ptr != NULL) Xfree(ptr);
}

#ifndef HEAP_SEGMENT_SIZE
#define HEAP_SEGMENT_SIZE 1492
#endif

static char *
_XtHeapAlloc(heap, bytes)
    Heap*       heap;
    Cardinal    bytes;
{
    register char* heap_loc;
    if (heap == NULL) return XimTMMalloc(bytes);
    if (heap->bytes_remaining < (int)bytes) {
        if ((bytes + sizeof(char*)) >= (HEAP_SEGMENT_SIZE>>1)) {
            /* preserve current segment; insert this one in front */
#ifdef _TRACE_HEAP
            printf( "allocating large segment (%d bytes) on heap %#x\n",
                    bytes, heap );
#endif
            heap_loc = XimTMMalloc(bytes + sizeof(char*));
            if (heap->start) {
                *(char**)heap_loc = *(char**)heap->start;
                *(char**)heap->start = heap_loc;
            }
            else {
                *(char**)heap_loc = NULL;
                heap->start = heap_loc;
            }
            return heap_loc + sizeof(char*);
        }
        /* else discard remainder of this segment */
#ifdef _TRACE_HEAP
        printf( "allocating new segment on heap %#x\n", heap );
#endif
        heap_loc = XimTMMalloc((unsigned)HEAP_SEGMENT_SIZE);
        *(char**)heap_loc = heap->start;
        heap->start = heap_loc;
        heap->current = heap_loc + sizeof(char*);
        heap->bytes_remaining = HEAP_SEGMENT_SIZE - sizeof(char*);
    }
#ifdef WORD64
    /* round to nearest 8-byte boundary */
    bytes = (bytes + 7) & (~7);
#else
    /* round to nearest 4-byte boundary */
    bytes = (bytes + 3) & (~3);
#endif /* WORD64 */
    heap_loc = heap->current;
    heap->current += bytes;
    heap->bytes_remaining -= bytes; /* can be negative, if rounded */
    return heap_loc;
}

#ifdef notdef
static void
_XtHeapFree(heap)
    Heap*       heap;
{
    char* segment = heap->start;
    while (segment != NULL) {
        char* next_segment = *(char**)segment;
        XtFree(segment);
        segment = next_segment;
    }
    heap->start = NULL;
    heap->bytes_remaining = 0;
}
#endif

static unsigned long StrToHex(str)
    String str;
{
    register char   c;
    register unsigned long    val = 0;

    while (c = *str) {
        if ('0' <= c && c <= '9') val = val*16+c-'0';
        else if ('a' <= c && c <= 'z') val = val*16+c-'a'+10;
        else if ('A' <= c && c <= 'Z') val = val*16+c-'A'+10;
        else return 0;
        str++;
    }

    return val;
}

static unsigned long StrToOct(str)
    String str;
{
    register char c;
    register unsigned long  val = 0;

    while (c = *str) {
        if ('0' <= c && c <= '7') val = val*8+c-'0'; else return 0;
        str++;
    }

    return val;
}

static unsigned long StrToNum(str)
    String str;
{
    register char c;
    register unsigned long val = 0;

    if (*str == '0') {
        str++;
        if (*str == 'x' || *str == 'X') return StrToHex(++str);
        else return StrToOct(str);
    }

    while (c = *str) {
        if ('0' <= c && c <= '9') val = val*10+c-'0';
        else return 0;
        str++;
    }

    return val;
}

static void Syntax(str,str1)
    String str,str1;
{
    Cardinal numChars;
    char message[1000];

    (void)strcpy(message,str);
    numChars = strlen(message);
    (void) strcpy(&message[numChars], str1);
    numChars += strlen(str1);
    message[numChars] = '\0';
    XtWarningMsg("parseError",message);
    return;
}

static String ScanIdent(str)
    register String str;
{
    ScanAlphanumeric(str);
    while (
           ('A' <= *str && *str <= 'Z')
        || ('a' <= *str && *str <= 'z')
        || ('0' <= *str && *str <= '9')
        || (*str == '-')
        || (*str == '_')
        || (*str == '$')
        ) str++;
    return str;
}

static void StoreLateBindings(keysymL,notL,keysymR,notR,lateBindings)

    KeySym  keysymL;
    Boolean notL;
    KeySym keysymR;
    Boolean notR;
    LateBindingsPtr* lateBindings;
{
    LateBindingsPtr temp;
    Boolean pair = FALSE;
    unsigned long count,number;
    if (lateBindings != NULL){
        temp = *lateBindings;
        if (temp != NULL) {
            for (count = 0; temp[count].keysym; count++){/*EMPTY*/}
        }
        else count = 0;
        if (! keysymR){
             number = 1;pair = FALSE;
        } else{
             number = 2;pair = TRUE;
        }
         
        temp = (LateBindingsPtr)XimTMRealloc((char *)temp,
            (unsigned)((count+number+1) * sizeof(LateBindings)) );
        *lateBindings = temp;
        temp[count].knot = notL;
        temp[count].pair = pair;
        if (count == 0)
            temp[count].ref_count = 1;
        temp[count++].keysym = keysymL;
        if (keysymR){
            temp[count].knot = notR;
            temp[count].pair = FALSE;
            temp[count++].keysym = keysymR;
        }
        temp[count].knot = FALSE;
        temp[count].keysym = 0;
    }
}

static void
_XtTranslateInitialize()
{
    Compile_XtEventTable( events, XtNumber(events) );
    Compile_XtModifierTable( modifiers, XtNumber(modifiers) );
}

static void ParseModImmed(name,value,lateBindings,notFlag,valueP)
    String name;
    Value value;
    LateBindingsPtr* lateBindings;
    Boolean notFlag;
    Value* valueP;
{
    *valueP = value;
}

static void ParseModSym (name,value,lateBindings,notFlag,valueP)
 /* is only valid with keysyms that have an _L and _R in their name;
  * and ignores keysym lookup errors (i.e. assumes only valid keysyms)
  */
    String name;
    Value value;
    LateBindingsPtr* lateBindings;
    Boolean notFlag;
    Value* valueP;
{
    register KeySym keysymL = (KeySym)value;
    register KeySym keysymR = keysymL + 1; /* valid for supported keysyms */
    StoreLateBindings(keysymL,notFlag,keysymR,notFlag,lateBindings);
    *valueP = 0;
}

static String PanicModeRecovery(str)
    String str;
{
     ScanFor(str,'\n');
     if (*str == '\n') str++;
     return str;

}

static String CheckForPoundSign(str, defaultOp, actualOpRtn)
    String str;
    _XtTranslateOp defaultOp;
    _XtTranslateOp *actualOpRtn;
{
    String start;
    char operation[20];
    _XtTranslateOp opType;

    opType = defaultOp;
    ScanWhitespace(str);
    if (*str == '#') {
        int len;
        str++;
        start = str;
        str = ScanIdent(str);
        len = MIN(19, str-start);
        bcopy(start, operation, len);
        operation[len] = '\0';
        if (!strcmp(operation,"replace"))
          opType = XtTableReplace;
        else if (!strcmp(operation,"augment"))
          opType = XtTableAugment;
        else if (!strcmp(operation,"override"))
          opType = XtTableOverride;
        ScanWhitespace(str);
        if (*str == '\n') {
            str++;
            ScanWhitespace(str);
        }
    }
    *actualOpRtn = opType;
    return str;
}

static KeySym StringToKeySym(str, error)
    String str;
    Boolean *error;
{
    KeySym k;

    if (str == NULL || *str == '\0') return (KeySym) 0;

#ifndef NOTASCII
    /* special case single character ASCII, for speed */
    if (*(str+1) == '\0') {
        if (' ' <= *str && *str <= '~') return XK_space + (*str - ' ');
    }
#endif

    if ('0' <= *str && *str <= '9') return (KeySym) StrToNum(str);
    k = XStringToKeysym(str);
    if (k != NoSymbol) return k;

#ifdef NOTASCII
    /* fall-back case to preserve backwards compatibility; no-one
     * should be relying upon this!
     */
    if (*(str+1) == '\0') return (KeySym) *str;
#endif

    Syntax("Unknown keysym name: ", str);
    *error = True;
    return NoSymbol;
}

static String ParseKeySym(str, closure, event,error)
    register String str;
    Opaque closure;
    EventPtr event;
    Boolean* error;
{
    char *start;
    char keySymName[100];

    ScanWhitespace(str);

    if (*str == '\\') {
	str++;
	keySymName[0] = *str;
	if (*str != '\0' && *str != '\n') str++;
	keySymName[1] = '\0';
	event->event.eventCode = StringToKeySym(keySymName, error);
	event->event.eventCodeMask = ~0L;
    } else if (*str == ',' || *str == ':' ||
             /* allow leftparen to be single char symbol,
              * for backwards compatibility
              */
             (*str == '(' && *(str+1) >= '0' && *(str+1) <= '9')) {
	/* no detail */
	event->event.eventCode = 0L;
        event->event.eventCodeMask = 0L;
    } else {
	start = str;
	while (
		*str != ','
		&& *str != ':'
		&& *str != ' '
		&& *str != '\t'
                && *str != '\n'
                && (*str != '(' || *(str+1) <= '0' || *(str+1) >= '9')
		&& *str != '\0') str++;
	bcopy(start, keySymName, str-start);
	keySymName[str-start] = '\0';
	event->event.eventCode = StringToKeySym(keySymName, error);
	event->event.eventCodeMask = ~0L;
    }
    if (*error) {
	if (keySymName[0] == '<') {
	    /* special case for common error */
	    XtWarningMsg("missingComma","... possibly due to missing ',' in event sequence.");
	}
	return PanicModeRecovery(str);
    }
    if (event->event.standard)
	event->event.matchEvent = _XtMatchUsingStandardMods;
    else 
	event->event.matchEvent = _XtMatchUsingDontCareMods;

    return str;
}

# ifdef notdef
static String ParseKeyAndModifiers(str, closure, event,error)
    String str;
    Opaque closure;
    EventPtr event;
    Boolean* error;
{
    str = ParseKeySym(str, closure, event,error);

    event->event.modifiers |= (unsigned long)closure;
    event->event.modifierMask |= (unsigned long)closure;

    return str;
}
#endif

static Boolean
_XtMatchUsingStandardMods (typeMatch, modMatch, eventSeq)
    TMTypeMatch typeMatch;
    TMModifierMatch modMatch;
    TMEventPtr eventSeq;
{
    Modifiers modifiers_return;
    KeySym keysym_return;
    Modifiers computed= 0;
    Modifiers computedMask = 0;
    Boolean resolved = TRUE;
    XtPerDisplay pd = _XtGetPerDisplay();
    TMKeyContext tm_context = pd->tm_context;
    Modifiers translateModifiers;

    translateModifiers =(Modifiers)
# ifdef         SunJapanKeypad
      (eventSeq->event.modifiers & ((ShiftMask|LockMask|Mod3Mask) | pd->mode_switch));
# else          /* !SunJapanKeypad */
      (eventSeq->event.modifiers & ((ShiftMask|LockMask) | pd->mode_switch));
# endif         /* SunJapanKeypad */

    TRANSLATE(tm_context, pd, (Display *)eventSeq->xev->xany.display,
			(KeyCode)eventSeq->event.eventCode,
                        translateModifiers, modifiers_return, keysym_return);

    if ((typeMatch->eventCode & typeMatch->eventCodeMask) ==
             (keysym_return & typeMatch->eventCodeMask)) {
        if (modMatch->lateModifiers != NULL)
            resolved = _XtComputeLateBindings(modMatch->lateModifiers,
                                           eventSeq,&computed,&computedMask);
        if (!resolved) return FALSE;
        computed |= modMatch->modifiers;
        computedMask |= modMatch->modifierMask;

        if ((computed & computedMask) ==
            (eventSeq->event.modifiers & computedMask)) {
            tm_context->event = eventSeq->xev;
            tm_context->serial = eventSeq->xev->xany.serial;
            tm_context->keysym = keysym_return;
            tm_context->modifiers = translateModifiers;
            return TRUE;
        }
    }
    return FALSE;
}

static Boolean
_XtMatchUsingDontCareMods(typeMatch, modMatch, eventSeq)
    TMTypeMatch 	typeMatch;
    TMModifierMatch 	modMatch;
    TMEventPtr 		eventSeq;
{
    Modifiers modifiers_return;
    KeySym keysym_return;
    Modifiers useful_mods;
    int i;
    Modifiers computed = 0;
    Modifiers computedMask = 0;
    Boolean resolved = TRUE;
    XtPerDisplay pd;
    TMKeyContext tm_context;
    
    if (modMatch->lateModifiers != NULL)
      resolved = _XtComputeLateBindings(modMatch->lateModifiers,
					eventSeq,&computed,&computedMask);
    if (!resolved) return FALSE;
    computed |= modMatch->modifiers;
    computedMask |= modMatch->modifierMask; /* gives do-care mask */
    
    if ( (computed & computedMask) ==
        (eventSeq->event.modifiers & computedMask) ) {
	Modifiers least_mod;
	
	pd = _XtGetPerDisplay();
	tm_context = pd->tm_context;
	TRANSLATE(tm_context, pd, (Display *)eventSeq->xev->xany.display,
			    (KeyCode)eventSeq->event.eventCode,
			    (unsigned)0, modifiers_return, keysym_return);
	
        if ((keysym_return & typeMatch->eventCodeMask)  == typeMatch->eventCode ) {
	    tm_context->event = eventSeq->xev;
	    tm_context->serial = eventSeq->xev->xany.serial;
	    tm_context->keysym = keysym_return;
	    tm_context->modifiers = (Modifiers)0;
	    return TRUE;
	}
        useful_mods = ~computedMask & modifiers_return;
        if (useful_mods == 0) return FALSE;
	for (least_mod = 1; (least_mod & useful_mods)==0; least_mod <<= 1){/*EMPTY*/};
        for (i = modifiers_return; i >= least_mod; i--)
	  /* all useful combinations of 8 modifier bits */
	  if (useful_mods & i) {
	      TRANSLATE(tm_context, pd, (Display *)eventSeq->xev->xany.display,
			eventSeq->event.eventCode,
			(Modifiers)i, modifiers_return, keysym_return);
	      if (keysym_return  ==
		  (typeMatch->eventCode & typeMatch->eventCodeMask)) {
		  tm_context->event = eventSeq->xev;
		  tm_context->serial = eventSeq->xev->xany.serial;
		  tm_context->keysym = keysym_return;
		  tm_context->modifiers = (Modifiers)i;
		  return TRUE;
	      }
	  }
    }
    return FALSE;
}

static void
XtTranslateKeycode (dpy, keycode, modifiers,
                            modifiers_return, keysym_return)
    Display *dpy;
    KeyCode keycode;
    Modifiers modifiers;
    Modifiers *modifiers_return;
    KeySym *keysym_return;
{
    XtPerDisplay pd = _XtGetPerDisplay();
    _InitializeKeysymTables(dpy, pd);
    XtTranslateKey(
            keycode,modifiers,modifiers_return,keysym_return);
}

static Boolean
_XtComputeLateBindings(lateModifiers,eventSeq,computed,computedMask)
    LateBindingsPtr lateModifiers;
    TMEventPtr eventSeq;
    Modifiers *computed,*computedMask;
{
    int i,j,ref;
    ModToKeysymTable* temp;
    XtPerDisplay perDisplay;
    Boolean found;
    KeySym tempKeysym = NoSymbol;
    Display *dpy = eventSeq->xev->xany.display;
    perDisplay = _XtGetPerDisplay();
    if (perDisplay == NULL) {
         return FALSE;
    }
    _InitializeKeysymTables(dpy, perDisplay);
    for (ref=0; lateModifiers[ref].keysym; ref++) {
        found = FALSE;
        for (i=0;i<8;i++) {
            temp = &(perDisplay->modsToKeysyms[i]);
            for (j=0;j<temp->count;j++){
                if (perDisplay->modKeysyms[temp->idx+j] ==
                    lateModifiers[ref].keysym) {
                    *computedMask = *computedMask | temp->mask;
                    if (!lateModifiers[ref].knot)
                      *computed |= temp->mask;
                    tempKeysym = lateModifiers[ref].keysym;
                    found = TRUE; break;
                }
            }
            if (found) break;
        }
        if (!found  && !lateModifiers[ref].knot)
            if (!lateModifiers[ref].pair && (tempKeysym == NoSymbol))
                return FALSE;
        /* if you didn't find the modifier and the modifier must be
           asserted then return FALSE. If you didn't find the modifier
           and the modifier must be off, then it is OK . Don't
           return FALSE if this is the first member of a pair or if
           it is the second member of a pair when the first member
           was bound to a modifier */
    if (!lateModifiers[ref].pair) tempKeysym = NoSymbol;
    }
    return TRUE;
}

static void
_XtBuildKeysymTables(dpy,pd)
    Display *dpy;
    register XtPerDisplay pd;
{
    ModToKeysymTable *table;
    int maxCount,i,j,k,tempCount,idx;
    KeySym keysym,tempKeysym;
    XModifierKeymap* modKeymap;
    KeyCode keycode;
#define KeysymTableSize 16

    FLUSHKEYCACHE(pd->tm_context);
    if (pd->keysyms)
	XFree( (char *)pd->keysyms );
    XDisplayKeycodes(dpy, &pd->min_keycode, &pd->max_keycode);
    pd->keysyms = XGetKeyboardMapping(dpy, pd->min_keycode,
				      pd->max_keycode-pd->min_keycode+1,
				      &pd->keysyms_per_keycode);
    if (pd->modKeysyms)
	XtFree((char *)pd->modKeysyms);
    if (pd->modsToKeysyms)
	XtFree((char *)pd->modsToKeysyms);
    pd->modKeysyms = (KeySym*)XimTMMalloc((Cardinal)KeysymTableSize*sizeof(KeySym));
    maxCount = KeysymTableSize;
    tempCount = 0;

    table = (ModToKeysymTable*)XimTMMalloc((Cardinal)8*sizeof(ModToKeysymTable));
    pd->modsToKeysyms = table;

    table[0].mask = ShiftMask;
    table[1].mask = LockMask;
    table[2].mask = ControlMask;
    table[3].mask = Mod1Mask;
    table[4].mask = Mod2Mask;
    table[5].mask = Mod3Mask;
    table[6].mask = Mod4Mask;
    table[7].mask = Mod5Mask;
    tempKeysym = 0;

    modKeymap = XGetModifierMapping(dpy);
    for (i=0;i<32;i++)
	pd->isModifier[i] = 0;
    pd->mode_switch = 0;
    for (i=0;i<8;i++) {
        table[i].idx = tempCount;
        table[i].count = 0;
        for (j=0;j<modKeymap->max_keypermod;j++) {
            keycode = modKeymap->modifiermap[i*modKeymap->max_keypermod+j];
            if (keycode != 0) {
		pd->isModifier[keycode>>3] |= 1 << (keycode & 7);
                for (k=0; k<pd->keysyms_per_keycode;k++) {
                    idx = ((keycode-pd->min_keycode)*
                             pd->keysyms_per_keycode)+k;
                    keysym = pd->keysyms[idx];
		    if ((keysym == XK_Mode_switch) && (i > 2))
			pd->mode_switch |= 1 << i;
                    if (keysym != 0 && keysym != tempKeysym ){
                        if (tempCount==maxCount) {
                            maxCount += KeysymTableSize;
                            pd->modKeysyms = (KeySym*)XimTMRealloc(
                                (char*)pd->modKeysyms,
                                (unsigned) (maxCount*sizeof(KeySym)) );
                        }
                        pd->modKeysyms[tempCount++] = keysym;
                        table[i].count++;
                        tempKeysym = keysym;
                    }
                }
            }
        }
    }
    pd->lock_meaning = NoSymbol;
    for (i = 0; i < table[1].count; i++) {
	keysym = pd->modKeysyms[table[1].idx + i];
	if (keysym == XK_Caps_Lock) {
	    pd->lock_meaning = XK_Caps_Lock;
	    break;
	} else if (keysym == XK_Shift_Lock) {
	    pd->lock_meaning = XK_Shift_Lock;
	}
    }
    XFreeModifiermap(modKeymap);
}

static int OrderModifiers(a, b)
#ifdef __STDC__
    void const *a, *b;
#else
    ModifierRec *a, *b;
#endif
{
#ifdef __STDC__
    return ((((ModifierRec *)a)->signature < 
	((ModifierRec *)b)->signature) ? -1 : 1
);
#else
    return ((a->signature < b->signature) ? -1 : 1);
#endif
}

static int OrderEvents(a, b)
#ifdef __STDC__
    const void  *a, *b;
#else
    EventKey    *a, *b;
#endif
{
#ifdef __STDC__
    return ((((EventKey *)a)->signature < ((EventKey *)b)->signature) ? -1 : 1);
#else
    return ((a->signature < b->signature) ? -1 : 1);
#endif
}


static void Compile_XtModifierTable(table, count)
    ModifierKeys table;
    Cardinal count;
{
    register int i;
    register ModifierKeys entry = table;

    for (i=count; --i >= 0; entry++)
        entry->signature = XrmPermStringToQuark(entry->name);
    qsort(table, count, sizeof(ModifierRec), OrderModifiers);
}

static void Compile_XtEventTable(table, count)
    EventKeys   table;
    Cardinal    count;
{
    register int i;
    register EventKeys entry = table;

    for (i=count; --i >= 0; entry++)
        entry->signature = XrmPermStringToQuark(entry->event);
    qsort(table, count, sizeof(EventKey), OrderEvents);
}

static void _XtConvertCase(sym, lower, upper)
    KeySym sym;
    KeySym *lower;
    KeySym *upper;
{
    *lower = sym;
    *upper = sym;
    switch(sym >> 8) {
    case 0:
	if ((sym >= XK_A) && (sym <= XK_Z))
	    *lower += (XK_a - XK_A);
	else if ((sym >= XK_a) && (sym <= XK_z))
	    *upper -= (XK_a - XK_A);
	else if ((sym >= XK_Agrave) && (sym <= XK_Odiaeresis))
	    *lower += (XK_agrave - XK_Agrave);
	else if ((sym >= XK_agrave) && (sym <= XK_odiaeresis))
	    *upper -= (XK_agrave - XK_Agrave);
	else if ((sym >= XK_Ooblique) && (sym <= XK_Thorn))
	    *lower += (XK_oslash - XK_Ooblique);
	else if ((sym >= XK_oslash) && (sym <= XK_thorn))
	    *upper -= (XK_oslash - XK_Ooblique);
	break;
#ifdef XK_LATIN2
      case 1:
	/* Assume the KeySym is a legal value (ignore discontinuities) */
	if (sym == XK_Aogonek)
	    *lower = XK_aogonek;
	else if (sym >= XK_Lstroke && sym <= XK_Sacute)
	    *lower += (XK_lstroke - XK_Lstroke);
	else if (sym >= XK_Scaron && sym <= XK_Zacute)
	    *lower += (XK_scaron - XK_Scaron);
	else if (sym >= XK_Zcaron && sym <= XK_Zabovedot)
	    *lower += (XK_zcaron - XK_Zcaron);
	else if (sym == XK_aogonek)
	    *upper = XK_Aogonek;
	else if (sym >= XK_lstroke && sym <= XK_sacute)
	    *upper -= (XK_lstroke - XK_Lstroke);
	else if (sym >= XK_scaron && sym <= XK_zacute)
	    *upper -= (XK_scaron - XK_Scaron);
	else if (sym >= XK_zcaron && sym <= XK_zabovedot)
	    *upper -= (XK_zcaron - XK_Zcaron);
	else if (sym >= XK_Racute && sym <= XK_Tcedilla)
	    *lower += (XK_racute - XK_Racute);
	else if (sym >= XK_racute && sym <= XK_tcedilla)
	    *upper -= (XK_racute - XK_Racute);
	break;
#endif
#ifdef XK_LATIN3
      case 2:
	/* Assume the KeySym is a legal value (ignore discontinuities) */
	if (sym >= XK_Hstroke && sym <= XK_Hcircumflex)
	    *lower += (XK_hstroke - XK_Hstroke);
	else if (sym >= XK_Gbreve && sym <= XK_Jcircumflex)
	    *lower += (XK_gbreve - XK_Gbreve);
	else if (sym >= XK_hstroke && sym <= XK_hcircumflex)
	    *upper -= (XK_hstroke - XK_Hstroke);
	else if (sym >= XK_gbreve && sym <= XK_jcircumflex)
	    *upper -= (XK_gbreve - XK_Gbreve);
	else if (sym >= XK_Cabovedot && sym <= XK_Scircumflex)
	    *lower += (XK_cabovedot - XK_Cabovedot);
	else if (sym >= XK_cabovedot && sym <= XK_scircumflex)
	    *upper -= (XK_cabovedot - XK_Cabovedot);
	break;
#endif
#ifdef XK_LATIN4
      case 3:
	/* Assume the KeySym is a legal value (ignore discontinuities) */
	if (sym >= XK_Rcedilla && sym <= XK_Tslash)
	    *lower += (XK_rcedilla - XK_Rcedilla);
	else if (sym >= XK_rcedilla && sym <= XK_tslash)
	    *upper -= (XK_rcedilla - XK_Rcedilla);
	else if (sym == XK_ENG)
	    *lower = XK_eng;
	else if (sym == XK_eng)
	    *upper = XK_ENG;
	else if (sym >= XK_Amacron && sym <= XK_Umacron)
	    *lower += (XK_amacron - XK_Amacron);
	else if (sym >= XK_amacron && sym <= XK_umacron)
	    *upper -= (XK_amacron - XK_Amacron);
	break;
#endif
    }
}

static void
XtConvertCase(keysym,lower_return,upper_return)
    KeySym keysym;
    KeySym *lower_return, *upper_return;
{
    *lower_return = *upper_return = keysym;
    if (keysym <= 0x3ff)        /* Latin-1 start = 0, Latin-4 stop = 0x3ff */
        _XtConvertCase(keysym, lower_return, upper_return);
}

static void
_XtAllocTMContext(pd)
    XtPerDisplay pd;
{
    TMKeyContext ctx;
    ctx = (TMKeyContext)_XtHeapAlloc(&pd->heap,
                                     sizeof(TMKeyContextRec));
    ctx->event = NULL;
    ctx->serial = 0;
    ctx->keysym = NoSymbol;
    ctx->modifiers = 0;
    FLUSHKEYCACHE(ctx);
    pd->tm_context = ctx;
}

/* This code should match XTranslateKey (internal, sigh) in Xlib */
static void
XtTranslateKey(keycode, modifiers,
                            modifiers_return, keysym_return)
    KeyCode keycode;
    Modifiers modifiers;
    Modifiers *modifiers_return;
    KeySym *keysym_return;
{
    register XtPerDisplay pd = _XtGetPerDisplay();
    int per;
    register KeySym *syms;
    KeySym sym, lsym, usym;
# ifdef		SunJapanKeypad
    int		i, KeypadKey;
# endif		/* SunJapanKeypad */

# ifdef		SunJapanKeypad
    *modifiers_return = (ShiftMask|LockMask|Mod3Mask) | pd->mode_switch;
# else		/* !SunJapanKeypad */
    *modifiers_return = (ShiftMask|LockMask) | pd->mode_switch;
# endif		/* SunJapanKeypad */
    if (((int)keycode < pd->min_keycode) || ((int)keycode > pd->max_keycode)) {
	*keysym_return = NoSymbol;
	return;
    }
    per = pd->keysyms_per_keycode;
    syms = &pd->keysyms[(keycode - pd->min_keycode) * per];
    while ((per > 2) && (syms[per - 1] == NoSymbol))
	per--;

# ifdef		SunJapanKeypad
    /* Sun: Japanese keypad support */
    KeypadKey = 0;
    for (i = 0; i < per; i++) {
	if (IsKeypadKey(syms[i])) {
		KeypadKey = 1;
	}
    }

    if ((per > 2) && 
	/* Not a keypad key and mode_switch is ON */
	(((!KeypadKey) && (modifiers & pd->mode_switch)) ||
	/* Is a keypad key and Mod3(num_lock) is ON */
	 ( (KeypadKey) && (modifiers & Mod3Mask)))) {
	syms += 2;
	per -= 2;
    }
# else		/* !SunJapanKeypad */
    if ((per > 2) && (modifiers & pd->mode_switch)) {
	syms += 2;
	per -= 2;
    }
# endif		/* SunJapanKeypad */
    if (!(modifiers & ShiftMask) &&
	(!(modifiers & LockMask) || (pd->lock_meaning == NoSymbol))) {
	if ((per == 1) || (syms[1] == NoSymbol))
	    XtConvertCase(syms[0], keysym_return, &usym);
	else
	    *keysym_return = syms[0];
    } else if (!(modifiers & LockMask) ||
	       (pd->lock_meaning != XK_Caps_Lock)) {
	if ((per == 1) || ((usym = syms[1]) == NoSymbol))
	    XtConvertCase(syms[0], &lsym, &usym);
	*keysym_return = usym;
    } else {
	if ((per == 1) || ((sym = syms[1]) == NoSymbol))
	    sym = syms[0];
	XtConvertCase(sym, &lsym, &usym);
	if (!(modifiers & ShiftMask) && (sym != syms[0]) &&
	    ((sym != usym) || (lsym == usym)))
	    XtConvertCase(syms[0], &lsym, &usym);
	*keysym_return = usym;
    }

    if (*keysym_return == XK_VoidSymbol)
	*keysym_return = NoSymbol;
}

static XtPerDisplay InitDisplay()
{
    XtPerDisplay pd = NULL;

    _XtperDisplayList = pd = XtNew(XtPerDisplayStruct);

    _XtHeapInit(&pd->heap);

    pd->keysyms = NULL;
    pd->modKeysyms = NULL;
    pd->modsToKeysyms = NULL;

    pd->multi_click_time = 200;

    _XtAllocTMContext(pd);

    return pd;
}

#define NonMaskableMask ((EventMask)0x80000000L)

static EventMask Const masks[] = {
        0,                          /* Error, should never see  */
        0,                          /* Reply, should never see  */
        KeyPressMask,               /* KeyPress                 */
        KeyReleaseMask,             /* KeyRelease               */
};

static EventMask
_XtConvertTypeToMask (eventType)
    int         eventType;
{
    eventType &= 0x7f;  /* Events sent with XSendEvent have high bit set. */
    if (eventType < XtNumber(masks))
        return masks[eventType];
    else
        return 0;
}

static TMShortCard GetBranchHead(parseTree, typeIndex, modIndex, isDummy)
    TMParseStateTree    parseTree;
    TMShortCard         typeIndex;
    TMShortCard         modIndex;
    Boolean             isDummy;
{
#define TM_BRANCH_HEAD_TBL_ALLOC        8
#define TM_BRANCH_HEAD_TBL_REALLOC      8

    register TMBranchHead branchHead = parseTree->branchHeadTbl;
    TMShortCard newSize, i;

    /*
     * dummy is used as a place holder for later matching in old-style
     * matching behavior. If there's already an entry we don't need
     * another dummy.
     */
    if (isDummy) {
        for (i = 0; i < parseTree->numBranchHeads; i++, branchHead++) {
            if ((branchHead->typeIndex == typeIndex) &&
                (branchHead->modIndex == modIndex))
              return i;
        }
    }
    if (parseTree->numBranchHeads == parseTree->branchHeadTblSize)
      {
          if (parseTree->branchHeadTblSize == 0)
            parseTree->branchHeadTblSize += TM_BRANCH_HEAD_TBL_ALLOC;
          else
            parseTree->branchHeadTblSize +=
              TM_BRANCH_HEAD_TBL_REALLOC;
          newSize = (parseTree->branchHeadTblSize * sizeof(TMBranchHeadRec));
          if (parseTree->isStackBranchHeads) {
              TMBranchHead      oldBranchHeadTbl = parseTree->branchHeadTbl;
              parseTree->branchHeadTbl = (TMBranchHead) XimTMMalloc(newSize);
              XtBCopy(oldBranchHeadTbl, parseTree->branchHeadTbl, newSize);
              parseTree->isStackBranchHeads = False;
          }
          else {
              parseTree->branchHeadTbl = (TMBranchHead)
                XimTMRealloc((char *)parseTree->branchHeadTbl,
                          (parseTree->branchHeadTblSize *
                           sizeof(TMBranchHeadRec)));
          }
      }
#ifdef TRACE_TM
    XimGlobalTM.numBranchHeads++;
#endif /* TRACE_TM */
    branchHead =
      &parseTree->branchHeadTbl[parseTree->numBranchHeads++];
    branchHead->typeIndex = typeIndex;
    branchHead->modIndex = modIndex;
    branchHead->more = 0;
    branchHead->isSimple = True;
    branchHead->hasActions = False;
    branchHead->hasCycles = False;
    return parseTree->numBranchHeads-1;
}

static EventMask EventToMask(typeMatch, modMatch)
    register TMTypeMatch     typeMatch;
    register TMModifierMatch modMatch;
{
    EventMask returnMask;
    unsigned long eventType = typeMatch->eventType;

    returnMask = _XtConvertTypeToMask((int)eventType);
    return returnMask;
}

static void FreeActions(actions)
    ActionPtr   actions;
{
    register ActionPtr action;
    register TMShortCard i;
    for (action = actions; action;) {
        ActionPtr nextAction = action->next;
        for (i = action->num_params; i;) {
            XtFree( action->params[--i] );
        }
        XtFree( (char*)action->params );
        XtFree((char*) action);
        action = nextAction;
    }
}

static void AmbigActions(initialEvent, state, stateTree)
    EventSeqPtr initialEvent;
    StatePtr    *state;
    TMParseStateTree stateTree;
{
    XtWarningMsg ("ambiguousActions","Overriding earlier translation manager actions.");

    FreeActions((*state)->actions);
    (*state)->actions = NULL;
}

static TMShortCard GetComplexBranchIndex(parseTree, typeIndex, modIndex)
    TMParseStateTree    parseTree;
    TMShortCard         typeIndex;
    TMShortCard         modIndex;
{
#define TM_COMPLEXBRANCH_HEAD_TBL_ALLOC 8
#define TM_COMPLEXBRANCH_HEAD_TBL_REALLOC 4
   
    if (parseTree->numComplexBranchHeads == parseTree->complexBranchHeadTblSize)
 {
        TMShortCard     newSize;

        if (parseTree->complexBranchHeadTblSize == 0)
          parseTree->complexBranchHeadTblSize += TM_COMPLEXBRANCH_HEAD_TBL_ALLOC;
        else
          parseTree->complexBranchHeadTblSize += TM_COMPLEXBRANCH_HEAD_TBL_REALLOC;

        newSize = (parseTree->complexBranchHeadTblSize * sizeof(StatePtr));

        if (parseTree->isStackComplexBranchHeads) {
            StatePtr *oldcomplexBranchHeadTbl
              = parseTree->complexBranchHeadTbl;
            parseTree->complexBranchHeadTbl = (StatePtr *) XimTMMalloc(newSize);
            XtBCopy(oldcomplexBranchHeadTbl, parseTree->complexBranchHeadTbl,
                    newSize);
            parseTree->isStackComplexBranchHeads = False;
        }
        else {
            parseTree->complexBranchHeadTbl = (StatePtr *)
              XimTMRealloc((char *)parseTree->complexBranchHeadTbl,
                        (parseTree->complexBranchHeadTblSize *
                         sizeof(StatePtr)));
        }
    }
    parseTree->complexBranchHeadTbl[parseTree->numComplexBranchHeads++] = NULL;
    return parseTree->numComplexBranchHeads-1;
}

static TMShortCard
_XtGetTypeIndex(event)
    Event       *event;
{
    TMShortCard         i, j = TM_TYPE_SEGMENT_SIZE;
    TMShortCard         typeIndex = 0;
    TMTypeMatch         typeMatch;
    TMTypeMatch         segment;

    for (i = 0; i < XimGlobalTM.numTypeMatchSegments; i++) {
        segment = XimGlobalTM.typeMatchSegmentTbl[i];
        for (j = 0;
             typeIndex < XimGlobalTM.numTypeMatches && j <  TM_TYPE_SEGMENT_SIZE
;
             j++, typeIndex++)
          {
              typeMatch = &(segment[j]);
              if (event->eventType == typeMatch->eventType &&
                  event->eventCode == typeMatch->eventCode &&
                  event->eventCodeMask == typeMatch->eventCodeMask &&
                  event->matchEvent == typeMatch->matchEvent)
                    return typeIndex;
          }
    }

    if (j == TM_TYPE_SEGMENT_SIZE) {
        if (XimGlobalTM.numTypeMatchSegments == XimGlobalTM.typeMatchSegmentTblSize) {
            XimGlobalTM.typeMatchSegmentTblSize += TM_TYPE_SEGMENT_SIZE/* 4 */;
            XimGlobalTM.typeMatchSegmentTbl = (TMTypeMatch *)
              XimTMRealloc((char *)XimGlobalTM.typeMatchSegmentTbl,
                        (XimGlobalTM.typeMatchSegmentTblSize * sizeof(TMTypeMatch)));
        }
        XimGlobalTM.typeMatchSegmentTbl[XimGlobalTM.numTypeMatchSegments++] =
          segment = (TMTypeMatch)
            XimTMMalloc(TM_TYPE_SEGMENT_SIZE * sizeof(TMTypeMatchRec));
        j = 0;
    }
    typeMatch = &segment[j];
    typeMatch->eventType = event->eventType;
    typeMatch->eventCode = event->eventCode;
    typeMatch->eventCodeMask = event->eventCodeMask;
    typeMatch->matchEvent = event->matchEvent;
    XimGlobalTM.numTypeMatches++;
    return typeIndex;
}

static Boolean CompareLateModifiers(lateBind1P, lateBind2P)
    LateBindingsPtr lateBind1P, lateBind2P;
{
    LateBindingsPtr late1P = lateBind1P;
    LateBindingsPtr late2P = lateBind2P;

    if (late1P != NULL || late2P != NULL) {
        int i = 0;
        int j = 0;
        if (late1P != NULL)
          for (; late1P->keysym != NoSymbol; i++) late1P++;
        if (late2P != NULL)
          for (; late2P->keysym != NoSymbol; j++) late2P++;
        if (i != j) return FALSE;
        late1P--;
        while (late1P >= lateBind1P) {
            Boolean last = True;
            for (late2P = lateBind2P + i - 1;
                 late2P >= lateBind2P;
                 late2P--) {
                if (late1P->keysym == late2P->keysym
                    && late1P->knot == late2P->knot) {
                    j--;
                    if (last) i--;
                    break;
                }
                last = False;
            }
            late1P--;
        }
        if (j != 0) return FALSE;
    }
    return TRUE;
}

static TMShortCard
_XtGetModifierIndex(event)
    Event       *event;
{
    TMShortCard         i, j = TM_MOD_SEGMENT_SIZE;
    TMShortCard         modIndex = 0;
    TMModifierMatch     modMatch;
    TMModifierMatch     segment;
    for (i = 0; i < XimGlobalTM.numModMatchSegments; i++) {
        segment = XimGlobalTM.modMatchSegmentTbl[i];
        for (j = 0;
             modIndex < XimGlobalTM.numModMatches && j <  TM_MOD_SEGMENT_SIZE;
             j++, modIndex++) {
            modMatch = &(segment[j]);
            if (event->modifiers == modMatch->modifiers &&
                event->modifierMask == modMatch->modifierMask &&
                event->standard == modMatch->standard &&
                ((!event->lateModifiers && !modMatch->lateModifiers) ||
                 CompareLateModifiers(event->lateModifiers,
                                      modMatch->lateModifiers))) {
                /*
                 * if we found a match then we can free the parser's
                 * late modifiers. If there isn't a match we use the
                 * parser's copy
                 */
                if (event->lateModifiers &&
                    --event->lateModifiers->ref_count == 0) {
                    XtFree((char *)event->lateModifiers);
                    event->lateModifiers = NULL;
                }
                return modIndex;
            }
        }
    }

    if (j == TM_MOD_SEGMENT_SIZE) {
        if (XimGlobalTM.numModMatchSegments == XimGlobalTM.modMatchSegmentTblSize) {
            XimGlobalTM.modMatchSegmentTblSize += TM_MOD_SEGMENT_SIZE/* 4 */;
            XimGlobalTM.modMatchSegmentTbl = (TMModifierMatch *)
              XimTMRealloc((char *)XimGlobalTM.modMatchSegmentTbl,
                        (XimGlobalTM.modMatchSegmentTblSize * sizeof(TMModifierMatch)));
        }
        XimGlobalTM.modMatchSegmentTbl[XimGlobalTM.numModMatchSegments++] =
          segment = (TMModifierMatch)
            XimTMMalloc(TM_MOD_SEGMENT_SIZE * sizeof(TMModifierMatchRec));
        j = 0;
    }
    modMatch = &segment[j];
    modMatch->modifiers = event->modifiers;;
    modMatch->modifierMask = event->modifierMask;
    modMatch->standard = event->standard;
    /*
     * We use the parser's copy of the late binding array
     */
#ifdef TRACE_TM
    if (event->lateModifiers)
      XimGlobalTM.numLateBindings++;
#endif /* TRACE_TM */
    modMatch->lateModifiers = event->lateModifiers;
    XimGlobalTM.numModMatches++;
    return modIndex;
}

static StatePtr NewState(stateTree, typeIndex, modIndex)
    TMParseStateTree stateTree;
    TMShortCard typeIndex, modIndex;
{
    register StatePtr state = XtNew(StateRec);

#ifdef TRACE_TM
    XimGlobalTM.numComplexStates++;
#endif /* TRACE_TM */
    state->typeIndex = typeIndex;
    state->modIndex = modIndex;
    state->nextLevel = NULL;
    state->actions = NULL;
    state->isCycleStart = state->isCycleEnd = False;
    return state;
}

static void _XtParseKeysymMod(name,lateBindings,notFlag,valueP,error)
    String name;
    LateBindingsPtr* lateBindings;
    Boolean notFlag;
    Value *valueP;
    Boolean *error;
{
    KeySym keySym;
    keySym = StringToKeySym(name, error);
    *valueP = 0;
    if (keySym != NoSymbol) {
        StoreLateBindings(keySym,notFlag,(KeySym) NULL,FALSE,lateBindings);
    }
    return;
}

static Boolean _XtLookupModifier(name,lateBindings,notFlag,valueP,constMask)
    String name;
    LateBindingsPtr* lateBindings;
    Boolean notFlag;
    Value *valueP;
    Bool constMask;
{
   register int i, left, right;
   register XrmQuark signature = StringToQuark(name);
   static int previous = 0;

   if (signature == modifiers[previous].signature) {
       if (constMask)  *valueP = modifiers[previous].value;
       else /* if (modifiers[previous].modifierParseProc) always true */
           (*modifiers[previous].modifierParseProc)
              (name, modifiers[previous].value, lateBindings, notFlag, valueP);
       return TRUE;
   }

   left = 0;
   right = XtNumber(modifiers) - 1;
   while (left <= right) {
       i = (left + right) >> 1;
       if (signature < modifiers[i].signature)
           right = i - 1;
       else if (signature > modifiers[i].signature)
           left = i + 1;
       else {
           previous = i;
           if (constMask)  *valueP = modifiers[i].value;
           else /* if (modifiers[i].modifierParseProc) always true */
               (*modifiers[i].modifierParseProc)
                   (name, modifiers[i].value, lateBindings, notFlag, valueP);
           return TRUE;
       }
   }
   return FALSE;
}

static void
_XtAddEventSeqToStateTree(eventSeq, stateTree)
    register EventSeqPtr        eventSeq;
    TMParseStateTree            stateTree;
{
    register StatePtr           *state;
    EventSeqPtr                 initialEvent = eventSeq;
    TMBranchHead                branchHead;
    TMShortCard                 idx, modIndex, typeIndex;

    if (eventSeq == NULL) return;

    /* note that all states in the event seq passed in start out null */
    /* we fill them in with the matching state as we traverse the list */

    /*
     * We need to free the parser data structures !!!
     */

    typeIndex = _XtGetTypeIndex(&eventSeq->event);
    modIndex = _XtGetModifierIndex(&eventSeq->event);
    idx = GetBranchHead(stateTree, typeIndex, modIndex, False);
    branchHead = &stateTree->branchHeadTbl[idx];

    /*
     * Need to check for pre-existing actions with same lhs |||
     */

    /*
     * Check for optimized case. Don't assume that the eventSeq has actions.
     */
    if (!eventSeq->next &&
         eventSeq->actions &&
        !eventSeq->actions->next &&
        !eventSeq->actions->num_params)
      {
          branchHead->hasActions = True;
          branchHead->more = eventSeq->actions->idx;
          FreeActions(eventSeq->actions);
          eventSeq->actions = NULL;
          return;
      }

    branchHead->isSimple = False;
    if (!eventSeq->next)
      branchHead->hasActions = True;
    branchHead->more = GetComplexBranchIndex(stateTree, typeIndex, modIndex);
    state = &stateTree->complexBranchHeadTbl[TMBranchMore(branchHead)];

    for (;;) {
        *state = NewState(stateTree, typeIndex, modIndex);

        /* *state now points at state record matching event */
        eventSeq->state = *state;

        if (eventSeq->actions != NULL) {
            if ((*state)->actions != NULL)
              AmbigActions(initialEvent, state, stateTree);
            (*state)->actions = eventSeq->actions;
#ifdef TRACE_TM
            XimGlobalTM.numComplexActions++;
#endif /* TRACE_TM */
        }

        if (((eventSeq = eventSeq->next) == NULL) || (eventSeq->state))
          break;

        state = &(*state)->nextLevel;
        typeIndex = _XtGetTypeIndex(&eventSeq->event);
        modIndex = _XtGetModifierIndex(&eventSeq->event);
        if (!TMNewMatchSemantics()) {
            /*
             * force a potential empty entry into the branch head
             * table in order to emulate old matching behavior
             */
            (void) GetBranchHead(stateTree, typeIndex, modIndex, True);
        }
    }

    if (eventSeq && eventSeq->state) {
        /* we've been here before... must be a cycle in the event seq. */
        branchHead->hasCycles = True;
        (*state)->nextLevel = eventSeq->state;
        eventSeq->state->isCycleStart = True;
        (*state)->isCycleEnd = TRUE;
    }
}

/*
 * I don't think this "notdef" improves the performance fairly, but I hope.
 */
#ifdef notdef
static XtTranslations
_XtCreateXlations(stateTrees, numStateTrees, first, second)
    TMStateTree         *stateTrees;
    TMShortCard         numStateTrees;
    XtTranslations      first, second;
{
    register XtTranslations     xlations;
    TMShortCard i;

    xlations = (XtTranslations)
      XimTMMalloc(sizeof(TranslationData) +
               (numStateTrees-1) * sizeof(TMStateTree));
#ifdef TRACE_TM
    if (XimGlobalTM.numTms == XimGlobalTM.tmTblSize) {
        XimGlobalTM.tmTblSize += 16;
        XimGlobalTM.tmTbl = (XtTranslations *)
          XimTMRealloc((char *)XimGlobalTM.tmTbl,
                   XimGlobalTM.tmTblSize * sizeof(XtTranslations));
    }
    XimGlobalTM.tmTbl[XimGlobalTM.numTms++] = xlations;
#endif /* TRACE_TM */

    xlations->composers[0] = first;
    xlations->composers[1] = second;
    xlations->hasBindings = False;
    xlations->operation = XtTableReplace;

    for (i = 0;i < numStateTrees; i++)
      {
          xlations->stateTreeTbl[i] = (TMStateTree) stateTrees[i];
          stateTrees[i]->simple.refCount++;
      }
    xlations->numStateTrees = numStateTrees;
    xlations->eventMask = 0;
    return xlations;
}
#else
static XtTranslations
_XtCreateXlations(stateTrees)
    TMStateTree         *stateTrees;
{
    register XtTranslations     xlations;

    xlations = (XtTranslations) XimTMMalloc(sizeof(TranslationData)); 
#ifdef TRACE_TM
    if (XimGlobalTM.numTms == XimGlobalTM.tmTblSize) {
        XimGlobalTM.tmTblSize += 16;
        XimGlobalTM.tmTbl = (XtTranslations *)
          XimTMRealloc((char *)XimGlobalTM.tmTbl,
                   XimGlobalTM.tmTblSize * sizeof(XtTranslations));
    }
    XimGlobalTM.tmTbl[XimGlobalTM.numTms++] = xlations;
#endif /* TRACE_TM */

    xlations->composers[0] = xlations->composers[1] = NULL;
    xlations->hasBindings = False;
    xlations->operation = XtTableReplace;

    xlations->stateTreeTbl[0] = (TMStateTree) stateTrees[0];
    stateTrees[0]->simple.refCount++;

    xlations->numStateTrees = 1;
    xlations->eventMask = 0;
    return xlations;
}
#endif

static TMShortCard
_XtGetQuarkIndex(parseTree, quark)
    TMParseStateTree    parseTree;
    XrmQuark            quark;
{
#define TM_QUARK_TBL_ALLOC      16
#define TM_QUARK_TBL_REALLOC    16
    register TMShortCard  i = parseTree->numQuarks;

    for (i=0; i < parseTree->numQuarks; i++)
      if (parseTree->quarkTbl[i] == quark)
            break;

    if (i == parseTree->numQuarks)
      {
          if (parseTree->numQuarks == parseTree->quarkTblSize)
            {
                TMShortCard     newSize;

                if (parseTree->quarkTblSize == 0)
                  parseTree->quarkTblSize += TM_QUARK_TBL_ALLOC;
                else
                  parseTree->quarkTblSize += TM_QUARK_TBL_REALLOC;
                newSize = (parseTree->quarkTblSize * sizeof(XrmQuark));

                if (parseTree->isStackQuarks) {
                    XrmQuark    *oldquarkTbl = parseTree->quarkTbl;
                    parseTree->quarkTbl = (XrmQuark *) XimTMMalloc(newSize);
                    XtBCopy(oldquarkTbl, parseTree->quarkTbl, newSize);
                    parseTree->isStackQuarks = False;
                }
                else {
                    parseTree->quarkTbl = (XrmQuark *)
                      XimTMRealloc((char *)parseTree->quarkTbl,
                                (parseTree->quarkTblSize *
                                 sizeof(XrmQuark)));
                }
            }
          parseTree->quarkTbl[parseTree->numQuarks++] = quark;
      }
    return i;
}

static Boolean AggregateEventMask(state, data)
    StatePtr    state;
    XtPointer   data;
{
    *((EventMask *)data) |= EventToMask(TMGetTypeMatch(state->typeIndex),
                                        TMGetModifierMatch(state->modIndex));
   return False;
}

static void
_XtTraverseStateTree(tree, func, data)
    TMStateTree tree;
    _XtTraversalProc func;
    XtPointer   data;
{
    register    TMComplexStateTree stateTree = (TMComplexStateTree)tree;
    TMBranchHead        currBH;
    TMShortCard         i;
    StateRec            dummyStateRec, *dummyState = &dummyStateRec;
    ActionRec           dummyActionRec, *dummyAction = &dummyActionRec;
    Boolean             firstSimple = True;
    StatePtr            currState;

    /* first traverse the complex states */
    if (stateTree->isSimple == False)
      for (i = 0; i < stateTree->numComplexBranchHeads; i++) {
          currState = stateTree->complexBranchHeadTbl[i];
          for (; currState; currState = currState->nextLevel) {
              if (func(currState, data))
                return;
              if (currState->isCycleEnd)
                break;
          }
      }

    /* now traverse the simple ones */
    for (i = 0, currBH = stateTree->branchHeadTbl;
         i < stateTree->numBranchHeads;
         i++, currBH++)
      {
          if (currBH->isSimple && currBH->hasActions)
            {
                if (firstSimple)
                  {
                      XtBZero((char *) dummyState, sizeof(StateRec));
                      XtBZero((char *) dummyAction, sizeof(ActionRec));
                      dummyState->actions = dummyAction;
                      firstSimple = False;
                  }
                dummyState->typeIndex = currBH->typeIndex;
                dummyState->modIndex = currBH->modIndex;
                dummyAction->idx = currBH->more;
                if (func(dummyState, data))
                  return;
            }
      }
}

static void
_XtInstallTranslations(xlations)
    XtTranslations xlations;
{
    register Cardinal   i;
    TMStateTree stateTree;

    if (xlations == NULL) return;

    xlations->eventMask = 0;
    for (i = 0;
         i < (Cardinal)xlations->numStateTrees;
         i++)
      {
          stateTree = xlations->stateTreeTbl[i];
          _XtTraverseStateTree(stateTree,
                            AggregateEventMask,
                            (XtPointer)&xlations->eventMask);
      }
}

static TMStateTree
_XtParseTreeToStateTree(parseTree)
    TMParseStateTree    parseTree;
{
    register TMSimpleStateTree  simpleTree;
    register unsigned int       tableSize;

    if (parseTree->numComplexBranchHeads) {
        register TMComplexStateTree complexTree;

        complexTree = XtNew(TMComplexStateTreeRec);
        complexTree->isSimple = False;
        tableSize = parseTree->numComplexBranchHeads * sizeof(StatePtr);
        complexTree->complexBranchHeadTbl = (StatePtr *)
          XimTMMalloc(tableSize);
        XtBCopy(parseTree->complexBranchHeadTbl,
                complexTree->complexBranchHeadTbl,
                tableSize);
        complexTree->numComplexBranchHeads =
          parseTree->numComplexBranchHeads;
        simpleTree = (TMSimpleStateTree)complexTree;
    }
    else {
        simpleTree = XtNew(TMSimpleStateTreeRec);
        simpleTree->isSimple = True;
    }
    simpleTree->isAccelerator = parseTree->isAccelerator;
    simpleTree->refCount = 0;

    tableSize = parseTree->numBranchHeads * sizeof(TMBranchHeadRec);
    simpleTree->branchHeadTbl = (TMBranchHead) XimTMMalloc(tableSize);
    XtBCopy(parseTree->branchHeadTbl, simpleTree->branchHeadTbl, tableSize);
    simpleTree->numBranchHeads = parseTree->numBranchHeads;

    tableSize = parseTree->numQuarks * sizeof(XrmQuark);
    simpleTree->quarkTbl = (XrmQuark *) XimTMMalloc(tableSize);
    XtBCopy(parseTree->quarkTbl, simpleTree->quarkTbl, tableSize);
    simpleTree->numQuarks = parseTree->numQuarks;

    return (TMStateTree)simpleTree;
}

static EventSeqRec timerEventRec = {
    {0, 0, NULL, _XtEventTimerEventType, 0L, 0L, NULL},
    /* (StatePtr) -1 */ NULL,
    NULL,
    NULL
};

static String FetchModifierToken(str,modStr)
    String str,modStr;
{
    String start = str;
    String metaString = "Meta";
    String ctrlString = "Ctrl";
    if (*str == '$') {
        strcpy(modStr,metaString);
        str++;
        return str;
    }
    if (*str == '^') {
        strcpy(modStr,ctrlString);
        str++;
        return str;
    }
    str = ScanIdent(str);
    if (start != str) {
         bcopy(start, modStr, str-start);
          modStr[str-start] = '\0';
          return str;
    }
    return str;
}

static Cardinal LookupTMEventType(eventStr,error)
  String eventStr;
  Boolean *error;
{
    register int   i, left, right;
    register XrmQuark   signature;
    static int  previous = 0;

    if ((signature = StringToQuark(eventStr)) == events[previous].signature)
        return (Cardinal) previous;

    left = 0;
    right = XtNumber(events) - 1;
    while (left <= right) {
        i = (left + right) >> 1;
        if (signature < events[i].signature)
            right = i - 1;
        else if (signature > events[i].signature)
            left = i + 1;
        else {
            previous = i;
            return (Cardinal) i;
        }
    }

    Syntax("Unknown event type :  ",eventStr);
    *error = TRUE;
    return (Cardinal) i;
}

static String ParseString(str, strP)
    register String str;
    String *strP;
{
    register String start;

    if (*str == '"') {
        register unsigned prev_len, len;
        str++;
        start = str;
        *strP = NULL;
        prev_len = 0;

        while (*str != '"' && *str != '\0') {
            /* \"  produces double quote embedded in a quoted parameter
             * \\" produces backslash as last character of a quoted parameter
             */
            if (*str == '\\' &&
                (*(str+1) == '"' || (*(str+1) == '\\' && *(str+2) == '"'))) {
                len = prev_len + (str-start+2);
                *strP = XimTMRealloc(*strP, len);
                bcopy(start, *strP + prev_len, str-start);
                prev_len = len-1;
                str++;
                (*strP)[prev_len-1] = *str;
                (*strP)[prev_len] = '\0';
                start = str+1;
            }
            str++;
        }
        len = prev_len + (str-start+1);
        *strP = XimTMRealloc(*strP, len);
        bcopy(start, *strP + prev_len, str-start);
        (*strP)[len-1] = '\0';
        if (*str == '"') str++; else
            XtWarningMsg("parseString","Missing '\"'.");
    } else {
        /* scan non-quoted string, stop on whitespace, ',' or ')' */
        start = str;
        while (*str != ' '
                && *str != '\t'
                && *str != ','
                && *str != ')'
                && *str != '\n'
                && *str != '\0') str++;
        *strP = XimTMMalloc((unsigned)(str-start+1));
        bcopy(start, *strP, str-start);
        (*strP)[str-start] = '\0';
    }
    return str;
}

static String ParseParamSeq(str, paramSeqP, paramNumP)
    register String str;
    String **paramSeqP;
    Cardinal *paramNumP;
{
    typedef struct _ParamRec *ParamPtr;
    typedef struct _ParamRec {
        ParamPtr next;
        String  param;
    } ParamRec;

    ParamPtr params = NULL;
    register Cardinal num_params = 0;
    register Cardinal i;

    ScanWhitespace(str);
    while (*str != ')' && *str != '\0' && *str != '\n') {
        String newStr;
        str = ParseString(str, &newStr);
        if (newStr != NULL) {
            ParamPtr temp = (ParamRec*)
                ALLOCATE_LOCAL( (unsigned)sizeof(ParamRec) );

            num_params++;
            temp->next = params;
            params = temp;
            temp->param = newStr;
            ScanWhitespace(str);
            if (*str == ',') {
                str++;
                ScanWhitespace(str);
            }
        }
    }

    if (num_params != 0) {
        String *paramP = (String *)
                XimTMMalloc( (unsigned)(num_params+1) * sizeof(String) );
        *paramSeqP = paramP;
        *paramNumP = num_params;
        paramP += num_params; /* list is LIFO right now */
        *paramP-- = NULL;
        for (i=0; i < num_params; i++) {
            ParamPtr next = params->next;
            *paramP-- = params->param;
            DEALLOCATE_LOCAL( (char *)params );
            params = next;
        }
    } else {
        *paramSeqP = NULL;
        *paramNumP = 0;
    }

    return str;
}

static String ParseActionProc(str, actionProcNameP, error)
    register String str;
    XrmQuark *actionProcNameP;
    Boolean *error;
{
    register String start = str;
    char procName[200];

    str = ScanIdent(str);
    if (str-start >= 199) {
        Syntax("Action procedure name is longer than 199 chars","");
        *error = TRUE;
        return str;
    }
    bcopy(start, procName, str-start);
    procName[str-start] = '\0';
    *actionProcNameP = XrmStringToQuark( procName );
    return str;
}

static String ParseXtEventType(str, event, tmEventP,error)
    register String str;
    EventPtr event;
    Cardinal *tmEventP;
    Boolean* error;
{
    String start = str;
    char eventTypeStr[100];

    ScanAlphanumeric(str);
    bcopy(start, eventTypeStr, str-start);
    eventTypeStr[str-start] = '\0';
    *tmEventP = LookupTMEventType(eventTypeStr,error);
    if (*error)
        return PanicModeRecovery(str);
    event->event.eventType = events[*tmEventP].eventType;
    return str;
}

static void RepeatOther(eventP, reps, actionsP)
    EventPtr *eventP;
    int reps;
    ActionPtr **actionsP;
{
    register EventPtr event, tempEvent;
    register int i;

    tempEvent = event = *eventP;

    if (event->event.lateModifiers)
        event->event.lateModifiers->ref_count += reps - 1;

    for (i=1; i<reps; i++) {
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = *tempEvent;
    }

    *eventP = event;
    *actionsP = &event->actions;
}

static String ParseRepeat(str, reps, plus, error)
    register String str;
    int *reps;
    Boolean *plus, *error;
{

    /*** Parse the repetitions, for double click etc... ***/
    if (*str != '(' || !(isdigit(str[1]) || str[1] == '+' || str[1] == ')'))
        return str;
    str++;
    if (isdigit(*str)) {
        String start = str;
        char repStr[7];
        int len;

        ScanNumeric(str);
        len = (str - start);
        if (len < sizeof repStr) {
            bcopy(start, repStr, len);
            repStr[len] = '\0';
            *reps = StrToNum(repStr);
        } else {
            Syntax("Repeat count too large.", "");
            *error = True;
            return str;
        }
    }
    if (*reps == 0) {
        Syntax("Missing repeat count.","");
        *error = True;
        return str;
    }

    if (*str == '+') {
        *plus = TRUE;
        str++;
    }
    if (*str == ')')
        str++;
    else {
        Syntax("Missing ')'.","");
        *error = True;
    }

    return str;
}

static void FreeEventSeq(eventSeq)
    EventSeqPtr eventSeq;
{
    register EventSeqPtr evs = eventSeq;

    while (evs != NULL) {
        evs->state = (StatePtr) evs;
        if (evs->next != NULL
            && evs->next->state == (StatePtr) evs->next)
            evs->next = NULL;
        evs = evs->next;
    }

    evs = eventSeq;
    while (evs != NULL) {
        register EventPtr event = evs;
        evs = evs->next;
        if (evs == event) evs = NULL;
        XtFree((char *)event);
    }
}

static String ParseAction(str, actionP, quarkP, error)
    String str;
    ActionPtr actionP;
    XrmQuark* quarkP;
    Boolean* error;
{
    str = ParseActionProc(str, quarkP, error);
    if (*error) return str;

    if (*str == '(') {
        str++;
        str = ParseParamSeq(str, &actionP->params, &actionP->num_params);
    } else {
        Syntax("Missing '(' while parsing action sequence","");
        *error = TRUE;
        return str;
    }
    if (*str == ')') str++;
    else{
        Syntax("Missing ')' while parsing action sequence","");
        *error = TRUE;
        return str;
    }
    return str;
}

static String ParseActionSeq(parseTree, str, actionsP, error)
    TMParseStateTree    parseTree;
    String              str;
    ActionPtr           *actionsP;
    Boolean             *error;
{
    ActionPtr *nextActionP = actionsP;

    *actionsP = NULL;
    while (*str != '\0' && *str != '\n') {
        register ActionPtr      action;
        XrmQuark quark;

        action = XtNew(ActionRec);
        action->params = NULL;
        action->num_params = 0;
        action->next = NULL;

        str = ParseAction(str, action, &quark, error);
        if (*error) return PanicModeRecovery(str);

	action->idx = _XtGetQuarkIndex(parseTree, quark);

        ScanWhitespace(str);
        *nextActionP = action;
        nextActionP = &action->next;
    }
    if (*str == '\n') str++;
    ScanWhitespace(str);
    return str;
}

static void ShowProduction(currentProduction)
  String currentProduction;
{
    int len = 499;
    char *eol, production[500], msg[600];;

    eol = strchr(currentProduction, '\n');
    if (eol) len = MIN(499, eol - currentProduction);
    bcopy(currentProduction, production, len);
    production[len] = '\0';

    sprintf(msg, "... found while parsing '%s'", production);
    XtWarningMsg("showLine",msg);
}

static String ParseQuotedStringEvent(str, event,error)
    register String str;
    register EventPtr event;
    Boolean *error;
{
    register int j;

    Value ctrlMask;
    Value metaMask;
    Value shiftMask;
    Value lockMask;
    register char       c;
    char        s[2];

    (void) _XtLookupModifier("Ctrl",(LateBindingsPtr*)NULL,
                 FALSE,(Value *) &ctrlMask,TRUE);
    (void) _XtLookupModifier("Meta", (LateBindingsPtr*)NULL,
                 FALSE,(Value *) &metaMask,FALSE);
    (void) _XtLookupModifier("Shift",(LateBindingsPtr*)NULL,
                 FALSE,(Value *) &shiftMask,TRUE);
    (void) _XtLookupModifier("Lock",(LateBindingsPtr*)NULL,
                 FALSE,(Value *) &lockMask,TRUE);
    for (j=0; j < 2; j++)
        if (*str=='^' && !(event->event.modifiers & ctrlMask)) {
            str++;
            event->event.modifiers |= ctrlMask;
        } else if (*str == '$' && !(event->event.modifiers & metaMask)) {
            str++;
            event->event.modifiers |= metaMask;
        } else if (*str == '\\') {
            str++;
            c = *str;
            if (*str != '\0' && *str != '\n') str++;
            break;
        } else {
            c = *str;
            if (*str != '\0' && *str != '\n') str++;
            break;
        }
    event->event.eventType = KeyPress;
    s[0] = c;
    s[1] = '\0';
    event->event.eventCode = StringToKeySym(s, error);
    if (*error) return PanicModeRecovery(str);
    event->event.eventCodeMask = ~0L;
    event->event.modifierMask = ~(shiftMask|lockMask);
    event->event.matchEvent = _XtMatchUsingStandardMods;
    event->event.standard = True;

    return str;
}

static String ParseModifiers(str, event,error)
    register String str;
    EventPtr event;
    Boolean* error;
{
    register String start;
    Boolean notFlag, exclusive, keysymAsMod;
    Value maskBit;
    char modStr[100];

    ScanWhitespace(str);
    start = str;
    str = FetchModifierToken(str,modStr);
    exclusive = FALSE;
    if (start != str) {
          if (_XtLookupModifier(modStr,(LateBindingsPtr *) NULL,
                  FALSE,&maskBit,TRUE)) {
              if (maskBit== None) {
                  event->event.modifierMask = ~0;
                  event->event.modifiers = 0;
                  ScanWhitespace(str);
                  return str;
              }
              if (maskBit == AnyModifier) {/*backward compatability*/
                  event->event.modifierMask = 0;
                  event->event.modifiers = 0;
                  ScanWhitespace(str);
                  return str;
              }
          }
          str = start; /*if plain modifier, reset to beginning */
    }
    else while (*str == '!' || *str == ':') {
        if (*str == '!') {
             exclusive = TRUE;
             str++;
             ScanWhitespace(str);
        }
        if (*str == ':') {
             event->event.standard = TRUE;
             str++;
             ScanWhitespace(str);
        }
    }

    while (*str != '<') {
        if (*str == '~') {
             notFlag = TRUE;
             str++;
          } else
              notFlag = FALSE;
        if (*str == '@') {
            keysymAsMod = TRUE;
            str++;
        }
        else keysymAsMod = FALSE;
        start = str;
        str = FetchModifierToken(str,modStr);
        if (start == str) {
            Syntax("Modifier or '<' expected","");
            *error = TRUE;
            return PanicModeRecovery(str);
        }
         if (keysymAsMod) {
             _XtParseKeysymMod(modStr,&event->event.lateModifiers,
                               notFlag,&maskBit, error);
             if (*error)
                 return PanicModeRecovery(str);

         } else
             if (!_XtLookupModifier( modStr,
           &event->event.lateModifiers, notFlag, &maskBit,FALSE)) {
                 Syntax("Unknown modifier name:  ",modStr);
                 *error = TRUE;
                 return PanicModeRecovery(str);
             }
        event->event.modifierMask |= maskBit;
        if (notFlag) event->event.modifiers &= ~maskBit;
        else event->event.modifiers |= maskBit;
        ScanWhitespace(str);
    }
    if (exclusive) event->event.modifierMask = ~0;
    return str;
}


static String ParseEvent(str, event, reps, plus, error)
    register String str;
    EventPtr    event;
    int*        reps;
    Boolean*    plus;
    Boolean* error;
{
    Cardinal    tmEvent;

    str = ParseModifiers(str, event,error);
    if (*error) return str;
    if (*str != '<') {
         Syntax("Missing '<' while parsing event type.","");
         *error = TRUE;
         return PanicModeRecovery(str);
    }
    else str++;
    str = ParseXtEventType(str, event, &tmEvent,error);
    if (*error) return str;
    if (*str != '>'){
         Syntax("Missing '>' while parsing event type","");
         *error = TRUE;
         return PanicModeRecovery(str);
    }
    else str++;
    if (*str == '(') {
        str = ParseRepeat(str, reps, plus, error);
        if (*error) return str;
    }
    str = (*(events[tmEvent].parseDetail))(
        str, events[tmEvent].closure, event,error);
    if (*error) return str;

/* gross hack! ||| this kludge is related to the X11 protocol deficiency w.r.t.
 * modifiers in grabs.
 */
    return str;
}

static void RepeatOtherPlus(eventP, reps, actionsP)
    EventPtr *eventP;
    int reps;
    ActionPtr **actionsP;
{
    register EventPtr event, tempEvent;
    register int i;

    tempEvent = event = *eventP;

    if (event->event.lateModifiers)
        event->event.lateModifiers->ref_count += reps - 1;

    for (i=1; i<reps; i++) {
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = *tempEvent;
    }

    event->next = event;
    *eventP = event;
    *actionsP = &event->actions;
}

static void RepeatUp(eventP, reps, actionsP)
    EventPtr *eventP;
    int reps;
    ActionPtr **actionsP;
{
    EventRec upEventRec;
    register EventPtr event, downEvent;
    EventPtr upEvent = &upEventRec;
    register int i;

    /* the event currently sitting in *eventP is an "up" event */
    /* we want to make it a "down" event followed by an "up" event, */
    /* so that sequence matching on the "state" side works correctly. */

    downEvent = event = *eventP;
    *upEvent = *downEvent;
    downEvent->event.eventType = ((event->event.eventType == ButtonRelease) ?
        ButtonPress : KeyPress);

    if (event->event.lateModifiers)
        event->event.lateModifiers->ref_count += reps * 2 - 1;

    /* up */
    event->next = XtNew(EventSeqRec);
    event = event->next;
    *event = *upEvent;

    for (i=1; i<reps; i++) {

        /* timer */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = timerEventRec;

        /* down */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = *downEvent;

        /* up */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = *upEvent;

        }

    event->next = NULL;
    *eventP = event;
    *actionsP = &event->actions;
}

static void RepeatDown(eventP, reps, actionsP)
    EventPtr *eventP;
    int reps;
    ActionPtr **actionsP;
{
    EventRec upEventRec;
    register EventPtr event, downEvent;
    EventPtr upEvent = &upEventRec;
    register int i;

    downEvent = event = *eventP;
    *upEvent = *downEvent;
    upEvent->event.eventType = ((event->event.eventType == ButtonPress) ?
        ButtonRelease : KeyRelease);

    if (event->event.lateModifiers)
        event->event.lateModifiers->ref_count += (reps - 1) * 2;

    for (i=1; i<reps; i++) {

        /* up */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = *upEvent;

        /* timer */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = timerEventRec;

        /* down */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = *downEvent;

    }

    event->next = NULL;
    *eventP = event;
    *actionsP = &event->actions;
}

static void RepeatUpPlus(eventP, reps, actionsP)
    EventPtr *eventP;
    int reps;
    ActionPtr **actionsP;
{
    EventRec upEventRec;
    register EventPtr event, downEvent, lastUpEvent;
    EventPtr upEvent = &upEventRec;
    register int i;

    /* the event currently sitting in *eventP is an "up" event */
    /* we want to make it a "down" event followed by an "up" event, */
    /* so that sequence matching on the "state" side works correctly. */

    downEvent = event = *eventP;
    *upEvent = *downEvent;
    downEvent->event.eventType = ((event->event.eventType == ButtonRelease) ?
        ButtonPress : KeyPress);

    if (event->event.lateModifiers)
        event->event.lateModifiers->ref_count += reps * 2;

    for (i=0; i<reps; i++) {

        /* up */
        event->next = XtNew(EventSeqRec);
        lastUpEvent = event = event->next;
        *event = *upEvent;

        /* timer */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = timerEventRec;

        /* down */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = *downEvent;

        }

    event->next = lastUpEvent;
    *eventP = event;
    *actionsP = &lastUpEvent->actions;
}

static void RepeatDownPlus(eventP, reps, actionsP)
    EventPtr *eventP;
    int reps;
    ActionPtr **actionsP;
{
    EventRec upEventRec;
    register EventPtr event, downEvent, lastDownEvent;
    EventPtr upEvent = &upEventRec;
    register int i;

    downEvent = event = *eventP;
    *upEvent = *downEvent;
    upEvent->event.eventType = ((event->event.eventType == ButtonPress) ?
        ButtonRelease : KeyRelease);

    if (event->event.lateModifiers)
        event->event.lateModifiers->ref_count += reps * 2 - 1;

    for (i=0; i<reps; i++) {

        if (i > 0) {
        /* down */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = *downEvent;
        }
        lastDownEvent = event;

        /* up */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = *upEvent;

        /* timer */
        event->next = XtNew(EventSeqRec);
        event = event->next;
        *event = timerEventRec;

    }

    event->next = lastDownEvent;
    *eventP = event;
    *actionsP = &lastDownEvent->actions;
}

static void RepeatEvent(eventP, reps, plus, actionsP)
    EventPtr *eventP;
    int reps;
    Boolean plus;
    ActionPtr **actionsP;
{
    switch ((*eventP)->event.eventType) {

        case ButtonPress:
        case KeyPress:
            if (plus) RepeatDownPlus(eventP, reps, actionsP);
            else RepeatDown(eventP, reps, actionsP);
            break;

        case ButtonRelease:
        case KeyRelease:
            if (plus) RepeatUpPlus(eventP, reps, actionsP);
            else RepeatUp(eventP, reps, actionsP);
            break;

        default:
            if (plus) RepeatOtherPlus(eventP, reps, actionsP);
            else RepeatOther(eventP, reps, actionsP);
    }
}

static Boolean
_XtRegularMatch(typeMatch, modMatch, eventSeq)
    TMTypeMatch         typeMatch;
    TMModifierMatch     modMatch;
    TMEventPtr          eventSeq;
{
    Modifiers computed =0;
    Modifiers computedMask =0;
    Boolean resolved = TRUE;
    if (typeMatch->eventCode != (eventSeq->event.eventCode &
                                  typeMatch->eventCodeMask)) return FALSE;
    if (modMatch->lateModifiers != NULL)
      resolved =
        _XtComputeLateBindings(modMatch->lateModifiers,
                               eventSeq,
                               &computed,
                               &computedMask);
    if (!resolved) return FALSE;
    computed |= modMatch->modifiers;
    computedMask |= modMatch->modifierMask;

    return ( (computed & computedMask) ==
            (eventSeq->event.modifiers & computedMask));
}

static String ParseEventSeq(str, eventSeqP, actionsP,error)
    register String str;
    EventSeqPtr *eventSeqP;
    ActionPtr   **actionsP;
    Boolean *error;
{
    EventSeqPtr *nextEvent = eventSeqP;

    *eventSeqP = NULL;

    while ( *str != '\0' && *str != '\n') {
        static Event    nullEvent =
             {0, 0,0L, 0, 0L, 0L,_XtRegularMatch,FALSE};
        EventPtr        event;

        ScanWhitespace(str);

        if (*str == '"') {
            str++;
            while (*str != '"' && *str != '\0' && *str != '\n') {
                event = XtNew(EventRec);
                event->event = nullEvent;
                event->state = /* (StatePtr) -1 */ NULL;
                event->next = NULL;
                event->actions = NULL;
                str = ParseQuotedStringEvent(str, event,error);
                if (*error) {
                    XtWarningMsg("nonLatin1","... probably due to non-Latin1 character in quoted string");
                    return PanicModeRecovery(str);
                }
                *nextEvent = event;
                *actionsP = &event->actions;
                nextEvent = &event->next;
            }
            if (*str != '"') {
                Syntax("Missing '\"'.","");
                *error = TRUE;
                return PanicModeRecovery(str);
             }
             else str++;
        } else {
            int reps = 0;
            Boolean plus = False;

            event = XtNew(EventRec);
            event->event = nullEvent;
            event->state = /* (StatePtr) -1 */ NULL;
            event->next = NULL;
            event->actions = NULL;

            str = ParseEvent(str, event, &reps, &plus, error);
            if (*error) return str;
            *nextEvent = event;
            *actionsP = &event->actions;
            if (reps > 1 || plus)
                RepeatEvent(&event, reps, plus, actionsP);
            nextEvent = &event->next;
        }
        ScanWhitespace(str);
        if (*str == ':') break;
        else {
            if (*str != ',') {
                Syntax("',' or ':' expected while parsing event sequence.","");
                *error = TRUE;
                return PanicModeRecovery(str);
            } else str++;
        }
    }

    if (*str != ':') {
        Syntax("Missing ':'after event sequence.","");
        *error = TRUE;
        return PanicModeRecovery(str);
    } else str++;

    return str;
}

static String ParseTranslationTableProduction(parseTree, str)
    TMParseStateTree     parseTree;
    register String str;
{
    EventSeqPtr eventSeq = NULL;
    ActionPtr   *actionsP;
    Boolean error = FALSE;
    String      production = str;

    str = ParseEventSeq(str, &eventSeq, &actionsP,&error);
    if (error == TRUE) {
        ShowProduction(production);
        FreeEventSeq(eventSeq);
        return (str);
    }
    ScanWhitespace(str);
    str = ParseActionSeq(parseTree, str, actionsP, &error);
    if (error) {
        ShowProduction(production);
        FreeEventSeq(eventSeq);
        return (str);
    }

    if(eventSeq && eventSeq->actions == NULL)
	eventSeq->actions = *actionsP;

    _XtAddEventSeqToStateTree(eventSeq, parseTree);
    FreeEventSeq(eventSeq);
    return (str);
}

static XtTranslations ParseTranslationTable(source, isAccelerator, defaultOp)
    String      source;
    Boolean     isAccelerator;
    _XtTranslateOp defaultOp;
{
    XtTranslations              xlations;
    TMStateTree                 stateTrees[1];
    TMParseStateTreeRec         parseTreeRec, *parseTree = &parseTreeRec;
    XrmQuark                    stackQuarks[200];
    TMBranchHeadRec             stackBranchHeads[200];
    StatePtr                    stackComplexBranchHeads[200];
    _XtTranslateOp              actualOp;

    if (source == NULL)
      return (XtTranslations)NULL;

    source = CheckForPoundSign(source, defaultOp, &actualOp);

    parseTree->isSimple = True;
    parseTree->isAccelerator = isAccelerator;
    parseTree->isStackBranchHeads =
      parseTree->isStackQuarks =
        parseTree->isStackComplexBranchHeads = True;

    parseTree->numQuarks =
      parseTree->numBranchHeads =
        parseTree->numComplexBranchHeads = 0;

    parseTree->quarkTblSize =
      parseTree->branchHeadTblSize =
        parseTree->complexBranchHeadTblSize = 200;

    parseTree->quarkTbl = stackQuarks;
    parseTree->branchHeadTbl = stackBranchHeads;
    parseTree->complexBranchHeadTbl = stackComplexBranchHeads;

    while (source != NULL && *source != '\0') {
        source =  ParseTranslationTableProduction(parseTree, source);
    }
    stateTrees[0] = _XtParseTreeToStateTree(parseTree);

    if (!parseTree->isStackQuarks)
      XtFree((char *)parseTree->quarkTbl);
    if (!parseTree->isStackBranchHeads)
      XtFree((char *)parseTree->branchHeadTbl);
    if (!parseTree->isStackComplexBranchHeads)
      XtFree((char *)parseTree->complexBranchHeadTbl);

#ifdef notdef
    xlations = _XtCreateXlations(stateTrees, 1, NULL, NULL);
#else
    xlations = _XtCreateXlations(stateTrees);
#endif /* notdef */
    xlations->operation = actualOp;

#ifdef notdef
    XtFree(stateTrees);
#endif /* notdef */
    return xlations;
}

static XtTranslations
XtParseTranslationTable(source)
    Const char* source;
{
    return (ParseTranslationTable((String)source, False, XtTableReplace));
}

#define MatchIncomingEvent(tmEvent, typeMatch, modMatch) \
  (typeMatch->eventType == tmEvent->event.eventType && \
   (typeMatch->matchEvent != NULL) && \
   (*typeMatch->matchEvent)(typeMatch, modMatch, tmEvent))


static unsigned long GetTime(tm, event)
    XtTM tm;
    register XEvent *event;
{
    switch (event->type) {

        case KeyPress:
        case KeyRelease:
            return event->xkey.time;

        case ButtonPress:
        case ButtonRelease:
            return event->xbutton.time;

        default:
            return tm->lastEventTime;

    }

}

static int MatchBranchHead(stateTree, startIndex, event)
    TMSimpleStateTree   stateTree;
    int                 startIndex;
    register TMEventPtr event;
{
    register TMBranchHead
      branchHead = &stateTree->branchHeadTbl[startIndex];
    register int i;

    for (i = startIndex;
         i < (int)stateTree->numBranchHeads;
         i++, branchHead++)
      {
          TMTypeMatch           typeMatch;
          TMModifierMatch       modMatch;

          typeMatch  = TMGetTypeMatch(branchHead->typeIndex);
          modMatch = TMGetModifierMatch(branchHead->modIndex);

          if (MatchIncomingEvent(event, typeMatch, modMatch))
            return i;
      }
    return (TM_NO_MATCH);
}

static int MatchExact(stateTree, startIndex, typeIndex, modIndex)
    TMSimpleStateTree   stateTree;
    int                 startIndex;
    TMShortCard         typeIndex, modIndex;
{
    register TMBranchHead branchHead = &(stateTree->branchHeadTbl[startIndex]);
    register int i;

    for (i = startIndex;
         i < (int)stateTree->numBranchHeads;
         i++, branchHead++)
      {
          if ((branchHead->typeIndex == typeIndex) &&
              (branchHead->modIndex == modIndex))
            return i;
      }
    return (TM_NO_MATCH);
}

#define IsOn(vec,idx) ((vec)[(idx)>>3] & (1 << ((idx) & 7)))

static Boolean Ignore(event)
    register TMEventPtr event;
{
    register Display *dpy;
    register XtPerDisplay pd;

    if (event->event.eventType == MotionNotify)
        return TRUE;
    if (!(event->event.eventType == KeyPress ||
          event->event.eventType == KeyRelease))
        return FALSE;
    dpy = event->xev->xany.display;
    pd = _XtGetPerDisplay();
    _InitializeKeysymTables(dpy, pd);
    return IsOn(pd->isModifier, event->event.eventCode) ? TRUE : FALSE;
}

typedef struct {
    unsigned int isCycleStart:1;
    unsigned int isCycleEnd:1;
    TMShortCard typeIndex;
    TMShortCard modIndex;
}MatchPairRec, *MatchPair;

typedef struct TMContextRec{
    TMShortCard numMatches;
    TMShortCard maxMatches;
    MatchPair   matches;
}TMContextRec, *TMContext;

static TMContextRec     contextCache[2];

#define GetContextPtr(tm) ((TMContext *)&(tm->current_state))

#define TM_CONTEXT_MATCHES_ALLOC 4
#define TM_CONTEXT_MATCHES_REALLOC 2

static void FreeContext(contextPtr)
    TMContext   *contextPtr;
{
    TMContext           context = NULL;
   
    if (&contextCache[0] == *contextPtr)
      context = &contextCache[0];
    else if (&contextCache[1] == *contextPtr)
      context = &contextCache[1];
    if (context) {
        context->numMatches = 0;
        context->maxMatches = 0;
        if (context->matches)
                XtFree((char *)context->matches);
        context->matches = NULL;
    } else if (contextPtr && *contextPtr) {
              if ((*contextPtr)->matches)
                XtFree((char *)(*contextPtr)->matches);
              XtFree((char *)*contextPtr);
    }

    *contextPtr = NULL;
}

static void XEventToTMEvent(event, tmEvent)
    register XEvent *event;
    register TMEventPtr tmEvent;
{
    tmEvent->xev = event;
    tmEvent->event.eventCodeMask = 0;
    tmEvent->event.modifierMask = 0;
    tmEvent->event.eventType = event->type;
    tmEvent->event.lateModifiers = NULL;
    tmEvent->event.matchEvent = NULL;
    tmEvent->event.standard = FALSE;

    switch (event->type) {

	case KeyPress:
	case KeyRelease:
            tmEvent->event.eventCode = event->xkey.keycode;
	    tmEvent->event.modifiers = event->xkey.state;
	    break;

	default:
	    tmEvent->event.eventCode = 0;
	    tmEvent->event.modifiers = 0;
	    break;
    }
}

static int MatchComplexBranch(stateTree, startIndex, context, leafStateRtn)
    TMComplexStateTree  stateTree;
    int                 startIndex;
    TMContext           context;
    StatePtr            *leafStateRtn;
{
    TMShortCard i;

    for (i = startIndex; i < stateTree->numComplexBranchHeads; i++)
      {
          StatePtr      candState;
          TMShortCard   numMatches = context->numMatches;
          MatchPair     statMatch = context->matches;

          for (candState = stateTree->complexBranchHeadTbl[i];
               numMatches && candState;
               numMatches--, statMatch++, candState = candState->nextLevel)
            {
                if ((statMatch->typeIndex != candState->typeIndex) ||
                    (statMatch->modIndex != candState->modIndex))
                  break;
            }
          if (numMatches == 0) {
              *leafStateRtn = candState;
              return i;
          }
      }
    *leafStateRtn = NULL;
    return (TM_NO_MATCH);
}

static StatePtr TryCurrentTree(stateTreePtr, tmRecPtr, curEventPtr)
    TMComplexStateTree  *stateTreePtr;
    XtTM                tmRecPtr;
    TMEventRec          *curEventPtr;
{
    StatePtr            candState = NULL, matchState = NULL;
    TMContext           *contextPtr = GetContextPtr(tmRecPtr);
    TMTypeMatch         typeMatch;
    TMModifierMatch     modMatch;
    int                 currIndex = -1;
   
    /*
     * we want the first sequence that both matches and has actions.
     * we keep on looking till we find both
     */
    while ((currIndex =
            MatchComplexBranch(*stateTreePtr,
                               ++currIndex,
                               (*contextPtr),
                               &candState))
           != TM_NO_MATCH) {
        if (candState  != NULL) {
            typeMatch  = TMGetTypeMatch(candState->typeIndex);
            modMatch = TMGetModifierMatch(candState->modIndex);

            /* does this state's index match? --> done */
            if (MatchIncomingEvent(curEventPtr, typeMatch, modMatch))
              {
                  if (candState->actions) {
                      return candState;
                  }
                  else
                    matchState = candState;
              }
            /* is this an event timer? */
            if (typeMatch->eventType == _XtEventTimerEventType) {
                StatePtr nextState = candState->nextLevel;

                /* does the succeeding state match? */
                if (nextState != NULL) {
                    TMTypeMatch         nextTypeMatch;
                    TMModifierMatch     nextModMatch;

                    nextTypeMatch  = TMGetTypeMatch(nextState->typeIndex);
                    nextModMatch = TMGetModifierMatch(nextState->modIndex);

                    /* is it within the timeout? */
                    if (MatchIncomingEvent(curEventPtr,
                                           nextTypeMatch,
                                           nextModMatch)) {
                        XEvent *xev = curEventPtr->xev;
                        unsigned long time = GetTime(tmRecPtr, xev);
                        XtPerDisplay pd = _XtGetPerDisplay();
                        unsigned long delta = pd->multi_click_time;

                        if ((tmRecPtr->lastEventTime + delta) >= time) {
                            if (nextState->actions) {
                                return candState;
                            }
                            else
                              matchState = candState;
                        }
                    }
                }
            }
        }
    }
    return matchState;
}

static void PushContext(contextPtr, newState)
    TMContext   *contextPtr;
    StatePtr    newState;
{
    TMContext           context = *contextPtr;
   
    if (context == NULL)
      {
          if (contextCache[0].numMatches == 0)
            context = &contextCache[0];
          else if (contextCache[1].numMatches == 0)
            context = &contextCache[1];
          if (!context)
            {
                context = XtNew(TMContextRec);
                context->matches = NULL;
                context->numMatches =
                  context->maxMatches = 0;
            }
      }
    if (context->numMatches &&
        context->matches[context->numMatches-1].isCycleEnd)
      {
          TMShortCard   i;
          for (i = 0;
               i < context->numMatches &&
               !(context->matches[i].isCycleStart);
               i++){};
          if (i < context->numMatches)
            context->numMatches = i+1;
#ifdef DEBUG
          else
            XtWarning("pushing cycle end with no cycle start");
#endif /* DEBUG */
      }
    else
      {
          if (context->numMatches == context->maxMatches)
            {
                if (context->maxMatches == 0)
                  context->maxMatches += TM_CONTEXT_MATCHES_ALLOC;
                else
                  context->maxMatches += TM_CONTEXT_MATCHES_REALLOC;
                context->matches = (MatchPairRec *)
                  XimTMRealloc((char *)context->matches,
                            context->maxMatches * sizeof(MatchPairRec));
            }
          context->matches[context->numMatches].isCycleStart = newState->isCycleStart;
          context->matches[context->numMatches].isCycleEnd = newState->isCycleEnd;
          context->matches[context->numMatches].typeIndex = newState->typeIndex;
          context->matches[context->numMatches++].modIndex = newState->modIndex;
          *contextPtr = context;
      }
}

static int
HandleSimpleState(tmRecPtr, curEventPtr, actTblPtr, 
	num_action_table, rsvEvents, num_rsvEvents, result)
    XtTM		tmRecPtr;
    TMEventRec		*curEventPtr;
    CompiledActionTable	actTblPtr;
    int			num_action_table;
    XEvent		**rsvEvents;
    int			*num_rsvEvents;
    IMBindResult	*result;
{  
    XtTranslations	xlations = tmRecPtr->translations;
    TMSimpleStateTree	stateTree;
    TMContext		*contextPtr = GetContextPtr(tmRecPtr);
    TMShortCard		i;
    ActionRec		*actions;
    Boolean		matchExact = False;
    Boolean	       	match = False; 
    StatePtr		complexMatchState = NULL;
    int			currIndex;
    TMShortCard		typeIndex, modIndex;
    int			matchTreeIndex = TM_NO_MATCH;
    int			ret = IMBindFailed;
    
    stateTree = (TMSimpleStateTree)xlations->stateTreeTbl[0];
    
    for (i = 0; 
	 ((!match || !complexMatchState) && (i < xlations->numStateTrees));
	 i++){
	stateTree = (TMSimpleStateTree)xlations->stateTreeTbl[i];
	currIndex = -1;
	/*
	 * don't process this tree if we're only looking for a
	 * complexMatchState and there are no complex states
	 */
	while (!(match && stateTree->isSimple) &&
	       ((!match || !complexMatchState) && (currIndex != TM_NO_MATCH))) {
	    currIndex++;
	    if (matchExact)
	      currIndex = MatchExact(stateTree,currIndex,typeIndex,modIndex);
	    else
	      currIndex = MatchBranchHead(stateTree,currIndex,curEventPtr);
	    if (currIndex != TM_NO_MATCH) {
		TMBranchHead branchHead;
		StatePtr currState;
		
		branchHead = &stateTree->branchHeadTbl[currIndex];
		if (branchHead->isSimple)
		  currState = NULL;
		else
		  currState = ((TMComplexStateTree)stateTree)
		    ->complexBranchHeadTbl[TMBranchMore(branchHead)];
		
		/*
		 * first check for a complete match
		 */
		if (!match) {
		    if (branchHead->hasActions) {
			if (branchHead->isSimple) {
			    static ActionRec	dummyAction;
			    
			    dummyAction.idx = TMBranchMore(branchHead);
			    actions = &dummyAction;
			}
			else 
			  actions = currState->actions;
			tmRecPtr->lastEventTime = 
			  GetTime(tmRecPtr, curEventPtr->xev);
			FreeContext((TMContext
				     *)&tmRecPtr->current_state);
			match = True;
			matchTreeIndex = i;
		    }
		    /* 
		     * if it doesn't have actions and
		     * it's bc mode then it's a potential match node that is
		     * used to match later sequences.
		     */
		    if (!TMNewMatchSemantics() && !matchExact) {
			matchExact = True;
			typeIndex = branchHead->typeIndex;
			modIndex = branchHead->modIndex;
		    }
		}
		/*
		 * check for it being an event sequence which can be
		 * a future match 
		 */
		if (!branchHead->isSimple &&
		    !branchHead->hasActions &&
		    !complexMatchState) 
		  complexMatchState = currState;
	    }
	}
    }
    /* convert reserved events to failed result */
    if (*num_rsvEvents) {
      _xim_tm_make_failed_result(*rsvEvents, *num_rsvEvents, result) ;
      _xim_tm_free_reserved_event(rsvEvents, num_rsvEvents) ;
    }

    if (match) {
      _xim_tm_make_succeeded_result(
		curEventPtr->xev, 1,
		(TMSimpleStateTree)xlations->stateTreeTbl[matchTreeIndex],
		actions, actTblPtr, num_action_table, result) ;
      ret = IMBindSucceeded ;
    }
    if (complexMatchState) {
      PushContext(contextPtr, complexMatchState);
      if (!match) {
	_xim_tm_add_reserved_event(curEventPtr->xev, rsvEvents, num_rsvEvents) ;
	ret = IMBindNeedMoreEvent ;
      }
    } else if (!match)
      ret = IMBindFailed ;

    return ret ;
}

static int
HandleComplexState(tmRecPtr, curEventPtr,
		actTblPtr, num_action_table, rsvEvents, num_rsvEvents, result)
    XtTM		tmRecPtr;
    TMEventRec		*curEventPtr;
    CompiledActionTable	actTblPtr;
    int			num_action_table;
    XEvent		**rsvEvents;
    int			*num_rsvEvents;
    IMBindResult	*result;
{
    XtTranslations 	xlations = tmRecPtr->translations;
    TMContext		*contextPtr = GetContextPtr(tmRecPtr);
    TMShortCard		i, matchTreeIndex;
    StatePtr		matchState = NULL, candState;
    TMComplexStateTree 	*stateTreePtr = 
      (TMComplexStateTree *)&xlations->stateTreeTbl[0];
    int			ret = IMBindFailed;
    
    for (i = 0;
	 i < xlations->numStateTrees;
	 i++, stateTreePtr++) {
	/* 
	 * some compilers sign extend Boolean bit fields so test for
	 * false |||
	 */
	if (((*stateTreePtr)->isSimple == False) &&
	    (candState = TryCurrentTree(stateTreePtr,
				       tmRecPtr,
				       curEventPtr))) {
	    matchTreeIndex = i;
	    matchState = candState;
	    if (candState->actions)
	      break;
	}
    }
    if (matchState == NULL){
	/* couldn't find it... */
	if (!Ignore(curEventPtr))
	  {
	      FreeContext(contextPtr);
	      return HandleSimpleState(tmRecPtr, curEventPtr,
				actTblPtr, num_action_table,
				rsvEvents, num_rsvEvents, result);
	  } else
	      return ret ;
    } else {
	TMTypeMatch 	typeMatch;
	
	typeMatch  = TMGetTypeMatch(matchState->typeIndex);

	PushContext(contextPtr, matchState);
	if (typeMatch->eventType == _XtEventTimerEventType) {
	    matchState = matchState->nextLevel;
	    PushContext(contextPtr, matchState);
	}
	tmRecPtr->lastEventTime = GetTime (tmRecPtr, curEventPtr->xev);

	if(matchState->actions != NULL) {
	    _xim_tm_add_reserved_event(curEventPtr->xev, rsvEvents, num_rsvEvents) ;
	    _xim_tm_make_succeeded_result(
                *rsvEvents, *num_rsvEvents,
                (TMSimpleStateTree)xlations->stateTreeTbl[matchTreeIndex],
                matchState->actions, actTblPtr, num_action_table, result) ;
	    _xim_tm_free_reserved_event(rsvEvents, num_rsvEvents) ;
	    ret = IMBindSucceeded ;
 
	} else {
	    _xim_tm_add_reserved_event(curEventPtr->xev, rsvEvents, num_rsvEvents) ;
	    ret = IMBindNeedMoreEvent ;
 
	}

	return ret ;
    }
}

static CompiledAction *
SearchActionTable(signature, actionTable, numActions)
    XrmQuark            signature;
    CompiledActionTable actionTable;
    Cardinal            numActions;
{
    register int i, left, right;

    left = 0;
    right = numActions - 1;
    while (left <= right) {
        i = (left + right) >> 1;
        if (signature < actionTable[i].signature)
            right = i - 1;
        else if (signature > actionTable[i].signature)
            left = i + 1;
        else {
            while (i && actionTable[i - 1].signature == signature)
                i--;
            return &actionTable[i];
        }
    }
    return (CompiledAction *) NULL;
}

typedef struct _TranslationTableRec *TranslationTable;
typedef struct _TranslationTableRec {
    XtTranslations	translations;
    IMTMid		*id;
    int			count;
    TranslationTable	next;
} TranslationTableRec;

static TranslationTable _HeadTranslationTable = NULL;

static void
_xim_tm_set_translation(translations, id)
XtTranslations	translations;
IMTMid		id;
{
    TranslationTable ptr = _HeadTranslationTable, 
		     last = NULL, 
		     tt = XtNew(TranslationTableRec);

    tt->translations = translations;
    tt->id = (int *)XimTMMalloc(sizeof(int));
    tt->id[0] = id;
    tt->count = 1;
    tt->next = NULL;

    while(ptr) {
	last = ptr;
	ptr = ptr->next;
    }

    if(last) 
	last->next = tt;
    else
	_HeadTranslationTable = tt;

}

static XtTranslations
_xim_tm_get_translation(id, ref_id)
IMTMid		id;
IMTMid		ref_id;
{
    TranslationTable ptr = _HeadTranslationTable;
    register int i;

    while(ptr) {
	for(i = 0; i < ptr->count; i++) {
	    if(ptr->id[i] == id) {
		ptr->id = (int *)XimTMRealloc((char *)ptr->id, 
		    (unsigned)((ptr->count+1) * sizeof(int)));
		ptr->id[ptr->count] = ref_id;
		ptr->count++;
		return ptr->translations;
	    }
	}
	ptr = ptr->next;
    }

    return NULL;
}

static void
_xim_tm_rm_translation(id)
IMTMid		id;
{
    TranslationTable ptr = _HeadTranslationTable, prev = NULL;
    register int i, j, k;

    while(ptr) {
	for(i = 0; i < ptr->count; i++) {
	    if(ptr->id[i] == id) {
		if(ptr->count == 1) {
		    if(prev)
			prev->next = ptr->next;
		    else
			_HeadTranslationTable = ptr->next;

		    _xim_tm_destroy_translations(ptr->translations);
		    XtFree((char *)ptr->id);
		    XtFree((char *)ptr);
		} else {
		    IMTMid *new_id = (IMTMid *)XimTMMalloc(sizeof(int) * 
			(ptr->count-1));

		    for(j = 0, k = 0; j < ptr->count; j++) {
			if(ptr->id[j] != id)
			    new_id[k++] = ptr->id[j];
		    }

		    XtFree((char *)ptr->id);

		    ptr->id = new_id;
		    ptr->count--;
		}

		return;
	    }
	}
	prev = ptr;
	ptr = ptr->next;
    }
}

static void 
_xim_tm_free_reserved_event (event_buf, n_events)
    XEvent **   event_buf;
    int *       n_events;
{
    if (*event_buf) {
        XtFree ((char *)*event_buf);
        *event_buf = NULL;
    }
    *n_events = 0;
}

static Bool
_xim_tm_make_failed_result(event, n_events, result)
    XEvent         *event;
    int             n_events;
    IMBindResult   *result;
{
    XEvent         *eve_buf = NULL;
    IMBindResult    res_buf;

    if (n_events) {
        eve_buf = (XEvent *) XimTMMalloc(sizeof(XEvent) * n_events);
        if (!eve_buf)
            return False;
        XtBCopy(event, eve_buf, sizeof(XEvent) * n_events);
    }
    res_buf = (IMBindResult) XimTMMalloc(sizeof(IMBindResultRec));
    if (!res_buf) {
        XtFree((char *) eve_buf);
        return False;
    }
    res_buf->next = NULL;
    res_buf->result = IMBindResultFailed;
    res_buf->actions = (IMActionList) NULL;
    res_buf->num_actions = 0;
    res_buf->num_events = n_events;
    res_buf->events = eve_buf;

    if (*result == NULL)
        *result = res_buf;
    else {
        IMBindResult    res_wrk;

        for (res_wrk = *result; res_wrk->next; res_wrk = res_wrk->next);
        res_wrk->next = res_buf;
    }

    return True;
}

static Bool 
_xim_tm_add_reserved_event (event, event_buf, n_events)
    XEvent *    event;
    XEvent **   event_buf;
    int *       n_events;
{
    *event_buf = (XEvent *) XimTMRealloc ((char *)*event_buf,
                                sizeof(XEvent) * ((*n_events)+1)) ;
    if (*event_buf == NULL) {
        return False;
    }

    XtBCopy (event, ((*event_buf)+(*n_events)), sizeof(XEvent));
    (*n_events)++;

    return True;
}

static Bool 
_xim_tm_make_succeeded_result(event, n_events, state_tree, actions, 
    action_table, num_action_table, result)
    XEvent *		event;
    int			n_events;
    TMSimpleStateTree	state_tree;
    ActionPtr		actions;
    CompiledActionTable action_table;
    int			num_action_table;
    IMBindResult *	result;
{
    XEvent		*eve_buf = NULL;
    IMBindResult	res_buf;
    IMActionList	action_buf = NULL;
    int			n_key_buf = 0;
    int			np;

    if (n_events) {
	eve_buf = (XEvent *) XimTMMalloc (sizeof(XEvent) * n_events);
	if (!eve_buf)	return False;
	XtBCopy (event, eve_buf, sizeof(XEvent) * n_events);
    }

    res_buf = (IMBindResult) XimTMMalloc (sizeof(IMBindResultRec));
    if (!res_buf) {
	XtFree ((char *)eve_buf);
	return False;
    }

    while (actions != NULL) {
	char		*func_name ;
	int		nParams = 0;
	int		len = 0;
	CompiledAction	*action;

	func_name = XrmQuarkToString (state_tree->quarkTbl[actions->idx] );

	if ((action = SearchActionTable(state_tree->quarkTbl[actions->idx],
		action_table, num_action_table)) != NULL) {
		
		action_buf = 
			(IMActionList)XimTMRealloc(
				(char *)action_buf,
				sizeof(IMActionRec) * (n_key_buf  + 1));
		action_buf[n_key_buf].proc = action->proc;
		action_buf[n_key_buf].proc_name = func_name;
		action_buf[n_key_buf].params =
			(String *)XimTMMalloc(
				sizeof(String) * (actions->num_params));
		
		/*
		 * Set other parameters.
		 */

		for (np = 0; np < actions->num_params; np++) {
			len = sizeof(char) * (strlen(actions->params[np]) + 1);
			action_buf[n_key_buf].params[nParams] =
				(String)XimTMMalloc(len);
			XtBZero(action_buf[n_key_buf].params[nParams],
			len); 
			strcpy(action_buf[n_key_buf].params[nParams],
				actions->params[np]);
			nParams++;
		}

		action_buf[n_key_buf].num_params = nParams;
	}

	n_key_buf++ ;
	actions = actions->next;
    }

    res_buf->next = NULL;
    res_buf->result = IMBindResultSucceeded;
    res_buf->num_actions = n_key_buf;
    res_buf->actions = action_buf;
    res_buf->num_events = n_events;
    res_buf->events = eve_buf;

    if (*result == NULL)
	*result = res_buf;
    else {
	IMBindResult	res_wrk;
	for (res_wrk = *result; res_wrk->next; res_wrk = res_wrk->next);
	res_wrk->next = res_buf;
    }

    return True;
}

static XtTM
_xim_tm_create_binding_table(resource)
    char           *resource;
{
    XtTM            binding_table;
    XtTranslations  translations;

    translations = XtParseTranslationTable(resource);
    if (!translations)
        return NULL;

    /* Set Event Mask */
    _XtInstallTranslations(translations);

    binding_table = (XtTM) XimTMMalloc(sizeof(XtTMRec));

    XtBZero(binding_table, sizeof(XtTMRec));

    binding_table->translations = translations;

    return binding_table;
}

static void 
_xim_tm_free_state_tree (tree)
TMStateTree  tree;
{
    TMComplexStateTree stateTree = (TMComplexStateTree)tree;

    if (--stateTree->refCount == 0) {
        /*
         * should we free/refcount the match recs ?
         */
        if (!stateTree->isSimple)  {
            StatePtr    currState, nextState;
            TMShortCard i;
            for (i = 0; i < stateTree->numComplexBranchHeads; i++) {
                currState =
                  nextState =
                    stateTree->complexBranchHeadTbl[i];
                for (; nextState;){
                    FreeActions(currState->actions);
                    currState->actions = NULL;
                    if (!currState->isCycleEnd)
                      nextState = currState->nextLevel;
                    else
                      nextState = NULL;
                    XtFree( (char*)currState );
                    currState = nextState;
                }
            }
            XtFree((char*)stateTree->complexBranchHeadTbl);
        }
        XtFree((char*)stateTree->branchHeadTbl);
        XtFree((char*)stateTree->quarkTbl);
        XtFree((char*)stateTree);
    }
}

static void 
_xim_tm_destroy_translations (translations)
XtTranslations      translations;
{
    register int        i;

    for (i = 0; i < (int)translations->numStateTrees; i++)
      _xim_tm_free_state_tree(translations->stateTreeTbl[i]);
    XtFree((char *)translations);
}

static void 
_xim_tm_free_current_state (binding_table)
    XtTM                binding_table;
{
    if (binding_table->current_state)
        FreeContext((TMContext *)&binding_table->current_state);
}

static void
_xim_tm_destroy_binding_table(binding_table, id)
    XtTM            binding_table;
    IMTMid	    id;
{

    /* Free Translation Table */
    _xim_tm_rm_translation(id);

    /* Free Current State, if exist */
    _xim_tm_free_current_state(binding_table);

    XtFree((char *) binding_table);
}

static int
_xim_tm_check_event_mask (eventType, eventMask)
    int         eventType;
    EventMask   eventMask;
{
    eventType &= 0x7f;  /* Events sent with XSendEvent have high bit set. */
    if (eventType < XtNumber(masks))
        return (masks[eventType] & eventMask) == masks[eventType] ? 1 : 0;
    else
        return 0;
}

static int
_xim_tm_binding(binding_table, action_table, num_action_table,
    event, reserve_event, result)
    XtTM            binding_table;
    CompiledActionTable action_table;
    int             num_action_table;
    XEvent         *event;
    ReserveEvent   *reserve_event;
    IMBindResult   *result;
{
    TMEventRec      curEvent;
    StatePtr        current_state = binding_table->current_state;
    int             ret;

    XEventToTMEvent(event, &curEvent);

    if (current_state == NULL)
        ret = HandleSimpleState(binding_table, &curEvent,
            action_table, num_action_table,
            &reserve_event->events, &reserve_event->n_events, result);
    else
        ret = HandleComplexState(binding_table, &curEvent,
            action_table, num_action_table,
            &reserve_event->events, &reserve_event->n_events, result);

    return ret;
}


/* Flag for TM activation. */
static Bool	XimIsTMactivate = False;

Bool
XimTMInitializeTM()
{
    if (XimIsTMactivate == False) {
	XtPerDisplay xpd = InitDisplay();

	_XtTranslateInitialize();

	if (xpd == NULL) {
	    fprintf(stderr, 
		"htt: Could not initialize the translation manager.\n");
            return False;
	}

	XimIsTMactivate = True;
    }

    return True;
}

void
XimTMDestroyTM()
{
    TMShortCard     i;

    if (XimIsTMactivate == False)
        return;

    /* Free Event Type Match Table */
    if (XimGlobalTM.typeMatchSegmentTbl) {
        for (i = 0; i < XimGlobalTM.numTypeMatchSegments; i++)
            XtFree((char *) XimGlobalTM.typeMatchSegmentTbl[i]);
        XtFree((char *) XimGlobalTM.typeMatchSegmentTbl);
    }
    /* Free Modifier Match Table */
    if (XimGlobalTM.modMatchSegmentTbl) {
        for (i = 0; i < XimGlobalTM.numModMatchSegments; i++)
            XtFree((char *) XimGlobalTM.modMatchSegmentTbl[i]);
        XtFree((char *) XimGlobalTM.modMatchSegmentTbl);
    }
}

IMBindTable
XimTMInitBindingTable()
{
    IMBindTable     bind_tbl;

    if (XimIsTMactivate == False)
        return NULL;

    /* Alloc Binding Table */
    bind_tbl = (IMBindTable) XimTMMalloc(sizeof(IMBindTableRec));

    /* Initialize the number of binding tables. */
    XtBZero(bind_tbl, sizeof(IMBindTableRec));

    return bind_tbl;
}

#define NUM_SLICED_TABLE   5

static IMTMid INC_TM_ID = 1; /* intial value is not 0. */

Bool
XimTMParseTranslation(bind_table, translation, return_tm_id)
    IMBindTable     bind_table;
    char           *translation;
    IMTMid         *return_tm_id;
{
    register int    i;

    if (XimIsTMactivate == False)
        return False;

    if (bind_table == NULL)
        return False;

    if (bind_table->num_binding_table == 0) {
        bind_table->binding_table =
            (XtTM *) XimTMMalloc(sizeof(XtTM) * NUM_SLICED_TABLE);
        bind_table->indicate_binding_table =
            (IMTMid *) XimTMMalloc(sizeof(IMTMid) * NUM_SLICED_TABLE);

        for (i = 0; i < NUM_SLICED_TABLE; i++)
            bind_table->binding_table[i] = NULL;
    } else if ((bind_table->num_binding_table % NUM_SLICED_TABLE) == 0) {
        int  num_array = bind_table->num_binding_table + NUM_SLICED_TABLE;

        bind_table->binding_table =
            (XtTM *) XimTMRealloc((char *) bind_table->binding_table,
            sizeof(XtTM) * num_array);
        bind_table->indicate_binding_table =
            (IMTMid *) XimTMRealloc((char *) bind_table->indicate_binding_table,
            sizeof(IMTMid) * num_array);

        for (i = bind_table->num_binding_table; i < num_array; i++) {
            bind_table->binding_table[i] = NULL;
            bind_table->indicate_binding_table[i] = 0;
        }
    }

    bind_table->binding_table[bind_table->num_binding_table]
        = _xim_tm_create_binding_table((char *)translation);

    bind_table->indicate_binding_table[bind_table->num_binding_table]
        = *return_tm_id = INC_TM_ID++;

    _xim_tm_set_translation(
	bind_table->binding_table[bind_table->num_binding_table]->translations,
	*return_tm_id);

    bind_table->num_binding_table++;

    return True;
}

Bool
XimTMParseIDTranslation(bind_table, tm_id, return_tm_id)
    IMBindTable     bind_table;
    IMTMid         tm_id;
    IMTMid         *return_tm_id;
{
    register int    i;
    XtTM new_tm;
    XtTranslations xt;

    if (XimIsTMactivate == False)
        return False;

    if (bind_table == NULL)
        return False;

    *return_tm_id = INC_TM_ID++;

    if((xt = _xim_tm_get_translation(tm_id, *return_tm_id))
	== NULL) {
	INC_TM_ID--;
	return False;
    }

    if (bind_table->num_binding_table == 0) {
        bind_table->binding_table =
            (XtTM *) XimTMMalloc(sizeof(XtTM) * NUM_SLICED_TABLE);
        bind_table->indicate_binding_table =
            (IMTMid *) XimTMMalloc(sizeof(IMTMid) * NUM_SLICED_TABLE);

        for (i = 0; i < NUM_SLICED_TABLE; i++)
            bind_table->binding_table[i] = NULL;
    } else if ((bind_table->num_binding_table % NUM_SLICED_TABLE) == 0) {
        int  num_array = bind_table->num_binding_table + NUM_SLICED_TABLE;

        bind_table->binding_table =
            (XtTM *) XimTMRealloc((char *) bind_table->binding_table,
            sizeof(XtTM) * num_array);
        bind_table->indicate_binding_table =
            (IMTMid *) XimTMRealloc((char *) bind_table->indicate_binding_table,
            sizeof(IMTMid) * num_array);

        for (i = bind_table->num_binding_table; i < num_array; i++) {
            bind_table->binding_table[i] = NULL;
            bind_table->indicate_binding_table[i] = 0;
        }
    }

    new_tm = (XtTM) XimTMMalloc(sizeof(XtTMRec));
    XtBZero(new_tm, sizeof(XtTMRec));

    new_tm->translations = xt;

    bind_table->binding_table[bind_table->num_binding_table] = new_tm;

    bind_table->indicate_binding_table[bind_table->num_binding_table] =
	*return_tm_id;

    bind_table->num_binding_table++;

    return True;
}

void
XimTMDestroyTranslation(bind_table, tm_id)
    IMBindTable     bind_table;
    IMTMid          tm_id;
{
    register int    i;

    if (XimIsTMactivate == False)
        return;

    if (bind_table == NULL)
        return;

    if (bind_table->num_binding_table > 0) {
        for (i = 0; i < bind_table->num_binding_table; i++) {
            if (bind_table->indicate_binding_table[i] == tm_id) {
		_xim_tm_rm_translation(tm_id);
		bind_table->binding_table[i]->translations = NULL;
	    }
        }
    }
}

void
XimTMDestroyBindingTable(bind_table, destroy_translations)
    IMBindTable     bind_table;
    Bool	    destroy_translations;
{
    register int    i;

    if (XimIsTMactivate == False)
        return;

    if (bind_table == NULL)
        return;

    /* Free All Binding Table */
    if(destroy_translations == True) {
	for (i = 0; i < bind_table->num_binding_table; i++) {
	    if (bind_table->binding_table[i] == NULL)
		continue;
	    _xim_tm_destroy_binding_table(bind_table->binding_table[i],
	    bind_table->indicate_binding_table[i]);
	}
    }

    /* Free Reserve Event */
    if (bind_table->reserve_event.n_events)
        XtFree((char *)bind_table->reserve_event.events);

    XtFree((char *) bind_table);
}

IMActionTable
XimTMAddActionsTable(actions, num_actions)
    IMActionsList   actions;
    int             num_actions;
{
    IMActionTable   action_tbl;
    register CompiledActionTable cActions;
    register int    i;
    CompiledAction  hold;
    CompiledActionTable cTableHold;

    if (XimIsTMactivate == False)
        return NULL;

    if (num_actions <= 0)
        return NULL;

    /* Alloc Action Table */
    action_tbl = (IMActionTable) XimTMMalloc(sizeof(IMActionTableRec));

    cTableHold = cActions = (CompiledActionTable)
        XimTMMalloc(num_actions * sizeof(CompiledAction));

    for (i = num_actions; --i >= 0; cActions++, actions++) {
        cActions->proc = actions->proc;
        cActions->signature = XrmStringToQuark(actions->string);
    }
    cActions = cTableHold;

    for (i = 1; i <= num_actions - 1; i++) {
        register int    j;

        hold = cActions[i];
        j = i;
        while (j && cActions[j - 1].signature > hold.signature) {
            cActions[j] = cActions[j - 1];
            j--;
        }
        cActions[j] = hold;
    }

    action_tbl->action_table = cActions;
    action_tbl->num_actions = num_actions;

    return action_tbl;
}

void
XimTMDestroyActionsTable(action_table)
    IMActionTable     action_table;
{
    if (XimIsTMactivate == False)
        return;

    if(action_table && action_table->action_table)
        XtFree((char *)action_table->action_table);

    XtFree((char *)action_table);
}

int
XimTMLookupBinding(event, bind_table, action_table, tm_id, bind_result)
    XEvent         *event;
    IMBindTable     bind_table;
    IMActionTable   action_table;
    IMTMid          tm_id;
    IMBindResult   *bind_result;
{
    XtTM            tm = NULL;
    register int    i;

    if (XimIsTMactivate == False)
        return IMBindFailed;

    if (!bind_table)
        return IMBindFailed;

    if (bind_table->num_binding_table > 0) {
        for (i = 0; i < bind_table->num_binding_table; i++)
            if (bind_table->indicate_binding_table[i] == tm_id)
                break;

        if ((tm = bind_table->binding_table[i]) == NULL)
            return IMBindFailed;
    } else
            return IMBindFailed;

    /* Check Event Mask */
    if (!(_xim_tm_check_event_mask(event->type, tm->translations->eventMask)))
        return IMBindFailed;

    /* Bind Event */
    return _xim_tm_binding(tm,
        action_table->action_table, action_table->num_actions,
        event, &bind_table->reserve_event, bind_result);
}

void
XimTMDestroyBindResult(bind_result)
    IMBindResult   *bind_result;
{
    register int        i, j;
    IMBindResult        res_buf;

    if (XimIsTMactivate == False)
        return;

    if (*bind_result == NULL)
        return;

    res_buf = *bind_result;

    while (res_buf) {
        IMBindResult    res_wrk;
        IMActionList    action_buf = res_buf->actions;

        if (action_buf) { 
            for (i = 0; i < res_buf->num_actions; i++) {
                if (action_buf[i].params) {
                    for (j = 0;
                        j < action_buf[i].num_params; j++) {
                        if (action_buf[i].params[j])
                            XtFree((char *)action_buf[i].params[j]);
                    }
                }
            }
            XtFree ((char *)action_buf);
        }

        if (res_buf->events)
                XtFree ((char *)res_buf->events);

        res_wrk = res_buf->next;
        XtFree ((char *)res_buf);
        res_buf = res_wrk;
    }

    *bind_result = NULL;
}

void
XimTMResetBinding(bind_table, tm_id)
    IMBindTable bind_table;
    IMTMid      tm_id;
{
    register int    i;

    if (XimIsTMactivate == False)
        return;

    if (bind_table == NULL)
        return;

    if (bind_table->num_binding_table > 0) {
        for (i = 0; i < bind_table->num_binding_table; i++) {
            if (bind_table->indicate_binding_table[i] == tm_id)
                _xim_tm_free_current_state(bind_table->binding_table[i]);
        }
    }
}

#ifdef STANDALONE

/* TM_PERF */
float start, end;

#ifdef TM_PERF
#include <sys/time.h>

float
puttime(head)
char *head;
{
        static struct timeval tpbase;
        struct timeval  tp;
        struct timezone tzp;

        float           t;
        long            usec, sec;

        if (head == (char *) NULL) {
                gettimeofday(&tpbase, &tzp);
                return (float)0;
        }
        gettimeofday(&tp, &tzp);

        usec = tp.tv_usec - tpbase.tv_usec;
        sec = tp.tv_sec - tpbase.tv_sec;

        t = (float) (sec * 1000000 + usec) / 1000000.;

        return t;
}

print_time(str, start, end)
char *str;
float start, end;
{
    if(str == NULL)
	return;

    printf("%s %f\n", str, (end - start));
}

#else

float
puttime(head)
char *head;
{
    return;
}

print_time(str, start, end)
char *str;
float start, end;
{
    return;
}

#endif /* TM_PERF */

#if 0
#define NUM_TRANSLATION	6
#define DEF_TRANSLATION	2
#else
#define NUM_TRANSLATION	1
#define DEF_TRANSLATION	0
#endif

/* For testing. */
main()
{
    static void test_process_event();
    static IMActionProc test_action();

    IMBindTable binding_table = NULL, new_binding_table = NULL;
    IMTMid tm_id[NUM_TRANSLATION], return_tm_id[NUM_TRANSLATION];

    /* It is from atok. */
#if 0
    static char *translation[NUM_TRANSLATION] = {
	/* *xci*atok7.bind.preedit.init */
	"\
        Ctrl<Key>space:                         CNV_SWITCH()\n\
        Ctrl<Key>at:                            CNV_SWITCH()\n\
        <Key>Henkan_Mode:                       CNV_SWITCH()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Kanji:         ATOK_KEY_XFER()\n\
        ~Shift~Ctrl~Alt~Meta<Key>space:         ATOK_KEY_SPACE()\n\
        :Ctrl~Shift~Alt~Meta<Key>Prior:         IM_KANJI()\n\
        :Ctrl~Shift~Alt~Meta<Key>R9:            IM_KANJI()\n\
        :Ctrl~Shift~Alt~Meta<Key>Next:          IM_HANKAKU()\n\
        :Ctrl~Shift~Alt~Meta<Key>R15:           IM_HANKAKU()\n\
        Ctrl~Shift~Alt~Meta<Key>BackSpace:      ATOK_COMMIT_UNDO()\n\
        ~Shift~Ctrl~Alt~Meta<Key>F10:           IM_SWITCH()\n\
        ~Shift~Ctrl~Alt~Meta<Key>SunF36:        ATOK_XIM_EIJI_SWITCH()\n\
        Shift~Ctrl~Alt~Meta<Key>F6:             UPDATE_DICT()\n\
        Shift~Ctrl~Alt~Meta<Key>F8:             MENU_DICT()\n\
        Shift~Ctrl~Alt~Meta<Key>F9:             MENU_XIM()\n\
        Shift~Ctrl~Alt~Meta<Key>F10:            ATOK_MENU_IMENV()\n\
        :<Key>KP_Subtract:                      ATOK_KP_SUBTRACT()\n\
        :<Key>KP_Divide:                        ATOK_KP_DIVIDE()\n\
        :<Key>KP_Decimal:                       ATOK_KP_DECIMAL()\n",

	/* *xci*atok7.bind.aux.preedit.init */
	"\
        Ctrl<Key>space:                         CNV_SWITCH()\n\
        Ctrl<Key>at:                            CNV_SWITCH()\n\
        <Key>Henkan_Mode:                       CNV_SWITCH()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Kanji:         ATOK_KEY_XFER()\n\
        :Ctrl~Shift~Alt~Meta<Key>Prior:         IM_KANJI()\n\
        :Ctrl~Shift~Alt~Meta<Key>R9:            IM_KANJI()\n\
        :Ctrl~Shift~Alt~Meta<Key>Next:          IM_HANKAKU()\n\
        :Ctrl~Shift~Alt~Meta<Key>R15:           IM_HANKAKU()\n\
        ~Shift~Ctrl~Alt~Meta<Key>F10:           IM_SWITCH()\n\
        Shift~Ctrl~Alt~Meta<Key>F6:             UPDATE_DICT()\n\
        Shift~Ctrl~Alt~Meta<Key>F7:             CODE_SWITCH()\n",

	/* *xci*atok7.bind*preedit.edit */
	"\
	Ctrl<Key>space:				CNV_SWITCH()\n\
	Ctrl<Key>at:				CNV_SWITCH()\n\
	<Key>Henkan_Mode:			CNV_SWITCH()\n\
	~Shift~Ctrl~Alt~Meta<Key>Kanji:		ATOK_KEY_XFER()\n\
	Shift~Ctrl~Alt~Meta<Key>Kanji:		ATOK_KEY_SHIFT_XFER()\n\
	~Shift~Ctrl~Alt~Meta<Key>space:		ATOK_KEY_SPACE()\n\
	Shift~Ctrl~Alt~Meta<Key>space:		ATOK_KEY_SHIFT_SPACE()\n\
	Alt~Shift~Ctrl~Meta<Key>space:		ATOK_CNV_BUSYU()\n\
	~Shift~Ctrl~Alt~Meta<Key>Return:	ATOK_KEY_RETURN()\n\
	~Shift~Ctrl~Alt~Meta<Key>KP_Enter:	ATOK_KEY_RETURN()\n\
	~Shift~Ctrl~Alt~Meta<Key>Execute:	ATOK_KEY_RETURN()\n\
	Ctrl~Shift~Alt~Meta<Key>m:		ATOK_KEY_RETURN()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_MO:	ATOK_KEY_RETURN()\n\
	~Shift~Ctrl~Alt~Meta<Key>Escape:	ATOK_KEY_ESC()\n\
	Ctrl~Shift~Alt~Meta<Key>bracketleft:	ATOK_KEY_ESC()\n\
	Ctrl~Shift~Alt~Meta<Key>semivoicedsound:	ATOK_KEY_ESC()\n\
	Shift~Ctrl~Alt~Meta<Key>Escape:		ATOK_MENU_PREV()\n\
	~Shift~Ctrl~Alt~Meta<Key>BackSpace:	ERASE_LCHAR()\n\
	Ctrl~Shift~Alt~Meta<Key>h:		ERASE_LCHAR()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_KU:	ERASE_LCHAR()\n\
	Shift~Ctrl~Alt~Meta<Key>BackSpace:	ATOK_ERASE_ALL_FILENAME()\n\
	Ctrl~Shift~Alt~Meta<Key>BackSpace:	ATOK_COMMIT_UNDO()\n\
	:~Shift~Ctrl~Alt~Meta<Key>Delete:	ERASE_CHAR()\n\
	:~Shift~Ctrl~Alt~Meta<Key>Insert:	ATOK_AUTOCNV_CANCEL()\n\
	~Shift~Ctrl~Alt~Meta<Key>Tab:		ATOK_KEY_TAB()\n\
	Shift~Ctrl~Alt~Meta<Key>Tab:		ATOK_KEY_SHIFT_TAB()\n\
	:Shift~Ctrl~Alt~Meta<Key>Home:		ATOK_GAIJI_TOP()\n\
	Shift~Ctrl~Alt~Meta<Key>R7:		ATOK_GAIJI_TOP()\n\
	:~Shift~Ctrl~Alt~Meta<Key>Home:		ATOK_KIGOU_TOP()\n\
	:~Shift~Ctrl~Alt~Meta<Key>R7:		ATOK_KIGOU_TOP()\n\
	:Ctrl~Shift~Alt~Meta<Key>Right:		CURSOR_TAIL()\n\
	:Ctrl~Shift~Alt~Meta<Key>Left:		CURSOR_HEAD()\n\
	:~Shift~Ctrl~Alt~Meta<Key>Right:	CURSOR_RIGHT()\n\
	Ctrl~Shift~Alt~Meta<Key>l:		CURSOR_RIGHT()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_RI:	CURSOR_RIGHT()\n\
	:~Shift~Ctrl~Alt~Meta<Key>Left:		CURSOR_LEFT()\n\
	Ctrl~Shift~Alt~Meta<Key>k:		CURSOR_LEFT()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_NO:	CURSOR_LEFT()\n\
	:Shift~Ctrl~Alt~Meta<Key>Down:		ATOK_COMMIT_ONE()\n\
	:~Ctrl~Alt~Meta<Key>R14:		ATOK_COMMIT_ONE()\n\
	:~Shift~Ctrl~Alt~Meta<Key>Up:		ATOK_KEY_UP()\n\
	Ctrl~Shift~Alt~Meta<Key>n:		ATOK_KEY_DOWN()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_MI:	ATOK_KEY_DOWN()\n\
	:~Shift~Ctrl~Alt~Meta<Key>Down:		ATOK_KEY_DOWN()\n\
	:Ctrl~Shift~Alt~Meta<Key>Prior:		IM_KANJI()\n\
	:Ctrl~Shift~Alt~Meta<Key>R9:		IM_KANJI()\n\
	:Ctrl~Shift~Alt~Meta<Key>Next:		IM_HANKAKU()\n\
	:Ctrl~Shift~Alt~Meta<Key>R15:		IM_HANKAKU()\n\
	:~Shift~Ctrl~Alt~Meta<Key>Next:		ATOK_PAGE_NEXT()\n\
	:~Shift~Ctrl~Alt~Meta<Key>R15:		ATOK_PAGE_NEXT()\n\
	:~Shift~Ctrl~Alt~Meta<Key>Prior:	ATOK_PAGE_PREV()\n\
	:~Shift~Ctrl~Alt~Meta<Key>R9:		ATOK_PAGE_PREV()\n\
	~Shift~Ctrl~Alt~Meta<Key>F6:		TO_HIRAGANA()\n\
	Ctrl~Shift~Alt~Meta<Key>u:		TO_HIRAGANA()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_NA:	TO_HIRAGANA()\n\
	~Shift~Ctrl~Alt~Meta<Key>F7:		TO_ZENKANA()\n\
	Ctrl~Shift~Alt~Meta<Key>i:		TO_ZENKANA()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_NI:	TO_ZENKANA()\n\
	~Shift~Ctrl~Alt~Meta<Key>F8:		TO_HANKAKU()\n\
	Ctrl~Shift~Alt~Meta<Key>o:		TO_HANKAKU()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_RA:	TO_HANKAKU()\n\
	~Shift~Ctrl~Alt~Meta<Key>F9:		ATOK_TO_MUHENKAN()\n\
	Ctrl~Shift~Alt~Meta<Key>p:		ATOK_TO_MUHENKAN()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_SE:	ATOK_TO_MUHENKAN()\n\
	~Shift~Ctrl~Alt~Meta<Key>F10:		IM_SWITCH()\n\
	~Shift~Ctrl~Alt~Meta<Key>SunF36:	ATOK_XIM_EIJI_SWITCH()\n\
	Shift~Ctrl~Alt~Meta<Key>F6:		UPDATE_DICT()\n\
	Shift~Ctrl~Alt~Meta<Key>F7:		CODE_SWITCH()\n\
	Shift~Ctrl~Alt~Meta<Key>F9:		MENU_XIM()\n\
	Shift~Ctrl~Alt~Meta<Key>F10:		ATOK_MENU_IMENV()\n\
	Ctrl~Shift~Alt~Meta<Key>w:		SENTAKU()\n\
	Ctrl~Shift~Alt~Meta<Key>kana_TE:	SENTAKU()\n\
	:<Key>KP_Subtract:			ATOK_KP_SUBTRACT()\n\
	:<Key>KP_Divide:			ATOK_KP_DIVIDE()\n\
	:<Key>KP_Decimal:			ATOK_KP_DECIMAL()\n\
	:<Key>Home:				ATOK_NOP()\n\
	:<Key>R7:				ATOK_NOP()\n\
	:<Key>End:				ATOK_NOP()\n\
	:<Key>R13:				ATOK_NOP()\n\
	:<Key>Up:				ATOK_NOP()\n\
	:<Key>R8:				ATOK_NOP()\n\
	:<Key>Left:				ATOK_NOP()\n\
	:<Key>R10:				ATOK_NOP()\n\
	:<Key>Right:				ATOK_NOP()\n\
	:<Key>R12:				ATOK_NOP()\n\
	:<Key>Down:				ATOK_NOP()\n\
	:<Key>R14:				ATOK_NOP()\n\
	:<Key>R11:				ATOK_NOP()\n",

	/* *xci*atok7.bind*preedit.conv */
	"\
        Ctrl<Key>space:                         CNV_SWITCH()\n\
        Ctrl<Key>at:                            CNV_SWITCH()\n\
        <Key>Henkan_Mode:                       CNV_SWITCH()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Kanji:         ATOK_KEY_XFER()\n\
        Shift~Ctrl~Alt~Meta<Key>Kanji:          ATOK_KEY_SHIFT_XFER()\n\
        Shift~Ctrl~Alt~Meta<Key>space:          ATOK_KEY_SHIFT_SPACE()\n\
        ~Shift~Ctrl~Alt~Meta<Key>space:         ATOK_KEY_SPACE()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Return:        ATOK_KEY_RETURN()\n\
        ~Shift~Ctrl~Alt~Meta<Key>KP_Enter:      ATOK_KEY_RETURN()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Execute:       ATOK_KEY_RETURN()\n\
        Ctrl~Shift~Alt~Meta<Key>m:              ATOK_KEY_RETURN()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_MO:        ATOK_KEY_RETURN()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Escape:        ATOK_KEY_ESC()\n\
        Ctrl~Shift~Alt~Meta<Key>bracketleft:    ATOK_KEY_ESC()\n\
        Ctrl~Shift~Alt~Meta<Key>semivoicedsound:        ATOK_KEY_ESC()\n\
        ~Shift~Ctrl~Alt~Meta<Key>BackSpace:     HENKAN_CANCEL()\n\
        Ctrl~Shift~Alt~Meta<Key>h:              HENKAN_CANCEL()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_KU:        HENKAN_CANCEL()\n\
        Ctrl~Shift~Alt~Meta<Key>BackSpace:      ATOK_COMMIT_UNDO()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Insert:       ATOK_AUTOCNV_CANCEL()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Right:        FOCUS_NLONG()\n\
        Ctrl~Shift~Alt~Meta<Key>l:              FOCUS_NLONG()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_RI:        FOCUS_NLONG()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Left:         FOCUS_NSHORT()\n\
        Ctrl~Shift~Alt~Meta<Key>k:              FOCUS_NSHORT()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_NO:        FOCUS_NSHORT()\n\
        :Shift~Ctrl~Alt~Meta<Key>Down:          ATOK_COMMIT_ONE()\n\
        :~Ctrl~Alt~Meta<Key>R14:                ATOK_COMMIT_ONE()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Up:           ATOK_KEY_UP()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Down:         ATOK_KEY_DOWN()\n\
        Ctrl~Shift~Alt~Meta<Key>n:              ATOK_KEY_DOWN()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_MI:        ATOK_KEY_DOWN()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Next:         ATOK_PAGE_NEXT()\n\
        :~Shift~Ctrl~Alt~Meta<Key>R15:          ATOK_PAGE_NEXT()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Prior:        ATOK_PAGE_PREV()\n\
        :~Shift~Ctrl~Alt~Meta<Key>R9:           ATOK_PAGE_PREV()\n\
        ~Shift~Ctrl~Alt~Meta<Key>F6:            TO_HIRAGANA()\n\
        Ctrl~Shift~Alt~Meta<Key>u:              TO_HIRAGANA()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_NA:        TO_HIRAGANA()\n\
        ~Shift~Ctrl~Alt~Meta<Key>F7:            TO_ZENKANA()\n\
        Ctrl~Shift~Alt~Meta<Key>i:              TO_ZENKANA()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_NI:        TO_ZENKANA()\n\
        ~Shift~Ctrl~Alt~Meta<Key>F8:            TO_HANKAKU()\n\
        Ctrl~Shift~Alt~Meta<Key>o:              TO_HANKAKU()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_RA:        TO_HANKAKU()\n\
        ~Shift~Ctrl~Alt~Meta<Key>F9:            ATOK_TO_MUHENKAN()\n\
        Ctrl~Shift~Alt~Meta<Key>p:              ATOK_TO_MUHENKAN()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_SE:        ATOK_TO_MUHENKAN()\n\
        ~Shift~Ctrl~Alt~Meta<Key>F10:           IM_SWITCH()\n\
        ~Shift~Ctrl~Alt~Meta<Key>SunF36:        ATOK_XIM_EIJI_SWITCH()\n\
        Shift~Ctrl~Alt~Meta<Key>F9:             MENU_XIM()\n\
        Shift~Ctrl~Alt~Meta<Key>F10:            ATOK_MENU_IMENV()\n\
        Ctrl~Shift~Alt~Meta<Key>w:              SENTAKU()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_TE:        SENTAKU()\n\
        :<Key>KP_Subtract:                      ATOK_KP_SUBTRACT()\n\
        :<Key>KP_Divide:                        ATOK_KP_DIVIDE()\n\
        :<Key>KP_Decimal:                       ATOK_KP_DECIMAL()\n\
        :<Key>Home:                             ATOK_NOP()\n\
        :<Key>R7:                               ATOK_NOP()\n\
        :<Key>End:                              ATOK_NOP()\n\
        :<Key>R13:                              ATOK_NOP()\n\
        :<Key>Up:                               ATOK_NOP()\n\
        :<Key>R8:                               ATOK_NOP()\n\
        :<Key>Left:                             ATOK_NOP()\n\
        :<Key>R10:                              ATOK_NOP()\n\
        :<Key>Right:                            ATOK_NOP()\n\
        :<Key>R12:                              ATOK_NOP()\n\
        :<Key>Down:                             ATOK_NOP()\n\
        :<Key>R14:                              ATOK_NOP()\n\
        :<Key>R11:                              ATOK_NOP()\n",

	/* *xci*atok7.bind*lookup.init */
	"\
        Ctrl<Key>space:                         CNV_SWITCH()\n\
        Ctrl<Key>at:                            CNV_SWITCH()\n\
        <Key>Henkan_Mode:                       CNV_SWITCH()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Kanji:         SELECT_NEXT()\n\
        Shift~Ctrl~Alt~Meta<Key>Kanji:          SELECT_PREV()\n\
        ~Shift~Ctrl~Alt~Meta<Key>space:         SELECT_RIGHT()\n\
        Shift~Ctrl~Alt~Meta<Key>space:          SELECT_LEFT()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Return:        SELECT_DONE()\n\
        ~Shift~Ctrl~Alt~Meta<Key>KP_Enter:      SELECT_DONE()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Execute:       SELECT_DONE()\n\
        Ctrl~Shift~Alt~Meta<Key>m:              SELECT_DONE()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_MO:        SELECT_DONE()\n\
        Ctrl~Shift~Alt~Meta<Key>bracketleft:    SELECT_UNDO()\n\
        Ctrl~Shift~Alt~Meta<Key>semivoicedsound:        SELECT_UNDO()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Escape:        SELECT_UNDO()\n\
        Shift~Ctrl~Alt~Meta<Key>Escape:         ATOK_MENU_PREV()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Tab:           ATOK_KEY_TAB()\n\
        Shift~Ctrl~Alt~Meta<Key>Tab:            ATOK_KEY_SHIFT_TAB()\n\
        :Shift~Ctrl~Alt~Meta<Key>Home:          ATOK_GAIJI_TOP()\n\
        Shift~Ctrl~Alt~Meta<Key>R7:             ATOK_GAIJI_TOP()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Home:         ATOK_KIGOU_TOP()\n\
        :~Shift~Ctrl~Alt~Meta<Key>R7:           ATOK_KIGOU_TOP()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Right:        SELECT_RIGHT()\n\
        Ctrl~Shift~Alt~Meta<Key>l:              SELECT_RIGHT()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_RI:        SELECT_RIGHT()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Left:         SELECT_LEFT()\n\
        Ctrl~Shift~Alt~Meta<Key>k:              SELECT_LEFT()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_NO:        SELECT_LEFT()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Up:           SELECT_UP()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Down:         SELECT_DOWN()\n\
        ~Shift~Ctrl~Alt~Meta<Key>F10:           IM_SWITCH()\n\
        Shift~Ctrl~Alt~Meta<Key>F6:             UPDATE_DICT()\n\
        Shift~Ctrl~Alt~Meta<Key>F7:             CODE_SWITCH()\n\
        Shift~Ctrl~Alt~Meta<Key>F9:             MENU_XIM()\n\
        Shift~Ctrl~Alt~Meta<Key>F10:            ATOK_MENU_IMENV()\n\
        :Ctrl~Shift~Alt~Meta<Key>Prior:         IM_KANJI()\n\
        :Ctrl~Shift~Alt~Meta<Key>R9:            IM_KANJI()\n\
        :Ctrl~Shift~Alt~Meta<Key>Next:          IM_HANKAKU()\n\
        :Ctrl~Shift~Alt~Meta<Key>R15:           IM_HANKAKU()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Prior:        SELECT_PREV()\n\
        :~Shift~Ctrl~Alt~Meta<Key>R9:           SELECT_PREV()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Next:         SELECT_NEXT()\n\
        :~Shift~Ctrl~Alt~Meta<Key>R15:          SELECT_NEXT()\n\
        :<Key>KP_Subtract:                      ATOK_KP_SUBTRACT()\n\
        :<Key>KP_Divide:                        ATOK_KP_DIVIDE()\n\
        :<Key>KP_Decimal:                       ATOK_KP_DECIMAL()\n\
        :<Key>Home:                             ATOK_NOP()\n\
        :<Key>R7:                               ATOK_NOP()\n\
        :<Key>End:                              ATOK_NOP()\n\
        :<Key>R13:                              ATOK_NOP()\n\
        :<Key>Up:                               ATOK_NOP()\n\
        :<Key>R8:                               ATOK_NOP()\n\
        :<Key>Left:                             ATOK_NOP()\n\
        :<Key>R10:                              ATOK_NOP()\n\
        :<Key>Right:                            ATOK_NOP()\n\
        :<Key>R12:                              ATOK_NOP()\n\
        :<Key>Down:                             ATOK_NOP()\n\
        :<Key>R14:                              ATOK_NOP()\n\
        :<Key>R11:                              ATOK_NOP()\n",

	/* *xci*atok7.bind*lookup.choice */
	"\
        Ctrl<Key>space:                         CNV_SWITCH()\n\
        Ctrl<Key>at:                            CNV_SWITCH()\n\
        <Key>Henkan_Mode:                       CNV_SWITCH()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Kanji:         SELECT_NEXT()\n\
        Shift~Ctrl~Alt~Meta<Key>Kanji:          SELECT_PREV()\n\
        ~Shift~Ctrl~Alt~Meta<Key>space:         SELECT_RIGHT()\n\
        Shift~Ctrl~Alt~Meta<Key>space:          SELECT_LEFT()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Return:        SELECT_DONE()\n\
        ~Shift~Ctrl~Alt~Meta<Key>KP_Enter:      SELECT_DONE()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Execute:       SELECT_DONE()\n\
        Ctrl~Shift~Alt~Meta<Key>m:              SELECT_DONE()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_MO:        SELECT_DONE()\n\
        Ctrl~Shift~Alt~Meta<Key>bracketleft:    SELECT_UNDO()\n\
        Ctrl~Shift~Alt~Meta<Key>semivoicedsound:        SELECT_UNDO()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Escape:        SELECT_UNDO()\n\
        Shift~Ctrl~Alt~Meta<Key>Escape:         ATOK_MENU_PREV()\n\
        ~Shift~Ctrl~Alt~Meta<Key>Tab:           ATOK_KEY_TAB()\n\
        Shift~Ctrl~Alt~Meta<Key>Tab:            ATOK_KEY_SHIFT_TAB()\n\
        :Shift~Ctrl~Alt~Meta<Key>Home:          ATOK_GAIJI_TOP()\n\
        Shift~Ctrl~Alt~Meta<Key>R7:             ATOK_GAIJI_TOP()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Home:         ATOK_KIGOU_TOP()\n\
        :~Shift~Ctrl~Alt~Meta<Key>R7:           ATOK_KIGOU_TOP()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Right:        SELECT_RIGHT()\n\
        Ctrl~Shift~Alt~Meta<Key>l:              SELECT_RIGHT()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_RI:        SELECT_RIGHT()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Left:         SELECT_LEFT()\n\
        Ctrl~Shift~Alt~Meta<Key>k:              SELECT_LEFT()\n\
        Ctrl~Shift~Alt~Meta<Key>kana_NO:        SELECT_LEFT()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Up:           SELECT_UP()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Down:         SELECT_DOWN()\n\
        ~Shift~Ctrl~Alt~Meta<Key>F10:           IM_SWITCH()\n\
        Shift~Ctrl~Alt~Meta<Key>F6:             UPDATE_DICT()\n\
        Shift~Ctrl~Alt~Meta<Key>F7:             CODE_SWITCH()\n\
        Shift~Ctrl~Alt~Meta<Key>F9:             MENU_XIM()\n\
        Shift~Ctrl~Alt~Meta<Key>F10:            ATOK_MENU_IMENV()\n\
        :Ctrl~Shift~Alt~Meta<Key>Prior:         IM_KANJI()\n\
        :Ctrl~Shift~Alt~Meta<Key>R9:            IM_KANJI()\n\
        :Ctrl~Shift~Alt~Meta<Key>Next:          IM_HANKAKU()\n\
        :Ctrl~Shift~Alt~Meta<Key>R15:           IM_HANKAKU()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Prior:        SELECT_PREV()\n\
        :~Shift~Ctrl~Alt~Meta<Key>R9:           SELECT_PREV()\n\
        :~Shift~Ctrl~Alt~Meta<Key>Next:         SELECT_NEXT()\n\
        :~Shift~Ctrl~Alt~Meta<Key>R15:          SELECT_NEXT()\n\
        :<Key>KP_Subtract:                      ATOK_KP_SUBTRACT()\n\
        :<Key>KP_Divide:                        ATOK_KP_DIVIDE()\n\
        :<Key>KP_Decimal:                       ATOK_KP_DECIMAL()\n\
        :<Key>Home:                             ATOK_NOP()\n\
        :<Key>R7:                               ATOK_NOP()\n\
        :<Key>End:                              ATOK_NOP()\n\
        :<Key>R13:                              ATOK_NOP()\n\
        :<Key>Up:                               ATOK_NOP()\n\
        :<Key>R8:                               ATOK_NOP()\n\
        :<Key>Left:                             ATOK_NOP()\n\
        :<Key>R10:                              ATOK_NOP()\n\
        :<Key>Right:                            ATOK_NOP()\n\
        :<Key>R12:                              ATOK_NOP()\n\
        :<Key>Down:                             ATOK_NOP()\n\
        :<Key>R14:                              ATOK_NOP()\n\
        :<Key>R11:                              ATOK_NOP()\n",

	};

    static IMActionsRec test_actions[] = {
	{(char *)"CNV_SWITCH",		(IMActionProc)test_action},
	{(char *)"ATOK_KEY_XFER",	(IMActionProc)test_action},
	{(char *)"ATOK_KEY_SHIFT_XFER",	(IMActionProc)test_action},
	{(char *)"ATOK_KEY_SPACE",	(IMActionProc)test_action},
	{(char *)"ATOK_KEY_SHIFT_SPACE",(IMActionProc)test_action},
	{(char *)"ATOK_CNV_BUSYU",	(IMActionProc)test_action},
	{(char *)"ATOK_KEY_RETURN",	(IMActionProc)test_action},
	{(char *)"ATOK_KEY_ESC",	(IMActionProc)test_action},
	{(char *)"ATOK_MENU_PREV",	(IMActionProc)test_action},
	{(char *)"ERASE_LCHAR",		(IMActionProc)test_action},
	{(char *)"ATOK_ERASE_ALL_FILENAME",(IMActionProc)test_action},
	{(char *)"ATOK_COMMIT_UNDO",	(IMActionProc)test_action},
	{(char *)"ERASE_CHAR",		(IMActionProc)test_action},
	{(char *)"ATOK_AUTOCNV_CANCEL",	(IMActionProc)test_action},
	{(char *)"ATOK_KEY_TAB",	(IMActionProc)test_action},
	{(char *)"ATOK_KEY_SHIFT_TAB",	(IMActionProc)test_action},
	{(char *)"ATOK_GAIJI_TOP",	(IMActionProc)test_action},
	{(char *)"ATOK_KIGOU_TOP",	(IMActionProc)test_action},
	{(char *)"CURSOR_TAIL",		(IMActionProc)test_action},
	{(char *)"CURSOR_HEAD",		(IMActionProc)test_action},
	{(char *)"CURSOR_RIGHT",	(IMActionProc)test_action},
	{(char *)"CURSOR_LEFT",		(IMActionProc)test_action},
	{(char *)"ATOK_COMMIT_ONE",	(IMActionProc)test_action},
	{(char *)"ATOK_KEY_UP",		(IMActionProc)test_action},
	{(char *)"ATOK_KEY_DOWN",	(IMActionProc)test_action},
	{(char *)"IM_KANJI",		(IMActionProc)test_action},
	{(char *)"IM_HANKAKU",		(IMActionProc)test_action},
	{(char *)"ATOK_PAGE_NEXT",	(IMActionProc)test_action},
	{(char *)"ATOK_PAGE_PREV",	(IMActionProc)test_action},
	{(char *)"TO_HIRAGANA",		(IMActionProc)test_action},
	{(char *)"TO_ZENKANA",		(IMActionProc)test_action},
	{(char *)"TO_HANKAKU",		(IMActionProc)test_action},
	{(char *)"ATOK_TO_MUHENKAN",	(IMActionProc)test_action},
	{(char *)"IM_SWITCH",		(IMActionProc)test_action},
	{(char *)"ATOK_XIM_EIJI_SWITCH",(IMActionProc)test_action},
	{(char *)"UPDATE_DICT",		(IMActionProc)test_action},
	{(char *)"CODE_SWITCH",		(IMActionProc)test_action},
	{(char *)"MENU_DICT",		(IMActionProc)test_action},
	{(char *)"MENU_XIM",		(IMActionProc)test_action},
	{(char *)"ATOK_MENU_IMENV",	(IMActionProc)test_action},
	{(char *)"SENTAKU",		(IMActionProc)test_action},
	{(char *)"ATOK_KP_SUBTRACT",	(IMActionProc)test_action},
	{(char *)"ATOK_KP_DIVIDE",	(IMActionProc)test_action},
	{(char *)"ATOK_KP_DECIMAL",	(IMActionProc)test_action},
	{(char *)"ATOK_NOP",		(IMActionProc)test_action},
	{(char *)"HENKAN_CANCEL",	(IMActionProc)test_action},
	{(char *)"FOCUS_NLONG",		(IMActionProc)test_action},
	{(char *)"FOCUS_NSHORT",	(IMActionProc)test_action},
	{(char *)"ATOK_COMMIT_ONE",	(IMActionProc)test_action},
	{(char *)"SELECT_NEXT",		(IMActionProc)test_action},
	{(char *)"SELECT_PREV",		(IMActionProc)test_action},
	{(char *)"SELECT_RIGHT",	(IMActionProc)test_action},
	{(char *)"SELECT_LEFT",		(IMActionProc)test_action},
	{(char *)"SELECT_DONE",		(IMActionProc)test_action},
	{(char *)"SELECT_UNDO",		(IMActionProc)test_action},
    };

#else
    static char *translation[1] = {
	"\
	<Key>a, <Key>b:	tako()\n\
	<Key>a, <Key>b, <Key>c:	saru()\n\
	<Key>b, <Key>c:	ika()\n"};
    static IMActionsRec test_actions[] = {
	{(char *)"tako",          (IMActionProc)test_action},
	{(char *)"ika",       (IMActionProc)test_action},
	{(char *)"saru",       (IMActionProc)test_action}};
#endif


    Display *dpy = XOpenDisplay(0);

    Window win = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy),
        1, 1, 500, 300, 1, BlackPixel(dpy, 0), WhitePixel(dpy, 0));

    unsigned long  mask = 
	KeyPressMask | KeyReleaseMask | 
	ButtonPressMask | ButtonReleaseMask |
	PointerMotionMask | EnterWindowMask | 
	LeaveWindowMask | FocusChangeMask;

    Atom wdw = XInternAtom(dpy, "WM_DELETE_WINDOW", False);

    XWMHints    hints;

    IMActionTable action_table;

    int i;

    hints.flags = InputHint;
    hints.input = True;

    XSetWMHints(dpy, win, &hints);
    XSelectInput(dpy, win, mask);
    XSetWMProtocols(dpy, win, &wdw, 1);

    /* Initialize the gettimeofday. */
    puttime(NULL);


    /* Initialize the translation manager. */
    start = puttime("XimTMInitializeTM");
    XimTMInitializeTM();
    end = puttime("XimTMInitializeTM");
    print_time("XimTMInitializeTM", start, end);

    /* Get the binding table. */
    start = puttime("XimTMInitBindingTable");
    binding_table = XimTMInitBindingTable();
    end = puttime("XimTMInitBindingTable");
    print_time("XimTMInitBindingTable", start, end);

    /* Compile the translation. */
    start = puttime("XimTMParseTranslation");
    for(i = 0; i < NUM_TRANSLATION; i++)
	XimTMParseTranslation(binding_table, translation[i], &tm_id[i]);
    end = puttime("XimTMParseTranslation");
    print_time("XimTMParseTranslation", start, end);

    /* Test for XimTMParseIDTranslation function. */
    new_binding_table = XimTMInitBindingTable();
    start = puttime("XimTMParseIDTranslation");
    for(i = 0; i < NUM_TRANSLATION; i++)
	XimTMParseIDTranslation(new_binding_table, tm_id[i], &return_tm_id[i]);
    end = puttime("XimTMParseIDTranslation");
    print_time("XimTMParseIDTranslation", start, end);

    XimTMDestroyBindingTable(binding_table, True);

    binding_table = new_binding_table;

    /* Get the action table. */
    action_table = XimTMAddActionsTable(test_actions, XtNumber(test_actions));

    XMapWindow(dpy, win);

    for(;;) {
	XEvent event;

        XNextEvent(dpy, &event);

	switch(event.type) {
            case KeyPress: 
		/* Translate the key events. */
		test_process_event(&event, binding_table, action_table, 
		    return_tm_id[DEF_TRANSLATION]);
		break;

	    case ClientMessage:
		if(event.xclient.data.l[0] == wdw) {
		    XCloseDisplay(dpy);
		    goto test_end;
		}
	    
		break;
	    default:
		break;
        }
    }

test_end:
    XimTMDestroyTM();
}

static void
test_process_event(event, bind_table, action_table, tm_id)
XEvent		*event;
IMBindTable     bind_table;
IMActionTable   action_table;
IMTMid		tm_id;
{
    static void test_call_action();
    IMBindResultRec *bind_result = NULL;
    IMBindResultRec *cur = NULL;
    int    status;

    /* Look up the event. */
    start = puttime("XimTMLookupBinding");
    status = XimTMLookupBinding(event, bind_table, action_table, 
	tm_id, &bind_result);
    end = puttime("XimTMLookupBinding");
    print_time("XimTMLookupBinding", start, end);

    /* If not bound, get the dummy result. */
    if (status == IMBindFailed)
	_xim_tm_make_failed_result(event, 1, &bind_result) ;

    for(cur = bind_result; cur; cur = cur->next) {
	switch (cur->result) {
	case IMBindResultSucceeded: {
	    register int i;
	    for (i = 0; i < cur->num_actions; i++)
		test_call_action(event, &cur->actions[i], i);
	    break;
	}
	case IMBindResultFailed: {
	    char str[10];
	    KeySym key;

	    XLookupString((XKeyEvent *)event, str, 10, &key, NULL);
	    printf("Not bound: %s key is pressed.\n", XKeysymToString(key));
	    break;
	}
	}
    }

    XimTMDestroyBindResult(&bind_result);
}

typedef struct _TestClientDataRec *TestClientData;
typedef struct _TestClientDataRec {
   Const char      *proc_name;
   int             index_of_action;
} TestClientDataRec; 

static void
test_call_action(events, action_list, index_of_action)
XEvent          *events;
IMActionList	action_list;
int		index_of_action;
{
    TestClientDataRec tcd;

    tcd.proc_name = action_list->proc_name;
    tcd.index_of_action = index_of_action;

    (*action_list->proc)(events, action_list->params, 
                &action_list->num_params, (XPointer)&tcd);
}

static IMActionProc
test_action(events, params, nParams, call_data)
XEvent          *events;
String          *params;
Cardinal        *nParams;
XPointer        call_data;
{
    TestClientData tcd = (TestClientData)call_data;

    if(tcd->proc_name)
	printf("Bound    : %s func should be called.\n", tcd->proc_name);
    else
	printf("Not Bound: Default func should be called.\n");
}

#endif /* STANDALONE */
