/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdlib.h>
#include <string.h>
#ifndef WIN32
#include <signal.h>
#include <unistd.h>
#endif
#include "main.h"
#include "idk.hh"
#include "IMUser.hh"
#include "IMSystem.hh"
#include "IMTriggerKeyList.hh"
#include "IMLanguageList.hh"
#include "svrimprotohandler.hh"
#include "LEManager.hh"

#ifdef USE_IMP_MANAGER
#include "IMProtocolManager.hh"
#else
#include "IIIMProtocol.hh"
#endif

#include "SharedData.h"

/*************************************************************************
* $DESC_BEGIN
* Contructor function.
* itt member is initialized thru member initialization list.
* $DESC_END
*************************************************************************/
Idk::Idk(Itt *p_itt, 
	char *im_name)
{
  // Initialize all the member fields
  server_name 	        = (char *)strdup(im_name);
  itt = p_itt;
  iiimp_ims = (IMProtocol *)0;
  openIM();
}

/*************************************************************************
* $DESC_BEGIN
* Destructor function.
* $DESC_END
*************************************************************************/
Idk::~Idk() 
{ 
   // free the members
   free(server_name);
}

/*************************************************************************
* $DESC_BEGIN
* get an instance of the IMProtocols
* $DESC_END
*************************************************************************/
int
Idk::openIM()
{
  char transport[80];           /* enough */
  int port_number;
  IMLanguageList lang_list;
  IMTriggerKeyList key_list;
  char *trigger_keys;
  char *support_locale;
  IMUser * root_user = itt->getRootUser();
#define SetArg(arg, n, d) \
    ((void)( (arg).id = (n), (arg).value = (char*)(d) ))

  root_user->getResourceValues(0, RDB_CONV_ON_KEY, &trigger_keys,
                                  RDB_LOCALE_NAME, &support_locale,
			          (char *)0);
  if (trigger_keys) {
    key_list.add(trigger_keys);
    delete [] trigger_keys;
  }

#ifdef USE_IMP_MANAGER
  iiimp_ims = IMProtocolManager::getInstance(IMProtocolManager::IIIMP);
#else
  iiimp_ims = new IIIMProtocol(0, 0);
#endif

  char* hostname;
  root_user->getResourceValues(0, RDB_HOST_NAME, &hostname, (char*)0);
  root_user->getResourceValues(0, RDB_PORT_NUMBER, &port_number, (char*)0);
  sprintf(transport, "tcp/%s:%d", hostname, port_number);
  delete [] hostname;

  if (iiimp_ims == (IMProtocol *)0) {
    return -1;
  }
  // Succeeded in creating atleast one protocol 

  IMArg args[20];
  int n;

  memset(args, 0, sizeof(IMArg) * 20);

  n = 0;
  SetArg(args[n], IMProtocol::ServerName, server_name); n++;
  SetArg(args[n], IMProtocol::VendorName, "Sun"); n++;
  SetArg(args[n], IMProtocol::TransportAddress, transport); n++;
  SetArg(args[n], IMProtocol::PrimaryInputLocale, "ja"); n++;
  SetArg(args[n], IMProtocol::ConversionOnKeys, (char *)&key_list); n++;

  Bool use_trigger_off = False;
  root_user->getResourceValues(0,
			 RDB_USE_TRIGGER_OFF, &use_trigger_off,
			 (char *)0);
  if (use_trigger_off)
    SetArg(args[n], IMProtocol::ConversionOffKeys, &key_list); n++;

  iiimp_ims->set_values(args, n);

  // Set the list of downloadable objects
  LEManager& lemanager = itt->getLEManager();
  IMObjectDescriptorList* od_list = lemanager.getObjDescList();
  n = 0;
  SetArg(args[n], IMProtocol::ObjectDescriptors, od_list); n++;

  // Set the list of language lists
  IMEditorDescriptorList *ime_list=lemanager.getIMEDescList();
  int i, j;

  // If support_locale is usable, put it first
  if(support_locale){
    for(i=1;i<=ime_list->count();i++){
      IMEditorStruct *ime=&(ime_list->getIME(i));
      if(!ime) continue;
      for(j=0;j<ime->count_locales;j++){
        if(!strcmp(support_locale, ime->locales[j])){
          lang_list.add(ime->locales[j]);
        }
      }
    }
  }

  // Other locales sohuld be added after primary locale
  for(i=1;i<=ime_list->count();i++){
    IMEditorStruct *ime=&(ime_list->getIME(i));
    if(!ime) continue;
    for(j=0;j<ime->count_locales;j++){
      lang_list.add(ime->locales[j]);
    }
  }

  // temp fix
  // check lang_list.count() == 0
  if(lang_list.count() == 0){
     fprintf(stderr,"Error : No leif is available on this system.\n");
     if(ime_list->count() != 0){
	// -if option might be specified but locale
	// wasn't correct 
        fprintf(stderr,"      : the locale might be wrong. \
Please specify proper locale by using LC_ALL environment \
variable or -lc_basiclocale command line option\n");
     }
     exit(NOLEIF_EXITCODE);
  }

  SetArg(args[n], IMProtocol::LanguageList, &lang_list); n++;

  iiimp_ims->set_values(args, n);
   
  SvrIMProtoHandler *proto_callback = new SvrIMProtoHandler(itt);

  // register protocol handler for both XIMP4.0 and IIIMP
  n = 0;
  SetArg(args[n], IMProtocol::ProtocolHandler, proto_callback); n++;

  iiimp_ims->set_values(args, n);

  return 0;
}

/*************************************************************************
* $DESC_BEGIN
* This function calls the run method of the IMProtocols
* Triggers the conversion.
* $DESC_END
*************************************************************************/
void
Idk::run()
{
  int stat = 0;

  if ( (stat = iiimp_ims->run()) < 0) {
    exit(NORUN_EXITCODE);
  }

  while(1) {
    IMSystem::sleep(10000000);
  }

  return;
}

/*************************************************************************
* $DESC_BEGIN
* destroys the current instance.
* $DESC_END
*************************************************************************/
void Idk::destroy() 
{
  // Call the destructor
  delete this;
}
