/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(sun) || defined(Linux)
#include <unistd.h>
#endif
#if defined(WIN32)
#include <windows.h>
#include <winsock.h>
#endif
#include "util.hh"
#include "CompoundString.hh"
#include "itt.hh"
#include "IMUser.hh"

int IMUser::s_id = 0;
Itt* IMUser::itt = (Itt *)0;
IMResource* IMUser::root_resource = (IMResource *)0;

IMUser::IMUser(Itt * arg_itt) {
  this_id  = 0;
  itt      = arg_itt;
  root_resource = IMResource::create(itt->getCommandName(), 
				itt->getCmdArgNum(), 
				itt->getCmdArgs()); 
  resource = root_resource;
  IMUserList& user_list = itt->getIMUserList();
  user_list.addItem(this);  
}

IMUser::IMUser(char *arg_user, char *arg_host, char *arg_disp, char *arg_auth) {
  if (!itt)
     return;
  IMUserList& user_list = itt->getIMUserList();
  this_id = ++s_id;
  resource = root_resource;
  if (arg_user) {
     username = strdup(arg_user);
  } else {
     // username = IMSystem::getIMUserList();
     username = strdup(" ");
  }
  if (arg_host) {
     hostname = strdup(arg_host);
  } else {
     hostname = (char *)malloc(64);
     gethostname(hostname, 64);	
  }
  if (arg_disp) {
    displayid = strdup(arg_disp);
  } else {
    displayid = strdup("#1");
  }
  if (arg_auth) {
    authpasswd = strdup(arg_auth);
  } else {
    authpasswd = NULL;
  }
  user_list.addItem(this);  
}

IMUser::~IMUser() {
  IMUserList& user_list = itt->getIMUserList();
  resource->destroy();
  resource = (IMResource *)0;
  free(username);
  free(hostname);
  free(displayid);
  free(authpasswd);
  user_list.remove(this);
}

IMUser *
IMUser::getIMUser(int id) {
  IMUserList& user_list = itt->getIMUserList();
  int nsize = user_list.getSize();
  for (int i=1; i<=nsize; i++) {
    IMUser* imuser = &(user_list.getItem(i));
    if (imuser->this_id == 0)
       continue;	// skip the root_user
    if (imuser->this_id == id) {
       return imuser;
    }
  }
  return (IMUser *)0;
}

IMUser *
IMUser::getIMUser(CompoundString *user_id) {
  return (IMUser *)0;
}

IMUser *
IMUser::getIMUser(char *arg_user, char *arg_host, char *arg_disp, char *arg_auth) {
  IMUserList& user_list = itt->getIMUserList();
  int nsize = user_list.getSize();
  for (int i=1; i<=nsize; i++) {
    IMUser* imuser = &(user_list.getItem(i));
    if (imuser->this_id == 0)
       continue;	// skip the root_user
    if ((arg_user && !strcmp(imuser->username, arg_user)) && 
	(arg_host && !strcmp(imuser->hostname, arg_host)) &&
	(arg_disp && !strcmp(imuser->displayid, arg_disp)) ) {

       /* authpasswd may be updated in different session */
       if(imuser->authpasswd) {
	   free(imuser->authpasswd);
	   imuser->authpasswd = 0;
       }
       if(arg_auth){
           imuser->authpasswd = strdup(arg_auth);
       }

       return imuser;
    }
  }
  return (IMUser *)0;
}

void
IMUser::destroy()
{
}

int
IMUser::updateResource(char * resource_str) {
  resource->mergeResourceString(resource_str);
  return 1;
}

int
IMUser::getId() const {
  return 1;
}

char *
IMUser::getUserName() const {
   return username;
}

char *
IMUser::getHostName() const {
   return hostname;
}

char *
IMUser::getDisplayId() const {
   return displayid;
}

char *
IMUser::getAuthPasswd() const {
   return authpasswd;
}

/*************************************************************************
* $DESC_BEGIN
* returns the total number of arguments in the argv list.
* $DESC_END
*************************************************************************/
void
IMUser::countVaList(va_list var,
                 int *total_count)
{
    int attr;

    *total_count = 0;
    for (attr = va_arg(var, int); attr; attr = va_arg(var, int)) {
        va_arg(var, IttResourceArg*);
        ++(*total_count);
    }
}

/*************************************************************************
* $DESC_BEGIN
* initializes IttResourceArg list based on the arg passed.
* $DESC_END
*************************************************************************/
void
IMUser::vaToNestedList(va_list var,
                    int max_count,
                    IttResourceArg **args_return)
{
  IttResourceArg *args;
  int attr;

  if (max_count <= 0) {
    *args_return = (IttResourceArg *)0;
    return;
  }
  args = (IttResourceArg*)
    malloc((unsigned)(max_count + 1) * sizeof(IttResourceArg));
  *args_return = args;
  if (!args) return;
  for (attr = va_arg(var, int); attr; attr = va_arg(var, int)) {
    args->name = attr;
    args->value = va_arg(var, void *);
    args++;
  }
  args->name = (int)0;
}

/*************************************************************************
* $DESC_BEGIN
* gets the values for the resource names from the resource database.
* $DESC_END
*************************************************************************/
int
IMUser::getResourceValues(int dummy, ...)
{
  va_list var;
  int total_count;
  IttResourceArg *args;
  int ret;
  va_start(var, dummy);
  countVaList(var, &total_count);
  va_end(var);

  va_start(var, dummy);
  vaToNestedList(var, total_count, &args);
  va_end(var);

  ret = resource->resourceGetValues(args);
  if (args) free((char *)args);
  return ret;
}

/*************************************************************************
* $DESC_BEGIN
* sets the values for the resource names in the resource databse.
* $DESC_END
*************************************************************************/
int
IMUser::setResourceValues(int dummy, ...)
{
  va_list var;
  int total_count;
  IttResourceArg *args;
  int ret;

  va_start(var, dummy);
  countVaList(var, &total_count);
  va_end(var);

  va_start(var, dummy);
  vaToNestedList(var, total_count, &args);
  va_end(var);
  ret = resource->resourceSetValues(args);
  if (args) free((char *)args);
  return ret;
}

