/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdlib.h>
#include <string.h>
#include "itt.hh"
#include "IMUser.hh"
#include "idk.hh"
#include "svric.hh"
#include "LEManager.hh"
#include "SystemMessage.h"

/*************************************************************************
* $DESC_BEGIN
* Contructor function for Itt.
* graphics and system objects are initialized thru member initialization
* list.
* $DESC_END
*************************************************************************/
Itt::Itt(int p_argc, 
		char **p_argv, 
		char *p_class_name,
	      	char *app_name)
{
  int i;
  argc = p_argc;
  argv = (char**)malloc(sizeof(char*) * p_argc);
  for (i = 0; i < argc; i++) {
     argv[i] = strdup(p_argv[i]);
  }

  command_name = strdup(app_name);
  class_name   = strdup(p_class_name);
  
  // Create a root user
  user_list = new IMList<IMUser>();
  root_user = new IMUser(this);
  initialize();

  // initialize system message data
  int use_syslog;
  char * message_locale;
  use_syslog = 0;
  message_locale = NULL;
  root_user->getResourceValues(0,
			       RDB_MESSAGE_SYSLOG, &use_syslog,
			       RDB_MESSAGE_LOCALE, &message_locale,
			       NULL);
  system_message_init(app_name, use_syslog, message_locale);
  delete message_locale;
}

/*************************************************************************
* $DESC_BEGIN
* Destructor function for Itt.
* $DESC_END
*************************************************************************/
Itt::~Itt() 
{
  if (command_name) free(command_name);
  if (class_name)   free(class_name);
  idk->destroy();
  idk      = (Idk *)0;
  delete lemanager;
  system_message_destroy();
}

/*************************************************************************
* $DESC_BEGIN
* initializes the Idk object for Itt.
* $DESC_END
*************************************************************************/
void 
Itt::initialize() 
{

  // Get the availalble LE list
  // dummy_ic = new SvrIc(this, (InputContext *)0);  // Pass NULL for 2nd argument
  lemanager = new LEManager(this);
  idk = new Idk(this, command_name);
  if (idk == (Idk *)0) {
    delete lemanager;
    // cout << "Idk couldn't be created" << endl;
    exit(-1);
  }
}

/*************************************************************************
* $DESC_BEGIN
* returns the class name of Itt.
* $DESC_END
*************************************************************************/
char* 
Itt::getClassName() 
{
  return class_name;
}

/*************************************************************************
* $DESC_BEGIN
* returns the command name member of Itt.
* $DESC_END
*************************************************************************/
char* 
Itt::getCommandName() 
{
  return command_name;
}

/*************************************************************************
* $DESC_BEGIN
* waits for input events from the client. Invoke the IMdkit's loop.
* $DESC_END
*************************************************************************/
void 
Itt::mainLoop() {
  idk->run();
}

/*************************************************************************
* $DESC_BEGIN
* destroys the current instance of the Itt object.
* $DESC_END
*************************************************************************/
void 
Itt::destroy() 
{
 delete this;
}

/*************************************************************************
* $DESC_BEGIN
* returns the number of command line arguments.
* $DESC_END
*************************************************************************/
int 
Itt::getCmdArgNum() 
{
    return argc;
}

/*************************************************************************
* $DESC_BEGIN
* returns the command line arguments.
* $DESC_END
*************************************************************************/
char** 
Itt::getCmdArgs() 
{
    return (char **)argv;
}


IMUser*
Itt::getRootUser()
{
  return root_user;
}

IMUserList &
Itt::getIMUserList()
{
  return *user_list;
}

LEManager &
Itt::getLEManager()
{
  return *lemanager;
}
