/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _resource_hh_
#define _resource_hh_

#include <stdarg.h>
#include "Corelib.h"

enum ResTypeName {ResString, ResInt, ResBoolean, ResNone};

#define RDB_CONV_ON_KEY          2
#define RDB_USE_TRIGGER_OFF      3
#define RDB_COMMAND_LINE_DB      4
// #define RDB_SUPPORT_XIMP40       5
// #define RDB_SUPPORT_IIIMP        6
#define RDB_PORT_NUMBER          7
#define RDB_HOST_NAME            8
#define RDB_LOCALE_NAME          9
#define RDB_IFPATH_NAME         10 
#define RDB_SUPPORTED_LOCALES   11 
#define RDB_IF_LIST   		12 
#define RDB_IMCONFIG   		13 
#define RDB_DIRECT_XSUNIM   	14 
#define RDB_MESSAGE_SYSLOG	15
#define RDB_MESSAGE_LOCALE	16

#define RDB_LOOKUP_STYLE        41
#define RDB_LOOKUP_BORDER_WIDTH 42
#define RDB_LOOKUP_NCOLUMNS     43
#define RDB_LOOKUP_NROWS        44
#define RDB_LOOKUP_SAVEUNDER    45
#define RDB_LOOKUP_TITLE        46
#define RDB_LOOKUP_TITLE_NAME   47
#define RDB_LOOKUP_PLACEMENT    48
#define RDB_LOOKUP_POSITION     49
#define RDB_LOOKUP_BG           50
#define RDB_LOOKUP_FG           51
#define RDB_LOOKUP_LABEL_TYPE   52
#define RDB_LOOKUP_POLICY       53

typedef enum {
    RmRoot              = 105,
    RmPopup             = 106
} RmWindowType;

typedef enum {
    RmScreen            = 107,
    RmClient            = 108,
    RmCursor            = 109,
    RmSpotLocation      = 110
} RmWindowPosition;

typedef enum {
    RmLower             = 112,
    RmUpper             = 113,
    RmNumeric           = 114
} RmLabelType;

typedef enum {
    RmWrap              = 115,
    RmScroll            = 116
} RmEdgeType;

typedef enum {
  RmConvOn            = 117,
  RmConvOff           = 118
} RmConvStatus;

typedef enum {
    RmDisplayAlways     = 119,
    RmDisplayOnDemand   = 120
} RmDisplayMode;

typedef enum {
    RmNormal      = 121,
    RmComposite   = 122
} RmRootLayout;

typedef enum {
    RmShare             = 123,
    RmNoshare           = 124
} RmLookupPolicy;

typedef enum {
    ConvOn      = 125,
    ConvOff     = 126
} ConvMode;

typedef enum {
    RmFirst     = 127,
    RmNext      = 128,
    RmLast      = 129
} RmSeekFlag;

typedef struct {
    int flag;
    int x;
    int y;
    int width;
    int height;
} HttGeom;

typedef struct _HttRectangle {
   short x, y;
   unsigned short width, height;
} HttRectangle;

typedef struct _HttPoint {
   short x, y;
} HttPoint;

typedef struct _Resourcedb {
        char * name;
        ResTypeName type;
        int len;
        int offset;
        void * default_value;
} Resourcedb;
 
typedef struct {
   int       name;
   void *    value;
} IttResourceArg;

typedef struct {
   char *locale_name;
   char * if_name;
   char * ifpath_name;
   int port_number;
   char *host_name;
   char * conv_keys;
   char *label_name;
   Bool use_trigger_off;
   char *imconfig;
   Bool direct_xsunim;
   Bool use_syslog;
   char * message_locale;
   int lookup_rows;
   int lookup_cols;
} ResourceStruct;

class IMResource {
   public :
	IMResource(char*, char*);
        ~IMResource();
        IMResource& operator=(const IMResource& res);
	static IMResource *create(char*, int, char**);
	virtual void destroy();
        int resourceGetValues(IttResourceArg *args);
        int resourceSetValues(IttResourceArg *args);
        virtual void initialize(Resourcedb *, int, char* );
  // virtual void initialize(Resourcedb *, int, char* , char *);
	virtual void readCmdLineArgs(Resourcedb *, int, char*, int, char **);
	virtual void mergeResourceString(char*);
    protected :
	ResourceStruct resources;
        char * urlpath; 
        char * classname;
        virtual int convertResValue(char * from_value, int * to_addr,
                                                        void * default_value);
        virtual int convertResValue(char * from_value, Bool * to_addr,
                                                        void *default_value);
        virtual int convertResValue(char * from_value, char ** to_addr,
                                                        void * default_val);
  	static char * checkOption(char * res_name, int argc, char ** argv); 
};

#endif
