/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "IMUser.hh"
#include "LEManager.hh"
#include "resource.hh"
#include "LELookup.hh"
#include "util.hh"

LEManager::LEManager(Itt * itt)
{
#ifndef USE_XSUNIM
    char *ifpath = (char *) 0;
    char *locale_name = (char *) 0;
    char *iflist = (char *) 0;
    char *imconfig = (char *) 0;
    IMUser *root_user = itt->getRootUser();
    int i, j, dynamic_id = 1;
    
    /* Setup the lock */
    LEInterface::initialize();
    
    root_user->getResourceValues(0, RDB_IFPATH_NAME, &ifpath,
        RDB_LOCALE_NAME, &locale_name,
        RDB_IF_LIST, &iflist,
        RDB_IMCONFIG, &imconfig,
        (char *) 0);
    
    /* Lookup list of LEs */
    le_list = LELookup::getListOfLEs(
        ifpath,
        imconfig,
        locale_name,
        iflist
        );
    
    if (le_list->getSize() == 0) {
#ifdef	WIN32
        char *iflist_ = "sunim_default";
#else
        char *iflist_ = (char*)"cm";
#endif
        if (iflist && *iflist) {
            iflist_ = iflist;
        }
        char *tmp;
        int ind = 0;
        while ((tmp = Util::getSubString(iflist_, (char*)":", ind++))
	       != (char *) 0) {
            UTFCHAR *name = new UTFCHAR[strlen(tmp) + 1];
            for (i = 0; i < strlen(tmp); i++) {
                name[i] = tmp[i];
            }
            name[i] = 0;
            InterfaceModule *lestruct = new InterfaceModule(ifpath,
                (UTFCHAR *) name,
                tmp,
                locale_name);
            le_list->addItem(lestruct);
            delete [] name;
        }
    }

    /* linking IME descriptor */
    dynamic_id = 1;
    for (i = 1; i <= le_list->getSize(); i++) {
        InterfaceModule *im = &(le_list->getItem(i));
	int name_len;
        int lsize = im->locale_list.getSize();
	char **locales=(char**)calloc(lsize, sizeof(char*));
        for (j = 1; j <= lsize; j++) {
	    IMLocale *locale = &(im->locale_list.getItem(j));
	    locales[j-1]=strdup(locale->id);
	}
	for(name_len=0;im->lename->name[name_len];name_len++);
	ime_descriptor_list.add(
	    im->lename->name,
	    name_len,
	    (char*)"domain",
	    im->lename->id,
    	    dynamic_id++,
	    locales,
	    lsize);
    }

    /* linking object descriptor of each LE */
    dynamic_id = 1;
    for (i = 1; i <= le_list->getSize(); i++) {
        InterfaceModule *im = &(le_list->getItem(i));
        for (j = 1; j <= im->object_list.count(); j++) {
            IMObjectDescriptorStruct *od = &(im->object_list.getObjectDescriptor(j));
            od->id = dynamic_id++;
            object_descriptor_list.add(od);
        }
    }
    
    LELookup::showListOfLEs(le_list);
    
    delete [] locale_name;
    delete [] ifpath;
    delete [] iflist;
    delete [] imconfig;
#endif
}

LEManager::~LEManager()
{
#ifndef USE_XSUNIM
    int lesize = le_list->getSize();
    int i;
    for (i = 1; i <= lesize; i++) {
        InterfaceModule *p = &(le_list->getItem(i));
        if (p->itf != 0) {
            delete p;
        }
    }
    /* need to delete ime_descriptor_list */
    /* need to delete object_descriptor_list */
#endif
}

int
LEManager::delLEInterface(
    LEInterface * to_be_deleted
)
{
#ifndef USE_XSUNIM
    int lesize = le_list->getSize();
    int i;
    for (i = 1; i <= lesize; i++) {
        InterfaceModule *p = &(le_list->getItem(i));
        if (p->itf == to_be_deleted) {
            delete p->itf;
            p->itf = NULL;
        }
    }
#endif
    return 1;
}

static Bool locale_match(char*,char*);

/* java locale to solaris locale */
typedef struct im_locale_pair_ {
    char *im_client_locale;
    char *native_locale;
} im_locale_pair;

im_locale_pair locale_list[] = {
    {(char*)"ja", (char*)"ja"},
    {(char*)"ja", (char*)"ja_JP.EUC"},
    {(char*)"ja", (char*)"ja_JP.PCK"},
    {(char*)"ja", (char*)"ja_JP.UTF-8"},
    {(char*)"ja", (char*)"japanese"},

    {(char*)"ko", (char*)"ko"},
    {(char*)"ko", (char*)"ko.UTF-8"},
    {(char*)"ko", (char*)"ko_KR.EUC"},
    {(char*)"ko", (char*)"korean"},

    {(char*)"zh_CN", (char*)"zh.UTF-8"},
    {(char*)"zh_CN", (char*)"zh_CN.UTF-8"},
    {(char*)"zh_CN", (char*)"zh_CN.EUC"},
    {(char*)"zh_CN", (char*)"zh_CN"},
    {(char*)"zh_CN", (char*)"zh"},

    {(char*)"zh_CN", (char*)"zh.GBK"},

    {(char*)"zh_TW", (char*)"zh_TW.UTF-8"},
    {(char*)"zh_TW", (char*)"zh_TW.BIG5"},
    {(char*)"zh_TW", (char*)"zh_TW.EUC"},
    {(char*)"zh_TW", (char*)"zh_TW"},

    {0, 0}
};

static Bool
locale_match(
	char *im_client_locale,
	char *native_locale
)
{
    int i;
    for (i = 0; locale_list[i].im_client_locale != 0; i++) {
        if (!strcmp(locale_list[i].im_client_locale, im_client_locale)) {
            if (!strcmp(locale_list[i].native_locale, native_locale)) {
            	return True;
	    }
        }
    }
    return False;
}

LEInterface *
LEManager::getLEInterface(
    char *if_name,
    char *if_locale
)
{
#ifndef USE_XSUNIM

    int lesize, lsize, i, j;
    static LEInterface *default_im = 0;

    /* use default engine */
    if(if_name && !strcmp(if_name, "sunim_default")){
        goto error;
    }

#ifdef	DEBUG
    printf("if_name=%s if_locale=%s\n", if_name, if_locale);
#endif

    lesize = le_list->getSize();
    
    /* from old java client, if_name is null */
#ifdef Linux
    if (if_name == NULL || (*if_name) == 0) {
#else
    if (if_name == NULL || (*if_name) == NULL) {
#endif
        for (i = 1; i <= lesize; i++) {
            InterfaceModule *p = &(le_list->getItem(i));
            lsize = p->locale_list.getSize();
            for (j = 1; j <= lsize; j++) {
                IMLocale & locale = p->locale_list.getItem(j);
		if (locale_match(if_locale, locale.id) == True){
                    if (!p->itf) {
                        p->itf = LEInterface::getLEInterface(p->ifpath,
					p->lename->id,
					locale.id);
                    }
		    if(p->itf == NULL) {
			goto error;
		    }
                    return p->itf;
                }
            }
        }
        goto error;
    }

    /* from new java client, if_name is specified */
    for (i = 1; i <= lesize; i++) {
        InterfaceModule *p = &(le_list->getItem(i));
        if (strcmp(if_name, p->lename->id) == 0) {
            int lsize = p->locale_list.getSize();
            for (j = 1; j <= lsize; j++) {
                IMLocale & locale = p->locale_list.getItem(j);
		if (locale_match(if_locale, locale.id) == True){
                    if (!p->itf) {
                        p->itf = LEInterface::getLEInterface(p->ifpath,
				if_name,
				locale.id);
                    }
		    if(p->itf == NULL) {
			goto error;
		    }
                    return p->itf;
                }
            }
        }
    }

  error:
    /* if any engine can 't be returned, return default `null' engine */
    if (default_im == 0) {
        default_im = LEInterface::getLEInterface((char*)"/",
						 (char*)"sunim_default",
						 (char*)"C");
    }
    return default_im;
#endif
    return (LEInterface *) NULL;
}

IMObjectDescriptorList *
LEManager::getObjDescList()
{
    return &object_descriptor_list;
}

IMEditorDescriptorList *
LEManager::getIMEDescList()
{
    return &ime_descriptor_list;
}
