/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef CONVERTER_HH
#define CONVERTER_HH 1

#include <iconv.h>
#include <locale.h>
#include "IMProtocolStruct.h"
#include "KeyConverter.hh"
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

class Converter {
public :
  Converter(char *);
  IMText* convtoutf(char *src, XIMFeedback *feedback, int srclen);
  XIMText* convfromutf(IMText *src);

  void getXKeyEvent(IMKeyEventStruct &fev, XEvent &ev);
  void getIMKeyEvent(XEvent &ev, IMKeyEventStruct &fev);

  char* encodeWcText(wchar_t *str);
private :
  KeyConverter * keyconv;
  static const int UTF16_STRLEN;
  ConvertToUTF16(char *from_buf, size_t from_left,
                    char **to_buf, size_t *to_left);
  ConvertFromUTF16(char *from_buf, size_t from_left,
                    char **to_buf, size_t *to_left);
  iconv_t i_conv1;
  iconv_t i_conv2;	
  iconv_t i_conv1_FromUTF16;
  iconv_t i_conv2_FromUTF16;	
  char *current_locale;
  char *euc_encoding;
  char *utf8_encoding;
};

#endif // CONVERTER_HH
