/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "lookup_choice.hh"
#include <string.h>

LookupChoice::LookupChoice(int num) {
  memset(&lucs, 0, sizeof(IMLookupDrawCallbackStruct));

  num_of_choices = num;
  items = new IMChoiceObject[num_of_choices];
}

LookupChoice::~LookupChoice() {
  delete [] items;
}

void
LookupChoice::clear() {
  for (int i = 0; i < lucs.n_choices; i++) {
    if (lucs.choices[i].label) {
      delete lucs.choices[i].label->feedback;
      delete [] lucs.choices[i].label->text.utf_chars;
      delete lucs.choices[i].label;
    }
    delete lucs.choices[i].value->feedback;
    delete [] lucs.choices[i].value->text.utf_chars;
    delete lucs.choices[i].value;
  }
  if (lucs.title) delete [] lucs.title->text.utf_chars;
  delete lucs.title;

  delete [] lucs.choices;
  lucs.choices = 0;
  lucs.n_choices = 0;
}

void
LookupChoice::create_page(IMLookupDrawCallbackStruct &page) {
  page.max_len = lucs.max_len;
  page.index_of_first_candidate = 0;
  page.title = lucs.title;

  if (whoIsMaster == IMIsMaster) {
    page.index_of_last_candidate = lucs.index_of_last_candidate;
    page.n_choices = lucs.n_choices;
  } else {
    page.index_of_last_candidate = num_of_choices - 1;
    page.n_choices = num_of_choices;
  }

  int i;
  for (i = 0; i < page.n_choices; i++) {
    if (i + first_index == lucs.n_choices) {
      page.n_choices = i;
      page.index_of_last_candidate = i - 1;
      break;
    }
    items[i].value  = lucs.choices[i + first_index].value;
    items[i].label  = lucs.choices[i + first_index].label;
  }

  page.choices = items;

  page.index_of_current_candidate = focus_index - first_index;
#if 0
  if (focus_index >= first_index)
    page.choices[focus_index - first_index].value->feedback[0] = XIMReverse;
#endif
  return;
}

IMText *
LookupChoice::toIMText(XIMText * xt) {
  IMText * imtext;
  if (xt->length != 0) {
    if (xt->encoding_is_wchar) {
      char *mbs = converter->encodeWcText(xt->string.wide_char);
      imtext = converter->convtoutf(mbs, xt->feedback, strlen(mbs));	
      delete [] mbs;
    } else {
      imtext = converter->convtoutf(xt->string.multi_byte,
				    xt->feedback,
				    xt->length);
    }
    return imtext;
  }
  return (IMText *)0;
}

void
LookupChoice::set_choices(XIMLookupDrawCallbackStruct *call_data,
			  XIMText *label_text) {
  int n_choices = call_data->n_choices;
  XIMChoiceObject *choices = call_data->choices;
  clear();

  lucs.choices = new IMChoiceObject[n_choices];
  lucs.n_choices = n_choices;
  memset(lucs.choices, 0, sizeof(IMChoiceObject) * n_choices);

  XIMText *my_label = label_text;
  int use_my_label = (choices[0].label == 0 ? True : False);
  for (int i = 0; i < n_choices; i++) {
    if (!use_my_label) // instead of (choices[i].label)
      lucs.choices[i].label = toIMText(choices[i].label);
    else {
      if (i % num_of_choices == 0)
	my_label = label_text;
      lucs.choices[i].label = toIMText(my_label++);
    }
    lucs.choices[i].value = toIMText(choices[i].value);
  }

  lucs.max_len = call_data->max_len;
  if (call_data->title) lucs.title = toIMText(call_data->title);

  lucs.index_of_first_candidate = call_data->index_of_first_candidate;
  lucs.index_of_last_candidate = call_data->index_of_last_candidate;

  first_index = call_data->index_of_first_candidate;
  focus_index = call_data->index_of_first_candidate;

  return;
}

#ifndef min
#define min(a, b)               ((a) > (b) ? (b) : (a))
#endif

int
LookupChoice::move_next() {
  if (focus_index < lucs.index_of_last_candidate &&
      focus_index < first_index + num_of_choices - 1) {
    focus_index++;
    return True;
  } else if (focus_index == min(lucs.index_of_last_candidate,
				(first_index + num_of_choices - 1))) {
    // at the last candidate of the page
    if (move_next_page()) return True;
    if (move_top()) return True;
  }
  return False;
}

int
LookupChoice::move_prev() {
  if (focus_index > first_index) {
    focus_index--;
    return True;
  } else if (focus_index == first_index) {
    // goto previous page if any
    if (move_prev_page()) return True;
    if (move_last()) return True;
  }
  return False;
}

int
LookupChoice::move_up() {
  if (focus_index - ncolumns >= first_index) {
    focus_index -= ncolumns;
    return True;
  } else if (focus_index - ncolumns < first_index) {
    while (focus_index + ncolumns <=
	   min(lucs.index_of_last_candidate,
	       first_index + num_of_choices - 1)) {
      focus_index += ncolumns;
    }
    return True;
  }
  return False;
}

int
LookupChoice::move_down() {
  if (focus_index + ncolumns <= lucs.index_of_last_candidate &&
      focus_index + ncolumns <= first_index + num_of_choices - 1) {
    focus_index += ncolumns;
    return True;
  } else if (focus_index + ncolumns >
	     min(lucs.index_of_last_candidate,
		 first_index + num_of_choices - 1)) {
    while (focus_index - ncolumns >= first_index) {
      focus_index -= ncolumns;
    }
    return True;
  }
  return False;
}

int
LookupChoice::move_top() {
  if (focus_index != first_index) {
    focus_index = first_index;
    return True;
  }
  return False;
}

int
LookupChoice::move_last() {
  if (focus_index != lucs.index_of_last_candidate &&
      focus_index != first_index + num_of_choices - 1) {
    focus_index = min(lucs.index_of_last_candidate,
		      first_index + num_of_choices - 1);
    return True;
  }
  return False;
}

int
LookupChoice::move_next_page() {
  if (first_index + num_of_choices <=
      lucs.index_of_last_candidate) {
    first_index += num_of_choices;
    focus_index = first_index;
    return True;
  }
  return False;
}

int
LookupChoice::move_prev_page() {
  if (first_index >= num_of_choices) {
    first_index -= num_of_choices;
    focus_index = first_index;
    return True;
  }
  return False;
}
