/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <X11/Xlib.h>
#include "IMProtocolStruct.h"
#include "XSunExt.h"
#include "converter.hh"

class LookupChoice {
public:
  LookupChoice(int num_of_choices);
  ~LookupChoice();
  void create_page(IMLookupDrawCallbackStruct &page);
  void clear();
  void set_choices(XIMLookupDrawCallbackStruct *call_data, XIMText *label);

  void set_converter(Converter *conv) {converter = conv;}

  void set_WhoIsMaster(WhoIsMaster master) {whoIsMaster = master;}

  void set_ncolumns(int n) {ncolumns = n;}
  void set_nrows(int n) {nrows = n;}

  int get_focus_index() {return focus_index;}

  int select_choice(int index) {return first_index + index;}

  int last_index() {return lucs.index_of_last_candidate;}

  int move_top();
  int move_last();
  int move_next();
  int move_prev();
  int move_up();
  int move_down();
  int move_next_page();
  int move_prev_page();

private:
  IMText *toIMText(XIMText *xt);

  IMLookupDrawCallbackStruct lucs;

  IMChoiceObject *items;
  int num_of_choices;
  int first_index;
  int focus_index;
  Converter *converter;
  WhoIsMaster whoIsMaster;

  // LayoutInfo
  int ncolumns;
  int nrows;
};
