/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <stdlib.h>
#include "itt.hh"
#include "IMUser.hh"
#include "imsession.hh"
#include "sessioniml_sunim.hh"

extern "C" {
iml_inst * iml_execute(iml_inst **rrv, void *s);
}

ImlSession::~ImlSession()
{
  delete sc;
}

IMSession*
IMSession::create(SvrIc* p_ic, char *locale)
{
  IMSession* session = (IMSession *)0;
  session = (IMSession *)new SunIMSession(p_ic, locale);
  return (session);
}

/*************************************************************************
* $DESC_BEGIN
* Contructor function.
* $DESC_END
*************************************************************************/
SunIMSession::SunIMSession(SvrIc* p_ic, char *locale)
{
  if (locale && !strcmp(locale, " ")) {  // else Itt may want to create a dummy session to get LE infos
  } else {
    svric = p_ic;
    openSession(locale);
  }
}

/*************************************************************************
* $DESC_BEGIN
* open a session handler for the ic with the language engine.
* $DESC_END
*************************************************************************/
Bool SunIMSession::openSession(char *locale_name)
{
    Itt& itt = svric->getItt();
    LEManager& lemanager = itt.getLEManager();
    IMUser& imuser = svric->getIMUser();
    InputContext *input_context = &(svric->getInputContext());
    char *username = imuser.getUserName();
    char *hostname = imuser.getHostName();
    char *authpasswd = imuser.getAuthPasswd();
    char *display_id;

    if (!locale_name)
       imuser.getResourceValues(0, RDB_LOCALE_NAME, &locale_name, (char *)0);

    ImlSession * session = new ImlSession();

    CompoundString client_locale = input_context->getLocaleName();
    CompoundString client_engine = input_context->getEngineName();
    CompoundString client_type = input_context->getApplicationName();
    session->locale_name = input_context->getLocaleName();

#ifdef	notdef
    printf("client_locale=[%s]\n", (char*)client_locale);
    printf("client_engine=[%s]\n", (char*)client_engine);
    printf("client_type=[%s]\n", (char*)client_type);
#endif

    session->le = lemanager.getLEInterface((char*)client_engine, (char*)client_locale);     
    if (!session->le) {
       // Always True, SunIM returns `null' engine if the engine is missing
    }

    int arg_n=0;
    IMArg arg[12];

    IMSetArg(arg[arg_n], UI_USER_NAME, (char *)username); arg_n++;
    IMSetArg(arg[arg_n], UI_HOST_NAME, (char *)hostname); arg_n++;
    if (authpasswd) {
        IMSetArg(arg[arg_n], UI_AUTH_PASSWD, (char *)authpasswd); arg_n++;
    }

    CompoundString display_id_ = input_context->getXDisplayString();

    // only X client sends display ID
    if(strlen((char*)display_id_) == 0){
        display_id = new char [strlen(hostname) + 3];
	sprintf(display_id, "%s:0", hostname);
	display_id[strlen(hostname)+2] = '\0';
    } else {
        display_id = new char [strlen((char*)display_id_) + 1];
	strcpy(display_id, (char*)display_id_);
	display_id[strlen((char*)display_id_)] = '\0';
    }

#ifdef	notdef
    printf("display_id = [%s]\n", display_id);
#endif

    IMSetArg(arg[arg_n], UI_DISPLAY_ID, (char *)display_id); arg_n++;

    if(strstr((char*)client_type, "Htt XIM")){
        // from xiiimp.so.2 through htt_xbe
        IMSetArg(arg[arg_n], UI_PROTOCOL_TYPE, (char *)UI_PROTOCOL_TYPE_XIMP); arg_n++;
        IMSetArg(arg[arg_n], UI_CLIENT_TYPE, (char *)UI_CLIENT_TYPE_X); arg_n++;
    } else if(strstr((char*)client_type, "XIM IIIMP")){
        // from xiiimp.so.2 direct
        IMSetArg(arg[arg_n], UI_PROTOCOL_TYPE, (char *)UI_PROTOCOL_TYPE_IIIMP); arg_n++;
        IMSetArg(arg[arg_n], UI_CLIENT_TYPE, (char *)UI_CLIENT_TYPE_X); arg_n++;
    } else if(strstr((char*)client_type, "JDK")){
        // from JAVA2
        IMSetArg(arg[arg_n], UI_PROTOCOL_TYPE, (char *)UI_PROTOCOL_TYPE_IIIMP); arg_n++;
        IMSetArg(arg[arg_n], UI_CLIENT_TYPE, (char *)UI_CLIENT_TYPE_JAVA); arg_n++;
    } else {
        // unknown
        IMSetArg(arg[arg_n], UI_PROTOCOL_TYPE, (char *)UI_PROTOCOL_TYPE_IIIMP); arg_n++;
        IMSetArg(arg[arg_n], UI_CLIENT_TYPE, (char *)UI_CLIENT_TYPE_UNKNOWN); arg_n++;
    }

    CompoundString xserver_vendor = input_context->getXServerVendor();
    CompoundString os_name = input_context->getOSName();
    CompoundString os_arch = input_context->getOSArch();
    CompoundString os_version = input_context->getOSVersion();

    IMSetArg(arg[arg_n], UI_XSERVER_VENDOR, (char *)xserver_vendor); arg_n++;
    IMSetArg(arg[arg_n], UI_OS_NAME, (char *)os_name);	arg_n++;
    IMSetArg(arg[arg_n], UI_OS_ARCH, (char *)os_arch);	arg_n++;
    IMSetArg(arg[arg_n], UI_OS_VERSION, (char *)os_version);	arg_n++;

    UserInfo *user = new UserInfo(arg, arg_n);
    delete display_id;

    session->sc = LESessionContext::getLESessionContext(session->le, user);
    delete user;

    // if sc is not created, use default engine
    if (!session->sc) {
        session->le = lemanager.getLEInterface("sunim_default", "C");
        user = new UserInfo("dummy", "dummy", "dummy");
        session->sc = LESessionContext::getLESessionContext(session->le, user);
        delete user;
    }

    // bug fix for
    // 4221040: LOOKUP NROWS, NCOLS and LABELTYPE properties for XSunIM LEs
    int labeltype, nrows, ncols;
    imuser.getResourceValues(0, RDB_LOOKUP_LABEL_TYPE, &labeltype, (char*)0);
    imuser.getResourceValues(0, RDB_LOOKUP_NCOLUMNS, &ncols, (char*)0);
    imuser.getResourceValues(0, RDB_LOOKUP_NROWS, &nrows, (char*)0);
    IMSetArg(arg[0], SC_LOOKUP_LABELTYPE, (char *)labeltype);
    IMSetArg(arg[1], SC_LOOKUP_NCOLS, (char *)ncols);
    IMSetArg(arg[2], SC_LOOKUP_NROWS, (char *)nrows);
    session->sc->set_values(arg, 3);

    session->sc->addIMLListener(iml_execute, this);    
    session_list.addItem(session);
    active_session = session;
    return True;
}

/*************************************************************************
* $DESC_BEGIN
* destroys the current instance.
* $DESC_END
*************************************************************************/
void SunIMSession::destroy() {
    int num = session_list.getSize();
    for (int i=1; i<=num; i++) {
     ImlSession *session = &(session_list.getItem(i));
     delete session;
    }
    session_list.destroy();
    delete this;
    return;
}

int SunIMSession::realize()
{
  LESessionContext& sc = getActiveSession();
  IMArg arg[1];
  IMSetArg(arg[0], SC_REALIZE, (char *)0);
  sc.set_values(arg, 1);
  return 1;
}

int SunIMSession::startConversion()
{
  LESessionContext& sc = getActiveSession();
  IMArg arg[1];
  IMSetArg(arg[0], SC_TRIGGER_ON_NOTIFY, (char *)0);
  sc.set_values(arg, 1);
  return 1;
}

int SunIMSession::endConversion()
{
  LESessionContext& sc = getActiveSession();
  IMArg arg[1];
  IMSetArg(arg[0], SC_TRIGGER_OFF_NOTIFY, (char *)0);
  sc.set_values(arg, 1);
  return 1;
}

int SunIMSession::forwardEvent(IMInputEvent *fev)
{
  LESessionContext& sc = getActiveSession();
  sc.send_event(fev);
  return 1;
}

  
/*************************************************************************
* $DESC_BEGIN
* send set focus message to the language engine.
* $DESC_END
*************************************************************************/
int SunIMSession::setFocus() {
  LESessionContext& sc = getActiveSession();
  sc.set_focus();
  return 1;
}

/*************************************************************************
* $DESC_BEGIN
* send unset focus message to the language engine.
* $DESC_END
*************************************************************************/
int SunIMSession::unsetFocus() {
  LESessionContext& sc = getActiveSession();
  sc.unset_focus();
  return 1;
}

/*************************************************************************
* $DESC_BEGIN
* Switches between another language engine based on the key pressed.
* $DESC_END
*************************************************************************/
Bool SunIMSession::engineSwitch(char *locale_name) {
    /* not yet: Need to implement engine switch */
    // Go thru the list to find if any existing session matches the locale
    Bool FOUND = False;
    ImlSession * mysession;
    for (int i=1; i <= session_list.getSize(); i++) {
        mysession = (ImlSession *)&(session_list.getItem(i));
        if (mysession->locale_name.compare(locale_name)) {
           FOUND = True;
           active_session = mysession;
           break;
	}
    }
    if (!FOUND) {
       openSession(locale_name);
       // After openSession() realize() needs to be called
       realize();
    }
    reset(); 
    return (True);
}

/*************************************************************************
* $DESC_BEGIN
* reset the session with the language engine.
* $DESC_END
*************************************************************************/
IMText* SunIMSession::reset() {
  LESessionContext& sc = getActiveSession();
  if (svric->getPreeditState() == SvrIc::PreeditEnable)
     return(sc.reset());
  return (IMText *)0;
}

/*************************************************************************
* $DESC_BEGIN
* sets the values for the session.
* $DESC_END
*************************************************************************/
int SunIMSession::setValues(char *attr, void *value) {
  InputContext *input_context = &(svric->getInputContext());
  if (!active_session->locale_name.compare(input_context->getLocaleName())) {
     engineSwitch(input_context->getLocaleName());
  } else { 
     LESessionContext& sc = getActiveSession();
     sc.set_values(NULL, 0);
  }
  return 0;
}

/*************************************************************************
* $DESC_BEGIN
* returns the ic values for the session.
* $DESC_END
*************************************************************************/
int SunIMSession::getValues(char *attr, void *value) {
  LESessionContext& sc = getActiveSession();
  sc.get_values(NULL, 0);
  return 0;
}

/*************************************************************************
* $DESC_BEGIN
* returns the active session on the session list.
* $DESC_END
*************************************************************************/
LESessionContext& SunIMSession::getActiveSession() {
   return *(active_session->sc);
}

int 
SunIMSession::imli_nop(iml_inst *rv) {
    return LookupNone;
}

int 
SunIMSession::imli_set_status(iml_inst *rv) {
    SvrIc::PreeditState state = svric->getPreeditState();
    InputContext& ic = svric->getInputContext();
    iml_status_t   prev_status = 0;
    iml_status_t   status = *(iml_status_t *) & (rv->operand);

    if(state == SvrIc::PreeditEnable)
	prev_status |= IMLSTATUS_Henkan_Mode;

    if (((status & IMLSTATUS_Henkan_Mode) != IMLSTATUS_Henkan_Mode) &&
	((prev_status & IMLSTATUS_Henkan_Mode) == IMLSTATUS_Henkan_Mode)) {
	ic.conversion_end();
    } else if (((status & IMLSTATUS_Henkan_Mode) == IMLSTATUS_Henkan_Mode) &&
	       ((prev_status & IMLSTATUS_Henkan_Mode) != 
		IMLSTATUS_Henkan_Mode)) {
	ic.conversion_start();
    }
    return LookupNone;
} 

int 
SunIMSession::imli_reset(iml_inst *rv) {
    return LookupNone;
}

int 
SunIMSession::imli_keypress(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMKeyEventStruct *key = (IMKeyEventStruct*)&rv->operand ;
    ic.forward_event(key);
    return LookupNone;
}

int 
SunIMSession::imli_commit(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMText *cs;
    cs = (IMText *) & rv->operand;
    ic.commit_string(cs); 
    return (1);
}

int 
SunIMSession::imli_reset_return(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMText *cs;
    cs = (IMText *) & rv->operand;
    ic.commit_string(cs);
    return (1);
}

int 
SunIMSession::imli_preedit_start(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    ic.preedit_start((IMPreeditStruct *)0);
    return (LookupNone);
}

int 
SunIMSession::imli_preedit_draw(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMPreeditStruct *ps = new IMPreeditStruct;
    memcpy(&(ps->todo.draw), (void *)&rv->operand, 
				sizeof(IMPreeditDrawCallbackStruct));
    ic.preedit_draw(ps);
    delete ps;
    return (LookupNone);
}

int 
SunIMSession::imli_preedit_done(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    ic.preedit_done((IMPreeditStruct *)0);
    return (LookupNone);
}

int 
SunIMSession::imli_preedit_caret(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMPreeditStruct *ps = new IMPreeditStruct;
    memcpy(&(ps->todo.caret), (void *)&rv->operand, 
					sizeof(IMPreeditCaretCallbackStruct));
    ic.preedit_caret(ps);
    delete ps;
    return (LookupNone);
}

int 
SunIMSession::imli_status_start(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    ic.status_start((IMStatusStruct *)0);
    return (LookupNone);
}

int 
SunIMSession::imli_status_draw(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMStatusStruct * ss = new IMStatusStruct;
    memcpy(&(ss->todo.draw), (void *)&rv->operand,
				sizeof(IMStatusDrawCallbackStruct));    
    ic.status_draw(ss);
    delete ss;
    return (LookupNone);
}

int 
SunIMSession::imli_status_done(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    ic.status_done((IMStatusStruct *)0);
    return (LookupNone);
}

int 
SunIMSession::imli_lookup_start(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMLookupStruct *ls = new IMLookupStruct;
    memcpy(&(ls->todo.start), (void *)&rv->operand,
				sizeof(IMLookupStartCallbackStruct));
    ic.lookup_start(ls);
    delete ls;
    return (LookupNone);
}

int 
SunIMSession::imli_lookup_draw(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMLookupStruct *ls = new IMLookupStruct;
    memcpy(&(ls->todo.draw), (void *)&rv->operand,
				sizeof(IMLookupDrawCallbackStruct));
    ic.lookup_draw(ls);
    delete ls;
    return (LookupNone);
}

#ifdef has_lookup_process
int 
SunIMSession::imli_lookup_process(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMLookupStruct *ls = new IMLookupStruct;
    memcpy(&(ls->todo.process), (void *)&rv->operand,
				sizeof(IMLookupProcessCallbackStruct));
    ic.lookup_process(ls);
    return (LookupNone);
}
#endif

int 
SunIMSession::imli_lookup_done(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    ic.lookup_done((IMLookupStruct *)0);
    return (LookupNone);
}

int 
SunIMSession::imli_aux_start(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMAuxStruct *as = new IMAuxStruct;
    memcpy(&(as->todo.start), (void *)&rv->operand, 
				sizeof(IMAuxStartCallbackStruct));
    ic.auxiliary_start(as);
    delete as;
    return (LookupNone);
}

int 
SunIMSession::imli_aux_draw(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMAuxStruct *as = new IMAuxStruct;
    memcpy(&(as->todo.draw), (void *)&rv->operand, 
				sizeof(IMAuxDrawCallbackStruct));
    ic.auxiliary_draw(as);
    delete as;
    return (LookupNone);
}

int 
SunIMSession::imli_aux_done(iml_inst *rv) {
    InputContext& ic = svric->getInputContext();
    IMAuxStruct *as = new IMAuxStruct;
    memcpy(&(as->todo.done), (void *)&rv->operand, 
				sizeof(IMAuxDoneCallbackStruct));
    ic.auxiliary_done(as);
    delete as;
    return (LookupNone);
}

int 
SunIMSession::imli_key_info(iml_inst *rv) {
    return (LookupNone);
}

int 
SunIMSession::imli_put_queue(iml_inst *rv) {
    return (LookupNone);
}

int 
SunIMSession::executeHandler(int opcode, 
				iml_inst* inst)
{
     int ret_val = 0;
  switch (opcode) {
     case IMM_NOP        : ret_val = imli_nop(inst);
		           break;
     case IMM_SET_STATUS : ret_val = imli_set_status(inst);
		           break;
     case IMM_RESET	 : ret_val = imli_reset(inst);
		           break;
     case IMM_KEYPRESS 	 : ret_val = imli_keypress(inst);
		           break;
     case IMM_COMMIT     : ret_val = imli_commit(inst);
		           break;
     case IMM_RESET_RETURN : ret_val = imli_reset_return(inst);
		           break;
     case IMM_PREEDIT_START : ret_val = imli_preedit_start(inst);
		           break;
     case IMM_PREEDIT_DRAW : ret_val = imli_preedit_draw(inst);
		           break;
     case IMM_PREEDIT_DONE : ret_val = imli_preedit_done(inst);
		           break;
     case IMM_PREEDIT_CARET : 
			ret_val = imli_preedit_caret(inst);
		       	break;
     case IMM_STATUS_START : 
			ret_val = imli_status_start(inst);
		       	break;
     case IMM_STATUS_DRAW : ret_val = imli_status_draw(inst);
		           break;
     case IMM_STATUS_DONE : ret_val = imli_status_done(inst);
		           break;
     case IMM_LOOKUP_START : ret_val = imli_lookup_start(inst);
		           break;
     case IMM_LOOKUP_DRAW : ret_val = imli_lookup_draw(inst);
		           break;
#ifdef has_lookup_process
     case IMM_LOOKUP_PROCESS : ret_val = imli_lookup_process(inst);
		           break;
#endif
     case IMM_LOOKUP_DONE : ret_val = imli_lookup_done(inst);
		           break;
     case IMM_AUX_START_2 : ret_val = imli_aux_start(inst);
		           break;
     case IMM_AUX_DRAW_2 : ret_val = imli_aux_draw(inst);
		           break;
     case IMM_AUX_DONE_2 : ret_val = imli_aux_done(inst);
		           break;
     case IMM_KEY_INFO : ret_val = imli_key_info(inst);
		           break;
     case IMM_PUT_QUEUE : ret_val = imli_put_queue(inst);
		           break;
     default :		  ret_val = imli_nop(inst);
			   break;
  }
  return ret_val;
}

/*
 * This function expects to be invoked from X*LookupString() basically. The
 * function value is meaningless if it's not invoked from X*LookupString()
 */

iml_inst *
iml_execute(iml_inst **rrv, void * s) {
    SunIMSession * session = (SunIMSession *)s;
    iml_inst       *rv = *rrv;
    iml_inst       *i;
    iml_inst	   *result = (iml_inst*)0;
    int             op;

    for (i = rv; i != (iml_inst*)0; i = i->next) {
	op = i->opcode & ~IMM_CB_RESULT_REQUIRED ;
	if ((op < 0) || (op >= MAX_IMM_OPCODE)) {
	    break;
	}
	session->executeHandler(op, i);
	if (i->opcode & IMM_CB_RESULT_REQUIRED) {
	   if(result){
	   } else {
	      result = i ;
	   }
	}
    }
    return result ;
}
