/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef sessioniml_sunim_hh_
#define sessioniml_sunim_hh_ 1

#include <sys/types.h>
#include "IMArg.h"
#include "InputContext.hh"
#include "IMList.hh"
#include "sunim.hh"
#include "LEManager.hh"

typedef struct _XSFrrvCellRec *XSFrrvCell;

typedef struct _XSFrrvCellRec {
    XSFrrvCell     nlink;
    iml_inst       *called_rv;
    iml_inst       *rv;
} XSFrrvCellRec;

typedef struct _IMLGlueRec {
    /* Do not move the first 2 members */
    unsigned long window;                /* for xci */
    int         screen;          /* for xci */
    XSFrrvCell     cell_link;
    int            callback_flg;
    void           *session;   /* Session object */
} IMLGlueRec, *IMLGlue;

// forward declaration
class IMSessionIml;

class ImlSession {
    public:
        friend class SunIMSession;
        ~ImlSession();
    private :
        LEInterface       *le;
        LESessionContext  *sc;
	CompoundString locale_name;
};

class SunIMSession : public IMSession {
    public :
	static IMSession * create(SvrIc* p_ic, char * locale); 
        SunIMSession(SvrIc* p_ic, char* locale);
	virtual int startConversion();
  	virtual int endConversion();
  	virtual int realize();
        virtual int forwardEvent(IMInputEvent * ev);
	virtual int setFocus();
	virtual int unsetFocus();
	virtual IMText * reset();
	virtual int setValues(char *attr, void *value);
	virtual int getValues(char *attr, void *value);
	virtual void destroy();
        int executeHandler(int opcode, iml_inst* inst); 
    protected :
	virtual int imli_nop(iml_inst* inst);
	virtual int imli_set_status(iml_inst* inst);
	virtual int imli_reset(iml_inst* inst);
	virtual int imli_keypress(iml_inst* inst);
	virtual int imli_commit(iml_inst* inst);
	virtual int imli_reset_return(iml_inst* inst);
	virtual int imli_preedit_start(iml_inst* inst);
	virtual int imli_preedit_draw(iml_inst* inst);
	virtual int imli_preedit_done(iml_inst* inst);
	virtual int imli_preedit_caret(iml_inst* inst);
	virtual int imli_status_start(iml_inst* inst);
	virtual int imli_status_draw(iml_inst* inst);
	virtual int imli_status_done(iml_inst* inst);
	virtual int imli_lookup_start(iml_inst* inst);
	virtual int imli_lookup_draw(iml_inst* inst);
#ifdef has_lookup_process
	virtual int imli_lookup_process(iml_inst* inst);
#endif
	virtual int imli_lookup_done(iml_inst* inst);
	virtual int imli_aux_start(iml_inst* inst);
	virtual int imli_aux_draw(iml_inst* inst);
	virtual int imli_aux_done(iml_inst* inst);
	virtual int imli_key_info(iml_inst* inst);
	virtual int imli_put_queue(iml_inst* inst);
        virtual Bool openSession(char *);
	LESessionContext& getActiveSession();
        Bool engineSwitch(char *locale_name); 
        IMList<ImlSession> session_list;
        ImlSession* active_session;
};

#endif // sessioniml_sunim_hh_
