/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef sessioniml_xsunim_hh_
#define sessioniml_xsunim_hh_ 1

#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include "svric.hh"
#include "IMList.hh"
#include "XSunExt.h"
#include "XSunIMProt.h"
#include "XSunIMPriv.h"
#include "XSunIMMMan.h"
#include "XSunIMMthd.h"
#include "XSunIMCore.h"
#include "XSunIMPub.h"

#include "converter.hh"
#include "imsession.hh"
#include "localeservice.hh"

#include "lookup_choice.hh"

extern "C" {
void            imlimgr_init();
iml_if_t        *if_OpenIF(char *, char *, void *);
void            if_CloseIF(iml_if_t *);
Bool            if_GetIFValue(iml_if_t *, char *, caddr_t);
Bool            if_SetIFValue(iml_if_t *, char *, caddr_t);
iml_session_t   *if_CreateSC(iml_if_t *, void *, char *);
Bool            if_DestroySC(iml_session_t *);
Bool            if_SetSCValue(iml_session_t *, char *, caddr_t);
Bool            if_GetSCValue(iml_session_t *, char *, caddr_t);
char*           if_ResetSC(iml_session_t *);
void            if_SetSCFocus(iml_session_t *);
void            if_UnsetSCFocus(iml_session_t *);
void            if_SendEvent(iml_session_t *, XEvent *);
void            if_SetAuxValues(iml_session_t *, XIMAuxDrawCallbackStruct*);
Bool		if_FilterEvent(XEvent *event);
}

typedef struct _ImChainRec *ImChain;

typedef struct _ImChainRec {
    ImChain     next;
    ImChain     prev;
    void       *htt;            /* should be used with cast (ImChain) */
} ImChainRec;

typedef struct _HttRec {
  ImChain im;
  XrmDatabase   app_defaults;
  XrmDatabase   special;
  XrmDatabase   cmdlines;
  XrmDatabase   rdb;
  XrmDatabase   dot_rc;
  void          *ic_list;
  void          *free_ic_list;
  char          *command_name;
  char          *class_name;
  char          *dot_httrc;
  void	  *core;
  unsigned long biff;
} HttRec;

typedef struct _XSFrrvCellRec *XSFrrvCell;

typedef struct _XSFrrvCellRec {
    XSFrrvCell     nlink;
    iml_inst       *called_rv;
    iml_inst       *rv;
} XSFrrvCellRec;

typedef struct _IMLGlueRec {
    /* Do not move the first 2 members */
    unsigned long window;                /* for xci */
    int         screen;          /* for xci */
    XSFrrvCell     cell_link;
    int            callback_flg;
    void           *session;   /* Session object */
} IMLGlueRec, *IMLGlue;

// forward declaration
class XSunIMSession;

class ImlSession {
        friend class XSunIMSession;
    private :
        iml_if_t            *interface;
        iml_session_t         *s;
        iml_status_t        status;
};

class XSunIMSession : public IMSession {
    public :
        static iml_inst * iml_execute(iml_session_t *s, iml_inst **rrv);
	XSunIMSession(SvrIc* p_ic, char * locale);
	~XSunIMSession();
	virtual int startConversion();
  	virtual int endConversion();
	virtual int setFocus();
	virtual int unsetFocus();
        virtual int forwardEvent(IMInputEvent * ev);
	virtual IMText * reset();
	virtual int setValues(char *attr, void *value);
	virtual int getValues(char *attr, void *value);
	virtual void destroy();
	static void BC_xsunim_filterevent(XEvent *);
        int executeHandler(int opcode, iml_inst* inst, XEvent* ev); 
    protected :
	virtual int imli_nop(iml_inst* inst, XEvent* ev);
	virtual int imli_set_status(iml_inst* inst, XEvent* ev);
	virtual int imli_reset(iml_inst* inst, XEvent* ev);
	virtual int imli_keypress(iml_inst* inst, XEvent* ev);
	virtual int imli_commit(iml_inst* inst, XEvent* ev);
	virtual int imli_reset_return(iml_inst* inst, XEvent* ev);
	virtual int imli_preedit_start(iml_inst* inst, XEvent* ev);
	virtual int imli_preedit_draw(iml_inst* inst, XEvent* ev);
	virtual int imli_preedit_done(iml_inst* inst, XEvent* ev);
	virtual int imli_preedit_caret(iml_inst* inst, XEvent* ev);
	virtual int imli_status_start(iml_inst* inst, XEvent* ev);
	virtual int imli_status_draw(iml_inst* inst, XEvent* ev);
	virtual int imli_status_done(iml_inst* inst, XEvent* ev);
	virtual int imli_lookup_start(iml_inst* inst, XEvent* ev);
	virtual int imli_lookup_draw(iml_inst* inst, XEvent* ev);
	virtual int imli_lookup_process(iml_inst* inst, XEvent* ev);
	virtual int imli_lookup_done(iml_inst* inst, XEvent* ev);
	virtual int imli_aux_start(iml_inst* inst, XEvent* ev);
	virtual int imli_aux_draw(iml_inst* inst, XEvent* ev);
	virtual int imli_aux_done(iml_inst* inst, XEvent* ev);
	virtual int imli_key_info(iml_inst* inst, XEvent* ev);
	virtual int imli_put_queue(iml_inst* inst, XEvent* ev);
        virtual Bool openSession(char *);
	iml_session_t* getActiveSession();
        Bool engineSwitch(XEvent *); 
        ImChain getImChain();
        IMList<ImlSession> session_list;
        ImlSession* active_session;
	IMLGlue imlg;
        static Converter* converter;
        static LocaleService * loc;
    private :
        int init_label();
	static XIMText label_text[26];
  	static int num_of_labels;

        // for lookup draw
	LookupChoice *choice;

	const int SC_LOOKUP_NCOLS;
	const int SC_LOOKUP_NROWS;

	HttRec *htt;
};

#endif // _iml_session_hh_ 
