/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "sunim.hh"
#include "svrimprotohandler.hh"

SvrIMProtoHandler::SvrIMProtoHandler(Itt* p_itt)
{
 itt = p_itt;
}

SvrIc *
SvrIMProtoHandler::getSvrIc(InputContext *ic)
{
  IMArg args[1];
  SvrIc *tmp_ic = (SvrIc *)0;
  args[0].id = 1010;
  ic->get_icvalues(args, 1);
  tmp_ic = (SvrIc *)args->value;
  
  return (SvrIc *)tmp_ic;
}
 
int
SvrIMProtoHandler::CreateIC(InputContext *ic)
{
  SvrIc *svric = (SvrIc *)0;
  IMArg args[2];
  int n = 0;
  
  svric = new SvrIc(itt, ic);
  args[n].id = 1010;
  args[n].value = (char*)svric; n++;
  ic->set_icvalues(args, n);
  return(1);
}

int
SvrIMProtoHandler::RealizeIC(InputContext *ic)
{
  int ret_val = 0;
  SvrIc *svric = getSvrIc(ic);

  ret_val = svric->realizeIC();
  return(ret_val);
}

int
SvrIMProtoHandler::DestroyIC(InputContext *ic)
{
  SvrIc *svric = getSvrIc(ic);
  IMArg args[2];
  int n = 0;

  delete svric;
  args[n].id = 1010;
  args[n].value = (char*)0; n++;
  ic->set_icvalues(args, n);
  return(1);
}

int
SvrIMProtoHandler::SetICFocus(InputContext *ic)
{
  int ret_val = 0;
  SvrIc *svric = getSvrIc(ic);
  ret_val = svric->setICFocus();
  return(ret_val);
}

int
SvrIMProtoHandler::UnsetICFocus(InputContext *ic)
{
  int ret_val = 0;
  SvrIc *svric = getSvrIc(ic);
  ret_val = svric->unsetICFocus();
  return(ret_val);
}

IMText *
SvrIMProtoHandler::ResetIC(InputContext *ic)
{
  IMText * text = (IMText *)0;
  SvrIc *svric = getSvrIc(ic);
  text = svric->resetIC();
  return (IMText *)text;
}

int
SvrIMProtoHandler::StartConversion(InputContext *ic)
{
  int ret_val = 0;
  SvrIc *svric = getSvrIc(ic);
  ret_val = svric->startConversion();
  return(ret_val);
}

int
SvrIMProtoHandler::EndConversion(InputContext *ic)
{
  int ret_val = 0;
  SvrIc *svric = getSvrIc(ic);
  ret_val = svric->endConversion();
  return(ret_val);
}

int
SvrIMProtoHandler::GetICValues(InputContext *ic, IMArg *args, int n)
{
  int ret_val = 0;
  SvrIc *svric = getSvrIc(ic);
  ret_val = svric->getICValues();
  return(ret_val);
}

int
SvrIMProtoHandler::SetICValues(InputContext *ic, IMArg *args, int n)
{
  int ret_val = 0;
  SvrIc *svric = getSvrIc(ic);
  ret_val = svric->setICValues();
  return(ret_val);
}

int
SvrIMProtoHandler::ForwardEvent(InputContext* ic, IMInputEvent* ev)
{
  int ret_val = 0;
  SvrIc *svric = getSvrIc(ic);
  ret_val = svric->forwardEvent(ev);
  return(ret_val);
}

int
SvrIMProtoHandler::ForwardXEvent(IMInputEvent* ev)
{
  LEInterface::BC_xsunim_filterevent(ev);
  return(0);
}
