/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <signal.h>
#include <sys/wait.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <unistd.h>
#include <fcntl.h>

#include "IMSystem.hh"
#include "SystemMessage.h"

static pid_t htt_master_pid = 0;
static pid_t htt_server_pid = 0;

mutex_t IMSystem::immutex;	// static init. will do
int IMSystem::hold_count = 0;

/*************************************************************************
 * Signal handler for the main process.
 *************************************************************************/
static void
htt_slave_dead(int dummy)
{
    int         status;
    static Bool wrapper = True;

    sighold(dummy);

    /*
     * when the htt main is dead
     */
    if (waitpid(htt_server_pid, &status, WNOHANG) == htt_server_pid){
        waitpid(htt_server_pid, &status, 0);
    }
    /*
     * when the watch dog is dead
     */
    else if (htt_master_pid == getpid()) {
        sigsend(P_PID, htt_server_pid, SIGTERM);
        _exit(0);
    }
    else if (htt_server_pid == getpid()) {
        _exit(0);
    }
    else {
      system_message(MSG_ERROR, "Unexpected signal received.\n");
/*      fprintf(stderr, "Unexpected signal received.\n"); */
    }
    sigrelse(dummy);
    return;
}


void
IMSystem::sleep(unsigned int seconds)
{
  ::sleep(seconds);
}

int 
IMSystem::begin_im_transaction() {
   block_signal_handler();
   int ret_val = lock();
   return ret_val;
}

int
IMSystem::end_im_transaction() {
   resume_signal_handler();
   int ret_val = unlock();
   return ret_val;
}

void
IMSystem::block_signal_handler()
{
  if (hold_count == 0) {
     sighold(SIGTERM);
  }
  hold_count++;
  return;
}

void
IMSystem::resume_signal_handler()
{
  hold_count--;
  if (hold_count == 0) {
     sigrelse(SIGTERM);
  }
  return;
}

int
IMSystem::lock() {
  return mutex_lock(&immutex);
} 

int
IMSystem::unlock() {
  return mutex_unlock(&immutex);
}
