/*
 * @(#)aux_win.c	1.5 99/09/07
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#include <stdio.h>
#include <stdlib.h>
#include <locale.h>
#include <limits.h>
#include <X11/Xmd.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/RepType.h>
#include <Xm/DialogS.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/MwmUtil.h>

#include <fcntl.h>
#include "gif_lib.h"
#include "getarg.h"

#define IMAGE_PATH "/usr/lib/im/locale/zh_CN/newpy/"

Pixmap LoadGIFFile(char * filename);
static void AllocateColors1(void);
static void AllocateColors2(void);

void ProcessInitialPropertyNotify(void);

#define ABS(x)          ((x) > 0 ? (x) : (-(x)))

/* Global Declarations */

#define HTT_AUX_EXT_NAME        "sample_ext"
#define HTT_AUX_SO_NAME         "sample_so"
#define HTT_AUX_PROP_NAME       "sample_prop"
#define HTT_AUX_PROP1_NAME      "sample_prop1"

Atom    aux_so_atom;
Atom    aux_ext_atom;
Atom    aux_prop_atom;
Atom    aux_prop1_atom;

int             icid;
int             imid;

Window  aux_window;

XtAppContext app_context = (XtAppContext) 0 ;
Display     *display     = (Display *)    0 ;
Widget      toplevel;

static int screen;
static GC gc;
static Colormap colormap;
static long XPixelTable[256];
static XColor XColorTable[256];
static Visual *XVisual;
static ColorMapObject *ColorMap;

Widget cascade1 = (Widget)NULL;

int input_mode = 13, quanjiao_mode = 0, gbk_mode = 0;

static char *button_names[17] = {
	"Math     ",
       	"Digital1 ",
       	"Digital2 ",
       	"Digital3 ",
       	"Roman    ",
       	"Greek    ",
       	"Russia   ",
       	"PY Symbol",
       	"Japanese1",
       	"Japanese2",
       	"Table1   ",
       	"Table2   ",
       	"Other    ",
       	"QuanPin  ",
	"ShuangPin",
       	"ASCII    ",
       	0 };

void symbolchange ( Widget w, int client_data, XtPointer call_data ) {
	Arg al[20];
	int ac;

	XmAnyCallbackStruct *   cb;
        char                    p[4];
        Display *               display;
        Window                  w_so;
        unsigned char           buf[1024];
        int                     size;

	ac = 0;
	XtSetArg(al[ac], XmNlabelString, 
		(XmString) XmStringCreateSimple(button_names[client_data])); ac++;
	XtSetValues(cascade1, al, ac);

	input_mode = client_data;
	p[1] = input_mode + 'a';
	p[0] = quanjiao_mode + 'a';
	p[2] = gbk_mode + 'a';
	p[3] = '\0';
	
        display = XtDisplay(w);
        cb = (XmAnyCallbackStruct *)call_data;

        if (None == (w_so = XGetSelectionOwner(display, aux_so_atom))) {
                return;
        }

        buf[0] = ((imid & 0xff00) >> 8);
        buf[1] = ((imid & 0x00ff) >> 0);
        buf[2] = ((icid & 0xff00) >> 8);
        buf[3] = ((icid & 0x00ff) >> 0);
        size = strlen(p);
        if (((sizeof (buf)) - 4) < size) {
                size = ((sizeof (buf)) - 4);
        }
        memcpy(buf + 4, p, size);
        XChangeProperty(display, w_so, aux_prop_atom, XA_STRING,
                        8, PropModeReplace, buf, size + 4);

        XFree(p);
}

void quanjiaochange ( Widget w, XtPointer client_data, XtPointer call_data )
{
	static Pixmap quanjiao_img = (Pixmap) 0, banjiao_img = (Pixmap) 0;
	static int first = 1;
	char image_path[100];
	XmAnyCallbackStruct *   cb;
        char                    p[4];
        Display *               display;
        Window                  w_so;
        unsigned char           buf[1024];
        int                     size;

	Arg al[20];
	int ac;

	if( !quanjiao_img && !banjiao_img ) {
		strcpy(image_path, IMAGE_PATH);
		strcat(image_path, "full.gif");
		quanjiao_img = LoadGIFFile(image_path);
		strcpy(image_path, IMAGE_PATH);
		strcat(image_path, "half.gif");
		banjiao_img = LoadGIFFile(image_path);
		quanjiao_mode = 0;
	}
	else quanjiao_mode = 1 - quanjiao_mode;

	ac = 0;
	XtSetArg(al[ac], XmNlabelType, XmPIXMAP); ac++;
	if (!quanjiao_mode) XtSetArg(al[ac], XmNlabelPixmap, (Pixmap) quanjiao_img);
	else  XtSetArg(al[ac], XmNlabelPixmap, (Pixmap) banjiao_img); 
	ac++;
	XtSetValues(w, al, ac);

	if (first) {
		first = 0;
		return;
	}

	p[1] = input_mode + 'a';
	p[0] = quanjiao_mode + 'a';
	p[2] = gbk_mode + 'a';
	p[3] = '\0';

        display = XtDisplay(w);
        cb = (XmAnyCallbackStruct *)call_data;

        if (None == (w_so = XGetSelectionOwner(display, aux_so_atom))) {
                return;
        }

        buf[0] = ((imid & 0xff00) >> 8);
        buf[1] = ((imid & 0x00ff) >> 0);
        buf[2] = ((icid & 0xff00) >> 8);
        buf[3] = ((icid & 0x00ff) >> 0);
        size = strlen(p);
        if (((sizeof (buf)) - 4) < size) {
                size = ((sizeof (buf)) - 4);
        }
        memcpy(buf + 4, p, size);
        XChangeProperty(display, w_so, aux_prop_atom, XA_STRING,
                        8, PropModeReplace, buf, size + 4);

        XFree(p);
}

void charsetchange ( Widget w, XtPointer client_data, XtPointer call_data )
{
        static Pixmap gb_img = (Pixmap) 0, gbk_img = (Pixmap) 0;
	char image_path[100];
	static int first = 1;
	XmAnyCallbackStruct *   cb;
        char                    p[4];
        Display *               display;
        Window                  w_so;
        unsigned char           buf[1024];
        int                     size;
        Arg al[20];
        int ac;

        if(!gb_img && !gbk_img ) {
		strcpy(image_path, IMAGE_PATH);
		strcat(image_path, "gb.gif");
                gb_img = LoadGIFFile(image_path);
		strcpy(image_path, IMAGE_PATH);
		strcat(image_path, "gbk.gif");
                gbk_img = LoadGIFFile(image_path);
                gbk_mode = 0;
        }
        else gbk_mode = 1 - gbk_mode;

        ac = 0;
        XtSetArg(al[ac], XmNlabelType, XmPIXMAP); ac++;
        if (gbk_mode) XtSetArg(al[ac], XmNlabelPixmap, (Pixmap) gbk_img);
        else XtSetArg(al[ac], XmNlabelPixmap, (Pixmap) gb_img); 
	ac++;
        XtSetValues(w, al, ac);

	if (first) {
		first = 0;
		return;
	}

	p[1] = input_mode + 'a';
	p[0] = quanjiao_mode + 'a';
	p[2] = gbk_mode + 'a';
	p[3] = '\0';
	
        display = XtDisplay(w);
        cb = (XmAnyCallbackStruct *)call_data;

        if (None == (w_so = XGetSelectionOwner(display, aux_so_atom))) {
                return;
        }

        buf[0] = ((imid & 0xff00) >> 8);
        buf[1] = ((imid & 0x00ff) >> 0);
        buf[2] = ((icid & 0xff00) >> 8);
        buf[3] = ((icid & 0x00ff) >> 0);
        size = strlen(p);
        if (((sizeof (buf)) - 4) < size) {
                size = ((sizeof (buf)) - 4);
        }
        memcpy(buf + 4, p, size);
        XChangeProperty(display, w_so, aux_prop_atom, XA_STRING,
                        8, PropModeReplace, buf, size + 4);

        XFree(p);
}

void createGUI (Widget parent)
{
	int i;
        Arg al[64];           /* Arg List */
        int ac = 0;           /* Arg Count */
	char image_path[100];

        Widget children[16];      /* Children to manage */

        Widget rowcol1 = (Widget)NULL;
        Widget menuBar1 = (Widget)NULL;
        Widget menu1 = (Widget)NULL;

        Widget button[16]; 
        Widget button16 = (Widget)NULL;
        Widget button17 = (Widget)NULL;
        Widget button18 = (Widget)NULL;



	for(i = 0; i < 16; i ++) button[i] = (Widget) NULL;

        ac = 0;
        XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
/*        XtSetArg(al[ac], XmNpacking, XmPACK_COLUMN); ac++;*/
        XtSetArg(al[ac], XmNentryAlignment, XmALIGNMENT_CENTER); ac++;
        rowcol1 = XmCreateRowColumn ( parent, "rowcol1", al, ac );

        ac = 0;
        menuBar1 = XmCreateMenuBar ( rowcol1, "menuBar1", al, ac );

	ac = 0;
        cascade1 = XmCreateCascadeButton ( menuBar1, "QuanPin  ", al, ac );

	ac = 0;
        menu1 = XmCreatePulldownMenu ( menuBar1, "menu1", al, ac );

	for(i = 0; i < 16; i ++){
		ac = 0;
	        button[i] = XmCreatePushButton ( menu1, button_names[i], al, ac );
		XtAddCallback(button[i], XmNactivateCallback, symbolchange, i);
	}

	ac = 0;
        button16 = XmCreatePushButton ( rowcol1, "qjmode", al, ac );
	XtAddCallback(button16, XmNactivateCallback, quanjiaochange, NULL);
	quanjiaochange(button16, NULL, NULL);

	ac = 0;
        button17 = XmCreatePushButton ( rowcol1, "gbkmode", al, ac );
	XtAddCallback(button17, XmNactivateCallback, charsetchange, NULL);
	charsetchange(button17, NULL, NULL);

	ac = 0;
        XtSetArg(al[ac], XmNlabelType, XmPIXMAP); ac++;
	strcpy(image_path, IMAGE_PATH);
	strcat(image_path, "help.gif");
        XtSetArg(al[ac], XmNlabelPixmap, (Pixmap)LoadGIFFile(image_path)); ac++;
        button18 = XmCreatePushButton ( rowcol1, "help", al, ac );

	ac = 0;
	for( i = 0; i < 16; i ++ ) children[ac++] = button[i];
        XtManageChildren(children, ac);

        ac = 0;
        XtSetArg(al[ac], XmNsubMenuId, menu1); ac++;
        XtSetValues(cascade1, al, ac );

        ac = 0;
        children[ac++] = cascade1;
        XtManageChildren(children, ac);

        ac = 0;
        children[ac++] = menuBar1;
        children[ac++] = button16;
        children[ac++] = button17;
        children[ac++] = button18;
        XtManageChildren(children, ac);

        XtManageChild ( rowcol1);
}

int main(int argc, char **argv)
{
	Arg al[64];
	int ac;
	char            atom_name[1024];

	/* Enable Localisation of the Application */
	setlocale(LC_ALL, NULL);

	XtSetLanguageProc((XtAppContext) 0, (XtLanguageProc) 0, (XtPointer) 0) ;

	ac = 0;
	XtSetArg(al[ac], XmNmwmDecorations, MWM_DECOR_BORDER | MWM_DECOR_TITLE); ac++;
	toplevel = XtAppInitialize(&app_context, "aux", NULL, 0,
                                   &argc, argv, NULL, al, ac);

	ac = 0;
	XtSetArg(al[ac], XmNallowShellResize, False); ac++;
	XtSetValues(toplevel, al, ac);

	display = XtDisplay(toplevel);

	screen = DefaultScreen(display);
	colormap = DefaultColormap(display, screen);
	gc = DefaultGC(display, screen);

	sprintf(atom_name, "htt_%s_%s", *(argv + 0), HTT_AUX_EXT_NAME);
        aux_ext_atom = XInternAtom(display, atom_name, False);
        sprintf(atom_name, "htt_%s_%s", *(argv + 0), HTT_AUX_SO_NAME);
        aux_so_atom = XInternAtom(display, atom_name, False);
        sprintf(atom_name, "htt_%s_%s", *(argv + 0), HTT_AUX_PROP_NAME);
        aux_prop_atom = XInternAtom(display, atom_name, False);
        sprintf(atom_name, "htt_%s_%s", *(argv + 0), HTT_AUX_PROP1_NAME);
        aux_prop1_atom = XInternAtom(display, atom_name, False);

        if (None != XGetSelectionOwner(display, aux_ext_atom)) {
                exit(1);
        }

	createGUI(toplevel);

	XtRealizeWidget(toplevel);

        aux_window = XtWindow(toplevel);

        if (None != XGetSelectionOwner(display, aux_ext_atom)) {
                exit(1);
        }
        XSetSelectionOwner(display, aux_ext_atom, aux_window, CurrentTime);
        if (aux_window != XGetSelectionOwner(display, aux_ext_atom)) {
                exit(1);
        }

/*
        XtAddEventHandler(toplevel, PropertyChangeMask, False,
                          AuxEventHandler, NULL);

        XtAddEventHandler(toplevel, NoEventMask, True,
                          AuxEventHandler, NULL);
*/

        ProcessInitialPropertyNotify();

	XtAppMainLoop (app_context);
}

void
ProcessInitialPropertyNotify(void)
{
        Display *               display;
        long                    long_length;
        Atom                    actual_type_return;
        int                     actual_format_return;
        unsigned long           nitem_return;
        unsigned long           bytes_after_return;
        unsigned char *         prop_return;
        int                     r;
        XTextProperty           text_prop;
        Window                  w_so;
        char                    buf[1024];
        int                     len;

        display = XtDisplay(toplevel);

        if (None == (w_so = XGetSelectionOwner(display, aux_so_atom))) {
                return;
        }


        r = XGetWindowProperty(display, w_so,
                               aux_prop1_atom, 0, INT_MAX, True,
                               AnyPropertyType, &actual_type_return,
                               &actual_format_return, &nitem_return,
                               &bytes_after_return, &prop_return);
        if (Success != r) {
                return;
        }

        switch (actual_type_return) {
        case XA_STRING:
                imid = *((CARD16 *)(prop_return + 0));
                icid = *((CARD16 *)(prop_return + 2));
/*
                len = (((nitem_return - 4) < (sizeof (buf))) ?
                       (nitem_return - 4) : ((sizeof (buf)) - 1));
                memcpy(buf, prop_return + 4, len);
                buf[len] = '\0';
                XmTextSetString(input, buf);
*/
                break;
        case XA_INTEGER:
                break;
        }

        XFree(prop_return);
        return;
}


/* Make some variables global, so we could access them faster: */

static int
    ColorMapSize = 0,
    InterlacedOffset[] = { 0, 4, 2, 1 }, /* The way Interlaced image should. */
    InterlacedJumps[] = { 8, 8, 4, 2 };    /* be read - offsets and jumps... */

Pixmap LoadGIFFile(char* filename)
{
    int i, j, x, y;
    int Error, ImageNum = 0, Size, Row, Col, Width, Height, ExtCode, Count;
    int ForceFlag = FALSE;

    char *XImageData;
    XImage *XImageBuffer;
    Pixmap pixmap;
    GifFileType *GifFile;
    GifRowType *ScreenBuffer;
    GifRecordType RecordType;
    GifByteType *Extension;

    if ((GifFile = DGifOpenFileName(filename)) == NULL) {
            PrintGifError();
            exit(-1);
    }	

    if ((ScreenBuffer = (GifRowType *)
        malloc(GifFile->SHeight * sizeof(GifRowType *))) == NULL) {
            printf("Failed to allocate memory required, aborted.");
	    exit(1);
	}

    Size = GifFile->SWidth * sizeof(GifPixelType);/* Size in bytes one row.*/
    if ((ScreenBuffer[0] = (GifRowType) malloc(Size)) == NULL) /* First row. */
        printf("Failed to allocate memory required, aborted.");

    for (i = 0; i < GifFile->SWidth; i++)  /* Set its color to BackGround. */
        ScreenBuffer[0][i] = GifFile->SBackGroundColor;
    for (i = 1; i < GifFile->SHeight; i++) {
        /* Allocate the other rows, and set their color to background too: */

        if ((ScreenBuffer[i] = (GifRowType) malloc(Size)) == NULL)
            printf("Failed to allocate memory required, aborted.");

        memcpy(ScreenBuffer[i], ScreenBuffer[0], Size);
    }

    /* Scan the content of the GIF file and load the image(s) in: */
    do {
        if (DGifGetRecordType(GifFile, &RecordType) == GIF_ERROR) {
            PrintGifError();
            exit(-1);
        }
        switch (RecordType) {
            case IMAGE_DESC_RECORD_TYPE:
                if (DGifGetImageDesc(GifFile) == GIF_ERROR) {
                    PrintGifError();
                    exit(-1);
                }
                Row = GifFile->Image.Top; /* Image Position relative to Screen. */
                Col = GifFile->Image.Left;
                Width = GifFile->Image.Width;
                Height = GifFile->Image.Height;
                if (GifFile->Image.Left + GifFile->Image.Width > GifFile->SWidth ||
                   GifFile->Image.Top + GifFile->Image.Height > GifFile->SHeight) {
                    fprintf(stderr, "Image %d is not confined to screen dimension, aborted.\n");
                    exit(-2);
                }
                if (GifFile->Image.Interlace) {
                    /* Need to perform 4 passes on the images: */
                    for (Count = i = 0; i < 4; i++)
                        for (j = Row + InterlacedOffset[i]; j<Row + Height;
                                                 j += InterlacedJumps[i]) {
                            if (DGifGetLine(GifFile, &ScreenBuffer[j][Col],
                                Width) == GIF_ERROR) {
                                PrintGifError();
                                exit(-1);
                            }
                        }
                }
                else {
                    for (i = 0; i < Height; i++) {
                        if (DGifGetLine(GifFile, &ScreenBuffer[Row++][Col],
                                Width) == GIF_ERROR) {
                            PrintGifError();
                            exit(-1);
                        }
                    }
                }
                break;
            case EXTENSION_RECORD_TYPE:
                /* Skip any extension blocks in file: */
                if (DGifGetExtension(GifFile, &ExtCode, &Extension) == GIF_ERROR) {
                    PrintGifError();
                    exit(-1);
                }
                while (Extension != NULL) {
                    if (DGifGetExtensionNext(GifFile, &Extension) == GIF_ERROR) {
                        PrintGifError();
                        exit(-1);
                    }
                }
                break;
            case TERMINATE_RECORD_TYPE:
                break;
            default:                /* Should be traps by DGifGetRecordType. */
                break;
        }
    }
    while (RecordType != TERMINATE_RECORD_TYPE);

    ColorMap = (GifFile->Image.ColorMap
                ? GifFile->Image.ColorMap
                : GifFile->SColorMap);
    ColorMapSize = ColorMap->ColorCount;

    /* The big trick here is to select the colors so lets do this first: */
    if (ForceFlag)
        AllocateColors2();
    else
        AllocateColors1();

    /* Create the image in X format: */
    if ((XImageData = (char *) malloc(GifFile->SWidth * GifFile->SHeight)) == NULL)
        printf("Failed to allocate memory required, aborted.");

    for (i = 0; i < GifFile->SHeight; i++) {
        y = i * GifFile->SWidth;
        for (j = 0; j < GifFile->SWidth; j++)
            XImageData[y + j] = XPixelTable[ScreenBuffer[i][j]];
    }
    XImageBuffer = XCreateImage(display, XVisual, 8, ZPixmap, 0,
                                XImageData, GifFile->SWidth, GifFile->SHeight,
                                8, GifFile->SWidth);

    pixmap = XCreatePixmap(display, RootWindow(display, screen), GifFile->SWidth, GifFile->SHeight,8);

    XPutImage(display, pixmap, gc, XImageBuffer,0,0,0,0,GifFile->SWidth, GifFile->SHeight);
    free(XImageData);
    XDestroyImage(XImageBuffer);

    return pixmap;
}

/******************************************************************************
* Routine to allocate the requested colors from the X server.                 *
* Colors are allocated until success by stripping off the least bits of the   *
* colors.                                                                     *
******************************************************************************/
static void AllocateColors1(void)
{
    int Strip, Msk, i, j;
    char Msg[80];

    for (i = 0; i < 256; i++)
        XPixelTable[i] = 0;        /* Put reasonable color for out of range. */

    for (Strip = 0, Msk = 0xff; Strip < 8; Strip++, Msk <<= 1) {
        for (i = 0; i < ColorMapSize; i++) {
            /* Prepere color entry in X format. */
            XColorTable[i].red = (ColorMap->Colors[i].Red & Msk) << 8;
            XColorTable[i].green = (ColorMap->Colors[i].Green & Msk) << 8;
            XColorTable[i].blue = (ColorMap->Colors[i].Blue & Msk) << 8;
            XColorTable[i].flags = DoRed | DoGreen | DoBlue;
            if (XAllocColor(display, colormap, &XColorTable[i]))
                XPixelTable[i] = XColorTable[i].pixel;
            else
                break;
        }
        if (i < ColorMapSize)
            XFreeColors(display, colormap, XPixelTable, i, 0L);
        else
            break;
    }

    if (Strip == 8)
        printf("Can not display the image - not enough colors available.");

    if (Strip != 0) {
        sprintf(Msg, "%d bits were stripped off the color map.", Strip);
        printf(Msg);
    }
}

/******************************************************************************
* Routine to allocate the requested colors from the X server.                 *
* Two stages are performed:                                                   *
* 1. Colors are requested directly.                                           *
* 2. If not enough colors can be allocated, the closest current color         *
*    in current table is selected instead.                                    *
* This allocation is not optimal as when fail to allocate all colors one      *
* should pick the right colors to do allocate in order to minimize the        *
* closest distance from the unallocated ones under some norm (what is a good  *
* norm for the RGB space?). Improve it if you are bored.                      *
******************************************************************************/
static void AllocateColors2(void)
{
    int i, j, Index = 0, Count = 0, XNumOfColors;
    char Msg[80];
    unsigned long D, Distance, AvgDistance = 0, Red, Green, Blue;
    GifBooleanType Failed = FALSE;
    XColor *XOldColorTable;

    for (i = 0; i < 256; i++) {
        if (i < ColorMapSize) {          /* Prepere color entry in X format. */
            XColorTable[i].red = ColorMap->Colors[i].Red << 8;
            XColorTable[i].green = ColorMap->Colors[i].Green << 8;
            XColorTable[i].blue = ColorMap->Colors[i].Blue << 8;
            XColorTable[i].flags = DoRed | DoGreen | DoBlue;
            XPixelTable[i] = -1;                       /* Not allocated yet. */
        }
        else
            XPixelTable[i] = 0;    /* Put reasonable color for out of range. */
    }

    for (i = 0; i < ColorMapSize; i++)        /* Allocate the colors from X: */
        if (XAllocColor(display, colormap, &XColorTable[i]))
            XPixelTable[i] = XColorTable[i].pixel;
        else
            Failed = TRUE;

    if (Failed) {
        XNumOfColors = DisplayCells(display, screen);
        XOldColorTable = (XColor *) malloc(sizeof(XColor) * XNumOfColors);
        for (i = 0; i < XNumOfColors; i++) XOldColorTable[i].pixel = i;
        XQueryColors(display, colormap, XOldColorTable, XNumOfColors);

        for (i = 0; i < ColorMapSize; i++) {
            /* Allocate closest colors from X: */
            if (XPixelTable[i] == -1) {      /* Failed to allocate this one. */
                Distance = 0xffffffff;

                Red = XColorTable[i].red;
                Green = XColorTable[i].green;
                Blue = XColorTable[i].blue;

                for (j = 0; j < XNumOfColors; j++) {
                    /* Find the closest color in 3D RGB space using L1 norm. */
                    if ((D = ABS(Red - XOldColorTable[j].red) +
                             ABS(Green - XOldColorTable[j].green) +
                             ABS(Blue - XOldColorTable[j].blue)) < Distance) {
                        Distance = D;
                        Index = j;
                    }
                }
                XPixelTable[i] = Index;

                AvgDistance += Distance;
                Count++;
            }
        }
        free(XOldColorTable);

        sprintf(Msg, "Colors will be approximated (average error = %d).\n",
                AvgDistance / Count);
        printf(Msg);
    }
}

