/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifdef	WIN32
#include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "SunIM.h"

Bool if_sampleja2_OpenIF(iml_if_t *);
Bool if_sampleja2_CloseIF(iml_if_t *);
Bool if_sampleja2_GetIFValue(iml_if_t *, IMArgList, int);
Bool if_sampleja2_SetIFValue(iml_if_t *, IMArgList, int);
Bool if_sampleja2_OpenDesktop(iml_desktop_t *, IMArgList, int);
Bool if_sampleja2_CloseDesktop(iml_desktop_t *);
Bool if_sampleja2_CreateSC(iml_session_t *, IMArgList, int);
Bool if_sampleja2_DestroySC(iml_session_t *);
Bool if_sampleja2_GetSCValue(iml_session_t *, IMArgList, int);
Bool if_sampleja2_SetSCValue(iml_session_t *, IMArgList, int);
IMText *if_sampleja2_ResetSC(iml_session_t *);
void if_sampleja2_SetSCFocus(iml_session_t *);
void if_sampleja2_UnsetSCFocus(iml_session_t *);
void if_sampleja2_SendEvent(iml_session_t *, IMInputEvent * ev);

/* IF Method */
if_methods_t sampleja_methods = {
    if_sampleja2_OpenIF,
    if_sampleja2_CloseIF,
    if_sampleja2_GetIFValue,
    if_sampleja2_SetIFValue,
    if_sampleja2_OpenDesktop,
    if_sampleja2_CloseDesktop,
    if_sampleja2_CreateSC,
    if_sampleja2_DestroySC,
    if_sampleja2_GetSCValue,
    if_sampleja2_SetSCValue,
    if_sampleja2_ResetSC,
    if_sampleja2_SetSCFocus,
    if_sampleja2_UnsetSCFocus,
    if_sampleja2_SendEvent
};

UTFCHAR lename_string[] = {0x30b5, 0x30f3, 0x30d7, 0x30eb, 0x65e5, 0x672c, 0x8a9e, 0x30a8, 0x30f3, 0x30b8, 0x30f3, 0x0};
UTFCHAR jahrn_string[] = {0x65e5, 0x672c, 0x8a9e, 0x0};

static IMLEName lename = {
    "sampleja2", lename_string	/* LE id, HRN */
};

static IMLocale locales[] = {
    {"ja", jahrn_string},	/* locale id, HRN */
    NULL
};


extern "C" {

#ifdef	WIN32
#define EXPORT extern __declspec(dllexport)

EXPORT
#endif

void
if_GetIfInfo(
    IMArgList args,
    int num_args
)
{
    int i;
    for (i = 0; i < num_args; i++, args++) {
        switch (args->id) {
            case IF_VERSION:
                args->value = (IMArgVal) "1.2";
                break;
            case IF_METHOD_TABLE:
                args->value = (IMArgVal) & sampleja_methods;
                break;
            case IF_LE_NAME:
                args->value = (IMArgVal) & lename;
                break;
            case IF_SUPPORTED_LOCALES:
                args->value = (IMArgVal) & locales;
                break;
            case IF_NEED_THREAD_LOCK:
                args->value = (IMArgVal) False;
                break;
            default:
                break;
            }
    }
}

}

static int UTFCHARCpy(UTFCHAR *, UTFCHAR *);
static int UTFCHARLen(UTFCHAR *);
static IMFeedbackList *create_feedback(iml_session_t * s, int size);
static void my_conversion_on(iml_session_t *);
static void my_conversion_off(iml_session_t *);

#define	DEBUG

Bool
if_sampleja2_OpenIF(
    iml_if_t * If
)
{
#ifdef	DEBUG
    printf("if_sampleja2_OpenIF()\n");
    printf("	If=[%x]\n", If);
    printf("	locale=[%s]\n", If->locale);
    printf("	if_name=[%s]\n", If->if_name);
#endif
    return True;
}

Bool
if_sampleja2_CloseIF(
    iml_if_t * If
)
{
#ifdef	DEBUG
    printf("if_sampleja2_CloseIF()\n");
    printf("	If=[%x]\n", If);
    printf("	locale=[%s]\n", If->locale);
    printf("	if_name=[%s]\n", If->if_name);
#endif
    return True;
}

Bool
if_sampleja2_GetIFValue(
    iml_if_t * If,
    IMArgList args,
    int num_args
)
{
#ifdef	DEBUG
    printf("if_sampleja2_GetIFValue()\n");
    printf("	If=[%x]\n", If);
    printf("	locale=[%s]\n", If->locale);
    printf("	if_name=[%s]\n", If->if_name);
#endif
    return True;
}

Bool
if_sampleja2_SetIFValue(
    iml_if_t * If,
    IMArgList args,
    int num_args
)
{
    int i;
#ifdef	DEBUG
    printf("if_sampleja2_SetIFValue()\n");
    printf("	If=[%x]\n", If);
    printf("	locale=[%s]\n", If->locale);
    printf("	if_name=[%s]\n", If->if_name);
#endif
    return True;
}

Bool
if_sampleja2_OpenDesktop(
    iml_desktop_t * desktop,
    IMArgList args,
    int num_args
)
{
#ifdef	DEBUG
    printf("if_sampleja2_OpenDesktop()\n");
    printf("	If=[%x]\n", desktop->If);
    printf("	desktop=[%x]\n", desktop);
    printf("	locale=[%s]\n", desktop->If->locale);
    printf("	if_name=[%s]\n", desktop->If->if_name);
    printf("	USER:%s\n", desktop->user_name);
    printf("	HOST:%s\n", desktop->host_name);
    printf("	DISPLAY:%s\n", desktop->display_id);
#endif
    return True;
}

Bool
if_sampleja2_CloseDesktop(
    iml_desktop_t * desktop
)
{
#ifdef	DEBUG
    printf("if_sampleja2_CloseDesktop()\n");
    printf("	If=[%x]\n", desktop->If);
    printf("	desktop=[%x]\n", desktop);
    printf("	locale=[%s]\n", desktop->If->locale);
    printf("	if_name=[%s]\n", desktop->If->if_name);
    printf("	USER:%s\n", desktop->user_name);
    printf("	HOST:%s\n", desktop->host_name);
    printf("	DISPLAY:%s\n", desktop->display_id);
#endif
    return True;
}

Bool
if_sampleja2_CreateSC(
    iml_session_t *s,
    IMArgList args,
    int num_args
)
{
    iml_desktop_t *desktop = s->desktop;
#ifdef	DEBUG
    printf("if_sampleja2_CreateSC()\n");
    printf("	If=[%x]\n", desktop->If);
    printf("	desktop=[%x]\n", desktop);
    printf("	locale=[%s]\n", desktop->If->locale);
    printf("	if_name=[%s]\n", desktop->If->if_name);
    printf("	USER:%s\n", desktop->user_name);
    printf("	HOST:%s\n", desktop->host_name);
    printf("	DISPLAY:%s\n", desktop->display_id);
#endif
    return True;
}

Bool
if_sampleja2_DestroySC(
    iml_session_t * s
)
{
#ifdef	DEBUG
    printf("if_sampleja2_DestroySC(s=%x)\n", s);
    printf("	s=[%x]\n", s);
    printf("	If=[%x]\n", s->desktop->If);
    printf("	desktop=[%x]\n", s->desktop);
    printf("	locale=[%s]\n", s->desktop->If->locale);
    printf("	if_name=[%s]\n", s->desktop->If->if_name);
    printf("	USER:%s\n", s->desktop->user_name);
    printf("	HOST:%s\n", s->desktop->host_name);
#endif
    return True;
}

Bool
if_sampleja2_GetSCValue(
    iml_session_t * s,
    IMArgList args,
    int num_args
)
{
    int i;
    IMArg *p = args;
    
    static int charsubset[] = {
        67,			/* LATIN */
        47,			/* HIRAGANA */
        48,			/* KATAKANA */
        71,			/* KANJI */
        0
    };
    
#ifdef	DEBUG
    printf("if_sampleja2_GetSCValue(s=%x)\n", s);
    printf("	s=[%x]\n", s);
    printf("	If=[%x]\n", s->desktop->If);
    printf("	desktop=[%x]\n", s->desktop);
    printf("	locale=[%s]\n", s->desktop->If->locale);
    printf("	if_name=[%s]\n", s->desktop->If->if_name);
    printf("	USER:%s\n", s->desktop->user_name);
    printf("	HOST:%s\n", s->desktop->host_name);
#endif
    for (i = 0; i < num_args; i++, p++) {
        switch (p->id) {
            case SC_SUPPORTED_CHARACTER_SUBSETS:
                /* specify CHARACTER_SUBSETS */
                p->value = (IMArgVal) charsubset;
                break;
            default:
                break;
            }
    }
    return True;
}

UTFCHAR on_string[] = {0x65e5, 0x672c, 0x8a9e, 0x30aa, 0x30f3, 0};
UTFCHAR off_string[] = {0x65e5, 0x672c, 0x8a9e, 0x30aa, 0x30d5, 0};

static void
my_conversion_on(
    iml_session_t * s
)
{
    iml_inst *lp;
    iml_inst *rrv = NULL;
    
    lp = s->If->m->iml_make_start_conversion_inst(s);
    s->If->m->iml_link_inst_tail(&rrv, lp);

    IMText *p = (IMText *) s->If->m->iml_new(s, sizeof(IMText));
    p->encoding = UTF16_CODESET;
    p->char_length = UTFCHARLen(on_string);
    p->text.utf_chars = (UTFCHAR *) s->If->m->iml_new(s, sizeof(UTFCHAR) * (p->char_length + 1));
    UTFCHARCpy(p->text.utf_chars, on_string);
    p->feedback = create_feedback(s, p->char_length);

    lp = s->If->m->iml_make_status_draw_inst(s, p);
    s->If->m->iml_link_inst_tail(&rrv, lp);

    s->If->m->iml_execute(s, &rrv);
}

static void
my_conversion_off(
    iml_session_t * s
)
{
    iml_inst *lp;
    iml_inst *rrv = NULL;
    
    lp = s->If->m->iml_make_end_conversion_inst(s);

    s->If->m->iml_link_inst_tail(&rrv, lp);

    IMText *p = (IMText *) s->If->m->iml_new(s, sizeof(IMText));
    p->encoding = UTF16_CODESET; 
    p->char_length = UTFCHARLen(off_string);
    p->text.utf_chars = (UTFCHAR *) s->If->m->iml_new(s, sizeof(UTFCHAR) * (p->char_length + 1));
    UTFCHARCpy(p->text.utf_chars, off_string);
    p->feedback = create_feedback(s, p->char_length);

    lp = s->If->m->iml_make_status_draw_inst(s, p);
    s->If->m->iml_link_inst_tail(&rrv, lp);

    s->If->m->iml_execute(s, &rrv);
}

Bool
if_sampleja2_SetSCValue(
    iml_session_t * s,
    IMArgList args,
    int num_args
)
{
    int i;
    IMArg *p = args;
#ifdef	DEBUG
    printf("if_sampleja2_SetSCValue()\n");
    printf("	s=[%x]\n", s);
    printf("	If=[%x]\n", s->desktop->If);
    printf("	desktop=[%x]\n", s->desktop);
    printf("	locale=[%s]\n", s->desktop->If->locale);
    printf("	if_name=[%s]\n", s->desktop->If->if_name);
    printf("	USER:%s\n", s->desktop->user_name);
    printf("	HOST:%s\n", s->desktop->host_name);
#endif
    for (i = 0; i < num_args; i++, p++) {
        switch (p->id) {
            case SC_TRIGGER_ON_NOTIFY:
                printf("conversion on\n");
                my_conversion_on(s);
                break;
                
            case SC_TRIGGER_OFF_NOTIFY:
                printf("conversion off\n");
                my_conversion_off(s);
                break;
                
            case SC_REALIZE:
                break;
            default:
                break;
            }
    }
    return True;
}

IMText *
if_sampleja2_ResetSC(
    iml_session_t * s
)
{
#ifdef	DEBUG
    printf("if_sampleja2_ResetSC(s=%x)\n", s);
    printf("	s=[%x]\n", s);
    printf("	If=[%x]\n", s->desktop->If);
    printf("	desktop=[%x]\n", s->desktop);
    printf("	locale=[%s]\n", s->desktop->If->locale);
    printf("	if_name=[%s]\n", s->desktop->If->if_name);
    printf("	USER:%s\n", s->desktop->user_name);
    printf("	HOST:%s\n", s->desktop->host_name);
    printf("	DISPLAY:%s\n", s->desktop->display_id);
#endif
    return (IMText *) NULL;
}

void
if_sampleja2_SetSCFocus(
    iml_session_t * s
)
{
#ifdef	DEBUG
    printf("if_sampleja2_SetSCFocus()\n");
    printf("	s=[%x]\n", s);
    printf("	If=[%x]\n", s->desktop->If);
    printf("	desktop=[%x]\n", s->desktop);
    printf("	locale=[%s]\n", s->desktop->If->locale);
    printf("	if_name=[%s]\n", s->desktop->If->if_name);
    printf("	USER:%s\n", s->desktop->user_name);
    printf("	HOST:%s\n", s->desktop->host_name);
    printf("	DISPLAY:%s\n", s->desktop->display_id);
#endif
}

void
if_sampleja2_UnsetSCFocus(
    iml_session_t * s
)
{
#ifdef	DEBUG
    printf("if_sampleja2_UnsetSCFocus()\n");
    printf("	s=[%x]\n", s);
    printf("	If=[%x]\n", s->desktop->If);
    printf("	desktop=[%x]\n", s->desktop);
    printf("	locale=[%s]\n", s->desktop->If->locale);
    printf("	if_name=[%s]\n", s->desktop->If->if_name);
    printf("	USER:%s\n", s->desktop->user_name);
    printf("	HOST:%s\n", s->desktop->host_name);
    printf("	DISPLAY:%s\n", s->desktop->display_id);
#endif
}

void
if_sampleja2_SendEvent(
    iml_session_t * s,
    IMInputEvent * ev
)
{
#ifdef	DEBUG
    printf("if_sampleja2_SendEvent s=%x ev=%x\n", s, ev);
#endif
    if (ev) {
        if (ev->type == IM_EventKeyList) {
        } else if (ev->type == IM_EventString) {
		/* receive operation list */
		IMStringEvent *stringev=(IMStringEvent*)ev;
        } else if (ev->type == IM_EventAux) {
        } else if (ev->type == IM_EventString) {
        } else if (ev->type == IM_EventText) {
        }
    }
}

int
UTFCHARCpy(
    UTFCHAR * dest,
    UTFCHAR * original
)
{
    int i;
    for (i = 0; *original; i++) {
        *dest++ = *original++;
    }
    *dest = 0;
    return i;
}

int
UTFCHARLen(
    UTFCHAR * p
)
{
    int i;
    for (i = 0; *p; i++)
    p++;
    return i;
}

static IMFeedbackList *
create_feedback(
    iml_session_t * s,
    int size
)
{
    int i;
    IMFeedbackList *feedback, *fbl;
    IMFeedback *fb;

    if (s) {
        feedback = (IMFeedbackList *) s->If->m->iml_new(s, sizeof(IMFeedbackList) * size);
    } else {
        feedback = (IMFeedbackList *) calloc(1, sizeof(IMFeedbackList) * size);
    }
    for (i = 0; i < size; i++) {
        IMFeedbackList *fbl = &feedback[i];
        fbl->count_feedbacks = 1;
        if (s) {
            fb = fbl->feedbacks = (IMFeedback *) s->If->m->iml_new(s, sizeof(IMFeedback));
        } else {
            fb = fbl->feedbacks = (IMFeedback *) calloc(1, sizeof(IMFeedback));
        }
        memset(fbl->feedbacks, 0, sizeof(IMFeedback));
    }
    return feedback;
}
