/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/X.h>
#include <X11/Xmd.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "trace_message.h"

#include "xaux_common.h"
#include "xaux_ext_common.h"

#include "sampleja3_xaux.h"

/* Define Aux class */
xaux_class_t xaux_class = {
    "com.sun.sampleja3.PaletteAux", 1,
    (Window) 0, (Window) 0,
    (Atom) 0, (Atom) 0, (Atom) 0, (Atom) 0, (Atom) 0,
    NULL,
};

GtkWidget *button;
GtkWidget *entry;

GdkFilterReturn gdk_ext_event_handler(GdkXEvent *, GdkEvent *, gpointer);

static xaux_class_t *xc_ = 0;
static int im_ = 0;
static int ic_ = 0;

/* Event Handler */
GdkFilterReturn
gdk_ext_event_handler(GdkXEvent * gdk_xevent,
		      GdkEvent * event,
		      gpointer data)
{
    XEvent *xevent;
    xevent = (XEvent *) gdk_xevent;
    if (xevent->type == ClientMessage) {
	xaux_ext_process_client_message(GDK_DISPLAY(), (XClientMessageEvent *) xevent);
	return GDK_FILTER_REMOVE;
    }
    return GDK_FILTER_CONTINUE;
}

/* Method - Start */
Bool
xaux_ext_Start(
	       xaux_class_t * xc,
	       aux_ext_data_t * aux_ext_data)
{
    return True;
}

/* Method - Draw */
Bool
xaux_ext_Draw(
	      xaux_class_t * xc,
	      aux_ext_data_t * aux_ext_data)
{
    size_t i;
    char *sp;
    Bool rv = True;
    char buf[256];

    im_ = aux_ext_data->im;
    ic_ = aux_ext_data->ic;
    xc_ = xc;

    strncpy(buf, (const char *) aux_ext_data->aux_name,
	    aux_ext_data->aux_name_length);

    printf("ext_Draw[%s] im:0x%x, ic:0x%x\n",
	   buf, aux_ext_data->im, aux_ext_data->ic);


    for (i = 0; i < aux_ext_data->integer_count; i++) {
	printf("\tiv[%02d]=%d\n", i, aux_ext_data->integer_list[i]);
    }

    for (i = 0; i < aux_ext_data->string_count; i++) {
	printf("\tsv[%02d]=%s\n", i,
	       aux_ext_data->string_list[i].ptr);
    }

    if (aux_ext_data->integer_count == 1) {
	switch (aux_ext_data->integer_list[0]) {
	case SAMPLEJA3_AUXPALETTE_CONVON:
	    gtk_entry_set_text(GTK_ENTRY(entry), "Conversion ON");
	    break;
	case SAMPLEJA3_AUXPALETTE_CONVOFF:
	    gtk_entry_set_text(GTK_ENTRY(entry), "Conversion OFF");
	    break;
	case SAMPLEJA3_AUXPALETTE_HELPSTART:
printf("START!!!!!\n");
	    HelpInvoke("index.html");
	    break;
	}
    }
    return True;
}

/* Method - Done */
Bool
xaux_ext_Done(
	      xaux_class_t * xc,
	      aux_ext_data_t * aux_ext_data)
{
    return True;
}

void
callback(GtkWidget * widget,
	 gpointer data)
{
    int integers[5];
    char *strings[5];

    integers[0] = 1;
    integers[1] = 2;
    integers[2] = 3;
    integers[3] = 4;
    strings[0] = "test_string1";
    strings[1] = "test_string2";
    strings[2] = "test_string3";
    strings[3] = "test_string4";
    ReturnToEngine(4, integers, 4, strings);

}

int
main(int argc,
     char *argv[])
{
    GtkWidget *window;
    GtkWidget *box1;

    gtk_set_locale();

    gtk_init(&argc, &argv);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    gtk_window_set_title(GTK_WINDOW(window), "GDK Palette");

    box1 = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(window), box1);

    gtk_widget_show(box1);

    gtk_container_set_border_width(GTK_CONTAINER(window), 10);
    gtk_widget_realize(window);

    button = gtk_button_new_with_label("Test");

    gtk_signal_connect(GTK_OBJECT(button), "clicked",
	       GTK_SIGNAL_FUNC(callback), (gpointer) "cool button");

    gtk_widget_show(button);

    gtk_container_add(GTK_CONTAINER(box1), button);

    entry = gtk_entry_new_with_max_length(30);

    gtk_entry_set_text(GTK_ENTRY(entry), "Conversion OFF");

    gtk_widget_show(entry);

    gtk_container_add(GTK_CONTAINER(box1), entry);

    /* Register Event Handler */
    gdk_window_add_filter(GTK_WIDGET(window)->window, gdk_ext_event_handler, 0);

    gtk_widget_show(window);

    /* Register Aux class */
    if (xaux_ext_init_classes(GDK_DISPLAY(),
			      &xaux_class, GDK_WINDOW_XWINDOW(GTK_WIDGET(window)->window)) == False) {
	exit(1);
    }
    gtk_main();

    return (0);
}

ReturnToEngine(
	       int integer_count,
	       int *integers,
	       int string_count,
	       char **strings
)
{
    int i;

    aux_ext_data_t *aux_data;

    if (!im_ || !ic_ || !xc_)
	return;

    if (!integer_count && !string_count)
	return;

    aux_data = (aux_ext_data_t *) calloc(1, sizeof(aux_ext_data_t));

    aux_data->im = im_;
    aux_data->ic = ic_;

    aux_data->integer_count = integer_count;
    aux_data->string_count = string_count;

    if (aux_data->integer_count) {
	aux_data->integer_list = (int *) calloc(1, sizeof(int) * aux_data->integer_count);
	for (i = 0; i < aux_data->integer_count; i++) {
	    aux_data->integer_list[i] = integers[i];
	}
    }
    if (aux_data->string_count) {
	aux_data->string_list = (aux_ext_string_t *) calloc(1,
		 sizeof(aux_ext_string_t) * aux_data->string_count);
	for (i = 0; i < aux_data->string_count; i++) {
	    aux_ext_string_t *p = &aux_data->string_list[i];
	    p->length = strlen(strings[i]);
	    p->ptr = (unsigned char *) strdup(strings[i]);
	}
    }
    xaux_ext_SetValue(GDK_DISPLAY(), xc_, aux_data);

    if (aux_data->integer_list)
	free(aux_data->integer_list);
    if (aux_data->string_list) {
	for (i = 0; i < aux_data->string_count; i++) {
	    aux_ext_string_t *p = &aux_data->string_list[i];
	    if (p && p->ptr)
		free(p->ptr);
	}
	free(aux_data->string_list);
    }
    free(aux_data);
}
