/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.awt.print.PrinterJob;

import java.beans.*;
import java.io.*;
import java.applet.*;
import java.net.*;
import java.util.*;

class Checktool extends JPanel {
    
    static String tool_title;
    static JFrame frame = null;
    static CommentDialog commentDialog = null;
    static MailDialog maildialog = null;
    static ConsoleDialog consoledialog = null;
    static MailDialog bugmaildialog = null;
    static HelpDialog helpDialog = null;
    static DocDialog docDialog = null;
    static PropsDialog propsDialog = null;
    static ToolPropsDialog toolpropsDialog = null;
    static JLabel statusLabel = null;
    static CheckList list = null;
    static JFileChooser chooser=null;
    static JViewport port;
    static Checktool ct;
    static Applet applet=null;
    static JRadioButtonMenuItem windowsMenuItem, motifMenuItem, metalMenuItem;
    
    static boolean debug=false;
    static boolean edited=false;
    
    public static CData cdatas[];
    
    public static JMenuItem save_mi, saveas_mi, report_mi, next_mi, prev_mi, next_comment_mi,
    prev_comment_mi, comment_mi, pass_mi, fail_mi, help_mi, props_mi, clear_mi, clearall_mi,
    nextp_mi, prevp_mi, print_mi;
    
    public static JButton reportButton, nextButton, passButton,
    failButton, prevButton, saveasButton, commentButton,
    helpButton;
    
    public static void setActiveStore(boolean on) {
        edited=on;
        //saveButton.setEnabled(on);
        save_mi.setEnabled(on);
    }
    
    public static void setActive(boolean on) {
        // button items
        reportButton.setEnabled(on);
        saveasButton.setEnabled(on);
        commentButton.setEnabled(on);
        nextButton.setEnabled(on);
        passButton.setEnabled(on);
        failButton.setEnabled(on);
        prevButton.setEnabled(on);
        helpButton.setEnabled(on);
        
        // menun items
        save_mi.setEnabled(on);
        saveas_mi.setEnabled(on);
        report_mi.setEnabled(on);
        next_mi.setEnabled(on);
        prev_mi.setEnabled(on);
        nextp_mi.setEnabled(on);
        prevp_mi.setEnabled(on);
        next_comment_mi.setEnabled(on);
        prev_comment_mi.setEnabled(on);
        comment_mi.setEnabled(on);
        pass_mi.setEnabled(on);
        fail_mi.setEnabled(on);
        help_mi.setEnabled(on);
        props_mi.setEnabled(on);
        clear_mi.setEnabled(on);
        clearall_mi.setEnabled(on);
        print_mi.setEnabled(on);
    }
    
    static ActionListener menu_actions = null;
    public static ImageIcon open_icon, save_icon, report_icon, comment_icon,
    pass_icon, fail_icon, next_icon, prev_icon,
    comment_next_icon, comment_prev_icon, help_icon,
    frame_icon;
    
    public static void createIcons() {
        open_icon=getIcon(getString("open_btn_iconimage"));
        save_icon=getIcon(getString("saveas_btn_iconimage"));
        report_icon=getIcon(getString("report_btn_iconimage"));
        comment_icon=getIcon(getString("comment_btn_iconimage"));
        pass_icon=getIcon(getString("pass_btn_iconimage"));
        fail_icon=getIcon(getString("fail_btn_iconimage"));
        next_icon=getIcon(getString("next_btn_iconimage"));
        prev_icon=getIcon(getString("prev_btn_iconimage"));
        comment_next_icon=getIcon(getString("comment_next_btn_iconimage"));
        comment_prev_icon=getIcon(getString("comment_prev_btn_iconimage"));
        help_icon=getIcon(getString("help_btn_iconimage"));
        frame_icon=getIcon("checktool.gif");
    }
    
    public static void setTitle(String a) {
        frame.setTitle(ct.tool_title + " : " + a);
    }
    
    public static void main(String[] args) {
        
        Properties defaults = new Properties(System.getProperties());

sun.net.www.http.HttpClient.proxyHost = "webcache";
sun.net.www.http.HttpClient.proxyPort = 8080;

        
        if (defaults.getProperty("checktoolbase")!=null) {
            basedir=new File(defaults.getProperty("checktoolbase") + "/");
            //System.out.println("basedir=" + basedir.toString());
        }
        
        ct=new Checktool();
        
        frame = new JFrame();
        frame.setTitle(ct.tool_title);
        frame.setBackground(Color.lightGray);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(BorderLayout.CENTER, ct);
        frame.addWindowListener(new AppCloser());
        frame.pack();
        frame.setIconImage(ct.frame_icon.getImage());
        frame.setSize(600, 400);
        
        propsDialog = new PropsDialog(frame, ct);
        
        if (args.length == 1) {
            File file = new File(args[0]);
            if (file.exists()) {
                loadFile(file);
            } else {
                errorDisplay(getString("loaderror_message") + ":" + file.getAbsolutePath());
            }
        }
        
        frame.show();
        
        if (args.length != 1) {
            showAboutDialog();
        }
    }
    
    public static JMenuBar createMenubar() {
        JMenuBar menuBar=new JMenuBar();;
        JMenuItem mi;
        
        menu_actions = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Component mc=(Component)e.getSource();
                String cmd=mc.getName();
                
                if (currentFile==null) {
                    if ((cmd.equals("open")||
                      cmd.equals("quit")||
                      cmd.equals("helpcontents")||
                      cmd.equals("bugmail")||
                      cmd.equals("demo")||
                      cmd.equals("l10n")||
                      cmd.equals("format")||
                      cmd.equals("toolprops")||
                      cmd.equals("releasenotes")||
                      cmd.equals("about"))==false) {
                        return;
                    }
                }
                
                if (cmd.equals("open")) {
                    if (edited==true) {
                        Object[]      message = new Object[2];
                        message[0] = getString("newfile_confirm_message1");
                        message[1] = getString("newfile_confirm_message2");
                        if (showYesNoDialog(getFrame(),
                            getString("newfile_confirm_title"),
                        message)==false) {
                            return;
                        }
                        try { Thread.sleep(500); } catch (Exception ex) { System.out.println(ex); }
                    }
                    
                    if (chooser == null) {
                        setBusy(true);
                        chooser = new JFileChooser(".");
                        String exts[]={"sqa", "rpt"};
                        ExampleFileFilter a=new ExampleFileFilter(exts,
			    getString("filefilter_message"));
                        chooser.addChoosableFileFilter(a);
                        chooser.setFileFilter(a);
                        setBusy(false);
                    }
                    
                    chooser.rescanCurrentDirectory();
                    chooser.setDialogType(JFileChooser.OPEN_DIALOG);
                    int retval=chooser.showDialog(getFrame(), null);
                    if (retval == 0) {
                        File theFile = chooser.getSelectedFile();
                        if (theFile != null) {
                            loadFile(chooser.getSelectedFile());
                            return;
                        }
                    }
                } else if (cmd.equals("saveas")) {
                    if (currentFile==null) {
                        return;
                    }
                    if (chooser == null) {
                        setBusy(true);
                        chooser = new JFileChooser(".");
                        String exts[]={"sqa", "rpt"};
                        ExampleFileFilter a=new ExampleFileFilter(exts,
			    getString("filefilter_message"));
                        chooser.addChoosableFileFilter(a);
                        chooser.rescanCurrentDirectory();
                        chooser.setFileFilter(a);
                        chooser.rescanCurrentDirectory();
                        setBusy(false);
                    }
                    chooser.rescanCurrentDirectory();
                    chooser.setDialogType(JFileChooser.SAVE_DIALOG);
                    javax.swing.plaf.basic.BasicFileChooserUI p=
                    (javax.swing.plaf.basic.BasicFileChooserUI) chooser.getUI();
                    
                    String sqa_file=currentFile.getAbsolutePath();
                    String rpt_file=sqa_file.substring(sqa_file.lastIndexOf(File.separator)+1, sqa_file.lastIndexOf("."));
//System.out.println(File.pathSeparator);
//System.out.println(File.pathSeparatorChar);
//System.out.println(File.separator);
//System.out.println(File.separatorChar);
                    p.setFileName(rpt_file+".rpt");
                    
                    int retval=chooser.showDialog(getFrame(), null);
                    if (retval == 0) {
                        File theFile = chooser.getSelectedFile();
                        try { Thread.sleep(500); } catch (Exception ex) { System.out.println(ex); }
                        if (theFile != null) {
                            if (theFile.exists() == true) {
                                Object[]      message = new Object[1];
                                message[0] = getString("fileexist_message");
                                if (showYesNoDialog(getFrame(),
                                    getString("fileexist_title"),
                                message)==false) {
                                    setStatus(getString("fileexist_cancel_message"));
                                    return;
                                }
                            }
                            saveAsFile(theFile);
                            return;
                        }
                    }
                } else if (cmd.equals("save")) {
                    saveFile(currentFile);
                } else if (cmd.equals("report")) {
                    showMailDialog();
                } else if (cmd.equals("quit")) {
                    quitChecktool();
                } else if (cmd.equals("help")) {
                    showHelpDialog();
                } else if (cmd.equals("next")) {
                    nextList();
                } else if (cmd.equals("prev")) {
                    prevList();
                } else if (cmd.equals("nextpage")) {
                    nextPageList();
                } else if (cmd.equals("prevpage")) {
                    prevPageList();
                } else if (cmd.equals("nextcomment")) {
                    nextComment();
                } else if (cmd.equals("prevcomment")) {
                    prevComment();
                } else if (cmd.equals("props")) {
                    showPropsDialog();
                } else if (cmd.equals("pass")) {
                    passList();
                } else if (cmd.equals("fail")) {
                    failList();
                } else if (cmd.equals("clear")) {
                    clearList();
                } else if (cmd.equals("clearall")) {
                    clearAllList();
                } else if (cmd.equals("comment")) {
                    doubleClicked(list.getSelectedIndex());
                } else if (cmd.equals("helpcontents")) {
                    showDocDialog();
                } else if (cmd.equals("bugmail")) {
                    showBugMailDialog();
                } else if (cmd.equals("demo")) {
                    loadFile(new File(getBaseDir()+ct.getString("demo_file")));
                } else if (cmd.equals("print")) {
                    PrintCs p=new PrintCs(ct);
                    p.start();
                } else if (cmd.equals("format")) {
                    showFormatDialog();
                } else if (cmd.equals("l10n")) {
                    showL10NDialog();
                    if (false) {
                        PrinterJob printJob = PrinterJob.getPrinterJob();
                        printJob.setPrintable(list);
                        if (printJob.printDialog()) {
                            try {
                                printJob.print();
                            } catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                } else if (cmd.equals("releasenotes")) {
                    showRelDialog();
                } else if (cmd.equals("about")) {
                    showAboutDialog();
                } else if (cmd.equals("toolprops")) {
                    showToolPropsDialog();
                }
            }
        };
        
        JMenu file = (JMenu) menuBar.add(new JMenu(getString("file_menu")));
        mi = (JMenuItem) file.add(new JMenuItem(getString("open_mi")));
        mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, ActionEvent.CTRL_MASK));
        setAccelerator(mi, getString("open_mi_accelchar"), getString("open_mi_accelmask"));
        mi.setName("open");
        mi.addActionListener(menu_actions);
        
        save_mi = (JMenuItem) file.add(new JMenuItem(getString("save_mi")));
        save_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //save_mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
        setAccelerator(save_mi, getString("save_mi_accelchar"), getString("save_mi_accelmask"));
        save_mi.setName("save");
        save_mi.addActionListener(menu_actions);
        
        file.add(new JSeparator());
        saveas_mi = (JMenuItem) file.add(new JMenuItem(getString("saveas_mi")));
        saveas_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //saveas_mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A, ActionEvent.CTRL_MASK));
        setAccelerator(saveas_mi, getString("saveas_mi_accelchar"), getString("saveas_mi_accelmask"));
        saveas_mi.setName("saveas");
        saveas_mi.addActionListener(menu_actions);
        
        report_mi = (JMenuItem) file.add(new JMenuItem(getString("report_mi")));
        report_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //report_mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, ActionEvent.CTRL_MASK));
        setAccelerator(report_mi, getString("report_mi_accelchar"), getString("report_mi_accelmask"));
        report_mi.setName("report");
        report_mi.addActionListener(menu_actions);
        
        print_mi = (JMenuItem) file.add(new JMenuItem(getString("print_mi")));
        print_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        setAccelerator(print_mi, getString("print_mi_accelchar"), getString("print_mi_accelmask"));
        print_mi.setName("print");
        print_mi.addActionListener(menu_actions);
        
        file.add(new JSeparator());
        mi = (JMenuItem) file.add(new JMenuItem(getString("quit_mi")));
        setAccelerator(mi, getString("quit_mi_accelchar"), getString("quit_mi_accelmask"));
        mi.setName("quit");
        mi.addActionListener(menu_actions);
        
        JMenu view = (JMenu) menuBar.add(new JMenu(getString("view_menu")));
        
        view.add(new JSeparator());
        next_mi = (JMenuItem) view.add(new JMenuItem(getString("next_mi")));
        next_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //next_mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
        setAccelerator(next_mi, getString("next_mi_accelchar"), getString("next_mi_accelmask"));
        next_mi.setName("next");
        next_mi.addActionListener(menu_actions);
        
        prev_mi = (JMenuItem) view.add(new JMenuItem(getString("prev_mi")));
        prev_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //prev_mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, ActionEvent.CTRL_MASK));
        setAccelerator(prev_mi, getString("prev_mi_accelchar"), getString("prev_mi_accelmask"));
        prev_mi.setName("prev");
        prev_mi.addActionListener(menu_actions);
        
        view.add(new JSeparator());
        nextp_mi = (JMenuItem) view.add(new JMenuItem(getString("nextpage_mi")));
        nextp_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //next_mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
        setAccelerator(nextp_mi, getString("nextpage_mi_accelchar"), getString("nextpage_mi_accelmask"));
        nextp_mi.setName("nextpage");
        nextp_mi.addActionListener(menu_actions);
        
        prevp_mi = (JMenuItem) view.add(new JMenuItem(getString("prevpage_mi")));
        prevp_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        setAccelerator(prevp_mi, getString("prevpage_mi_accelchar"), getString("prevpage_mi_accelmask"));
        prevp_mi.setName("prevpage");
        prevp_mi.addActionListener(menu_actions);
        
        view.add(new JSeparator());
        next_comment_mi = (JMenuItem) view.add(new JMenuItem(getString("next_comment_mi")));
        setAccelerator(next_comment_mi, getString("next_comment_mi_accelchar"), getString("next_comment_mi_accelmask"));
        next_comment_mi.setName("nextcomment");
        next_comment_mi.addActionListener(menu_actions);
        
        prev_comment_mi = (JMenuItem) view.add(new JMenuItem(getString("prev_comment_mi")));
        setAccelerator(prev_comment_mi, getString("prev_comment_mi_accelchar"), getString("prev_comment_mi_accelmask"));
        prev_comment_mi.setName("prevcomment");
        prev_comment_mi.addActionListener(menu_actions);
        
        view.add(new JSeparator());
        help_mi = (JMenuItem) view.add(new JMenuItem(getString("help_mi")));
        setAccelerator(help_mi, getString("help_mi_accelchar"), getString("help_mi_accelmask"));
        help_mi.setName("help");
        help_mi.addActionListener(menu_actions);
        
        props_mi = (JMenuItem) view.add(new JMenuItem(getString("props_mi")));
        props_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        setAccelerator(props_mi, getString("props_mi_accelchar"), getString("props_mi_accelmask"));
        props_mi.setName("props");
        props_mi.addActionListener(menu_actions);
        
        JMenu edit = (JMenu) menuBar.add(new JMenu(getString("edit_menu")));
        comment_mi = (JMenuItem) edit.add(new JMenuItem(getString("comment_mi")));
        comment_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //comment_mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK));
        setAccelerator(comment_mi, getString("comment_mi_accelchar"), getString("comment_mi_accelmask"));
        comment_mi.setName("comment");
        comment_mi.addActionListener(menu_actions);
        
        edit.add(new JSeparator());
        pass_mi = (JMenuItem) edit.add(new JMenuItem(getString("pass_mi")));
        pass_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //pass_mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 0));
        setAccelerator(pass_mi, getString("pass_mi_accelchar"), getString("pass_mi_accelmask"));
        pass_mi.setName("pass");
        pass_mi.addActionListener(menu_actions);
        
        fail_mi = (JMenuItem) edit.add(new JMenuItem(getString("fail_mi")));
        fail_mi.setHorizontalTextPosition(JMenuItem.RIGHT);
        //fail_mi.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 0));
        setAccelerator(fail_mi, getString("fail_mi_accelchar"), getString("fail_mi_accelmask"));
        fail_mi.setName("fail");
        fail_mi.addActionListener(menu_actions);
        
        edit.add(new JSeparator());
        clear_mi = (JMenuItem) edit.add(new JMenuItem(getString("clear_mi")));
        setAccelerator(clear_mi, getString("clear_mi_accelchar"), getString("clear_mi_accelmask"));
        clear_mi.setName("clear");
        clear_mi.addActionListener(menu_actions);
        
        clearall_mi = (JMenuItem) edit.add(new JMenuItem(getString("clearall_mi")));
        setAccelerator(clearall_mi, getString("clearall_mi_accelchar"), getString("clearall_mi_accelmask"));
        clearall_mi.setName("clearall");
        clearall_mi.addActionListener(menu_actions);
        
        edit.add(new JSeparator());
        
        mi = (JMenuItem) edit.add(new JMenuItem(getString("toolprops_mi")));
        setAccelerator(mi, getString("toolprops_mi_accelchar"), getString("toolprops_mi_accelmask"));
        mi.setName("toolprops");
        mi.addActionListener(menu_actions);
        
        JMenu help = (JMenu) menuBar.add(new JMenu(getString("help_menu")));
        
        mi = (JMenuItem) help.add(new JMenuItem(getString("helpcontents_mi")));
        setAccelerator(mi, getString("helpcontents_mi_accelchar"), getString("helpcontents_mi_accelmask"));
        mi.setName("helpcontents");
        mi.addActionListener(menu_actions);
        
        mi = (JMenuItem) help.add(new JMenuItem(getString("releasenotes_mi")));
        setAccelerator(mi, getString("releasenotes_mi_accelchar"), getString("releasenotes_mi_accelmask"));
        mi.setName("releasenotes");
        mi.addActionListener(menu_actions);
        
        mi = (JMenuItem) help.add(new JMenuItem("L10N Guide..."));
        mi.setName("l10n");
        mi.addActionListener(menu_actions);

        mi = (JMenuItem) help.add(new JMenuItem("Check Sheet Format..."));
        mi.setName("format");
        mi.addActionListener(menu_actions);
        
        mi = (JMenuItem) help.add(new JMenuItem(getString("demo_mi")));
        //setAccelerator(mi, getString("bugmail_mi_accelchar"), getString("bugmail_mi_accelmask"));
        mi.setName("demo");
        mi.addActionListener(menu_actions);
        
        mi = (JMenuItem) help.add(new JMenuItem(getString("bugmail_mi")));
        setAccelerator(mi, getString("bugmail_mi_accelchar"), getString("bugmail_mi_accelmask"));
        mi.setName("bugmail");
        mi.addActionListener(menu_actions);
        
        mi = (JMenuItem) help.add(new JMenuItem(getString("about_mi")));
        setAccelerator(mi, getString("about_mi_accelchar"), getString("about_mi_accelmask"));
        mi.setName("about");
        mi.addActionListener(menu_actions);
        
        return menuBar;
    }
    private static JToolBar createToolbar() {
        JToolBar toolbar = new JToolBar();
        
        //toolbar.add(Box.createHorizontalStrut(5));
        
        JButton openButton = getButton(open_icon);
        openButton.setName("open");
        openButton.setToolTipText(getString("open_btn_tip"));
        openButton.addActionListener(menu_actions);
        toolbar.add(openButton);
        
        //toolbar.add(Box.createHorizontalGlue());
        
        saveasButton = getButton(save_icon);
        saveasButton.setName("saveas");
        saveasButton.setToolTipText(getString("saveas_btn_tip"));
        saveasButton.addActionListener(menu_actions);
        toolbar.add(saveasButton);
        
        toolbar.add(Box.createHorizontalStrut(10));
        
        commentButton = getButton(comment_icon);
        commentButton.setName("comment");
        commentButton.setToolTipText(getString("comment_btn_tip"));
        commentButton.addActionListener(menu_actions);
        toolbar.add(commentButton);
        
        reportButton = getButton(report_icon);
        reportButton.setName("report");
        reportButton.setToolTipText(getString("report_btn_tip"));
        reportButton.addActionListener(menu_actions);
        toolbar.add(reportButton);
        
        helpButton = getButton(help_icon);
        helpButton.setName("help");
        helpButton.setToolTipText(getString("help_btn_tip"));
        helpButton.addActionListener(menu_actions);
        toolbar.add(helpButton);
        
        toolbar.add(Box.createHorizontalGlue());
        
        prevButton = getButton(prev_icon);
        prevButton.setName("prev");
        prevButton.setToolTipText(getString("prev_btn_tip"));
        prevButton.addActionListener(menu_actions);
        toolbar.add(prevButton);
        
        nextButton = getButton(next_icon);
        nextButton.setName("next");
        nextButton.setToolTipText(getString("next_btn_tip"));
        nextButton.addActionListener(menu_actions);
        toolbar.add(nextButton);
        
        toolbar.add(Box.createHorizontalStrut(10));
        
        failButton = getButton(fail_icon);
        failButton.setName("fail");
        failButton.setToolTipText(getString("fail_btn_tip"));
        failButton.addActionListener(menu_actions);
        toolbar.add(failButton);
        
        passButton = getButton(pass_icon);
        passButton.setName("pass");
        passButton.setToolTipText(getString("pass_btn_tip"));
        passButton.addActionListener(menu_actions);
        toolbar.add(passButton);
        
        return toolbar;
    }
    
    public Insets getInsets() {
        return new Insets(2,2,2,2);
    }
    
    public Checktool () {
        this(null);
    }
    
    public Checktool(java.applet.Applet anApplet) {
        
        this.applet=anApplet;
        
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        } catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        
        if (anApplet != null) {
            System.out.println(anApplet.getCodeBase());
        }
        
        createIcons();
        
        tool_title=getString("tool_title");
        
        setBorder(BorderFactory.createEtchedBorder());
        setLayout(new BorderLayout());
        
        JMenuBar menubar = createMenubar();
        add(BorderLayout.NORTH, menubar);
        
        JPanel panel = new JPanel() {
            public Insets getInsets() {
                return new Insets(10,10,10,10);
            }
        };
        
        panel.setLayout(new BorderLayout());
        panel.add(BorderLayout.NORTH,createToolbar());
        
        list = new CheckList(this);
        
        panel.add(BorderLayout.CENTER, list);
        panel.add(BorderLayout.SOUTH, statusLabel=new JLabel("             "));
        add(BorderLayout.CENTER, panel);
        
        setActive(false);
        
        setSmtp();
        
        try {
            System.getProperties().put("checktool.readfilechar", getString("checktool.readfilechar", "ISO8859_1"));
            System.getProperties().put("checktool.writefilechar", getString("checktool.writefilechar", "ISO8859_1"));
            
            System.getProperties().put("checktool.readfilechar", getString("checktool.readfilechar", "usecurrentlocale"));
            System.getProperties().put("checktool.writefilechar", getString("checktool.writefilechar", "usecurrentlocale"));
        } catch (Exception ex) {
        }
    }
    
    static boolean nextComment() {
        int i;
        int row=list.getSelectedIndex();
        if (row>cdatas.length) {
            return false;
        }
        for (i=row+1;i<cdatas.length;i++) {
            String cmt=cdatas[i].comment;
            if (cmt!=null && cmt.equals("")==false) {
                list.setSelectedIndex(i);
                singleClicked(i);
                if (commentDialog == null) {
                    commentDialog = new CommentDialog(getFrame(), ct);
                }
                commentDialog.setVisible();
                return true;
            }
        }
        return false;
    }
    static boolean prevComment() {
        int i;
        int row=list.getSelectedIndex();
        if (row==0) {
            return false;
        }
        for (i=row-1;i>=0;i--) {
            String cmt=cdatas[i].comment;
            if (cmt!=null && cmt.equals("")==false) {
                list.setSelectedIndex(i);
                singleClicked(i);
                if (commentDialog == null) {
                    commentDialog = new CommentDialog(getFrame(), ct);
                }
                commentDialog.setVisible();
                return true;
            }
        }
        return false;
    }
    
    static void nextPageList() {
        list.nextPage();
    }
    static void prevPageList() {
        list.prevPage();
    }
    
    static boolean nextList() {
        int i;
        if (cdatas==null) {
            return true;
        }
        int row=list.getSelectedIndex();
        if (debug) {
            System.out.println("row=" + row + " cdatas.length=" + cdatas.length);
        }
        if (row>=cdatas.length-1) {
            return false;
        }
        for (i=row+1;i<cdatas.length;i++) {
            int state=cdatas[i].state;
            if (state == CData.NOCHECK ||
              state == CData.PASSED ||
              state == CData.FAILED) {
                list.setSelectedIndex(i);
                singleClicked(i);
                return true;
            }
        }
        return false;
    }
    static boolean prevList() {
        int i;
        if (cdatas==null) {
            return true;
        }
        int row=list.getSelectedIndex();
        if (row==0) {
            return false;
        }
        for (i=row-1;i>=0;i--) {
            int state=cdatas[i].state;
            if (state == CData.NOCHECK ||
              state == CData.PASSED ||
              state == CData.FAILED) {
                list.setSelectedIndex(i);
                singleClicked(i);
                return true;
            }
        }
        return false;
    }
    static void toggleState() {
        CData cdata=getCurrentData();
        if (cdata != null) {
            setActiveStore(true);
            cdata.toggleState();
            list.repaint();
        }
    }
    static void passList() {
        CData cdata = getCurrentData();
        if (cdata != null) {
            if (cdata.state != CData.NONE) {
                cdata.markPass();
                setActiveStore(true);
                if (nextList()==false) {
                    list.repaint();	// need to repaint
                }
            }
        }
    }
    static void failList() {
        CData cdata = getCurrentData();
        if (cdata != null) {
            if (cdata.state != CData.NONE) {
                cdata.markFail();
                setActiveStore(true);
                if (nextList()==false) {
                    list.repaint();	// need to repaint
                }
            }
        }
    }
    static void clearList() {
        CData cdata = getCurrentData();
        if (cdata != null) {
            if (cdata.state != CData.NONE) {
                cdata.markNocheck();
                setActiveStore(true);
                if (nextList()==false) {
                    list.repaint();	// need to repaint
                }
            }
        }
    }
    static void clearAllList() {
        Object[]      message = new Object[1];
        message[0] = getString("clearall_message");
        if (showYesNoDialog(getFrame(),
            getString("clearall_title"),
        message)==true) {
            doClearAllList();
        }
    }
    static void doClearAllList() {
        CData cdata;
        if (cdatas==null) {
            return;
        }
        setActiveStore(true);
        for (int i=0;i<cdatas.length;i++) {
            cdata = cdatas[i];
            if (cdata.state != CData.NONE) {
                cdata.markNocheck();
            }
            cdata.setComment("");
        }
        list.repaint();
    }
    
    static void errorDisplay(String s) {
        //JOptionPane.showMessageDialog(getFrame(), s);
        Object[]      message = new Object[1];
        message[0] = s;
        showConfirmDialog(getFrame(),
            getString("error_dialog_title"),
        message);
    }
    
    static void setStatus(String s) {
        statusLabel.setText(s + "   ");
    }
    
    static void deleteStatus() {
        statusLabel.setText("");
    }
    
    static void execWithArg(String cmd) {
        String          result;
        result = JOptionPane.showInputDialog(getFrame(),
            "Please enter $ARG:");
        if (result != null) {
            if (debug) {
                System.out.println("ARG=" + result);
            }
            String cmd_="";
            StringTokenizer st = new StringTokenizer(cmd, " \t\n\r");
            while (st.hasMoreTokens()) {
                String arg=st.nextToken();
                if (arg.equals("$ARG")) {
                    cmd_+=(result+" ");
                } else {
                    cmd_+=(arg+" ");
                }
            }
            execCmd(cmd_.trim());
        }
    }
    
    static class RunCMDPrivate implements Runnable {
        private Thread thread;
        InputStreamReader theInputStreamReader;
        ConsoleDialog consoledialog;
        public RunCMDPrivate(InputStreamReader theInputStreamReader_, ConsoleDialog consoledialog_) {
            theInputStreamReader=theInputStreamReader_;
            consoledialog=consoledialog_;
        }
        public void start() {
            thread = new Thread(this);
            thread.start();
        }
        public void run() {
            int c;
            try {
                while ((c = theInputStreamReader.read()) != -1) {
                    if (consoledialog.isVisible()==false) {
                        consoledialog.setVisible(true);
                    }
                    consoledialog.append((char)c);
                    System.out.print((char)c);
                }
            } catch (Exception jj) {
                System.out.println(jj.toString());
            }
        }
    }
    
    
    static class RunCMD implements Runnable {
        private Thread thread;
        String cmd;
        File tmpfile;
        public void setCmd(String cmd_) {
            cmd=cmd_;
            long timestamp = System.currentTimeMillis()/1000;
            if (Shared.IsWindows()) {
                tmpfile=new File("c:\\temp\\checktool_" + System.getProperty("user.name") + "_" + timestamp + ".bat");
            } else {
                tmpfile=new File("/tmp/checktool." + System.getProperty("user.name") + "." + timestamp);
            }
            Shared.saveFile(tmpfile, cmd + "\n");
        }
        public void start() {
            thread = new Thread(this);
            thread.start();
        }
        public synchronized void run() {
            try {
                Process child = null;
                if (Shared.IsWindows()) {
                    child = Runtime.getRuntime().exec(tmpfile.getAbsolutePath());
                } else {
                    child = Runtime.getRuntime().exec("sh " + tmpfile.getAbsolutePath());
                }
                InputStream es = child.getErrorStream();
                //InputStream es = child.getInputStream();
                InputStreamReader theInputStreamReader=new InputStreamReader(es);
                if (consoledialog==null) {
                    consoledialog=new ConsoleDialog(getFrame());
                    consoledialog.setTitle(ct.tool_title + ":" + getString("console_title"));
                    consoledialog.setCloseButton(getString("consoledialog_close_btn"));
                    consoledialog.setClearButton(getString("consoledialog_clear_btn"));
                }
                consoledialog.append("\n\n----- [ " + cmd + " ] -----\n");
                
                int c;
                while ((c = theInputStreamReader.read()) != -1) {
                    if (consoledialog.isVisible()==false) {
                        consoledialog.setVisible(true);
                    }
                    consoledialog.append((char)c);
                    System.out.print((char)c);
                }
                
                theInputStreamReader.close();
                es.close();
                try {
                    child.waitFor();
                } catch (InterruptedException e) {
                    System.out.println(e.toString());
                }
                tmpfile.delete();
            } catch (Exception ex) {
                System.out.println(ex.toString());
            }
        }
    }
    
    static void execCmd(String cmd) {
        RunCMD rc=new RunCMD();
        setStatus(getString("execmd_start_message") + ": " + cmd);
        rc.setCmd(cmd);
        rc.start();
    }
    
    static void doubleClicked(int index) {
        current_index=index;
        CData cdata=getCurrentData();
        if (cdata != null) {
            String s=cdata.ritem.trim();
            if (s.startsWith("CMD:")) {
                if (s.indexOf("$ARG")!=-1) {
                    execWithArg(s.substring(4).trim());
                } else {
                    if (debug) {
                        System.out.println("exec command " + s);
                    }
                    execCmd(s.substring(4).trim());
                }
                setBusy(false);	//???
                return;
            }
        }
        if (commentDialog == null) {
            commentDialog = new CommentDialog(getFrame(), ct);
        }
        commentDialog.setVisible();
        if (helpDialog != null && helpDialog.isVisible()==true) {
            helpDialog.setVisible();
        }
    }
    static void singleClicked(int index) {
        if (current_index == index) {
            return;
        }
        current_index=index;
        if (commentDialog != null && commentDialog.isVisible()==true) {
            commentDialog.setVisible();
        }
        if (helpDialog != null && helpDialog.isVisible()==true) {
            helpDialog.setVisible();
        }
        setStatus((index+1) + "/" + cdatas.length);
    }
    
    static void loadFile(File s) {
        File prev_currentFile=null;
        setBusy(true);
        try {
            URL url=s.toURL();
            prev_currentFile=currentFile;
            currentFile=s;
            if (tryLoadFile(s)==true) {
                list.setData();
                nextList();
                setTitle(currentFile.getName());
                setActive(true);
                setActiveStore(false);
                propsDialog.setInitResults();
                setBusy(false);
                return;
            }
	    currentFile=prev_currentFile;
        } catch (Exception ex) {
	    currentFile=prev_currentFile;
            System.out.println(ex);
        }
        
        setBusy(false);
        
        errorDisplay(getString("loaderror_message") + ":" + s);
        
        if (debug) {
            System.out.println("load [" + s + "] error");
        }
    }
    
    static void saveAsFile(File s) {
        setBusy(true);
        if (debug) {
            System.out.println("save as [" + s + "]");
        }
        saveFile(s);	// if OK
        setBusy(false);
    }

    static void showFormatDialog() {
        setBusy(true);
        URL url=null;

        try {
            url = ClassLoader.getSystemResource("lib/help/format.html");
        } catch (Exception ex){
	    setBusy(false);
	    return;
        }

        if (docDialog==null) {
            docDialog = new DocDialog(getFrame(), url);
            docDialog.setTitle(ct.tool_title + " : " + ct.getString("docdialog_title"));
            docDialog.setCloseButton(ct.getString("docdialog_close_btn"));
        } else {
            docDialog.setPage(url);
	}
        docDialog.setVisible();
        setBusy(false);
    }

    static void showL10NDialog() {
        setBusy(true);

        URL url=null;

        try {
            url = ClassLoader.getSystemResource("lib/help/l10nguide.html");
        } catch (Exception ex){
            setBusy(false);
            return;
        }

        if (docDialog==null) {
            docDialog = new DocDialog(getFrame(), url);
            docDialog.setTitle(ct.tool_title + " : " + ct.getString("docdialog_title"));
            docDialog.setCloseButton(ct.getString("docdialog_close_btn"));
        } else {
            docDialog.setPage(url);
        }
        docDialog.setVisible();
        setBusy(false);
    }
    
    static void showDocDialog() {
        setBusy(true);

        URL url=null;

        try {
            url = ClassLoader.getSystemResource(ct.getString("docdialog_url"));
        } catch (Exception ex){
            setBusy(false);
            return;
        }

        if (docDialog==null) {
            docDialog = new DocDialog(getFrame(), url);
            docDialog.setTitle(ct.tool_title + " : " + ct.getString("docdialog_title"));
            docDialog.setCloseButton(ct.getString("docdialog_close_btn"));
        } else {
            docDialog.setPage(url);
	}
        docDialog.setVisible();
        setBusy(false);
    }
    
    static void showHelpDialog() {
        setBusy(true);
        if (helpDialog==null) {
            helpDialog = new HelpDialog(getFrame(), ct);
        }
        helpDialog.setVisible();
        setBusy(false);
    }
    
    static void showPropsDialog() {
        setBusy(true);
        propsDialog.setVisible();
        setBusy(false);
    }
    
    static void showToolPropsDialog() {
        setBusy(true);
        if (toolpropsDialog==null) {
            toolpropsDialog = new ToolPropsDialog(getFrame(), ct);
        }
        toolpropsDialog.setVisible();
        setBusy(false);
    }

    static void showRelDialog() {
        setBusy(true);

        URL url=null;

        try {
            url = ClassLoader.getSystemResource(ct.getString("relnotes_url"));
        } catch (Exception ex){
            setBusy(false);
            return;
        }

        if (docDialog==null) {
            docDialog = new DocDialog(getFrame(), url);
            docDialog.setTitle(ct.tool_title + " : " + ct.getString("docdialog_title"));
            docDialog.setCloseButton(ct.getString("docdialog_close_btn"));
        } else {
            docDialog.setPage(url);
        }
        docDialog.setVisible();
        setBusy(false);
    }
    
    static void showBugMailDialog() {
        setBusy(true);
        if (bugmaildialog==null) {
            bugmaildialog = new MailDialog(getFrame(), ct);
        }
        bugmaildialog.setTitle(tool_title + " : " + getString("bugmail_title"));
        bugmaildialog.setTo(getString("bugmail_to"));
        bugmaildialog.setSubject(getString("bugmail_subject"));
        bugmaildialog.setCc(System.getProperty("user.name"));
        bugmaildialog.setBody(getString("bugmail_body"));
        if (currentFile!=null) {
            bugmaildialog.setBody(
            getString("bugmail_body") +
            getString("bugmail_body_file") +
            currentFile.getAbsolutePath() + "\n\n"
            );
        } else {
            bugmaildialog.setBody(getString("bugmail_body"));
        }
        bugmaildialog.setVisible(true);
        setBusy(false);
    }
    
    static void showMailDialog() {
        setBusy(true);
        if (maildialog==null) {
            maildialog = new MailDialog(getFrame(), ct);
        }
        maildialog.setVisible();
        setBusy(false);
    }
    
    static void showAboutDialog() {
        String name="aboutdialog_";
        Object[]      message = new Object[4];
        message[0] = "Checktool for Java2: " + "Version 1.0";
        message[1] = "Build Date: " + "Tue Jan 26 18:58:42 JST 1999";
        message[2] = "JDK Version: " + Shared.getJvmVer();
        message[3] = "JavaMail Version: " + "1.1";
        showConfirmDialog(getFrame(),
            getString(name + "title"),
        message,
        getIcon(getString(name + "iconimage")));
    }
    
    static void quitChecktool() {
        if (edited==true) {
            Object[]      message = new Object[1];
            message[0] = getString("exit_message");
            if (showYesNoDialog(getFrame(),
                getString("exit_dialog_title"),
            message)==false) {
                return;
            }
        }
        System.exit(0);
    }
    
    static void saveFile(File s) {
        if (s == null) {
            return;
        }
        setBusy(true);
        String str=getResult();
        if (str.equals("")==false) {
            try {
                OutputStreamWriter writer;
                String c=System.getProperty("checktool.writefilechar");
                if (c.equals("usecurrentlocale")==false) {
                    writer = new OutputStreamWriter(new FileOutputStream(s), c);
                } else {
                    writer = new OutputStreamWriter(new FileOutputStream(s));
                }
                writer.write(str, 0, str.length());
                writer.close();
                setActiveStore(false);
                currentFile=s;
                setTitle(currentFile.getName());
            } catch (IOException exp) {
                setBusy(false);
                errorDisplay(getString("saveerror_message") + ":" + s.getAbsolutePath());
            }
        }
        setBusy(false);
    }
    
    protected static final class AppCloser extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
    
    protected static final void setBusy_(Component a, boolean busy_on) {
        if (a==null) {
            return;
        }
        if (busy_on) {
            a.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        } else {
            a.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
        }
    }
    
    protected static final void setBusy(boolean busy_on) {
        setBusy_(ct.getFrame(), busy_on);
        setBusy_(ct.commentDialog, busy_on);
        setBusy_(ct.maildialog, busy_on);
        setBusy_(ct.helpDialog, busy_on);
        setBusy_(ct.docDialog, busy_on);
        setBusy_(ct.propsDialog, busy_on);
        setBusy_(ct.toolpropsDialog, busy_on);
        setBusy_(ct.chooser, busy_on);
        setBusy_(ct.bugmaildialog, busy_on);
    }
    
    public static File basedir=new File(".");
    public static int current_index=-1;
    public static ResourceBundle resources=null;
    
    public static String sheetHelpText=null;
    
    public static File currentFile=null;
    public static String sheet_code=null;
    public static String sheet_ver=null;
    
    public static int passed;
    public static int failed;
    public static int nocheck;
    
    public final static boolean use_swing=true;
    
    public static String getString(String s) {
        return getString(s, s);
    }
    public static String getString(String s, String alt) {
        if (resources==null) {
            try {
                resources = ResourceBundle.getBundle("Checktool",
                    Locale.getDefault());
            } catch (MissingResourceException mre) {
                System.err.println("properties file not found");
                System.exit(1);
            }
        }
        try {
            String l10n_string=resources.getString(s);
            if (l10n_string==null) {
                return alt;
            } else {
                return l10n_string;
            }
        } catch (MissingResourceException mre) {
            return alt;
        }
    }
    
    public static ImageIcon getIcon(String image_file) {
        try {
            URL url = ClassLoader.getSystemResource("lib/images/"+image_file);
            return new ImageIcon(url);
        } catch (Exception ex){
            return new ImageIcon(getBaseDir() + "lib/images/" + image_file);
        }
    }
    
    public static JButton getButton(String title, String image_file) {
        JButton button;
        if (title.equals("")) {
            button = new JButton(new ImageIcon(getBaseDir() +
            "lib/images/" + image_file));
        } else {
            button = new JButton(title, getIcon(image_file));
        }
        button.setRequestFocusEnabled(false);
        button.setMargin(new Insets(1,1,1,1));
        return button;
    }
    
    public static JButton getButton(String image_file) {
        return getButton("", image_file);
    }
    
    public static JButton getButton(String label, ImageIcon image) {
        JButton button = new JButton(label, image);
        button.setRequestFocusEnabled(false);
        button.setMargin(new Insets(1,1,1,1));
        return button;
    }
    
    public static JButton getButton(ImageIcon image) {
        JButton button = new JButton(image);
        button.setRequestFocusEnabled(false);
        button.setMargin(new Insets(1,1,1,1));
        return button;
    }
    
    public static CData getCurrentData() {
        if (current_index<0) {
            return null;
        }
        if (cdatas == null) {
            return null;
        }
        if (cdatas.length < current_index) {
            return null;
        }
        return cdatas[current_index];
    }
    
    static synchronized String getResult() {
        CData cdata;
        
        StringBuffer sb = new StringBuffer();
        
        sb.append(ct.propsDialog.getResults());
        sb.append("\n\n");
        
        try {
            if (debug) System.out.println(CData.CHECK_START_STR);
            
            if (sheetHelpText!=null&&sheetHelpText!="") {
                sb.append(CData.HELP_START_STR + "\n" + sheetHelpText +
                CData.HELP_END_STR + "\n\n");
            }
            
            sb.append(CData.CHECK_START_STR + "\n");
            for (int i=0;i<cdatas.length;i++) {
                cdata = cdatas[i];
                String ritem=cdata.ritem;
                if (ritem==null) {
                    ritem="";
                }
                if (cdata.state!=CData.NONE) {
                    ritem=ritem.substring(0, ritem.lastIndexOf("["));
                }
                if (cdata.state==CData.PASSED) {
                    ritem+=CData.PASSED_STR1;
                } else if (cdata.state==CData.FAILED) {
                    ritem+=CData.FAILED_STR1;
                } else if (cdata.state==CData.NOCHECK) {
                    ritem+=CData.NOCHECK_STR1;
                }
                sb.append(ritem+"\n");
                if (debug) System.out.println(ritem);
                if (cdata.help!=null && cdata.help.length()>1) {
                    String line=cdata.help;
                    String linenew=CData.HELP_STR;
                    for (int j=0;j<line.length();j++) {
                        if (line.charAt(j) == '\n') {
                            linenew+="\n";
                            linenew+=CData.HELP_STR;
                        } else {
                            linenew+=line.charAt(j);
                        }
                    }
                    if (linenew.endsWith(CData.HELP_STR)) {
                        linenew=linenew.substring(0,linenew.length()-1);
                        sb.append(linenew);
                    } else {
                        sb.append(linenew+"\n");
                    }
                    if (debug) System.out.println(linenew);
                }
                if (cdata.comment!=null && cdata.comment.length()>1) {
                    String line=cdata.comment;
                    String linenew=CData.COMMENT_STR;
                    for (int j=0;j<line.length();j++) {
                        if (line.charAt(j) == '\n') {
                            linenew+="\n";
                            linenew+=CData.COMMENT_STR;
                        } else {
                            linenew+=line.charAt(j);
                        }
                    }
                    if (linenew.endsWith(CData.COMMENT_STR)) {
                        linenew=linenew.substring(0,linenew.length()-1);
                        sb.append(linenew);
                    } else {
                        sb.append(linenew+"\n");
                    }
                    if (debug) System.out.println(linenew);
                }
            }
            sb.append(CData.CHECK_END_STR + "\n");
            if (debug) System.out.println(CData.CHECK_END_STR);
            return sb.toString();
        } catch (Exception ex) {
            //errorDisplay("Error in getResults()");
        }
        return "";
    }
    
    public static synchronized boolean tryLoadFile(File s) {
        String line;
        String charset=System.getProperty("checktool.readfilechar");
        InputStreamReader theInputStreamReader;
        FileInputStream fd;
        
        try {
            fd = new FileInputStream(s);
            if (charset.equals("usecurrentlocale")) {
                theInputStreamReader=new InputStreamReader(fd);
            } else {
                theInputStreamReader=new InputStreamReader(fd,charset);
            }
            LineNumberReader in = new LineNumberReader(theInputStreamReader, 4096);
            while ((line=in.readLine())!=null) {
            }
            theInputStreamReader.close();
            fd.close();
        } catch (sun.io.MalformedInputException me) {
            System.out.println("charset " + charset + " to UTF");
            charset="UTF8";
        } catch (Exception ex) {
            return false;
        }
        
        try {
            int linenumber=0;
            fd = new FileInputStream(s);
            if (charset.equals("usecurrentlocale")) {
                theInputStreamReader=new InputStreamReader(fd);
            } else {
                theInputStreamReader=new InputStreamReader(fd,charset);
            }
            LineNumberReader in = new LineNumberReader(theInputStreamReader, 4096);
            sheet_ver="";
            sheet_code="";
            while ((line=in.readLine())!=null) {
                if (line.startsWith(CData.CHECK_START_STR)) {
                    break;
                } else if (line.startsWith(CData.SHEET_VER_STR)) {
                    sheet_ver=line.substring(CData.SHEET_VER_STR.length()).trim();
                } else if (line.startsWith(CData.SHEET_CODE_STR)) {
                    sheet_code=line.substring(CData.SHEET_CODE_STR.length()).trim();
                }
            }
            /* counts line */
            while ((line=in.readLine())!=null) {
                if (line.startsWith(CData.CHECK_END_STR)) {
                    break;
                }
                if (line.startsWith(CData.COMMENT_STR)==false &&
                  line.startsWith(CData.HELP_STR)==false) {
                    linenumber++;
                }
            }
            theInputStreamReader.close();
            fd.close();
            
            if (debug) System.out.println("linenumber=" + linenumber);
            
            if (linenumber==0) {
                return false;
            }
            
            cdatas = new CData [linenumber];
            
            // ================= SHEET HELP ==================
            fd = new FileInputStream(s);
            if (charset.equals("usecurrentlocale")) {
                theInputStreamReader=new InputStreamReader(fd);
            } else {
                theInputStreamReader=new InputStreamReader(fd,charset);
            }
            in = new LineNumberReader(theInputStreamReader, 4096);
            boolean help_flag=false;
            sheetHelpText="";
            while ((line=in.readLine())!=null) {
                if (line.startsWith(CData.HELP_START_STR)) {
                    help_flag=true;
                    continue;
                }
                if (line.startsWith(CData.HELP_END_STR)) {
                    help_flag=false;
                    break;
                }
                if (help_flag) {
                    sheetHelpText += (line+"\n");
                }
            }
            if (help_flag) {
                // error
                sheetHelpText="";
            }
            theInputStreamReader.close();
            fd.close();
            
            /* reopen */
            fd = new FileInputStream(s);
            if (charset.equals("usecurrentlocale")) {
                theInputStreamReader=new InputStreamReader(fd);
            } else {
                theInputStreamReader=new InputStreamReader(fd,charset);
            }
            in = new LineNumberReader(theInputStreamReader, 4096);
            
            while ((line=in.readLine())!=null) {
                if (line.startsWith(CData.CHECK_START_STR)) {
                    break;
                }
            }
            if (debug) System.out.println("loadFile():read to CHECK_START_STR");
            linenumber=0;
            while ((line=in.readLine())!=null) {
                if (line.startsWith(CData.CHECK_END_STR)) {
                    break;
                }
                if (line.startsWith(CData.COMMENT_STR)==false &&
                  line.startsWith(CData.HELP_STR)==false) {
                    if (debug) System.out.println("L=" + line);
                    cdatas[linenumber++]=new CData(line);
                } else if (line.startsWith(CData.COMMENT_STR)) {
                    cdatas[linenumber-1].appendComment((line.substring(1)+"\n"));
                } else if (line.startsWith(CData.HELP_STR)) {
                    cdatas[linenumber-1].appendHelp((line.substring(1)+"\n"));
                }
            }
            
            theInputStreamReader.close();
            fd.close();
            
            if (debug) System.out.println("loadFile() is succeeded");
            if (debug) System.out.println("sheet_ver=" + sheet_ver);
            if (debug) System.out.println("sheet_code=" + sheet_code);
            
            return true;
            
        } catch (SecurityException ex) {
            if (debug) System.out.println(ex.toString());
            return false;
        } catch (Exception ex) {
            if (debug) System.out.println(ex.toString());
            return false;
        }
    }
    
    static boolean calcResult() {
        CData cdata;
        if (cdatas==null) {
            return false;
        }
        passed=0;
        failed=0;
        nocheck=0;
        try {
            for (int i=0;i<cdatas.length;i++) {
                cdata = cdatas[i];
                if (cdata.state==CData.PASSED) {
                    passed++;
                } else if (cdata.state==CData.FAILED) {
                    failed++;
                } else if (cdata.state==CData.NOCHECK) {
                    nocheck++;
                }
            }
            return true;
        } catch (Exception ex) {
        }
        return false;
    }
    
    static String getSmtpAddr() {
        return System.getProperty("user.fromaddr");
    }
    static String getSmtpHost() {
        return System.getProperty("mail.host");
    }
    static void setSmtp() {
        try {
            String str = System.getProperty("user.name");
            if (str != null) {
                String host = System.getProperty("mail.host");
                if (host == null) {
                    try {
                        host = InetAddress.getLocalHost().getHostName();
                    } catch (java.net.UnknownHostException e) {
                        return;
                    }
                }
                str += "@" + host;
                System.getProperties().put("mail.host", host);
                System.getProperties().put("user.fromaddr", str);
            }
        } catch (Exception ex) {
            
        }
    }
    public static void showConfirmDialog(Component parent, String title, Object message[], Icon icon) {
        String[]      options = {getString("ok_btn")};
        int result = JOptionPane.showOptionDialog(parent,
            message,
            title,
            JOptionPane.DEFAULT_OPTION,
            JOptionPane.QUESTION_MESSAGE,
            icon,
            options,
            options[0]);
    }
    public static void showConfirmDialog(Component parent, String title, Object message[]) {
        showConfirmDialog(parent, title, message, (Icon)null);
    }
    public static boolean showYesNoDialog(Component parent, String title, Object message[]) {
        String[]      options = {
            getString("yes_btn"),
            getString("no_btn")
        };
        
        int result = JOptionPane.showOptionDialog(parent,
            message,
            title,
            JOptionPane.DEFAULT_OPTION,
            JOptionPane.QUESTION_MESSAGE,
            null,
            options,
            options[1]);
        
        if (result == JOptionPane.YES_OPTION) {
            return true;
        }
        return false;
    }
    public static String getBaseDir() {
        if (applet!=null) {
            return applet.getCodeBase().toString();
        } else {
            return basedir.getAbsolutePath() + "/";
        }
    }
    public static Frame getFrame() {
        if (applet!=null) {
            Container parent;
            for (parent = applet; parent != null && !(parent instanceof Frame) ; parent = parent.getParent());
            if (parent != null) {
                return (Frame)parent;
            } else {
                return null;
            }
        } else {
            return frame;
        }
    }
    public static KeyStroke getKeyStroke(String k, String mask) {
        int mask_;
        int key_;
        if (mask.startsWith("CTRL")) {
            mask_=ActionEvent.CTRL_MASK;
        } else if (mask.startsWith("ALT")) {
            mask_=ActionEvent.ALT_MASK;
        } else if (mask.startsWith("META")) {
            mask_=ActionEvent.META_MASK;
        } else if (mask.startsWith("SHIFT")) {
            mask_=ActionEvent.SHIFT_MASK;
        } else {
            mask_=0;
        }
        key_=k.charAt(0);
        if (k.equals("LEFT")) {
            key_=KeyEvent.VK_LEFT;
        } else if (k.equals("RIGHT")) {
            key_=KeyEvent.VK_RIGHT;
        } else if (k.equals("UP")) {
            key_=KeyEvent.VK_UP;
        } else if (k.equals("DOWN")) {
            key_=KeyEvent.VK_DOWN;
        } else if (k.equals("PAGE_UP")) {
            key_=KeyEvent.VK_PAGE_UP;
        } else if (k.equals("PAGE_DOWN")) {
            key_=KeyEvent.VK_PAGE_DOWN;
        } else if (k.length()>1) {
            return null;
        }
        return KeyStroke.getKeyStroke(key_, mask_);
    }
    public static void setAccelerator(JMenuItem mi, String k, String mask) {
        KeyStroke ks;
        if ((ks=getKeyStroke(k, mask))!=null) {
            mi.setAccelerator(ks);
        }
    }
}
