/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.beans.*;
import java.io.*;
import java.net.URL;
import java.util.*;

class CommentDialog extends JDialog implements ActionListener {
    JTextArea textarea;
    Checktool ct;
    final String name="comment_";
    String prev_comment=null;
    
    public CommentDialog(Frame frame, Checktool ct) {
        super(frame);
        this.ct=ct;
        
        JPanel panel=new JPanel() {
            public Insets getInsets() {
                return new Insets(10,10,10,10);
            }
        };
        
        JButton passButton,failButton,applyButton,clearButton,nextButton,prevButton,resetButton;
        
        setTitle(ct.tool_title + " : " + ct.getString(name + "title"));
        setBackground(Color.lightGray);
        
        JPanel buttonpanel=new JPanel(new BorderLayout());
        
        JPanel buttonpanel1=new JPanel(new FlowLayout(FlowLayout.LEFT));
        JPanel buttonpanel2=new JPanel(new FlowLayout(FlowLayout.RIGHT,1,1));
        
        applyButton = new JButton(ct.getString(name + "apply_btn"));
        applyButton.setName("apply");
        applyButton.setToolTipText(ct.getString(name + "apply_btn_tip"));
        applyButton.addActionListener(this);
        
        resetButton = new JButton(ct.getString(name + "reset_btn"));
        resetButton.setName("reset");
        resetButton.setToolTipText(ct.getString(name + "reset_btn_tip"));
        resetButton.addActionListener(this);
        
        clearButton = new JButton(ct.getString(name + "clear_btn"));
        clearButton.setName("clear");
        clearButton.setToolTipText(ct.getString(name + "clear_btn_tip"));
        clearButton.addActionListener(this);
        
        passButton = ct.getButton(ct.pass_icon);
        passButton.setName("pass");
        passButton.setToolTipText(ct.getString(name + "pass_btn_tip"));
        passButton.addActionListener(this);
        
        failButton = ct.getButton(ct.fail_icon);
        failButton.setName("fail");
        failButton.setToolTipText(ct.getString(name + "fail_btn_tip"));
        failButton.addActionListener(this);
        
        nextButton = ct.getButton(ct.comment_next_icon);
        nextButton.setName("next");
        nextButton.setToolTipText(ct.getString(name + "next_btn_tip"));
        nextButton.addActionListener(this);
        
        prevButton = ct.getButton(ct.comment_prev_icon);
        prevButton.setName("prev");
        prevButton.setToolTipText(ct.getString(name + "prev_btn_tip"));
        prevButton.addActionListener(this);
        
        buttonpanel1.add(applyButton);
        buttonpanel1.add(resetButton);
        buttonpanel1.add(clearButton);
        
        buttonpanel2.add(prevButton);
        buttonpanel2.add(nextButton);
        buttonpanel2.add(Box.createHorizontalStrut(6));
        buttonpanel2.add(failButton);
        buttonpanel2.add(passButton);
        
        buttonpanel.add(buttonpanel1,BorderLayout.WEST);
        buttonpanel.add(buttonpanel2,BorderLayout.EAST);
        
        panel.setLayout(new BorderLayout());
        panel.add("North", buttonpanel);
        
        textarea=new JTextArea();
        JScrollPane scrollPane = new JScrollPane(textarea);
        
        panel.add(BorderLayout.CENTER, scrollPane);
        textarea.setFont(Shared.getInputFont());
        
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(BorderLayout.CENTER, panel);
        
        pack();
        setSize(600, 200);
        
        Shared.setWindowPosition(frame, this, Shared.POSITION_BOTTOM);
    }
    
    public void actionPerformed(ActionEvent e) {
        String cmd=((JButton)e.getSource()).getName();
        if (cmd.equals("apply")) {
            String s;
            s=textarea.getText();
            ct.cdatas[ct.current_index].setComment(s);
            prev_comment=s;
            ct.list.repaint();
            ct.setActiveStore(true);
        } else if (cmd.equals("reset")) {
            CData cdata=ct.getCurrentData();
            String cmt=cdata.comment;
            if (cmt!=null && cmt.equals("")==false) {
                setComment(cmt);
                prev_comment=cmt;
            } else {
                setComment("");
                prev_comment="";
            }
        } else if (cmd.equals("clear")) {
            setComment("");
        } else if (cmd.equals("next")) {
            ct.nextComment();
        } else if (cmd.equals("prev")) {
            ct.prevComment();
        } else if (cmd.equals("pass")) {
            ct.passList();
        } else if (cmd.equals("fail")) {
            ct.failList();
        }
    }
    
    public void setComment(String s) {
        textarea.setText(s);
    };
    
    public void setVisible() {
        CData cdata=ct.getCurrentData();
        if (cdata == null) {
            return;
        }
        
        String cmt=cdata.comment;
        
        if (isVisible()==false) {
            setVisible(true);
        }
        
        if (prev_comment!=null &&
          prev_comment.equals("")&&
          (cmt==null || cmt.equals("")==true)) {
            return;
        }
        
        if (cmt!=null && cmt.equals("")==false) {
            setComment(cmt);
            prev_comment=cmt;
        } else {
            setComment("");
            prev_comment="";
        }
    };
}
