/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.beans.*;
import java.io.*;
import java.net.URL;
import java.util.*;

class DocDialog extends JDialog {
    HtmlPanel hp;
    final String name="docdialog_";
    JLabel url_label;
    JTextField url_textfield;
    JButton closeButton;

    //public DocDialog(Frame frame, String url_string) {
    public DocDialog(Frame frame, URL url) {
        super(frame);
        
        JPanel panel = new JPanel() {
            public Insets getInsets() {
                return new Insets(10,10,10,10);
            }
        };
        panel.setLayout(new BorderLayout());
        
        PropertyPanel textPanel = new PropertyPanel();
        textPanel.addHeader(url_label=new JLabel("URL:"));
        textPanel.addAnchor(url_textfield=new JTextField());
        url_textfield.setEditable(false);
        
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel1 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        
        closeButton = new JButton("close");
        buttonPanel1.add(closeButton);
        closeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        
        hp=new HtmlPanel(url);
        
        url_textfield.setText(url.toString());
        panel.add(BorderLayout.NORTH, textPanel);
        panel.add(BorderLayout.CENTER, hp);
        panel.add(BorderLayout.SOUTH, buttonPanel1);
        
        getContentPane().add(BorderLayout.CENTER, panel);
        
        setSize(600, 400);
        
        Shared.setWindowPosition(frame, this, Shared.POSITION_SIDE);
    }
    
    public void setCloseButton(String s) {
        closeButton.setLabel(s);
        
    }
    
    public void setVisible() {
        setVisible(true);
    }

    public void setPage(URL url) {
        url_textfield.setText(url.toString());
        hp.setPage(url);
    }
}
