/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.beans.*;
import java.io.*;
import java.net.URL;
import java.util.*;

class HelpDialog extends JDialog {
    JTextArea textarea;
    JRadioButton itembutton, sheetbutton;
    Checktool ct;
    final String name="help_";
    
    public HelpDialog(Frame frame, Checktool ct) {
        super(frame);
        JButton closeButton;
        
        this.ct=ct;
        
        setTitle(ct.tool_title + " : " + ct.getString(name+"title"));
        
        JPanel panel = new JPanel() {
            public Insets getInsets() {
                return new Insets(10,10,10,10);
            }
        };
        
        JPanel buttonPanel1 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        
        closeButton = new JButton(ct.getString(name+"close_btn"));
        buttonPanel1.add(closeButton);
        closeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        
        JPanel buttonPanel2 = new JPanel(new FlowLayout(FlowLayout.LEFT));
        buttonPanel2.add(new JLabel(ct.getString(name+"about_label")));
        
        ButtonGroup group = new ButtonGroup();
        itembutton = new JRadioButton(ct.getString(name+"item_btn"), true);
        itembutton.setToolTipText(ct.getString(name+"item_btn_tip"));
        group.add(itembutton);
        buttonPanel2.add(itembutton);
        itembutton.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                if (((JRadioButton)e.getSource()).isSelected() == true) {
                    showItemHelp();
                }
            }
        });
        
        sheetbutton = new JRadioButton(ct.getString(name+"sheet_btn"));
        group.add(sheetbutton);
        sheetbutton.setToolTipText(ct.getString(name+"sheet_btn_tip"));
        buttonPanel2.add(sheetbutton);
        sheetbutton.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                if (((JRadioButton)e.getSource()).isSelected() == true) {
                    showSheetHelp();
                }
            }
        });
        
        panel.setLayout(new BorderLayout());
        panel.add(BorderLayout.NORTH, buttonPanel2);
        
        textarea=new JTextArea();
        JScrollPane scrollPane = new JScrollPane(textarea);
        
        panel.add(BorderLayout.CENTER, scrollPane);
        panel.add(BorderLayout.SOUTH, buttonPanel1);
        
        getContentPane().add(BorderLayout.CENTER, panel);
        
        textarea.setFont(Shared.getInputFont());
        textarea.setEditable(false);
        setSize(600, 400);
        
        Shared.setWindowPosition(frame, this, Shared.POSITION_SIDE);
    }
    public void setVisible() {
        CData cdata=ct.getCurrentData();
        if (cdata==null) {
            return;
        }
        if (itembutton.isSelected()) {
            showItemHelp();
        } else {
            showSheetHelp();
        }
        setVisible(true);
    }
    public void setHelp(String s) { textarea.setText(s); };
    public void showItemHelp() {
        CData cdata=ct.getCurrentData();
        if (cdata==null) {
            return;
        }
        if (cdata.help!=null && cdata.help.equals("")==false) {
            setHelp(cdata.help);
        } else {
            setHelp("");
        }
    }
    public void showSheetHelp() {
        CData cdata=ct.getCurrentData();
        if (cdata==null) {
            return;
        }
        if (ct.sheetHelpText!=null&&ct.sheetHelpText!="") {
            setHelp(ct.sheetHelpText);
        } else {
            setHelp("");
        }
    }
}
