/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import java.awt.*;
import java.util.*;

public class PrintCs implements Runnable {
    private Thread thread;
    
    PrintCanvas canvas;
    Checktool ct=null;
    
    public void start() {
        thread = new Thread(this);
        thread.start();
    }
    
    public PrintCs(Checktool ct_) {
        this.ct=ct_;
    }
    
    public void run() {
        doPrint();
    }
    
    public void doPrint() {
        PrintJob pjob = ct.getToolkit().getPrintJob(ct.frame, "Checktool", null);
        
        if (pjob != null) {
            Dimension d=pjob.getPageDimension();
            int lineperpage=(d.height-PrintCanvas.top_margin-PrintCanvas.tail_margin)/PrintCanvas.lineheight;
            canvas = new PrintCanvas(ct, d.width, d.height);
            canvas.setLinePerPage(lineperpage);
            int pagecount=canvas.getPageCount();
            for (int i=0;i<pagecount;i++) {
                Graphics pg = pjob.getGraphics();
                if (pg != null) {
                    canvas.print(pg);
                    pg.dispose();
                }
            }
            pjob.end();
        }
    }
}

class PrintCanvas extends Canvas {
    Checktool ct=null;
    final static int lineheight=12;
    int printpage=0;
    int lineperpage=50;
    int pagewidth=0;
    int pageheight=0;
    String res[];
    
    final static int top_margin=20+lineheight;
    final static int tail_margin=20;
    final static int xmargin=20;
    
    final String fontname="Monospaced";
    int totalline=0;
    
    public PrintCanvas(Checktool ct_, int width, int height) {
        this.ct=ct_;
        this.pagewidth=width;
        this.pageheight=height;
        printpage=0;
        String p=ct.getResult();
        String line;
        int c=0;
        
        StringTokenizer st = new StringTokenizer(p, "\n\r");
        while (st.hasMoreTokens()) {
            line=st.nextToken();
            c++;
        }
        res = new String [c];
        
        c=0;
        st = new StringTokenizer(p, "\n\r");
        while (st.hasMoreTokens()) {
            res[c++]=st.nextToken();
        }
        
        totalline=c;
    }
    
    public void setLinePerPage(int m) {
        lineperpage=m;
    }
    
    public int getPageCount() {
        int pagecount=totalline/lineperpage;
        if (totalline%lineperpage>0) {
            pagecount++;
        }
        //System.out.println("len=" + totalline);
        //System.out.println("page=" + pagecount);
        return pagecount;
    }
    
    
    /*
    -------
    |
    -------
    -------
    |
    |
    -------
    */
    
    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.setFont(new Font(fontname, Font.BOLD, 10));
        
        g.drawRect(
        xmargin,
        top_margin-lineheight-1,
        pagewidth-xmargin*2,
        lineheight);
        
        g.drawString(ct.currentFile.getName() + "   " + ct.sheet_code + "     " + ct.sheet_ver + "    " + "Page " + (printpage+1), top_margin + 3, top_margin - 4);
        
        g.drawRect(
        xmargin,
        top_margin,
        pagewidth-xmargin*2,
        pageheight-top_margin-tail_margin);
        
        //System.out.println("printing page=" + printpage);
        
        g.setFont(new Font(fontname, Font.PLAIN, 10));
        for (int i=1;i<=lineperpage;i++) {
            if (totalline<=i+lineperpage*printpage) {
                break;
            }
            String p=res[i+lineperpage*printpage];
            String q="";
            
            for (int j=0;j<p.length();j++) {
                if (p.charAt(j) == '\t') {
                    q+="    ";
                } else {
                    q+=p.charAt(j);
                }
            }
            p=q;
            
            String n="";
            if (p.endsWith("[]")) {
                n="  [------]  ";
                g.setFont(new Font(fontname, Font.BOLD, 10));
                p=p.substring(0,p.length()-2);
            } else if (p.endsWith("[x]") || p.endsWith("[X]")) {
                n="  [PASSED]  ";
                g.setFont(new Font(fontname, Font.BOLD, 10));
                p=p.substring(0,p.length()-3);
            } else if (p.endsWith("[o]") || p.endsWith("[O]")) {
                n="  [FAILED]  ";
                g.setFont(new Font(fontname, Font.BOLD, 10));
                p=p.substring(0,p.length()-3);
            } else if (p.startsWith("HELP_") || p.startsWith("CHECK_")) {
                p="";
                g.drawLine(
                xmargin,
                top_margin+lineheight*i,
                pagewidth-xmargin,
                top_margin+lineheight*i);
            } else {
                g.setFont(new Font(fontname, Font.PLAIN, 10));
                n="            ";
            }
            n+=p;
            g.drawString(n,
                xmargin,
                top_margin+lineheight*i);
        }
        printpage++;
    }
}
