/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import javax.swing.border.*;

import java.net.*;
import java.awt.*;
import java.applet.*;
import java.io.*;
import java.util.*;

import sun.net.smtp.SmtpClient;

abstract class Shared {
    
    public final static Border emptyBorder0 = new EmptyBorder(0,0,0,0);
    public final static Border emptyBorder5 = new EmptyBorder(5,5,5,5);
    public final static Border emptyBorder10 = new EmptyBorder(10,10,10,10);
    public final static Border emptyBorder15 = new EmptyBorder(15,15,15,15);
    public final static Border emptyBorder20 = new EmptyBorder(20,20,20,20);
    public final static Border loweredBorder = new SoftBevelBorder(BevelBorder.LOWERED);
    
    public static boolean sendMail(String from, String to,
        String cc, String subject, String body,
        String host, String charset) {
        
        return JavaMailSender.SendMail(from,to,cc,subject,body,host,charset);
    }
    
    public static String sendMailSmtp(String from, String to,
        String cc, String subject, String body) {
        
        String str;
        
        try {
            SmtpClient mailer = new SmtpClient();
            mailer.from(from);
            mailer.to(to);
            
            PrintStream msgStream = mailer.startMessage();
            OutputStreamWriter writer;
            
            String c=System.getProperty("checktool.writefilechar");
            if (c!=null && c.equals("usecurrentlocale")==false) {
                writer = new OutputStreamWriter(msgStream, c);
            } else {
                writer = new OutputStreamWriter(msgStream);
            }
            
            if (from.length() > 0) {
                str="From: "+from+"\n";
                writer.write(str, 0, str.length());
            }
            
            str="To: "+to+"\n";
            writer.write(str, 0, str.length());
            
            if (cc != null && cc.length() > 0) {
                str="Cc: "+cc+"\n";
                writer.write(str, 0, str.length());
            }
            
            if (subject != null && subject.length() > 0) {
                str="Subject: " + subject + "\n";
                writer.write(str, 0, str.length());
            }
            //msgStream.println("Mime-version: 1.0");
            //msgStream.println(body);
            
            str="\n" + body + "\n";
            writer.write(str, 0, str.length());
            
            writer.close();
            mailer.closeServer();
        } catch (IOException e) {
            System.out.println(e.toString());
            return e.toString();
        } catch (Exception e) {
            System.out.println(e.toString());
            return e.toString();
        }
        return ""; // succeed
    }
    public static String getHostName() {
        String host="";
        try {
            host = InetAddress.getLocalHost().getHostName();
        } catch (java.net.UnknownHostException e) {
        }
        return host;
    }
    public static String getUserName() {
        return System.getProperty("user.name");
    }
    public static String getJvmVer() {
        return System.getProperty("java.version");
    }
    public static String getOsName() {
        return System.getProperty("os.name") + " " +
        System.getProperty("os.version");
    }
    public static String getOsArch() {
        return System.getProperty("os.arch");
    }
    
    public static boolean IsWindows() {
        String osname = System.getProperty("os.name");
        return(osname.startsWith("Windows"));
    }
    
    public static boolean IsUnix() {
        String osname = System.getProperty("os.name");
        return(!osname.startsWith("Windows"));
    }
    
    public static final int POSITION_SIDE=1;
    public static final int POSITION_BOTTOM=0;
    
    public static void setWindowPosition(Component parent, Component child,
        int position) {
        int x=0,y=0;
        Point p=parent.getLocation();
        Dimension d=parent.getSize();
        Dimension ds=child.getSize();
        Dimension s=Toolkit.getDefaultToolkit().getScreenSize();
        if (position==POSITION_BOTTOM) {
            x=p.x;
            y=p.y+d.height;
            if (s.height < p.y+d.height+ds.height) {
                y=s.height-ds.height;
            }
        } else if (position==POSITION_SIDE) {
            y=p.y;
            int left=p.x;		// left
            int right=s.width-(p.x+d.width);	// right
            if (right >= left) {
                x=p.x+d.width;
                if (s.width < p.x+d.width+ds.width) {
                    x=s.width-ds.width;
                }
            } else {
                x=p.x-ds.width;
                if (x < 0) {
                    x=0;
                }
            }
        } else {
            return;
        }
        child.setLocation(x, y);
    }
    
    public static synchronized String getHtmlContents(URL url) {
        String a=getHtmlContents("JISAutoDetect", url);
        if (a!="" && a!=null && a.equals("SecurityException")) {
            System.out.println("SecurityException");
            return "";
        }
        if (a!="" && a!=null && a.equals("Exception")) {
            System.out.println("Unknown Error");
            return "";
        }
        if (a!="" && a!=null) {
            return a;
        }
        a=getHtmlContents("JIS", url);
        if (a!="" && a!=null) {
            return a;
        }
        a=getHtmlContents("EUCJIS", url);
        if (a!="" && a!=null) {
            return a;
        }
        a=getHtmlContents("SJIS", url);
        if (a!="" && a!=null) {
            return a;
        }
        a=getHtmlContents("", url);
        if (a!="" && a!=null) {
            return a;
        }
        a=getHtmlContents("8859_1", url);
        if (a!="" && a!=null) {
            return a;
        }
        return null;
    }
    
    private static synchronized String getHtmlContents(String conv, URL url) {
        try {
            InputStream theFileInputStream=url.openStream();
            InputStreamReader theInputStreamReader=null;
            if (conv.equals("")) {
                theInputStreamReader=new InputStreamReader(theFileInputStream);
            } else {
                theInputStreamReader=new InputStreamReader(theFileInputStream, conv);
            }
            BufferedReader in = new BufferedReader(theInputStreamReader, 4096);
            int buf;
            StringBuffer sb = new StringBuffer();
            while ((buf=theInputStreamReader.read())!=-1) {
                sb.append((char)buf);
            }
            theInputStreamReader.close();
            theFileInputStream.close();
            return new String(sb.toString());
        } catch (SecurityException ex) {
            return "SecurityException";
        } catch (Exception ex) {
            return "";
        }
    }
    
    public static Font input_font=null;
    public static Font bold_font=null;
    
    public static Font getInputFont() {
        if (input_font==null) {
            input_font=new Font("DialogInput", Font.PLAIN, 12);
        }
        return input_font;
    }
    
    public static Font getBoldFont() {
        if (bold_font==null) {
            bold_font=new Font("DialogInput", Font.BOLD, 14);
        }
        return bold_font;
    }
    
    public static void saveFile(File s, String str) {
        if (s == null) {
            return;
        }
        try {
            OutputStreamWriter writer;
            writer = new OutputStreamWriter(new FileOutputStream(s));
            
            writer.write(str, 0, str.length());
            
            writer.close();
            
        } catch (IOException e) {
            System.out.println(e);
        }
    }
}
