/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.beans.*;
import java.net.*;

class ToolPropsDialog extends JDialog {
    JTextField mailaddress_tf, mailhost_tf;
    JRadioButton btn_default=null, btn_run;
    JRadioButton btn_gui_metal, btn_gui_windows, btn_gui_motif;
    Checktool ct;
    final String name="toolprops_";
    
    public ToolPropsDialog(Frame frame, Checktool ct_) {
        super(frame);
        JButton applyButton, closeButton;
        
        this.ct=ct_;
        
        setTitle(ct.tool_title + " : " + ct.getString(name+"title"));
        
        JPanel panel = new JPanel() {
            public Insets getInsets() {
                return new Insets(10,10,10,10);
            }
        };
        
        JPanel buttonPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        applyButton = new JButton(ct.getString(name+"apply_btn"));
        closeButton = new JButton(ct.getString(name+"close_btn"));
        buttonPanel.add(applyButton);
        buttonPanel.add(closeButton);
        closeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        applyButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                // SMTP
                String host=mailhost_tf.getText();
                String address=mailaddress_tf.getText();
                if (host!=null&&host.equals("")==false) {
                    System.getProperties().put("mail.host", host);
                } else {
                    //error
                }
                if (address!=null&&address.equals("")==false) {
                    System.getProperties().put("user.fromaddr", address);
                } else {
                    //error
                }
                // CHARSET
                if (btn_default==null) {
                    System.getProperties().put("checktool.writefilechar", "usecurrentlocale");
                } else {
                    if (btn_default.isSelected()==true) {
                        System.getProperties().put("checktool.writefilechar",
                            btn_default.getLabel());
                    } else {
                        System.getProperties().put("checktool.writefilechar", "usecurrentlocale");
                    }
                }
                // CHARSET
                int result=1;
                if (btn_gui_motif.isSelected()==true) {
                    result=updateLookandFeel(btn_gui_motif);
                } else if (btn_gui_windows.isSelected()==true) {
                    result=updateLookandFeel(btn_gui_windows);
                } else if (btn_gui_metal.isSelected()==true) {
                    result=updateLookandFeel(btn_gui_metal);
                }
                if (result==1) {
                    setVisible(false);
                }
            }
        });
        
        JTabbedPane tf = new JTabbedPane();
        
        // ===== SMTP ================================================
        JPanel smtpPanel_ = new JPanel(new BorderLayout());
        PropertyPanel smtpPanel = new PropertyPanel();
        smtpPanel.addHeader(new JLabel(ct.getString(name+"mailhost"),JLabel.RIGHT));
        smtpPanel.addAnchor(mailhost_tf=new JTextField(30));
        smtpPanel.addHeader(new JLabel(ct.getString(name+"mailaddress"),JLabel.RIGHT));
        smtpPanel.addAnchor(mailaddress_tf=new JTextField(30));
        
        smtpPanel_.add(BorderLayout.CENTER, smtpPanel);
        tf.addTab(ct.getString(name+"smtp"), smtpPanel_);
        
        // ===== CHARSET ================================================
        ButtonGroup charset_group = new ButtonGroup();
        String charset=System.getProperty("checktool.writefilechar");
        
        btn_run=new JRadioButton(ct.getString(name+"runninglocale"));
        btn_run.setSelected(false);
        
        if (charset.equals("usecurrentlocale")==false) {
            btn_default=new JRadioButton(System.getProperty("checktool.writefilechar"));
            btn_default.setSelected(true);
            charset_group.add(btn_default);
        } else {
            btn_run.setSelected(true);
        }
        charset_group.add(btn_run);
        
        JPanel outputPanel_ = new JPanel(new BorderLayout());
        PropertyPanel outputPanel = new PropertyPanel();
        outputPanel.addHeader(new JLabel(ct.getString(name+"outputchar"),JLabel.RIGHT));
        outputPanel.addAnchor(btn_run);
        if (btn_default!=null) {
            outputPanel.addHeader(new JLabel(""));
            outputPanel.addAnchor(btn_default);
        }
        
        outputPanel_.add(BorderLayout.CENTER, outputPanel);
        tf.addTab(ct.getString(name+"charset"), outputPanel_);
        
        // ===== GUI ================================================
        ButtonGroup gui_group = new ButtonGroup();
        
        btn_gui_metal=new JRadioButton(ct.getString(name + "metal_btn"));
        btn_gui_windows=new JRadioButton(ct.getString(name + "windows_btn"));
        btn_gui_motif=new JRadioButton(ct.getString(name + "motif_btn"));
        gui_group.add(btn_gui_metal);
        gui_group.add(btn_gui_windows);
        gui_group.add(btn_gui_motif);
        btn_gui_metal.setSelected(true);
        
        if (ct.getString("checktool.lookandfeel")!=null) {
            String s=ct.getString("checktool.lookandfeel");
        }
        
        JPanel guiPanel_ = new JPanel(new BorderLayout());
        PropertyPanel guiPanel = new PropertyPanel();
        guiPanel.addHeader(new JLabel(ct.getString(name+"lookandfeel"),JLabel.RIGHT));
        guiPanel.addAnchor(btn_gui_metal);
        guiPanel.addHeader(new JLabel(""));
        guiPanel.addAnchor(btn_gui_windows);
        guiPanel.addHeader(new JLabel(""));
        guiPanel.addAnchor(btn_gui_motif);
        
        guiPanel_.add(BorderLayout.CENTER, guiPanel);
        tf.addTab(ct.getString(name+"lookandfeel_tab"), guiPanel_);
        
        panel.setLayout(new BorderLayout());
        panel.add(BorderLayout.SOUTH, buttonPanel);
        panel.add(BorderLayout.CENTER, tf);
        
        getContentPane().add(BorderLayout.CENTER, panel);
        
        setMailHost();
        setMailAddress();
        
        setSize(400,400);
        
        Shared.setWindowPosition(frame, this, Shared.POSITION_SIDE);
    }
    
    public void setMailAddress() {
        String str = ct.getSmtpAddr();
        if (str!=null) {
            mailaddress_tf.setText(str);
        }
    }
    
    public void setMailHost() {
        String str = ct.getSmtpHost();
        if (str != null) {
            mailhost_tf.setText(str);
        }
    }
    
    public void setVisible() {
        setVisible(true);
    }
    
    static String currentUI="Metal";
    
    public int updateLookandFeel(JRadioButton rb) {
        String s=rb.getLabel();
        ct.setBusy(true);
        boolean need_update=false;
        try {
            if (s.equals("Windows")) {
                if (currentUI.equals("Windows")==false) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    need_update=true;
                }
            } else if (s.equals("Motif")) {
                if (currentUI.equals("Motif")==false) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    need_update=true;
                }
            } else if (s.equals("Metal")) {
                if (currentUI.equals("Metal")==false) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    need_update=true;
                }
            }
        } catch (UnsupportedLookAndFeelException exc) {
            System.out.println(exc);
            ct.setBusy(false);
            rb.setEnabled(false);
            ct.errorDisplay(ct.getString(name+"unsupport_message") + ":" + s);
            if (currentUI.equals("Windows")) {
                btn_gui_windows.setSelected(true);
            } else if (currentUI.equals("Motif")) {
                btn_gui_motif.setSelected(true);
            } else if (currentUI.equals("Metal")) {
                btn_gui_metal.setSelected(true);
            }
            return 0; // false
        } catch (Exception exc) {
            System.out.println(exc);
            rb.setEnabled(false);
            ct.setBusy(false);
            ct.errorDisplay(ct.getString(name+"unload_message") + ":" + s);
            return 0; // false
        }
        if (need_update) {
            currentUI=s;
            updateComponentTreeUI_(ct.getFrame());
            updateComponentTreeUI_(ct.commentDialog);
            updateComponentTreeUI_(ct.maildialog);
            updateComponentTreeUI_(ct.bugmaildialog);
            updateComponentTreeUI_(ct.helpDialog);
            updateComponentTreeUI_(ct.docDialog);
            updateComponentTreeUI_(ct.propsDialog);
            updateComponentTreeUI_(ct.toolpropsDialog);
            updateComponentTreeUI_(ct.chooser);
        }
        ct.setBusy(false);
        return 1;	// succeed
    }
    
    public static void updateComponentTreeUI_(Component a) {
        if (a!=null) {
            SwingUtilities.updateComponentTreeUI(a);
            a.validate();
            a.repaint();
        }
    }
}
