//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: TextViewPort.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_TextViewPort_)
#define	_Cvo_TextViewPort_

#if	!defined(_Cvo_ViewPort_)
#include <Cvo/ViewPort.h++>
#endif
#if	!defined(_Cvo_CRT_)
#include <Cvo/CRT.h++>
#endif
#if	!defined(_Cvo_Page_)
#include <Cvo/Page.h++>
#endif

#define	CvoTVP_RAISED		0x01

class Cvo_HighlightSegment {
public:
    Cvo_HighlightSegment(int line, int column, int length, Cvo_TextAttribute *);
    int row,col,len;
    Cvo_TextAttribute	*attr;
    Cvo_HighlightSegment *next;
};

inline
Cvo_HighlightSegment::Cvo_HighlightSegment(int line,int column,int length,
					   Cvo_TextAttribute *attribute)
{
    row = line;
    col = column;
    len = length;
    attr = attribute;
    next = NULL;
}

class Cvo_TextViewPort : public Cvo_ViewPort {
public:
    Cvo_Page	*page;
    Cvo_CRT	*text;

    void AddHighlightSegment(Cvo_HighlightSegment*);
    void ClearHighlightSegments();
protected:
    int		firstline;		// first line displayed
    int		lastline;		// last line displayed
    int		lines;			// last number of lines we knew about
    BOOL	jumptoend:1;		// 1 -> jump to end on page change
    BOOL	lookAtScreenOnly:1;
    BOOL	drawingscreen:1;
    Cvo_HighlightSegment *hilites;
    Cvo_HighlightSegment *lasthilite;
    void _Init(Cvo_Page *);
    void _Init()			{ _Init(0); }
    void EvaluateWidth(int = 0);
    virtual int Special(int);
    void DrawHighlightSegments();
    BOOL RedrawLine(unsigned, Cvo_CharacterBuffer &);
    BOOL WillLineFit(unsigned, Cvo_CharacterBuffer &);

    friend void Cvo_TextViewPort_ScrollHorizontal(Cvo_Object *, XEvent *, void *);
    friend void Cvo_TextViewPort_ScrollVertical(Cvo_Object *, XEvent *, void *);
    friend void Cvo_TextViewPort_PageChanged(Cvo_Object *, XEvent *, void *);
    friend void Cvo_TextViewPort_TextChangedSize(Cvo_Object *, XEvent *, void *);
    friend void Cvo_TextViewPort_MapRequest(Cvo_Object *, XEvent *, void *);
public:
    CONSTRUCDECL_1ARG(Cvo_TextViewPort, Cvo_Page *)
    CONSTRUCDECL(Cvo_TextViewPort)
    void	_Create();
    void	DontJump()		{ jumptoend = 0; }
    void	Jump(BOOL v = True)	{ jumptoend = v; }
    int		FirstLine()		{ return(firstline);	}
    int		LastLine()		{ return(lastline);	}
    void	GotoLine(int line, BOOL = False);
    Cvo_CRT     *Text()                 { return((Cvo_CRT *)main); }
    void	OnlyEvaluateScreen(BOOL v = True)
					{ lookAtScreenOnly = v; }
    Cvo_Page	*Page()			{ return(page); }
    virtual void MoveCursor(int, int);

    //
    // Forward on the string handling functions to the text part of
    // our object.
    //
    int StringWidth(char *s, int n = -1);
    int StringWidth(wchar_t *s, int n = -1);
    void StringExtents(char *s, int n, XRectangle &ink, XRectangle &log)
	{ text->StringExtents(s,n,ink,log); }
    void StringExtents(char *s, int n, XRectangle &ink)
	{ text->StringExtents(s,n,ink); }
    void StringExtents(char *s, XRectangle &ink, XRectangle &log)
	{ text->StringExtents(s,ink,log); }
    void StringExtents(char *s, XRectangle &ink)
	{ text->StringExtents(s,ink); }
    void StringExtents(wchar_t *s, int n, XRectangle &ink, XRectangle &log)
	{ text->StringExtents(s,n,ink,log); }
    void StringExtents(wchar_t *s, int n, XRectangle &ink)
	{ text->StringExtents(s,n,ink); }
    void StringExtents(wchar_t *s, XRectangle &ink, XRectangle &log)
	{ text->StringExtents(s,ink,log); }
    void StringExtents(wchar_t *s, XRectangle &ink)
	{ text->StringExtents(s,ink); }
};
#endif
