/*
 *
 * Create a Cvo_Application object with a Cvo_Matrix as a child.
 * The Cvo_Matrix object will contain four Cvo_Label objects
 * diagonally from upper left to lower right, will contain Cvo_Input
 * objects in the lower left and upper right corners, and a Cvo_Pin
 * object beneath the upper right Cvo_Input object. The Cvo_Matrix
 * is good for organizing different objects in this manner.
 *
 * Pulling the push pin out destroys the application.
 *
 */

#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/Input.h++>
#include <Cvo/Label.h++>
#include <Cvo/Matrix.h++>
#include <Cvo/Pin.h++>

// Increase the spacing between the various objects in
// the matrix. The default is three.

static Cvo_Default def[] = {
    "*CvoMatrix.Space: 7"
};

void Finished(Cvo_Object *, XEvent *, void *);

main(int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);

    // Create the Cvo_Application object and the Cvo_Matrix
    // object as its child.

    Cvo_Application *exampleApp = new Cvo_Application("exampleApp");
    Cvo_Matrix *matrixThing = new Cvo_Matrix("matrixThing", exampleApp);

    char resource[30], label[30];

    // Create four buttons, diagonally from upper left to lower
    // right.

    for (int i=1;i<=4;i++) {
	sprintf(resource, "button%d", i);
	sprintf(label, "Button %d", i);
	matrixThing->AddCell(new Cvo_Button(resource, matrixThing, label), i, i);
    }

    // Create two Cvo_Input objects.

    matrixThing->AddCell(new Cvo_Input("input1", matrixThing), 1, 4);
    matrixThing->AddCell(new Cvo_Input("input2", matrixThing), 4, 1);

    // Create a Cvo_Pin, pin it in, and register it to call the
    // Finished() function when it is pulled out.

    Cvo_Pin *pin1 = new Cvo_Pin("pin1", matrixThing);
    pin1->ForceOn();
    Cvo_Register(pin1, CvoButtonUpEvent, Finished);
    matrixThing->AddCell(pin1, 2, 4);

    exampleApp->MainLoop();
}

void Finished(Cvo_Object *, XEvent *, void *)
{
    Cvo_Exit(0);
}
