#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/OpenFile.h++>
#include <Cvo/TextPage.h++>

#define B_OPEN		100
#define B_RESEL		101
#define B_RADIO		102

void Handler(Cvo_Object *, XEvent *, void *);

Cvo_OpenFileInfo open_file("openfile");
Cvo_SaveFileInfo save_file("openfile");

Cvo_MenuItem menu1[] = {
    { "menu1-open", Cvo_OpenFile, &open_file, 0 },
    { "menu1-save", Cvo_SaveFile, &save_file, 0 },
    NULL
};

Cvo_MenuBarList menu_bar[] = {
    { "mb-file", menu1 },
    NULL
};

Cvo_Default def[] = {
    "*button.label: Open a file",
    "*reselect-button.label: Toggle Reselect Mode",
    "*radiomode-button.label: Toggle Radio Mode",

    "*CvoMenu*menu1-open.label: _Open File",
    "*CvoMenu*menu1-save.label: _Save File",

    "*CvoMenuBar*mb-file: _File",

    "*openfile.title: Open File",
};

char *list_data[] = {
    "The Moon",
    "Is Blue",
    "In May.",
    "But it is",
    "Red on",
    "Halloween",
    NULL
};

int main(int argc, char **argv)
{
    int i;

    open_file.SetEntry("/usr/lib/");
    open_file.SetFilter("*.a");

    Cvo_Parse(&argc, &argv);

    Cvo_Application *app = new Cvo_Application("exampleApp", menu_bar);
    app->Register(CvoOpenFileEvent, Handler);

    Cvo_Button *but = new Cvo_Button("button", app, "NR");
    but->SetData((void *) B_OPEN);
    but->Register(CvoButtonUpEvent, Handler);

    Cvo_TextPage *page = new Cvo_TextPage();

    for(i=0;list_data[i]!=NULL;page->AppendText(list_data[i++]));

    Cvo_List *list = new Cvo_List("list", app, page);
    list->AllowReselect(True);
    list->UseRadioStyle(True);
    list->ExpandFrame();
    list->SetMinSize(0, 8);
    list->Register(CvoListItemSelectedEvent, Handler);

    Cvo_Button *resel = new Cvo_Button("reselect-button", app, "NR");
    resel->SetData((void *) B_RESEL);
    resel->Register(CvoButtonUpEvent, Handler, list);

    Cvo_Button *radiomode = new Cvo_Button("radiomode-button", app, "NR");
    radiomode->SetData((void *) B_RADIO);
    radiomode->Register(CvoButtonUpEvent, Handler, list);

    app->MainLoop();
}

void Handler(Cvo_Object *obj, XEvent *ev, void *d)
{
    Cvo_Button *but = (Cvo_Button *) obj;
    Cvo_OpenFileEvent *ofse = (Cvo_OpenFileEvent *) ev;
    Cvo_List *list = (Cvo_List *) d;

    static int resel = True,
               radio = True;
    char s[40];

    switch(ev->type) {
	case CvoButtonUpEvent:
	    switch((int) but->GetData()) {
		case B_OPEN:
	            Cvo_OpenFile(obj, NULL, &open_file);
		    break;
		case B_RESEL:
		    if (list) {
		        if (resel) resel = False;
		        else resel = True;
		        list->AllowReselect(resel);
			sprintf(s, "Reselect Mode (%s)", (resel) ? "True" : "False");
			but->SetText(s);
		    }
		    break;
		case B_RADIO:
		    if (list) {
		        if (radio) radio = False;
		        else radio = True;
		        list->UseRadioStyle(radio);
			sprintf(s, "Radio Mode (%s)", (radio) ? "True" : "False");
			but->SetText(s);
		    }
		    break;
	    }
	    break;
	case CvoListItemSelectedEvent:
	    fprintf(stderr, "Got CvoListItemSelectedEvent\n");
	    break;
        case CvoOpenFileEvent:
	    fprintf(stderr, "Got CvoOpenFileEvent\n");
	    if (ofse->filename)
	        fprintf(stderr, "file: %s\n", ofse->filename);
	    break;
    }
}
