#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Label.h++>
#include <Cvo/Modal.h++>
#include <Cvo/RadioBox.h++>
#include <Cvo/Separator.h++>
#include <Cvo/Toggle.h++>
#include <Cvo/Window.h++>

// Define some values to be passed around.

#define OK	1
#define CANCEL	2

#define PRESSED	15
#define PULLED	16

#define NONE	-99

// Set these X resources.

Cvo_Default def[] = {
    "*pressme.label: Press Me",

    // The dialog box is in a separate window on the
    // X display.

    "*appDialog*title: Modal Dialog Box",

    // We do not want any moat or chamfer around the modal
    // dialog object.

    "*appDialog*CvoModal.Chamfer: 0",
    "*appDialog*CvoModal.Moat: 0",
    "*appDialog*CvoModal*dialogOK.label: OK",
    "*appDialog*CvoModal*dialogCancel.label: Cancel"
};

// This is the structure used to create a Cvo_RadioBox. It is an
// array of Cvo_RadioBoxList structures, terminated with a
// structure filled with NULL values.

Cvo_RadioBoxList radiolist[] = {
    { "Option One", "opt1" },
    { "Option Two", "opt2" },
    { "Option Three", "opt3" },
    { "Option Four", "opt4" },
    { NULL, NULL }
};

// Declarations for the various handler functions required.

void ModalDialog(Cvo_Object *, XEvent *, void *);
void ModalDialogBuilder(Cvo__Modal *, void *);

void ModalDialogHandler(Cvo_Object *, XEvent *, void *);
void RadioHandler(Cvo_Object *, XEvent *, void *);

main(int argc, char **argv)
{
    // The selection out of the radiobox. This is used to keep
    // track of which toggle button has been chosen, and to restore
    // that state to the radio box on future invocations of it.
    // Note how this variable is passed throughout the program.

    int selection = NONE;

    Cvo_Parse(&argc, &argv);	// Parse the command line.

    // Create an application window.

    Cvo_Application *app = new Cvo_Application("exampleApp");

    // Create a button, and register the CvoButtonUpEvent
    // from it with the function to create a modal dialog
    // box.

    Cvo_Button *b1 = new Cvo_Button("pressme", app, "NR");
    Cvo_Register(b1, CvoButtonUpEvent, ModalDialog, &selection);

    app->MainLoop();
}

void ModalDialog(Cvo_Object *obj, XEvent *, void *t)
{
    // Get the application object, which is the parent of
    // the button whose events this function processes.

    Cvo_Application *app = (Cvo_Application *) obj->Parent();

    // Get the value of the selection chosen in the radio box.
    // A temporary copy is created, since if Cvo_Modal returns
    // with a false value, we do not want to actually update
    // the selection chosen.

    int *selection = (int *) t;
    int tempval = *selection;

    // Create a new window on the X display.

    Cvo_Window *dialog = new Cvo_Window("appDialog", Cvo_MAINWINDOW);
    dialog->MakeTransient(app);

    // Create a modal dialog box in the window, whose parent
    // is the window just created. If it returns a True value,
    // we copy the index of the radio box selection to the variable
    // which stores that.

    if (Cvo_Modal("dialogModal", dialog, ModalDialogBuilder, &tempval))
	*selection = tempval;

    dialog->Unmap();	// Unmap the dialog window.
}

// Cvo_Modal() requires as an argument a function which will
// build the modal dialog box. This is that function.

void ModalDialogBuilder(Cvo__Modal *parent, void *t)
{
    int *selection = (int *) t;

    // This is the window of which the modal dialog object
    // is a child.

    Cvo_Window *win = (Cvo_Window *) parent->Parent();

    // Tell the dialog object to stack its children vertically.

    parent->VerticalChildren();

    // Create a label, and set its text to the value of the
    // "title" resource of the parent window of the dialog
    // object. See the resources set above.

    Cvo_Label *title = new Cvo_Label("title", parent, "NR");
    title->SetText(win->GetResource("title", "Title", "NR"));

    new Cvo_Separator(parent);

    // Create a Cvo_RadioBox using the toggle button structure
    // defined above, and tell it to arrange the buttons vertically.

    Cvo_RadioBox *radioBox = new Cvo_RadioBox("radioBox", parent, radiolist);
    radioBox->VerticalChildren();

    // Register events from the Cvo_RadioBox with event handler functions.

    Cvo_Register(radioBox, CvoRadioBoxSelectedEvent, RadioHandler, selection);
    Cvo_Register(radioBox, CvoRadioBoxDeselectedEvent, RadioHandler, selection);

    if (*selection != NONE)
	((Cvo_SquareToggleButton *) radiolist[*selection].toggle)->Toggle();

    // Create two buttons.

    Cvo_Button *ok = new Cvo_Button("dialogOK", parent, "NR");
    Cvo_Button *cancel = new Cvo_Button("dialogCancel", parent, "NR");

    // Register the CvoButtonUpEvent from each button to a handler
    // function. An integer value is passed to the handler to tell it
    // which button was pressed.

    Cvo_Register(ok, CvoButtonUpEvent, ModalDialogHandler, (void *) OK);
    Cvo_Register(cancel, CvoButtonUpEvent, ModalDialogHandler, (void *) CANCEL);

    // Set the title of the parent window from the same X resource
    // used to set the label above. Finally, map the parent window.

    win->SetTitle(win->GetResource("title", "Title", "NR"));
    win->Map();
}

void ModalDialogHandler(Cvo_Object *obj, XEvent *, void *t)
{
    // This function is called when a Cvo_Button object generates
    // an event. So, we want the parent of the object which 
    // generated the event to call this function.

    Cvo__Modal *modal = (Cvo__Modal *) obj->Parent();

    // This value is the type of button pressed, which is
    // passed as an integer value.

    int type = (int) t;

    // Call the proper modal dialog object member function,
    // depending on which button was pressed.

    switch(type) {
	case OK:
	    modal->Okay();
	    break;
	case CANCEL:
	    modal->Cancel();
	    break;
    }
}

void RadioHandler(Cvo_Object *, XEvent *ev, void *t)
{
    // Cast the arguments to the proper types.

    Cvo_RadioBoxSelectedEvent *event = (Cvo_RadioBoxSelectedEvent *) ev;
    int *selection = (int *) t;

    // This handler takes care of two types of events.
    // The two cases keep track of which radio box toggle
    // is selected.

    switch(event->type) {
	case CvoRadioBoxSelectedEvent:
	    *selection = event->index;
	    break;
	case CvoRadioBoxDeselectedEvent:
	    if (*selection == event->index) *selection = NONE;
	    break;
    }
}
