#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/Label.h++>
#include <Cvo/Pin.h++>
#include <Cvo/Window.h++>

Cvo_Default def[] = {
    "*CvoWindow.CvoLabel.label: Testing the Cvo_Pin",
    "*CvoWindow.CvoButton.label: Push Pin"
};

void Pressed(Cvo_Object *, XEvent *, void *);

main (int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);

    Cvo_Application *exampleApp = new Cvo_Application("exampleApp");

    Cvo_Window *pinWin = new Cvo_Window("pinWin", exampleApp);
    pinWin->HorizontalChildren();

    Cvo_Pin *pin = new Cvo_Pin("pin", pinWin);
    Cvo_Label *label = new Cvo_Label("label", pinWin, "NR");
    Cvo_Button *button = new Cvo_Button("button", pinWin, "NR");

    Cvo_Register(button, CvoButtonUpEvent, Pressed, pin);

    exampleApp->MainLoop();
}

void Pressed(Cvo_Object *but, XEvent *, void *obj)
{
    static stat = 0;

    Cvo_Button *button = (Cvo_Button *) but;
    Cvo_Pin *pin = (Cvo_Pin *) obj;
    Cvo_Application *app = (Cvo_Application *) pin->RootObject();

    if (stat == 0) {
	stat = 1;
	pin->ForceOn();
	pin->NewLayout();
	button->SetText("Pull Pin");
	app->NewLayout();
    } else {
	stat = 0;
	pin->ForceOff();
	pin->NewLayout();
	button->SetText("Push Pin");
	app->NewLayout();
    }
}
