#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/Frame.h++>
#include <Cvo/HoldWindow.h++>
#include <Cvo/Label.h++>
#include <Cvo/Output.h++>
#include <Cvo/RadioBox.h++>
#include <Cvo/Separator.h++>
#include <Cvo/Toggle.h++>
#include <Cvo/Window.h++>

// Set these X resources.

Cvo_Default def[] = {
    "*popupButton.label: Popup RadioBox",
    "*overlayButton.label: Overlay RadioBox",

    "*overlay*title: Overlay RadioBox",
    "*overlay*OKButton.label: OK",

    // The popup box is in a separate window on the
    // X display.

    "*appPopup*title: Popup RadioBox",
    "*appPopup*OKButton.label: OK",
};

// This is the structure used to create a Cvo_RadioBox. It is an
// array of Cvo_RadioBoxList structures, terminated with a
// structure filled with NULL values.

Cvo_RadioBoxList radiolist[] = {
    { "Option One", "opt1" },
    { "Option Two", "opt2" },
    { "Option Three", "opt3" },
    { "Option Four", "opt4" },
    { NULL, NULL }
};

int g_selection = 0;
Cvo_Output *g_output = NULL;

// Declarations for the various handler functions required.

void Overlay(Cvo_Object *, XEvent *, void *);
void OverlayHandler(Cvo_Object *, XEvent *, void *);

void PopUp(Cvo_Object *, XEvent *, void *);
void PopUpHandler(Cvo_Object *, XEvent *, void *);

void MakeRadio(Cvo_Object *, Cvo_RadioBox **);
void RadioHandler(Cvo_Object *, XEvent *, void *);

void OutputHandler(Cvo_Object *, XEvent *, void *);

main(int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);

    Cvo_Application *app = new Cvo_Application("exampleApp");

    Cvo_Window *win = new Cvo_Window("appWin", app);
    win->VerticalChildren();

    Cvo_Button *popupButton = new Cvo_Button("popupButton", win, "NR");
    Cvo_Button *overlayButton = new Cvo_Button("overlayButton", win, "NR");
    new Cvo_Separator(win);
    g_output = new Cvo_Output("outputLine", win);
    g_output->SetText(radiolist[g_selection].label);

    Cvo_Register(popupButton, CvoButtonUpEvent, PopUp, app);
    Cvo_Register(overlayButton, CvoButtonUpEvent, Overlay, win);

    app->MainLoop();
}

void Overlay(Cvo_Object *, XEvent *, void *obj)
{
    Cvo_Window *win = (Cvo_Window *) obj;
    static Cvo_Frame *overlay = NULL;
    static Cvo_RadioBox *radioBox = NULL;

    if (overlay == NULL) {
        overlay = new Cvo_Frame("overlay", win);
        overlay->MakeOverlay();
        overlay->ExpandFrame();
        overlay->VerticalChildren();

        Cvo_Label *title = new Cvo_Label("title", overlay, "NR");
        title->SetText(overlay->GetResource("title", "Title", "NR"));

        new Cvo_Separator(overlay);

        MakeRadio(overlay, &radioBox);

        Cvo_Button *ok = new Cvo_Button("OKButton", overlay, "NR");
        Cvo_Register(ok, CvoButtonUpEvent, OverlayHandler, overlay);
    }

    fprintf(stderr, "Overlay: Updating toggle buttons - %d.\n", g_selection);

    ((Cvo_SquareToggleButton *) radiolist[g_selection].toggle)->Toggle();

    radioBox->NewLayout();
    overlay->Map();
}

void OverlayHandler(Cvo_Object *, XEvent *, void *obj)
{
    ((Cvo_Frame *) obj)->Unmap();
}

void PopUp(Cvo_Object *, XEvent *, void *obj)
{
    Cvo_Application *app = (Cvo_Application *) obj;

    static Cvo_HoldWindow *hold = new Cvo_HoldWindow("hold", app);
    static Cvo_Window *popup = NULL;
    static Cvo_RadioBox *radioBox = NULL;

    if (popup == NULL) {
        popup = new Cvo_Window("appPopup", Cvo_MAINWINDOW);
        popup->VerticalChildren();
	popup->MakeTransient(app);

        Cvo_Label *title = new Cvo_Label("title", popup, "NR");
        title->SetText(popup->GetResource("title", "Title", "NR"));
    
        new Cvo_Separator(popup);

        MakeRadio(popup, &radioBox);

        Cvo_Button *ok = new Cvo_Button("OKButton", popup, "NR");
        Cvo_Register(ok, CvoButtonUpEvent, PopUpHandler, hold);
    
        popup->SetTitle(popup->GetResource("title", "Title", "NR"));
    }

    fprintf(stderr, "PopUp: Updating toggle buttons - %d.\n", g_selection);

    ((Cvo_SquareToggleButton *) radiolist[g_selection].toggle)->Toggle();

    hold->Map();
    radioBox->NewLayout();
    popup->Map();
}

void PopUpHandler(Cvo_Object *obj, XEvent *, void *hold)
{
    ((Cvo_Window *) obj->Parent())->Unmap();
    ((Cvo_HoldWindow *) hold)->Unmap();
}

void MakeRadio(Cvo_Object *parent, Cvo_RadioBox **radioBox)
{
    *radioBox = new Cvo_RadioBox("radioBox", parent, radiolist);
    (*radioBox)->VerticalChildren();
    (*radioBox)->RequireSelection();

    Cvo_Register(*radioBox, CvoRadioBoxSelectedEvent, RadioHandler);
    Cvo_Register(*radioBox, CvoRadioBoxSelectedEvent, OutputHandler);
}

void RadioHandler(Cvo_Object *, XEvent *ev, void *)
{
    Cvo_RadioBoxSelectedEvent *event = (Cvo_RadioBoxSelectedEvent *) ev;

    g_selection = event->index;
    fprintf(stderr, "g_selection is now %d\n", g_selection);
}

void OutputHandler(Cvo_Object *, XEvent *, void *)
{
    g_output->SetText(radiolist[g_selection].label);
    g_output->NewLayout();
    ((Cvo_Application *) g_output->Parent()->Parent())->NewLayout();
}
