#include <Cvo/Application.h++>
#include <Cvo/Window.h++>
#include <Cvo/Button.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Output.h++>
#include <Cvo/Input.h++>
#include <Cvo/Label.h++>

void newtexthandler(Cvo_Object *, XEvent *, void *);
void addtexthandler(Cvo_Object *, XEvent *, void *);
void gettexthandler(Cvo_Object *, XEvent *, void *);
void inputhandler  (Cvo_Object *, XEvent *, void *);

Cvo_Output *output;
Cvo_Label *outlabel;
Cvo_Label *inlabel;

main (int argc, char *argv[])
{
    Cvo_Parse (&argc, &argv);

    Cvo_Application *app = new Cvo_Application ("test", Cvo_MAINWINDOW);

    Cvo_Window *window = new Cvo_Window (app);
	window->ExpandFrame ();
	window->VerticalChildren();

	Cvo_Window *topwindow = new Cvo_Window (window);
	topwindow->ExpandFrame();
	topwindow->VerticalChildren();

	output = new Cvo_Output("output",topwindow);
	output->ExpandFrame();
	output->SetText("Cvo_Output Object");
	output->SetMinSize(17,1);

	outlabel = new Cvo_Label("label",topwindow," ");
	outlabel->ExpandFrame();

	Cvo_Frame *frame = new Cvo_Frame(topwindow);

	Cvo_Button *n = new Cvo_Button("new",frame,"New text");
	n->ExpandFrame();
	n->FillFrame(False);
	Cvo_Register(n,CvoButtonUpEvent,newtexthandler,"New");

	Cvo_Button *a = new Cvo_Button("add",frame,"Add text");
	a->ExpandFrame();
	a->FillFrame(False);
	Cvo_Register(a,CvoButtonUpEvent,addtexthandler,"Add");

	Cvo_Button *g = new Cvo_Button("get",frame,"Get text");
	g->ExpandFrame();
	g->FillFrame(False);
	Cvo_Register(g,CvoButtonUpEvent,gettexthandler);

	Cvo_Window *botwindow = new Cvo_Window(window);
	botwindow->ExpandFrame();
	botwindow->VerticalChildren();

	Cvo_Input *input = new Cvo_Input("input",botwindow);
	input->ExpandFrame();
	Cvo_Register(input,CvoInputEnteredEvent,inputhandler);

	inlabel = new Cvo_Label("label",botwindow," ");
	inlabel->ExpandFrame();

    Cvo_MainLoop (app);
}

void
newtexthandler(Cvo_Object *, XEvent *, void *d)
{
	output->SetText((char*)d);
	output->Flush();
}

void
addtexthandler(Cvo_Object *, XEvent *, void *d)
{
	output->Enter((char*)d);
	output->Flush();
}

void
gettexthandler(Cvo_Object *, XEvent *, void *)
{
	outlabel->SetText(output->GetText());
	outlabel->Flush();
}

void
inputhandler(Cvo_Object *, XEvent *e, void *)
{
	Cvo_InputEnteredEvent *ev = (Cvo_InputEnteredEvent*)e;

	inlabel->SetText(ev->text);
	inlabel->Flush();
}
