# Replacement macros can take three forms
#
# (1)   {*}[ALIAS]
# (2)   {*}[ALIAS]{label}
# (3)   {*}{href}{label}

BEGIN          { g_legend = "legend.html";
                  g_indexpage = "index.html";
                  g_events = "events.html";
                  g_trans = "translations.html";
                  g_resources = "resources.html";


                  g_revision = "made";
                  g_contact = "mailto:prb@cray.com (Paul Borman)";
                  g_includepath = "@Includes";

                  g_crossref = 0;

                  TYPES["OBJECT"]      = "object";
                  TYPES["STRUCT"]      = "structure";


                  AL["DISPLAY"]        = "{*}{types.html#Display}{Display}";
                  AL["XRECTANGLE"]     = "{*}{types.html#XRectangle}{XRectangle}";


                  AL["LOGO"]           = "{*}{info.html#logo}{logo}";
                  AL["TEXTMODES"]      = "{*}{info.html#TextModes}{Cvo text modes}";


                  AL["BASICBUTTON#EVENTS"]  = "{*}{Cvo_BasicButton.html#EVENTS}{Cvo_BasicButton}";


                  AL["ACCELERATOR"]         = "{*}{Cvo_Accelerator.html#Cvo_Accelerator}{Cvo_Accelerator}";
                  AL["APPLICATION"]         = "{*}{Cvo_Application.html#Cvo_Application}{Cvo_Application}";
                  AL["BASE"]                = "{*}{Cvo_Base.html#Cvo_Base}{Cvo_Base}";
                  AL["BASICBUTTON"]         = "{*}{Cvo_BasicButton.html#Cvo_BasicButton}{Cvo_BasicButton}";
                  AL["BASICOBJECT"]         = "{*}{Cvo_BasicObject.html#Cvo_BasicObject}{Cvo_BasicObject}";
                  AL["BASICTOGGLEBUTTON"]   = "{*}{Cvo_BasicToggleButton.html#Cvo_BasicToggleButton}{Cvo_BasicToggleButton}";
                  AL["BLANK"]               = "{*}{Cvo_Blank.html#Cvo_Blank}{Cvo_Blank}";
                  AL["BUTTON"]              = "{*}{Cvo_Button.html#Cvo_Button}{Cvo_Button}";
                  AL["BUTTONMENU"]          = "{*}{Cvo_ButtonMenu.html#Cvo_ButtonMenu}{Cvo_ButtonMenu}";
                  AL["CHAMFEREDLABEL"]      = "{*}{Cvo_ChamferedLabel.html#Cvo_ChamferedLabel}{Cvo_ChamferedLabel}";
                  AL["CHARACTERBUFFER"]     = "{*}{Cvo_CharacterBuffer.html#Cvo_CharacterBuffer}{Cvo_CharacterBuffer}";
                  AL["COLOR"]               = "{*}{Cvo_Color.html#Cvo_Color}{Cvo_Color}";
                  AL["CONFIRM"]             = "{*}{Cvo_Confirm.html#Cvo__Confirm}{Cvo__Confirm}";
                  AL["CRT"]                 = "{*}{Cvo_CRT.html#Cvo_CRT}{Cvo_CRT}";
                  AL["CRTHIGHLIGHT"]        = "{*}{Cvo_CRT_Highlight.html#Cvo_CRT_Highlight}{Cvo_CRT_Highlight}";
                  AL["CURSOR"]              = "{*}{Cvo_Cursor.html#Cvo_Cursor}{Cvo_Cursor}";
                  AL["DISPLAYLIST"]         = "{*}{Cvo_DisplayList.html#Cvo_DisplayList}{Cvo_DisplayList}";
                  AL["FILEPAGE"]            = "{*}{Cvo_FilePage.html#Cvo_FilePage}{Cvo_FilePage}";
                  AL["FONT"]                = "{*}{Cvo_Font.html#Cvo_Font}{Cvo_Font}";
                  AL["FRAME"]               = "{*}{Cvo_Frame.html#Cvo_Frame}{Cvo_Frame}";
                  AL["GENERICLIST"]         = "{*}{Cvo_GenericList.html#Cvo_GenericList}{Cvo_GenericList}";
                  AL["ICONGROUP"]           = "{*}{Cvo_IconGroup.html#Cvo_IconGroup}{Cvo_IconGroup}";
                  AL["ICONGROUPOBJECT"]     = "{*}{Cvo_IconGroupObject.html#Cvo_IconGroupObject}{Cvo_IconGroupObject}";
                  AL["IMAGE"]               = "{*}{Cvo_Image.html#Cvo_Image}{Cvo_Image}";
                  AL["IMAGEBUTTON"]         = "{*}{Cvo_ImageButton.html#Cvo_ImageButton}{Cvo_ImageButton}";
                  AL["INFORM"]              = "{*}{Cvo_Inform.html#Cvo__Inform}{Cvo__Inform}";
                  AL["INPUT"]               = "{*}{Cvo_Input.html#Cvo_Input}{Cvo_Input}";
                  AL["INPUTONLY"]           = "{*}{Cvo_InputOnly.html#Cvo_InputOnly}{Cvo_InputOnly}";
                  AL["INPUTRING"]           = "{*}{Cvo_InputRing.html#Cvo_InputRing}{Cvo_InputRing}";
                  AL["INPUTRINGELEMENT"]    = "{*}{Cvo_InputRingElement.html#Cvo_InputRingElement}{Cvo_InputRingElement}";
                  AL["LABEL"]               = "{*}{Cvo_Label.html#Cvo_Label}{Cvo_Label}";
                  AL["LABELMATRIXVIEWPORT"] = "{*}{Cvo_LabelMatrixViewPort.html#Cvo_LabelMatrixViewPort}{Cvo_LabelMatrixViewPort}";
                  AL["LAYOUTWINDOW"]        = "{*}{Cvo_LayoutWindow.html#Cvo_LayoutWindow}{Cvo_LayoutWindow}";
                  AL["LIST"]                = "{*}{Cvo_List.html#Cvo_List}{Cvo_List}";
                  AL["MATRIX"]              = "{*}{Cvo_Matrix.html#Cvo_Matrix}{Cvo_Matrix}";
                  AL["MATRIXCELL"]          = "{*}{Cvo_MatrixCell.html#Cvo_MatrixCell}{Cvo_MatrixCell}";
                  AL["MATRIXSLICE"]         = "{*}{Cvo_MatrixSlice.html#Cvo_MatrixSlice}{Cvo_MatrixSlice}";
                  AL["MATRIXVIEWPORT"]      = "{*}{Cvo_MatrixViewPort.html#Cvo_MatrixViewPort}{Cvo_MatrixViewPort}";
                  AL["MENU"]                = "{*}{Cvo_Menu.html#Cvo_Menu}{Cvo_Menu}";
                  AL["MENUBAR"]             = "{*}{Cvo_MenuBar.html#Cvo_MenuBar}{Cvo_MenuBar}";
                  AL["MENUBARENTRIES"]      = "{*}{Cvo_MenuBarEntries.html#Cvo_MenuBarEntries}{Cvo_MenuBarEntries}";
                  AL["MENUBARLIST"]         = "{*}{Cvo_MenuBarList.html#Cvo_MenuBarList}{Cvo_MenuBarList}";
                  AL["MENUENTRY"]           = "{*}{Cvo_MenuEntry.html#Cvo_MenuEntry}{Cvo_MenuEntry}";
                  AL["MENUITEM"]            = "{*}{Cvo_MenuItem.html#Cvo_MenuItem}{Cvo_MenuItem}";
                  AL["MENULABEL"]           = "{*}{Cvo_MenuLabel.html#Cvo_MenuLabel}{Cvo_MenuLabel}";
                  AL["MENULIST"]            = "{*}{Cvo_MenuList.html#Cvo_MenuList}{Cvo_MenuList}";
                  AL["MODAL"]               = "{*}{Cvo_Modal.html#Cvo__Modal}{Cvo__Modal}";
                  AL["OBJECT"]              = "{*}{Cvo_Object.html#Cvo_Object}{Cvo_Object}";
                  AL["OPENFILE"]            = "{*}{Cvo_OpenFile.html#Cvo__OpenFile}{Cvo__OpenFile}";
                  AL["OPENFILEINFO"]        = "{*}{Cvo_OpenFileInfo.html#Cvo_OpenFileInfo}{Cvo_OpenFileInfo}";
                  AL["OPTIONMENU"]          = "{*}{Cvo_OptionMenu.html#Cvo_OptionMenu}{Cvo_OptionMenu}";
                  AL["OUTPUT"]              = "{*}{Cvo_Output.html#Cvo_Output}{Cvo_Output}";
                  AL["PAGE"]                = "{*}{Cvo_Page.html#Cvo_Page}{Cvo_Page}";
                  AL["PAINTVIEWPORT"]       = "{*}{Cvo_PaintViewPort.html#Cvo_PaintViewPort}{Cvo_PaintViewPort}";
                  AL["PEELWIN"]             = "{*}{Cvo_PeelWin.html#Cvo_PeelWin}{Cvo_PeelWin}";
                  AL["PICTURE"]             = "{*}{Cvo_Picture.html#Cvo_Picture}{Cvo_Picture}";
                  AL["PIN"]                 = "{*}{Cvo_Pin.html#Cvo_Pin}{Cvo_Pin}";
                  AL["PINUP"]               = "{*}{Cvo_PinUp.html#Cvo_PinUp}{Cvo_PinUp}";
                  AL["PIXMAP"]              = "{*}{Cvo_Pixmap.html#Cvo_Pixmap}{Cvo_Pixmap}";
                  AL["RADIO"]               = "{*}{Cvo_Radio.html#Cvo_Radio}{Cvo_Radio}";
                  AL["RADIOBOX"]            = "{*}{Cvo_RadioBox.html#Cvo_RadioBox}{Cvo_RadioBox}";
                  AL["RADIOBOXLIST"]        = "{*}{Cvo_RadioBoxList.html#Cvo_RadioBoxList}{Cvo_RadioBoxList}";
                  AL["RADIOLIST"]           = "{*}{Cvo_RadioList.html#Cvo_RadioList}{Cvo_RadioList}";
                  AL["ROOTEDLIST"]          = "{*}{Cvo_RootedList.html#Cvo_RootedList}{Cvo_RootedList}";
                  AL["SAVEFILE"]            = "{*}{Cvo_SaveFile.html#Cvo__SaveFile}{Cvo__SaveFile}";
                  AL["SAVEFILEINFO"]        = "{*}{Cvo_SaveFileInfo.html#Cvo_SaveFileInfo}{Cvo_SaveFileInfo}";
                  AL["SCROLLBAR"]           = "{*}{Cvo_ScrollBar.html#Cvo_ScrollBar}{Cvo_ScrollBar}";
                  AL["SHELL"]               = "{*}{Cvo_Shell.html#Cvo_Shell}{Cvo_Shell}";
                  AL["SQUARETOGGLEBUTTON"]  = "{*}{Cvo_SquareToggleButton.html#Cvo_SquareToggleButton}{Cvo_SquareToggleButton}";
                  AL["TEXT"]                = "{*}{Cvo_Text.html#Cvo_Text}{Cvo_Text}";
                  AL["TEXTATTRIBUTE"]       = "{*}{Cvo_TextAttribute.html#Cvo_TextAttribute}{Cvo_TextAttribute}";
                  AL["TEXTPAGE"]            = "{*}{Cvo_TextPage.html#Cvo_TextPage}{Cvo_TextPage}";
                  AL["TEXTVIEWPORT"]        = "{*}{Cvo_TextViewPort.html#Cvo_TextViewPort}{Cvo_TextViewPort}";
                  AL["TOGGLEBUTTON"]        = "{*}{Cvo_ToggleButton.html#Cvo_ToggleButton}{Cvo_ToggleButton}";
                  AL["TOOLTALK"]            = "{*}{Cvo_ToolTalk.html#Cvo_ToolTalk}{Cvo_ToolTalk}";
                  AL["TREE"]                = "{*}{Cvo_Tree.html#Cvo_Tree}{Cvo_Tree}";
                  AL["TREENODE"]            = "{*}{Cvo_TreeNode.html#Cvo_TreeNode}{Cvo_TreeNode}";
                  AL["TREEVIEWPORT"]        = "{*}{Cvo_TreeViewPort.html#Cvo_TreeViewPort}{Cvo_TreeViewPort}";
                  AL["VIEWPORT"]            = "{*}{Cvo_ViewPort.html#Cvo_ViewPort}{Cvo_ViewPort}";
                  AL["WINDOW"]              = "{*}{Cvo_Window.html#Cvo_Window}{Cvo_Window}";
                  AL["WINDOWVIEWPORT"]      = "{*}{Cvo_WindowViewPort.html#Cvo_WindowViewPort}{Cvo_WindowViewPort}";
                  AL["WINDOWVIEWPORTPANNER"] = "{*}{Cvo_WindowViewPortPanner.html#Cvo_WindowViewPortPanner}{Cvo_WindowViewPortPanner}";
                  AL["XIMAGE"]              = "{*}{Cvo_XImage.html#Cvo_XImage}{Cvo_XImage}";

                  g_haveParent = 0;

                  g_haveSyntax = 0;
                  g_haveOverview = 0;
                  g_haveData = 0;
                  g_haveMembers = 0;
                  g_haveObjects = 0;
                  g_haveEvents = 0;
                  g_haveTranslations = 0;
                  g_haveResources = 0;
                  g_haveModRes = 0;
                  g_haveSource = 0;
                  g_haveExample = 0;
                  g_incode = 0;
                }

function cleanarg(arg) { gsub("&", "\\&amp;", arg);
                         gsub("<", "\\&lt;", arg);
                         gsub(">", "\\&gt;", arg);

                         while ((pos = match(arg, "(^|[^\\\\])\\\\[VICKB]([^\\\\]|$)")) != 0) {
                           pos = match(arg, "\\\\");
			   type = substr(arg, pos + 1, 1);

			   if (type == "V") { subs = "VAR"; } else
			   if (type == "I") { subs = "I"; } else
			   if (type == "C") { subs = "CODE"; } else
			   if (type == "K") { subs = "KBD"; } else
			   if (type == "B") { subs = "B"; } 

                           if (g_incode == 0) {
                             g_incode = 1;
                             left = substr(arg, 1, pos - 1);
                             right = substr(arg, pos + 2, length(arg));
                             arg = sprintf("%s<%s>%s", left, subs, right);
                           }
                           else {
                             g_incode = 0;
                             left = substr(arg, 1, pos - 1);
                             right = substr(arg, pos + 2, length(arg));
                             arg = sprintf("%s</%s>%s", left, subs, right);
                           }
                         }

                         while ((pos = match(arg, "(^|[^\\\\])\\\\([^\\\\]|$)")) != 0) {
                           pos = match(arg, "\\\\");
                           if (g_incode == 0) {
                             g_incode = 1;
                             left = substr(arg, 1, pos - 1);
                             right = substr(arg, pos + 1, length(arg));
                             arg = sprintf("%s<CODE>%s", left, right);
                           }
                           else {
                             g_incode = 0;
                             left = substr(arg, 1, pos - 1);
                             right = substr(arg, pos + 1, length(arg));
                             arg = sprintf("%s</CODE>%s", left, right);
                           }
                         }

#                        printf("%s\n", arg) > "LOG";
                         return arg;
                       }

function parsearg(arg) { pos = match(arg, "{[*]}{[^{}]*}{[^{}]*}");
                         if (pos == 0) {
                           pos = match(arg, "{[*]}\[[A-Z#]*\]([^{]|$)");
                           if (pos == 0) {
                             pos = match(arg, "{[*]}\[[A-Z#]*\]{[^{}]*}");
                             if (pos > 0) {
                               rest = substr(arg, pos+4, length(arg));
                               alias = substr(rest, 1, index(rest, "]") - 1);
                               label = substr(rest, length(alias) + 3, index(rest, "}") - length(alias) - 3);
                               if (alias in AL) al = AL[alias];
                               else al = "NO_SUCH_ALIAS"
                               sub("{[^{}]*}$", sprintf("{%s}", label), al);
                               sub(sprintf("{[*]}\\[%s\\]{%s}", alias, label), al, arg);
                               return parsearg(arg);
                             }
                             else return arg;
                           }
                           else {
                             rest = substr(arg, pos + 4, length(arg));
                             alias = substr(rest, 1, index(rest, "]") - 1);
                             s1 = substr(arg, 1, pos - 1);
                             if (alias in AL) s2 = AL[alias];
                             else s2 = "NO_SUCH_ALIAS"
                             s3 = substr(arg, length(s1) + length(alias) + 6, length(arg));
                             return parsearg(sprintf("%s%s%s", s1, s2, s3));
                           }
                         }
                         else {
                           rest = substr(arg, pos + 4, length(arg));
                           href = substr(rest, 1, index(rest, "}") - 1);
                           rest = substr(rest, index(rest, "{") + 1, length(arg));
                           g_label = substr(rest, 1, index(rest, "}") - 1);
                           s1 = substr(arg, 1, pos - 1);
                           s2 = sprintf("<A HREF=\"%s\">%s</A>", href, g_label);
                           s3 = substr(arg, length(s1) + length(href) + length(g_label) + 8, length(arg));
                           return parsearg(sprintf("%s%s%s", s1, s2, s3));
                         }
                       }

function fixarg(s, arg) { return substr(s, length(arg) + 2, length(s));
                        }

function striplink(s) { gsub("<A[^>]*>", "", s);
                        gsub("</A[^>]*>", "", s);
                        return s;
                      }

function crossref(s, t) { if (g_crossref == 0) {
                           printf("<HTML><HEAD>\n") > CROSSREF;
                           printf("<TITLE>Cross reference index for %s</TITLE>\n", g_class) > CROSSREF;
                           printf("</HEAD><BODY>\n") > CROSSREF;
                           printf("<P>\n") > CROSSREF;
                         }

                         printf("<A HREF=\"%s#CROSSREF%d\">%s : %s</A>\n<BR>\n", OUTPUT, g_crossref, g_class, striplink(s)) > CROSSREF;
                         printf("<A NAME=\"CROSSREF%d\">%s</A>\n", g_crossref++, t);
                       }

function boldO() { printf("<B>\n"); }
function boldC() { printf("</B>\n"); }

function breakOC() { printf("<BR>\n"); }

function codeO() { printf("<CODE>\n"); }
function codeC() { printf("</CODE>\n"); }

function deflO() { printf("<DL>\n"); }
function deflC() { printf("</DL>\n"); }
function deftO() { printf("<DT>\n"); }
function deftC() { printf("</DT>\n"); }
function defdO() { printf("<DD>\n"); }
function defdC() { printf("</DD>\n"); }

function headerO(d) { printf("<H%d>\n", d); }
function headerC(d) { printf("</H%d>\n", d); }

function italO() { printf("<I>\n"); }
function italC() { printf("</I>\n"); }

function itemO() { printf("<LI>\n"); }
function itemC() { printf("</LI>\n"); }

function kbdO() { printf("<KBD>\n"); }
function kbdC() { printf("</KBD>\n"); }

function listO() { printf("<UL>\n"); }
function listC() { printf("</UL>\n"); }

# Nested paragraphs are illegal.

function paraO() { if (g_inpara != 1) {
                     printf("<P>\n");
                     g_inpara = 1;
                   }
                 }

function paraC() { if (g_inpara == 1) {
                     printf("</P>\n");
                     g_inpara = 0;
                   }
                 }

function preO() { printf("<PRE>\n"); }
function preC() { printf("</PRE>\n"); }

function rule() { printf("<HR>\n"); }

function varO() { printf("<VAR>\n"); }
function varC() { printf("</VAR>\n"); }

function NAME(s, t) { printf("<A NAME=\"%s\">%s</A>\n", s, t); }
function HREF(href, tag) { printf("<A HREF=\"%s\">%s</A>\n", href, tag); }

# Body of the parser - rules.

/^#/            { next;
                }

                { g_line = cleanarg($0);
                }

/^\.title /     { g_title = parsearg(fixarg(g_line, ".title"));
                  next;
                }

/^\.tag /       { arg = fixarg(g_line, ".tag");
                  tag = substr(arg, 1, index(arg, " ") - 1);
                  text = substr(arg, length(tag) + 2, length(arg) - length(tag));
                  NAME(tag, text);
                  next;
                }

/^\.class /     { g_class = parsearg(fixarg(g_line, ".class"));
                  g_func = g_class;
                  g_type = "OBJECT";
                  headerO(1);
                    printf("Class\n");
                  headerC(1);

                  deflO();
                    deftO();
                    deftC();
                    defdO();
                      codeO();
                        boldO();
                          printf("%s\n", g_class);
                        boldC();
                      codeC();
                    defdC();
                  deflC();

                  next;
                }

/^\.struct /    { arg = fixarg(g_line, ".struct");
                  g_class = parsearg(arg);
                  g_func = g_class;
		  g_struct = g_class;
                  g_type = "STRUCT";

                  headerO(1);
                    printf("Structure\n");
                  headerC(1);

                  deflO();
                    deftO();
                    deftC();
                    defdO();
                      codeO();
                        boldO();
                          printf("%s", g_class);
                        boldC();
                      codeC();
                    defdC();
                  deflC();

                  next;
                }

/^\.parent /    { arg = fixarg(g_line, ".parent");

                  # g_label is set in parsearg() - clear it before calling

                  g_label = "";
                  arg = parsearg(arg);

                  if (g_label == "") g_parent = sprintf("%s.html", arg);
                  else g_parent = sprintf("%s.html", g_label);

                  headerO(1);
                    printf("Base\n");
                  headerC(1);

                  deflO();
                    deftO();
                    deftC();
                    defdO();
                      codeO();
                        printf("%s", arg);
                      codeC();
                    defdC();
                  deflC();

                  g_haveParent = 1;
                  next;
                }

/^\.include /   { g_plaininclude = fixarg(g_line, ".include");
                  path = g_plaininclude;
                  gsub("\\.h\\+\\+", ".h", path);
                  g_include = sprintf("<A HREF=\"%s/%s\">%s</A>", g_includepath, path, g_plaininclude);
                  next;
                }

/^\.function /  { g_func = parsearg(fixarg(g_line, ".function"));
                  next;
                }

/^\.variable /  { g_variable = parsearg(fixarg(g_line, ".variable"));
                  next;
                }

function dofunc(arg) { g_argcnt = 0;

		       if (g_haveSyntax == 0) {
			 headerO(1);
			   printf("Syntax\n");
			 headerC(1);
		       }

		       deflO();
			 deftO();
			 deftC();
			 defdO();
			   deflO();
			     deftO();
			       if (g_haveSyntax == 0) {
				 codeO();
				   crossref(sprintf("include file <CODE>&lt;%s&gt;</CODE>", g_plaininclude), "#include ");
				   printf("&lt;%s&gt;\n", g_include);
				 codeC();
				 breakOC();
				 breakOC();
			       }
			       codeO();
				 crossref(sprintf("constructor <CODE>%s</CODE>", g_func), arg);
				 printf("%s %s\( ", g_func, g_variable);

		       g_haveSyntax = 1;
                     }

/^\.func\( ./   { dofunc(parsearg(fixarg(g_line, ".func\(")));
                  next;
                }

/^\.func\( *$/  { dofunc("");
                  next;
                }

function subchar(arg, pos, chars) { begin = substr(arg, 1, pos-1);
                                    end = substr(arg, pos+1, length(arg)-pos);
				    str = sprintf("%s%s%s", begin, chars, end);
				    return str;
                                  }

function subarg(arg) { pos = match(arg, "\\[[^ ]");
		       if (pos == 0) {
			 pos = match(arg, "[^ ]\\]");
			 if (pos == 0 ) {
		           pos = match(arg, "\\{[^ ]");
			   if (pos == 0 ) {
		             pos = match(arg, "[^ ]\\}");
			     if (pos > 0) {
			       arg = subchar(arg, pos+1, " }");
			       return subarg(arg);
			     }
			     else {
			       printf("%s\n", arg) > "LOG";
			       return arg;
			     }
			   } else {
			     arg = subchar(arg, pos, "{ ");
			     return subarg(arg);
			   }
			 } else {
			   arg = subchar(arg, pos+1, " ]");
			   return subarg(arg);
			 }
		       } else {
			 arg = subchar(arg, pos, "[ ");
			 return subarg(arg);
		       }
                     }

function doarg(arg) { g_argcnt++;
		      arg = subarg(parsearg(arg));

		      if (g_argcnt == 1) printf("%s", arg);
		      else {
			if (g_argcnt == 2) {
                          if (g_inEvent != 1 && g_inStruct != 1) printf(",");
			  printf("\n");
			  codeC();
			  deftC();
			  defdO();
			    codeO();
			    printf("%s", arg);
			}
			else {
			  printf(",\n");
			  codeC();
			  breakOC();
			  codeO();
			  printf("%s", arg);
			}
		      }
                    }

/^\.stdargs$/   { doarg("char *resource_name");
                  doarg("{ {*}[OBJECT] *parent | {*}[DISPLAY] *display }");
                  next;
                }

/^\.arg /       { arg = fixarg(g_line, ".arg");
		  doarg(arg);
                  next;
                }

/^\.\)func$/    { printf(" \)");
                  codeC();

                  if (g_argcnt < 2) deftC();
                  else defdC();

                      deflC();
                    defdC();
                  deflC();

                  next;
                }


/^\.struct\(/   { g_argcnt = 1;            # cheat to make it push the event argument down.
		  g_inStruct = 1;

                  headerO(1);
                    printf("Syntax\n");
                  headerC(1);

                  deflO();
                    deftO();
                    deftC();
                    defdO();
                      deflO();
                        deftO();
                          codeO();
                            crossref(sprintf("include file <CODE>&lt;%s&gt;</CODE>", g_plaininclude), "#include ");
                            printf("&lt;%s&gt;\n", g_include);
                          codeC();
                          breakOC();
                          breakOC();
                          codeO();
                            crossref(sprintf("structure <CODE>%s</CODE>", g_struct), "struct ");
                            printf("%s {\n", g_struct);

                  next;
                }

/^\.\)struct$/  { printf(" }");
                  codeC();

                  if (g_argcnt < 2) deftC();
                  else defdC();

                      deflC();
                    defdC();
                  deflC();

                  next;
                }

/^\.overview$/  { headerO(1);
                    NAME("OVERVIEW", "Overview\n");
                  headerC(1);

                  g_haveOverview = 1;
                  next;
                }

/^\.pp\(/       { paraO();
                  next;
                }

/^\.\)pp$/      { paraC();
                  next;
                }

/^\.code /      { arg = parsearg(fixarg(g_line, ".code"));
                  codeO();
                    printf("%s\n", arg);
                  codeC();
                  next;
                }

/^\.list\(/     { listO();
                  g_inlist = 1;
                  next;
                }

/^\.\)list$/    { listC();
                  g_inlist = 0;
                  next;
                }

/^\.data\(/     { headerO(1);
                    NAME("DATA", "Public Data Members\n");
                  headerC(1);

                  paraO();
                    if (g_haveParent == 1) {
                        printf("This %s defines the following public data members in addition to\n", TYPES[g_type]);
                        HREF(sprintf("%s#DATA", g_parent), "those defined by its parent");
                        printf("and ancestor %ss.\n", TYPES[g_type]);
                    }
                    else printf("This %s defines the following public data members.\n", TYPES[g_type]);
                  paraC();

                  listO();
                  g_haveData = 1;
                  next;
                }

/^\.data /      { arg = parsearg(fixarg(g_line, ".data"));

                  if (g_indata == 1) {
                      paraO();
                      paraC();
                    itemC();
                  }

                    itemO();
                      codeO();
                        printf("%s\n", arg);
                      codeC();

                  g_indata = 1;
                  next;
                }

/^\.\)data$/    { if (g_indata == 1) {
                      paraO();
                      paraC();
                    itemC();
                  }

                  listC();
                  g_indata = 0;
                  next;
                }

/^\.members\(/  { headerO(1);
                    NAME("MEMBERS", "Member Functions\n");
                  headerC(1);

                  paraO();
                    if (g_haveParent == 1) {
                        printf("This %s defines the following member functions in addition to\n", TYPES[g_type]);
                        HREF(sprintf("%s#MEMBERS", g_parent), "those defined by its parent");
                        printf("and ancestor %ss.\n", TYPES[g_type]);
                    }
                    else printf("This %s defines the following member functions.\n", TYPES[g_type]);
                  paraC();

                  listO();
                  g_haveMembers = 1;
                  next;
                }

/^\.sub\(/      { if (g_inmember == 1) {
                      paraO();
                      paraC();
                    itemC();
                    g_inmember = 0;
                  }
                  listC();
                  paraO();
                  next;
                }

/^\.\)sub$/     { paraC();
                  listO();
                  next;
                }

/^\.member\( /  { arg = parsearg(fixarg(g_line, ".member\("));
                  g_argcnt = 0;
                  if (g_inmember == 1) {
                      paraO();
                      paraC();
                    itemC();
                  }

                  itemO();
                    deflO();
                      deftO();
                        codeO();
                          printf("%s ", arg);
                          crossref(sprintf("member function <CODE>%s()</CODE>", arg), " \(");

                  g_inmember = 1;
                  next;
                }

/^\.\)member$/  { printf(" \)");
                  codeC();

                  if (g_argcnt < 2) deftC();
                  else defdC();

                    deflC();

                  next;
                } 

/^\.\)members$/ { if (g_inmember == 1) {
                      paraO();
                      paraC();
                    itemC();
                  }

                  listC();
                  next;
                }

/^\.objects\(/  { headerO(1);
                    NAME("OBJECTS", "Children Objects\n");
                  headerC(1);

                  paraO();
                    printf("This %s is composed of the following Cvo objects.\n", TYPES[g_type]);
                    printf("Each object has the shown resource name.\n");
                    if (g_haveParent == 1) {
                      printf("This link displays the composition of the ");
                      HREF(sprintf("%s#OBJECTS", g_parent), sprintf("parent %s.", TYPES[g_type]));
                    }
                  paraC();

                  listO();
                  g_haveObjects = 1;
                  next;
                }

/^\.object /    { arg = fixarg(g_line, ".object");
                  object = substr(arg, 1, index(arg, " ") - 1);
                  resource = substr(arg, length(object) + 1, length(arg));
		  object = parsearg(object);

                    itemO();
                      codeO();
			printf("%s", object);
                      codeC();
                      crossref(sprintf("object <CODE>%s</CODE>", object), " : ");
                      codeO();
                        printf("%s\n", resource);
                      codeC();
                    itemC();

                  next;
                }

/^\.\)objects$/ { listC();
                  next;
                }

/^\.events\(/   { headerO(1);
                    NAME("EVENTS", "Cvo Events\n");
                  headerC(1);

                  paraO();
                    printf("This %s defines the following ", TYPES[g_type]);
                    if (g_haveParent == 1) {
                      HREF(g_events, "Cvo Events");
                      printf(" in addition to ");
                      HREF(sprintf("%s#EVENTS", g_parent), "those defined by its parent");
                      printf(" and ancestor %ss.\n", TYPES[g_type]);
                    }
                    else HREF(g_events, "Cvo Events.");
                  paraC();

                  listO();
                  g_haveEvents = 1;
                  next;
                }

/^\.event\( /   { arg = fixarg(g_line, ".event\(");
                  event = substr(arg, 1, index(arg, " "));
                  struct =substr(arg, length(event) + 1, length(arg));

                  g_argcnt = 1;            # cheat to make it push the event argument down.

                  if (g_inEvent == 1) {
                      paraO();
                      paraC();
                    itemC();
                  }

                  g_inEvent = 1;

                  itemO();
                    deflO();
                      deftO();
                        codeO();
                          crossref(sprintf("event <CODE>%s</CODE>", event), event);
                        codeC();
                        breakOC();
                        breakOC();
                        codeO();
                          crossref(sprintf("event structure <CODE>%s</CODE>", struct), "struct ");
                          printf("%s\n", parsearg(struct));

                  next;
                }

/^\.\)event$/    { codeC();

                  if (g_argcnt < 2) deftC();
                  else defdC();

                    deflC();

                  next;
                } 

/^\.\)events$/  { if (g_inEvent == 1) {
                      paraO();
                      paraC();
                    itemC();
                  }

                  listC();

                  g_inEvent = 0;
                  next;
                }

/^\.transl\(/   { headerO(1);
                    NAME("TRANSLATIONS", "Event Translations\n");
                  headerC(1);

                  paraO();
                    printf("This %s defines the following ", TYPES[g_type]);
                    if (g_haveParent == 1) {
                      HREF(g_trans, "event translations");
                      printf(" in addition to ");
                      HREF(sprintf("%s#TRANSLATIONS", g_parent), "those defined by its parent");
                      printf(" and ancestor %ss.\n", TYPES[g_type]);
                    }
                    else HREF(g_trans, "event translations.");
                  paraC();

                  listO();
                  g_haveTranslations = 1;
                  next;
                }

/^\.trans\( /   { arg = parsearg(fixarg(g_line, ".trans\("));

                    itemO();
                      deflO();
                        deftO();
                          crossref(sprintf("translation <CODE>%s</CODE>", arg), arg);
                        deftC();
                        defdO();

                  next;
                }

/^\.trans: /    { arg = fixarg(g_line, ".trans:");
                  keys = substr(arg, 1, index(arg, " ") - 1);
                  translation = substr(arg, length(keys) + 1, length(arg));

                          codeO();
                            printf("%s", parsearg(keys));
                          codeC();
                          printf(" : ");
                          codeO();
                            printf("%s\n", parsearg(translation));
                          codeC();
                          breakOC();

                  next;
                }

/^\.\)trans$/   {       defdC();
                      deflC();
                      paraO();
                      paraC();
                    itemC();
                  next;
                }

/^\.\)transl$/  { listC();
                  next;
                }

/^\.resources\(/{ headerO(1);
                    NAME("RESOURCES", "New X Resources\n");
                  headerC(1);

                  paraO();
                    printf("This %s uses the following ", TYPES[g_type]);
                    if (g_haveParent == 1) {
                      HREF(g_resources, "X resources");
                      printf(" in addition to ");
                      HREF(sprintf("%s#RESOURCES", g_parent), "those used by its parent");
                      printf(" and ancestor %ss.\n", TYPES[g_type]);
                    }
                    else HREF(g_resources, "X resources.\n");
                  paraC();

                  listO();
                  g_haveResources = 1;
                  next;
                }

# Takes two arguments: resource name, resource class. Class is optional.

/^\.resource /  { arg = fixarg(g_line, ".resource");
                  if (index(arg, " ") != 0) {
                    resource = substr(arg, 1, index(arg, " ") - 1);
                    class = substr(arg, length(resource) + 1, length(arg));
                  }
                  else {
                    resource = arg;
                    class = "";
                  }

                    if (g_inres == 1) itemC();

                    g_inres = 1;

                    itemO();
                      codeO();
                        crossref(sprintf("resource <CODE>%s</CODE> (class <CODE>%s</CODE>)", resource, class), resource);
                      codeC();

                      if (length(class) > 0 ) {
                        printf(" (class: ");
                        codeO();
                          printf("%s", class);
                        codeC();
                        printf(")", class);
                      }
#                     breakOC();

                  next;
                }

/^\.value /     { arg = parsearg(fixarg(g_line, ".value"));

                      printf(" (default value: ");
                      codeO();
                        printf("%s", arg);
                      codeC();
                      printf(")\n");
#                     breakOC();

                  next;
                }

/^\.\)resources/{ if (g_inres == 1) itemC();
                  listC();
                  g_inres = 0;

                  next;
                }

/^\.modres\(/   { headerO(1);
                    NAME("MODRES", "Modified X Resources\n");
                  headerC(1);

                  paraO();
                    printf("This %s modifies the following ", TYPES[g_type]);
                    if (g_haveParent == 1) {
                      HREF(g_resources, "X resources");
                      printf(" which are ");
                      HREF(sprintf("%s#RESOURCES", g_parent), "used by its parent");
                      printf(" or other ancestors.\n");
                    }
                    else HREF(g_resources, "X resources.");
                  paraC();

                  listO();
                  g_haveModRes = 1;
                  next;
                }

/^\.modres /    { arg = fixarg(g_line, ".modres");
                  if (index(arg, " ") != 0) {
                    resource = substr(arg, 1, index(arg, " ") - 1);
                    value = substr(arg, length(resource) + 1, length(arg));
                  }
                  else {
                    resource = arg;
                    value = "";
                  }

                    itemO();
                      codeO();
                        crossref(sprintf("modified resource <CODE>%s</CODE> : <CODE>%s</CODE>", resource, value), resource);
                      codeC();
                      printf(" (new value: ");
                      codeO();
                        printf("%s", parsearg(value));
                      codeC();
                      printf(")\n");
                    itemC();

                  next;
                }

/^\.\)modres$/  { listC();
                  next;
                }

/^\.source /    { code = fixarg(g_line, ".source");

                  if (g_haveSource != 1) {
                    g_haveSource = 1;
                    rule();
                  }

                  paraO();
                    crossref(sprintf("sample source: %s", code), "See the ");
                    HREF(code, "sample source code");
		    g_sampleSource = code;
                    printf("for an example of how to use this %s.\n", TYPES[g_type]);
                  paraC();

                  next;
                }

/^\.example /   { arg = fixarg(g_line, ".example");
                  code = sprintf("@Examples/%s", arg);

                  if (g_haveExample != 1) {
                    g_haveExample = 1;
                    rule();
                  }

                  paraO();
                    crossref(sprintf("sample source: %s", arg), "See the ");
                    HREF(code, "example source code");
		    g_exampleSource = code;
                    printf("for an example of how to use this %s.\n", TYPES[g_type]);
                  paraC();

                  next;
                }

/^\.pair: /     { arg = fixarg(g_line, ".pair:");
                  first = substr(arg, 1, index(arg, " ") - 1);
                  second = substr(arg, length(first) + 1, length(arg));

                    itemO();
                      printf("%s : %s\n", parsearg(first), parsearg(second));
                    itemC();

                  next;
                }

/^\.pair\(\) /  { arg = fixarg(g_line, ".pair()");
                  first = substr(arg, 1, index(arg, " ") - 1);
                  second = substr(arg, length(first) + 1, length(arg));

                    itemO();
                      printf("%s (%s)\n", parsearg(first), parsearg(second));
                    itemC();

                  next;
                }

/^\.code\(/     { preO();
                  codeO();
                  next;
                }

/^\.\)code$/    { codeC();
                  preC();
                  next;
                }

/^\.code /      { arg = parsearg(fixarg(g_line, ".code"));
		  codeO();
		    printf("%s\n", arg);
		  codeC();
		}

/^\.ital /      { arg = parsearg(fixarg(g_line, ".code"));
		  italO();
		    printf("%s\n", arg);
		  italC();
		}

/^\.kbd /       { arg = parsearg(fixarg(g_line, ".code"));
		  kbdO();
		    printf("%s\n", arg);
		  kbdC();
		}

/^\.var /       { arg = parsearg(fixarg(g_line, ".code"));
		  varO();
		    printf("%s\n", arg);
		  varC();
		}

                { arg = parsearg(g_line);

                  if (g_inlist == 1) {
                    itemO();
                      printf("%s\n", arg);
                    itemC();
                  }
                  else printf("%s\n", arg);
                  next;
                }

END             { rule();
                  paraO();
                    printf("See the ");
                    HREF(g_legend, "legend");
                    printf("for information about the conventions used in this documentation.\n");
                  paraC();

                  printf("</BODY></HTML>\n");

                  # Now we build the index.

                  printf("<HTML><HEAD>\n") > INDEX;
                  printf("<TITLE>%s</TITLE>\n", g_title) > INDEX;
                  printf("<LINK REV=\"%s\" HREF=\"%s\">\n</HEAD><BODY>\n", g_revision, g_contact) > INDEX;
                  printf("<P>\n") > INDEX;
                    printf("<A NAME=\"%s\">You</A> may return to the <A HREF=\"%s\">Cvo Object Documenation Index</A> from this document.\n", g_class, g_indexpage) > INDEX;
                    printf("This document contains the following sections\n") > INDEX;
                    printf("describing the %s %s:\n", g_class, TYPES[g_type]) > INDEX;
                  printf("</P>\n") > INDEX;
                  printf("<UL>\n") > INDEX;

                  if (g_haveOverview != 0)
                    printf("<LI><A HREF=\"#OVERVIEW\">Overview of the %s %s</A></LI>\n", g_class, TYPES[g_type]) > INDEX;

                  if (g_haveData != 0)
                    printf("<LI><A HREF=\"#DATA\">Public Data Members</A></LI>\n") > INDEX;

                  if (g_haveMembers != 0)
                    printf("<LI><A HREF=\"#MEMBERS\">Member Functions</A></LI>\n") > INDEX;

                  if (g_haveObjects != 0)
                    printf("<LI><A HREF=\"#OBJECTS\">Children Objects</A></LI>\n") > INDEX;

                  if (g_haveEvents != 0)
                    printf("<LI><A HREF=\"#EVENTS\">Cvo Events</A></LI>\n") > INDEX;

                  if (g_haveTranslations != 0)
                    printf("<LI><A HREF=\"#TRANSLATIONS\">Event Translations</A></LI>\n") > INDEX;

                  if (g_haveResources != 0)
                    printf("<LI><A HREF=\"#RESOURCES\">New X Resources</A></LI>\n") > INDEX;

                  if (g_haveModRes != 0)
                    printf("<LI><A HREF=\"#MODRES\">Modified X Resources</A></LI>\n") > INDEX;

                  if (g_haveSource != 0)
                    printf("<LI><A HREF=\"%s\">Sample Source Code</A></LI>\n", g_sampleSource) > INDEX;

                  if (g_haveExample != 0)
                    printf("<LI><A HREF=\"%s\">Example Source Code</A></LI>\n", g_exampleSource) > INDEX;

                  printf("<LI><A HREF=\"%s\">Documentation Legend</A></LI>\n", g_legend) > INDEX;

                  printf("</UL>\n") > INDEX;

                  if (g_crossref != 0) printf("</P></BODY></HTML>\n") > CROSSREF;
		}
