#include <stdio.h>
#include <sysent.h>
#include <Cvo/Ev.h++>
#include <Cvo/TimeVal.h++>

//
// This test code is based on one of Jim Nowicki's tests
//

EvTimeVal tv;
EvTimeVal now;

void
EchoInput(EvIOEvent *id, void *)
{
    int n;
    char buff[512];

    if ((n = read(id->Fd(), buff, sizeof(buff) - 1)) <= 0) {
       printf("End of input\n");
       delete id;
       exit(0);
    } else {
       buff[n] = '\0';
       printf("Input was: %s", buff);
    }
}

void
Timer2(EvTimerEvent *, void *data)
{
    long interval = (long) data;

    tv.SetCurrentTime();
    tv -= now;
    printf("Received timer event at %d.%6.6d, interval = %d\n", tv.tv_sec,
           tv.tv_usec, interval);
    interval /= 2;
    if (interval > 0)
       (void) new EvTimerEvent(interval, Timer2, (void *) interval, EV_DELETE);
}

void
Timer1(EvTimerEvent *, void *data)
{
    long i = (long) data;

    tv.SetCurrentTime();
    tv -= now;
    printf("Received timer event at %d.%6.6d, interval = %d\n", tv.tv_sec,
           tv.tv_usec, i);
    i *= 2;
    (void) new EvTimerEvent(i, i<12000 ? Timer1 : Timer2, (void*)i, EV_DELETE);
}

void
TimerEnd(EvTimerEvent *, void *)
{
    fprintf(stderr, "Finished!\n");
    exit(0);
}


int
worker(EvWorkProcEvent *, void *data)
{
    static int count = 0;
    if (count++ == 1000) {
       printf("%s", (char *) data);
       count = 0;
    }
    fflush(stdout);
    return 0;
}

void
sighandler(EvSignal *es, void *)
{
    fprintf(stderr, "Received signal %d\n", es->Signal());
}

void
main(int, char **)
{
    EvSignal        *s1 = new EvSignal(SIGINT, sighandler);
    EvInputEvent    *i1 = new EvInputEvent(0, EchoInput);
    EvTimerEvent    *t1 = new EvTimerEvent(500,   Timer1, (void *) 200);
    EvTimerEvent    *t2 = new EvTimerEvent(2,     Timer1, (void *) 2);
    EvTimerEvent    *t3 = new EvTimerEvent(100,   Timer1, (void *) 100);
    EvTimerEvent    *t4 = new EvTimerEvent(10000, TimerEnd);
    EvWorkProcEvent *wp = new EvWorkProcEvent(worker, "Work\n");

    now.SetCurrentTime();
    Ev::ProcessEvents();
}
