#include <Cvo/Application.h++>
#include <Cvo/GenericList.h++>
#include <Cvo/ExpandPage.h++>
#include <Cvo/Button.h++>
#include <Cvo/Frame.h++>

Cvo_ExpandPage page1;
Cvo_ExpandPage page2;
Cvo_GenericList *list;
Cvo_ExpandPageLine *item;

void changepage(Cvo_Object *, XEvent *, void *);
void listselect(Cvo_Object *, XEvent *, void *);
void showitem(Cvo_Object *, XEvent *, void *);
void hideitem(Cvo_Object *, XEvent *, void *);

main(int ac, char **av)
{
    Cvo_Parse(&ac, &av);

    Cvo_ExpandPageLine *line;
    Cvo_ExpandPageSet *set;

    line = page1.AppendItem("First Line", "data 1");
    set = line->AddHierarchy();
    set->AppendItem("Subline 1", "sub 1");
    set->AppendItem("Subline 2", "sub 2");
    set->AppendItem("Subline 3", "sub 3");

    item = line = page1.AppendItem("Second Line is a very long name and show set the scroll bar", "data 2");

    line = page1.AppendItem("Third Line", "data 3");
    set = line->AddHierarchy();
    set->AppendItem("Micro 1", "micro 1");
    set->AppendItem("Micro 2", "micro 2");

    line = page2.AppendItem("Line #1", "line 1");

    line = page2.AppendItem("Line #2", "line 2");
    set = line->AddHierarchy();
    set->AppendItem("Line 2a", "line 2a");
    set->AppendItem("Line 2b", "line 2b");
    set->AppendItem("Line 2c", "line 2c");
    set->AppendItem("Line 2d", "line 2d");

    line = page2.AppendItem("Line #3", "line 3");

    line = page2.AppendItem("Line #4", "line 4");

    Cvo_Application *app = new Cvo_Application("expand");
    Cvo_Window *slab = new Cvo_Window(app);
    slab->VerticalChildren();
    slab->ExpandFrame();

    Cvo_Frame *frame = new Cvo_Frame(slab);

    Cvo_Button *but;

    but = new Cvo_Button("page1", frame, "Page 1");
    but->Register(CvoButtonUpEvent, changepage, &page1);

    but = new Cvo_Button("page2", frame, "Page 2");
    but->Register(CvoButtonUpEvent, changepage, &page2);

    frame = new Cvo_Frame(slab);
    but = new Cvo_Button("hide", frame, "Hide Item");
    but->Register(CvoButtonUpEvent, hideitem);
    but = new Cvo_Button("show", frame, "Show Item");
    but->Register(CvoButtonUpEvent, showitem);

    list = new Cvo_GenericList("list", slab, &page1);
    list->ExpandFrame();

    list->Register(CvoListItemSelectedEvent, listselect);

    app->MainLoop();
}

void
changepage(Cvo_Object *, XEvent *, void *vp)
{
    list->NewPage((Cvo_Page *)vp);
}

void
showitem(Cvo_Object *, XEvent *, void *)
{
    item->Hide(False);

    Cvo_PageChangedEvent pce;

    pce.removedlines = True;
    pce.newlines = True;
    pce.changedlines = True;
    pce.type = CvoPageChangedEvent;

    Cvo_GenericList_PageChanged(0, (XEvent *)&pce, list);

}

void
hideitem(Cvo_Object *, XEvent *, void *)
{
    item->Hide(True);

    Cvo_PageChangedEvent pce;

    pce.removedlines = True;
    pce.newlines = True;
    pce.changedlines = True;
    pce.type = CvoPageChangedEvent;

    Cvo_GenericList_PageChanged(0, (XEvent *)&pce, list);
}

void
listselect(Cvo_Object *, XEvent *ev, void *)
{
    Cvo_ListItemSelectedEvent *lise = (Cvo_ListItemSelectedEvent *)ev;
    Cvo_ExpandPage *page = (Cvo_ExpandPage *)lise->item;

    if (lise->line >= 0)
	printf("%d click on %s\n",
		lise->count,
	        (char *)(page->GetAssociatedData(lise->line)));
}
