#include <Cvo/Modal.h++>
#include <Cvo/Application.h++>
#include <Cvo/Input.h++>
#include <Cvo/Button.h++>
#include <Cvo/Frame.h++>
#include <Cvo/TextPage.h++>
#include <Cvo/TextViewPort.h++>
#include <Cvo/Separator.h++>
#include <Cvo/Label.h++>

void domodal(Cvo_Object *, XEvent *, void *);
void modal_okay(Cvo_Object *, XEvent *, void *);
void modal_cancel(Cvo_Object *, XEvent *, void *);
void buildmodal(Cvo__Modal *, void *);

Cvo_Application *app;
Cvo_TextPage output;

main()
{
    app = new Cvo_Application("modal-example");
    Cvo_Window *slab = new Cvo_Window(app);
    slab->VerticalChildren();

    Cvo_Button *button = new Cvo_Button("domodal", slab, "Do Modal");
    button->Register(CvoButtonUpEvent, domodal);

    new Cvo_Separator(slab);

    new Cvo_Label("output-label", slab, "User Output");

    Cvo_TextViewPort *tvp = new Cvo_TextViewPort("output", slab, &output);
    tvp->ExpandFrame();
    tvp->SetMinSize(40,5);

    Cvo_MainLoop(app);
}

struct modalinfo {
    char	buffer[256];
    Cvo_Input	*input;
    Cvo__Modal	*modal;
};

void
domodal(Cvo_Object *, XEvent *, void *)
{
    modalinfo doko;

    if (Cvo_Modal("modal", app, buildmodal, &doko) == True)
	output.AppendText(doko.buffer);
}

void
buildmodal(Cvo__Modal *modal, void *vdoko)
{
    modalinfo *doko = (modalinfo *)vdoko;

    modal->VerticalChildren();

    doko->input = new Cvo_Input("modal-input", modal);
    doko->modal = modal;

    Cvo_Frame *frame = new Cvo_Frame(modal);
    frame->HorizontalChildren();

    Cvo_Button *button;

    button = new Cvo_Button("confirm", frame);
    button->SetLabel(modal->GetResource(_Qconfirm, _QMessage, "Confirm"));
    Cvo_Register(button, CvoButtonUpEvent, &modal_okay, doko);

    button = new Cvo_Button("cancel", frame);
    button->SetLabel(modal->GetResource(_Qcancel, _QMessage, "Cancel"));
    button->LayOpposite();
    Cvo_Register(button, CvoButtonUpEvent, &modal_cancel, doko);

    Cvo_Register(doko->input, CvoInputEnteredEvent, &modal_okay, doko);
}

void
modal_okay(Cvo_Object *, XEvent *, void *vdoko)
{
    modalinfo *doko = (modalinfo *)vdoko;

    strncpy(doko->buffer, doko->input->GetText(), sizeof(doko->buffer));

    doko->modal->Okay();
}

void
modal_cancel(Cvo_Object *, XEvent *, void *vdoko)
{
    modalinfo *doko = (modalinfo *)vdoko;
    doko->buffer[0] = 0;
    doko->modal->Cancel();
}
