/*************************************************************
 *                                                           *
 *                     file: cdrom.h                         *
 *                                                           *
 *************************************************************/

/*
 * Copyright (C) 1988, 1989 Sun Microsystems, Inc.
 */
#include "msf.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/buf.h>
#include <sun/dkio.h>
#ifdef sun4c
#include <scsi/targets/srdef.h>
#else
#include <sundev/srreg.h>
#endif
#include <sys/time.h>

/* @(#)cdrom.h @(#)cdrom.h 1.2 89/12/12 Copyr 1989 Sun Microsystem. */

/* definition for mounted() return value */
#define	STILL_MOUNTED	1
#define	UNMOUNTED	0

class CD_ROM {
	int			left;
	int			right;
	int			fd;		// FD of the CD ROM
	int			nx;		// Not exclusive use flag
	int			ejected;	// 0 -> disk in player
	struct	cdrom_tocentry	lead;
	struct	cdrom_tocentry	*entries;
	struct	cdrom_tochdr	hdr;
	struct  cdrom_subchnl	sc;
	Msf			total;
	Msf			*times;
public:
	CD_ROM(char *dev_name = "/dev/rsr0", int _nx = 0);
	~CD_ROM()		{ if (fd >= 0) close(fd); }
	void 	Open(char *dev_name = "/dev/rsr0", int _nx = 0);
	int	PlayTrack(int t)	{ return(PlayTrack(t, t)); }
	int	PlayTrack(int play_track, int end_track);
	int	Start();
	int	Stop();
	int	Eject();
	int	ReadTocEntry(struct cdrom_tocentry *entry);
	int	ReadTocHeader();
	int	ReadToc();
	int	Pause();
	int	Resume();
	int	Volume(double v)	{ return(Volume((int)(v ? v * 10 + 155 : 0))); }
	int	Volume(double vr, double vl) {
				int ivr = (int)(vr ? vr * 10 + 155 : 0);
				int ivl = (int)(vl ? vl * 10 + 155 : 0);
				return(Volume(ivl, ivr)); }
	int	Volume(int left, int right);
	int	Volume(int vol)		{ return(Volume(vol, vol)); }
	int	GetRelativeMSF(struct tm *tmp, int *track);
	int	GetAbsoluteMSF(Msf *msf);
	int	GetMSF(struct cdrom_msf *msf);
	int	PlayMSF(struct cdrom_msf *msf);
	int	Playing(int *track);
	int	Paused(int *track);
	int	Mounted(char *dev = "/dev/rsr0");
	int	GetSubChannel();
	void	Fade(double v, int t)	{ Fade(v, v, t); }
	void	Fade(double vr, double vl, int t);

	int	FirstTrack()		{ return(hdr.cdth_trk0); }
	int	LastTrack()		{ return(hdr.cdth_trk1); }
	Msf	TrackTime(int);
	int	Ejected()		{ return(fd < 0 || ejected); }
};
