/*************************************************************
 *                                                           *
 *                     file: msf.c                           *
 *                                                           *
 *************************************************************/

/*
 * Copyright (C) 1988, 1989 Sun Microsystems, Inc.
 */

/*
 * This file contains code for the MSF CDROM address format data structure 
 */

#include "msf.h"

/************************ entry points ***********************/

Msf::Msf()
{
	min = 0;
	sec = 0;
	frame = 0;
}

Msf::Msf(int f)
{
	min = f / (75 * 60);
	f -= min * 75 * 60;
	sec = f / 75;
	frame = f - sec * 75;
}

Msf::Msf(int m, int s, int f)
{
	min = m;
	sec = s;
	frame = f;
}

Msf &
Msf::operator =(Msf &msf)
{
	min = msf.min;
	sec = msf.sec;
	frame = msf.frame;
	return(*this);
}

void
Msf::SetFrames(int f)
{
	min = f / (75 * 60);
	f -= min * 75 * 60;
	sec = f / 75;
	frame = f - sec * 75;
}

Msf 
operator +(Msf &msf1, Msf &msf2)
{
    int frames = msf1.Frames() + msf2.Frames();
    Msf rmsf(frames);
    return(rmsf);
}

Msf 
operator -(Msf &msf1, Msf &msf2)
{
    int frames = msf1.Frames() - msf2.Frames();
    Msf rmsf(frames);
    return(rmsf);
}

Msf &
Msf::operator +=(Msf &msf)
{
    int frames = Frames() + msf.Frames();
 
    SetFrames(frames);
    return(*this);
}

Msf &
Msf::operator -=(Msf &msf)
{
    int frames = Frames() - msf.Frames();

    SetFrames(frames);
    return(*this);
}
 
int
Msf::operator ==(Msf &msf)
{
    return(Frames() == msf.Frames());
}
 
int
Msf::operator <(Msf &msf)
{
    return(Frames() < msf.Frames());
}
 
int
Msf::operator >(Msf &msf)
{
    return(Frames() > msf.Frames());
}
