//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Image.h++,v 1.3 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Image_)
#define	_Cvo_Image_

#if	!defined(_Cvo_Window_)
#include <Cvo/Object.h++>
#endif
#if	!defined(_Cvo_XImage_)
#include <Cvo/XImage.h++>
#endif

struct _IColor {
    Cvo_Color	color;
    int		rep;
};

struct _ImageMap {
    Pixmap	pixmap;
    int		depth;
    _ImageMap	*next;
    BOOL	selected : 1;
    BOOL	mask : 1;

    _ImageMap()		{ pixmap = 0; depth = 0; next = 0;
			  selected = False; mask = False; }
};

class _Image {
public:
	char			*filename;
	int			refcnt;
	int			depth;
	Cvo_XImage		*xim;
    	_ImageMap		*pixmaps;
	_IColor			*colors;
	int			ncolors;
	unsigned int		width;
	unsigned int		height;
	int			bpl;
	BOOL			amselected : 1;
	BOOL			usersdata : 1;
	void			*incore;	// Where user loaded from
	union {
	  CARD8	*data8;
	  CARD16 *data16;
	  CARD32 *data32;
	}			data;
	_Image()	{ colors = 0; data.data8 = 0; xim = 0;
			  refcnt =  0; filename = 0; pixmaps = 0;
			  amselected = 0; usersdata = 0; incore = 0; }
	~_Image();
};

class Cvo_Image {
public:
	static Cvo_Image *root;
	Cvo_Image	*next;
	Cvo_Image	*prev;

	_Image		*image;
	Cvo_Window	*win;
	BOOL		selected : 1;

	void LoadXPM2File(char *filename);
	void LoadXPMFile(char *filename);
	void LoadBMFile(char *filename);
	void LoadXPMData(int w, int h, int n, int c, char **cs, char **ps);
	void Init(Cvo_Window *);
	void LoadFile(char *);
public:
	Cvo_Image(Cvo_Window *_win, char *filename = 0, char *resource = 0);
	Cvo_Image(Cvo_Window *_win, int width, int height, int depth, CARD8 *);
	Cvo_Image(Cvo_Window *_win, int w, int h, int n, int, char **, char **);
	~Cvo_Image();

	void Show(int x, int y, int w = 0, int h = 0, int sx = 0, int sy = 0);
	void Select()	{ selected = 1; }
	void UnSelect()	{ selected = 0; }
	BOOL Loaded()	{ return(image ? True : False); }
	int Width()	{ return(image ? image->width : 0); }
	int Height()	{ return(image ? image->height : 0); }
	void ResetWindow(Cvo_Window *nw)	{ win = nw; }
	Cvo_XImage *Image()	{ return(image ? image->xim : 0); }
	Pixmap GetPixmap(int = -1);
    	Pixmap Mask()		{ return(GetPixmap(-2)); }
};
#endif
