//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Output.h++,v 1.3 1994/09/15 17:39:15 prb Exp $
//
#if	!defined(_Cvo_Output_)
#define	_Cvo_Output_

#if	!defined(_Cvo_CRT_)
#include <Cvo/CRT.h++>
#endif

class Cvo_Output : public Cvo_CRT {
protected:
    wchar_t		*buffer;
    int			bufmax;
    wchar_t		*bufptr;
    wchar_t		*bufend;
    wchar_t		*offset;
    char		*accept;
    int			acceptlen;
    BOOL 		(*filter)(Cvo_Output *, wchar_t, int, void *);
    void		*filterdata;
    BOOL		dirty:1;
private:
    void _Init();
protected:
    void EraseLine();
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_Output)
    void ResizeEvent(XEvent *, void *);
public:
    CONSTRUCDECL(Cvo_Output)
    ~Cvo_Output();
    void _Create();
    void Flush(int r = 0);
    void Enter(char *);
    void Enter(wchar_t *);
    void Enter(Cvo_CharacterBuffer &b)	{ Enter(b.wcValue()); }
    char *GetText();
    void SetText(char *s = 0)		{ EraseLine(); Enter(s); }
    void SetText(wchar_t *s)		{ EraseLine(); Enter(s); }
    void SetText(Cvo_CharacterBuffer &b){ EraseLine(); Enter(b.wcValue()); }
    void SetFilter(BOOL (*f)(Cvo_Output *, wchar_t, int, void *), void *d = 0)
					{ filter = f; filterdata = d; }
    int NumberCharacters()		{ return(bufend-buffer); }
    void MoveCursor(int line, int col);

    CARD16 CalculateWidth();
    CARD16 CalculateHeight();
};

#endif
