//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Protocols.h++,v 1.5 1994/09/29 20:31:51 prb Exp $
//
/*****************************************************************************/
/*  Protocols.h - Basic Inter-Client communication protocol		     */
/*  Date of origin: August 93 						     */
/*                                                                           */
/*  History:                                                                 */
/*     Author       Date    Comments                                         */
/*     ------       ----    --------                                         */
/*     Paul Algren   8-93   Initial implementation 			     */
/*                                                                           */
/*  Portions of this software may still be in development.  The existence of */
/*  the software still in development is not a commitment of actual release  */
/*  or support by Cray Research, Inc.  If it is released, the final form of  */
/*  the product and the time of official release is at the discretion of     */
/*  Cray Research, Inc.                                                      */
/*                                                                           */
/*****************************************************************************/
#ifndef __PROTOCOLS_H_DEFINED__
#  define __PROTOCOLS_H_DEFINED__ 1
#include <Cvo/Object.h++>
#if	defined(sun)
#define	_strings_h		// Get rid of X's inclusion of Sun's
				// conflicting files (string.h vs strings.h)
#endif
#include <X11/Intrinsic.h>
#include <X11/X.h>
#include <X11/Xmd.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

class Cvo_ICM_Protocol {
    char*	msg_target;
    Atom	msg_protocol;
    Cvo_Registration* reg;

    void InitProtocol();
    static void Handler(Cvo_Object*, XEvent*, void*);

  protected:	
    Cvo_Object* obj;

    void SetProtocol(Display*);
    Atom MsgProtocol() { return (msg_protocol); }
    Atom GetUnusedProperty(Display *dpy, Window to);
    virtual void Process(XEvent*)=0;

  public:
    Cvo_ICM_Protocol(char* targ, Cvo_Object* obj=0);
    ~Cvo_ICM_Protocol();
    const Cvo_Object* Object() { return (obj); }
    virtual BOOL Send(Display*, Window to)=0;
};

class Cvo_Drop_Protocol : public Cvo_ICM_Protocol {
  protected:	
    CARD16	x;
    CARD16	y;
    virtual void Process(XEvent*)=0;

  public:
    Cvo_Drop_Protocol(char* targ, Cvo_Object* obj=0)
	: Cvo_ICM_Protocol(targ, obj) { }
    Window FindDropTarget(Display*, int dx, int dy);
    virtual BOOL Send(Display*, Window to)=0;
};

class Cvo_CddDrop_Protocol : public Cvo_Drop_Protocol {
  protected:
    virtual void Process(XEvent*);

   public:
    Window      sendor;
    short	key;
    Time	time;

    unsigned char* data;
    int size;

    Cvo_CddDrop_Protocol(Cvo_Object* obj=0)
	: Cvo_Drop_Protocol("CDD_DROP_TARGET", obj) { size=0; data=0;}
    virtual ~Cvo_CddDrop_Protocol();
    virtual BOOL Send(Display*, Window to);
}; 

class Cvo_IXI_Protocol : public Cvo_Drop_Protocol {
  protected:
    virtual void Process(XEvent*);

  public:
    Time	time;

    unsigned char* data;
    int size;

    Cvo_IXI_Protocol(Cvo_Object* obj=0, char* targ = "IXI_DROP_PROTOCOL")
	: Cvo_Drop_Protocol(targ, obj) { data = 0; size = 0; }
    virtual ~Cvo_IXI_Protocol();
    virtual BOOL Send(Display*, Window to);
};

class Cvo_HostAndFile_Protocol : public Cvo_IXI_Protocol {
  public:
    Cvo_HostAndFile_Protocol(Cvo_Object* obj=0)
	: Cvo_IXI_Protocol(obj, "HOST_AND_FILE_NAME") { }
};

class Cvo_SunMvFiles_Protocol : public Cvo_Drop_Protocol {
  protected:
    virtual void Process(XEvent*);

   public:
    Window	sendor;

    unsigned char* data;
    int size;

    Cvo_SunMvFiles_Protocol(Cvo_Object* obj=0, char* targ = "XV_DO_DRAG_MOVE")
	: Cvo_Drop_Protocol(targ, obj) { data = 0; size = 0; }
    virtual ~Cvo_SunMvFiles_Protocol();
    virtual BOOL Send(Display*, Window to);
}; 

class Cvo_SunCpFiles_Protocol : public Cvo_SunMvFiles_Protocol {
   public:
    Cvo_SunCpFiles_Protocol(Cvo_Object* obj=0)
	: Cvo_SunMvFiles_Protocol(obj, "XV_DO_DRAG_COPY") { }
};

class Cvo_SunLdFiles_Protocol : public Cvo_SunMvFiles_Protocol {
   public:
    Cvo_SunLdFiles_Protocol(Cvo_Object* obj=0)
	: Cvo_SunMvFiles_Protocol(obj, "XV_DO_DRAG_LOAD") { }
};

#endif /* __PROTOCOLS_H_DEFINED__ */
