//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Registration.h++,v 1.5 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Registration_)
#define	_Cvo_Registration_

#if	!defined(_Cvo_EventTypes_)
#include <Cvo/EventTypes.h++>
#endif

class Cvo_Registration;
class Cvo_Object;

class Cvo_RegDependents {
public:
    Cvo_Object		*object;
    Cvo_RegDependents	*next;
};

class Cvo_RegReferences {
public:
    Cvo_Registration		*reg;
    Cvo_RegReferences	*next;
};
class Cvo_Registration {
private:
    static Cvo_Registration **freelist;
    int			type;
    CARD16		mask;
    CARD16		state;
    CARD32		key_button;

    Cvo_RegDependents	*dependents;	// Objects which have us registered
    Cvo_Registration	*next;
    Cvo_Registration	*prev;
    Cvo_Registration	**rootp;

public/*INTERNAL*/:
    void Handler(XEvent *ev, CARD16 _state, CARD32 _key_button);
    Cvo_Registration **AllocateArray();
    void FreeArray(Cvo_Registration **a)
            { *(Cvo_Registration ***)a = freelist; freelist = a; }
protected:
    BOOL		*deletedp;	// Used to determine if I was deleted.
    Cvo_Object		*object;	// Object registered on
    XEvent		*event;		// Point to event generated
    virtual void function() = 0;

public:
    Cvo_Registration(Cvo_Object *win, CARD32 _event, CARD16 _mask, KeySym _key = 0);
    virtual ~Cvo_Registration();

    void AddDependent(Cvo_Object *);
    void MoveUp(Cvo_Registration * = 0);
    BOOL Registered()			{ return(object ? True : False); }

    int Type()				{ return(type); }
    Cvo_Registration *Next()			{ return(next); }
    CARD16 State()			{ return(state); }
};

class Cvo_ExternalRegistration : public Cvo_Registration {
protected:
    Cvo_ExtEvFunc       func;
    void                *data;

    void function();
public:
    Cvo_ExternalRegistration(Cvo_Object *win,
                        CARD32 _event,
                        CARD16 _mask,
                        KeySym _key,
                        Cvo_ExtEvFunc _func,
                        void *_data);
};

class Cvo_OneTimeRegistration : public Cvo_ExternalRegistration {
protected:
    void function();
public:
    Cvo_OneTimeRegistration(Cvo_Object *,
                            CARD32,
                            Cvo_ExtEvFunc,
                            void * = 0);
};

class Cvo_InternalRegistration : public Cvo_Registration {
protected:
    Cvo_EvFunc          func;
    void                *data;

    void function();
public:
    Cvo_InternalRegistration(Cvo_Object *win,
                        CARD32 _event,
                        CARD16 _mask,
                        KeySym _key,
                        Cvo_EvFunc _func,
                        void *_data);
};

class Cvo_Action;

class Cvo_ActionRegistration : public Cvo_Registration {
protected:
    Cvo_Action  *actions;
    void function();
public:
    Cvo_ActionRegistration(Cvo_Object *, CARD32, CARD16, KeySym, Cvo_Action *);
};

#define	Cvo_MaxEvent	64
#define	Cvo_EventMask	0x000000ff
#define	Cvo_FullEventMask	0x0000ffff

//
// Internal Event numbers must not overlap with standard X events.
//
#define	InternalEvent0	48
#define	InternalEvent1	49
#define	InternalEvent2	50
#define	InternalEvent3	51
#define	InternalEvent4	52
#define	InternalEvent5	53
#define	InternalEvent6	54
#define	InternalEvent7	55
#define	InternalEvent8	56
#define	InternalEvent9	57
#define	InternalEvent10	58
#define	InternalEvent11	59
#define	InternalEvent12	60
#define	InternalEvent13	61
#define	InternalEvent14	62
#define	InternalEvent15	63

#define	Cvo_UserEvent0	(Cvo_UserEventType + InternalEvent0)
#define	Cvo_UserEvent1	(Cvo_UserEventType + InternalEvent1)
#define	Cvo_UserEvent2	(Cvo_UserEventType + InternalEvent2)
#define	Cvo_UserEvent3	(Cvo_UserEventType + InternalEvent3)
#define	Cvo_UserEvent4	(Cvo_UserEventType + InternalEvent4)
#define	Cvo_UserEvent5	(Cvo_UserEventType + InternalEvent5)
#define	Cvo_UserEvent6	(Cvo_UserEventType + InternalEvent6)
#define	Cvo_UserEvent7	(Cvo_UserEventType + InternalEvent7)
#define	Cvo_UserEvent8	(Cvo_UserEventType + InternalEvent8)
#define	Cvo_UserEvent9	(Cvo_UserEventType + InternalEvent9)
#define	Cvo_UserEvent10	(Cvo_UserEventType + InternalEvent10)
#define	Cvo_UserEvent11	(Cvo_UserEventType + InternalEvent11)
#define	Cvo_UserEvent12	(Cvo_UserEventType + InternalEvent12)
#define	Cvo_UserEvent13	(Cvo_UserEventType + InternalEvent13)
#define	Cvo_UserEvent14	(Cvo_UserEventType + InternalEvent14)
#define	Cvo_UserEvent15	(Cvo_UserEventType + InternalEvent15)

inline BOOL
_Cvo_IsCvoEvent(XEvent *e)
{
    int type = e->type & Cvo_EventMask;
    return(type >= InternalEvent0 && type < Cvo_MaxEvent);
}

#define	ButtonMask (Button1Mask|Button2Mask|Button3Mask|Button4Mask|Button5Mask)

//
// The upper bits are 0x07000000
//
#define	ButtonNumberMask	0x07000000
#define	ButtonNumberShift	24

#define	Button1Press	(ButtonPress | (Button1 << 24))
#define	Button2Press	(ButtonPress | (Button2 << 24))
#define	Button3Press	(ButtonPress | (Button3 << 24))
#define	Button4Press	(ButtonPress | (Button4 << 24))
#define	Button5Press	(ButtonPress | (Button5 << 24))

#define	Button1Release	(ButtonRelease | (Button1 << 24))
#define	Button2Release	(ButtonRelease | (Button2 << 24))
#define	Button3Release	(ButtonRelease | (Button3 << 24))
#define	Button4Release	(ButtonRelease | (Button4 << 24))
#define	Button5Release	(ButtonRelease | (Button5 << 24))

#define	Button1Motion	(MotionNotify | (Button1 << 24))
#define	Button2Motion	(MotionNotify | (Button2 << 24))
#define	Button3Motion	(MotionNotify | (Button3 << 24))
#define	Button4Motion	(MotionNotify | (Button4 << 24))
#define	Button5Motion	(MotionNotify | (Button5 << 24))

#define	ButtonCountMask		0xf0000000
#define	ButtonCountShift	28

#define	ButtonDoubleClick	0x10000000
#define	ButtonTripleClick	0x20000000
#define	ButtonQuadrupleClick	0x30000000
#define	ButtonQuintupleClick	0x40000000
#define	ButtonSextupleClick	0x50000000
#define	ButtonSeptupleClick	0x60000000
#define	ButtonOctupleClick	0x70000000

//
// Theses bits end up in	0x007f0000
//
#define	ShiftKey		(ShiftMask << 16)
#define	LockKey			(LockMask << 16)
#define	ControlKey		(ControlMask << 16)
#define	Mod1Key			(Mod1Mask << 16)
#define	Mod2Key			(Mod2Mask << 16)
#define	Mod3Key			(Mod3Mask << 16)
#define	Mod4Key			(Mod4Mask << 16)
#define	Mod5Key			(Mod5Mask << 16)

//
// The Button mask is in bits 0x0000ff00
//

void Cvo_PushEventFilter(XEvent *(*)(Cvo_Object *, XEvent *, void *),
			 Cvo_Object * = 0,
			 void * = 0, BOOL = False);
void Cvo_PopEventFilter();
BOOL Cvo_ExclusiveEventFilter();

inline void
Cvo_PushEventFilter(XEvent *(*f)(Cvo_Object *, XEvent *, void *), void *d)
{
    Cvo_PushEventFilter(f, 0, d);
}

inline void
Cvo_PushExEventFilter(XEvent *(*f)(Cvo_Object *, XEvent *, void *), void *d)
{
    Cvo_PushEventFilter(f, 0, d, True);
}

inline void
Cvo_PushExEventFilter(XEvent *(*f)(Cvo_Object *, XEvent *, void *),
                         Cvo_Object *o = 0, void *d = 0)
{
    Cvo_PushEventFilter(f, o, d, True);
}

#endif
