//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Translation.h++,v 1.8 1994/08/17 19:07:45 prb Exp $
//
#if	!defined(_Cvo_Translation_)
#define	_Cvo_Translation_

#define	XLATE_MOD_NONE	0x00
#define	XLATE_MOD_SHIFT	ShiftKey
#define	XLATE_MOD_CTRL	ControlKey
#define	XLATE_MOD_META	Mod1Key
#define	XLATE_MOD_HYPER	Mod2Key
#define	XLATE_MOD_LOCK	LockKey

//
// This is the structure the application will establish.
// Note that the routine to be called must be a member function to
// either the Cvo_Object class, or a class derived there from.
//
struct Cvo_HandleFunction {
	char		*symbol;
	virtual void	function(Cvo_Object *, XEvent *, int, char **) = 0;
};

struct Cvo_ExtHandleFunction : Cvo_HandleFunction {
	void		function(Cvo_Object *, XEvent *, int, char **);
	void		(*handler)(Cvo_Object *, XEvent *, int, char **);
	Cvo_ExtHandleFunction(char *, void (*)(Cvo_Object *, XEvent *, int, char **));
};

class Cvo_Action {
	friend void Cvo_ActionRegistration::function();
	friend class Cvo_Translation;
	friend class Cvo_TranRec;
	Cvo_Action		*next;
	Cvo_Action		*prev;
	char			*symbolic_name;
	Cvo_HandleFunction	*function;
	char			**params;
	int			numparams;
	BOOL			warned:1;
public:
	Cvo_Action(Cvo_Action **root);		// constructor
	void Delete(Cvo_Action **root);
	int Parse(char *);			//
	void AddList(char *, int);		// add to params list
	void Interrogate();			// for debugging purposes
	void Bind(Cvo_HandleFunction *);
	void Install(Cvo_Object *);
	void Verify()
			{ if (function == 0 && !warned) {
			   Cvo_Failure(CvoE_WARN, CvoE_MISSTRAN,
				"Could not bind the translation ``%s''\n",
				symbolic_name); warned = 1; } }

	Cvo_Action &operator=(Cvo_Action &old)
			{ symbolic_name = old.symbolic_name;
			  params = old.params;
			  numparams = old.numparams;
			  function = 0;
			  return(*this); }
	Cvo_Action *Duplicate();		// Dup my list
};

class Cvo_TranRec {
	friend class Cvo_Translation;
	Cvo_TranRec	*next;
	Cvo_TranRec	*prev;
	CARD32		yes_modifiers;	// Which modifiers are explicit allowed
	CARD32		no_modifiers;	// and disallowed
	CARD32		event;		// The translation type.
	KeySym		keysym;
	int		which;
	int		count;
	Cvo_Action	*actions;	// Linked list of actions
public:
	Cvo_TranRec(Cvo_TranRec **root);
	void Delete(Cvo_TranRec **root);
	Cvo_TranRec *Duplicate();		// Dup my list
	void Verify();
	void Install(Cvo_Object *);
	void Bind(Cvo_HandleFunction *);

	Cvo_TranRec &operator=(Cvo_TranRec &old)
			{ yes_modifiers = old.yes_modifiers;
			  no_modifiers = old.no_modifiers;
			  event = old.event;
			  count = old.count;
			  keysym = old.keysym;
			  which = old.which;
			  actions = old.actions->Duplicate();
			  return(*this); }

	inline friend int operator==(Cvo_TranRec &t0, Cvo_TranRec &t1);
};

inline int
operator==(Cvo_TranRec &t0, Cvo_TranRec &t1)
{
    return(t0.yes_modifiers == t1.yes_modifiers &&
	   t0.no_modifiers == t1.no_modifiers &&
	   t0.count == t1.count &&
	   t0.event == t1.event &&
	   t0.keysym == t1.keysym &&
	   t0.which == t1.which);
}

//
// Translation tables are funny beasts.
// The original tables are read in from strings, and these will simply
// have the ''base'' pointer set to that string so we can cache it.
// Once the tables are read in, they are merged, possibly differently
// for each widget.  At each stage of merging (as we come up through the
// class hierarchy) a new table is built, which is the product of the
// parent classes translations with the current classes orignal translations.
// These new tables have both the ''base'' and ''parent'' entries filled in
// which can be used to cache these tables.
//
// Note that theses structures start to get real cozy with one another, so
// it is generally a real bad idea to delete a translation table once it has
// mananged to get itself worked into the system...
//

class Cvo_Translation {
private:
	static Cvo_Translation	*root;
	Cvo_Translation	*next;
	Cvo_Translation	*prev;
	char		*base;		// What string this came from
	Cvo_Translation	*table0;	// The old table
	Cvo_Translation	*table1;	// And the one merged to it
	int		mode:3;		// mode (Override, Augment, Replace).
	Cvo_TranRec	*xlate_list;	// Translation Lists

	Cvo_TranRec	*Match(Cvo_TranRec *);
public:
	Cvo_Translation();
	~Cvo_Translation();
	void Interrogate();		// print out debugging info
	int ParseAction(char *);
	int Parse(char *, int defmode = XLATE_AUGMENT);
	void Merge(Cvo_Translation *, Cvo_Translation *);
	void Verify();
	void Install(Cvo_Object *);
	void Bind(Cvo_HandleFunction *);
	friend Cvo_Translation *Cvo_LoadTranslation(char *, int defmode = XLATE_AUGMENT);
	friend Cvo_Translation *Cvo_LoadTranslation(Cvo_Translation *,
						    Cvo_Translation *);
};

/*
 * Define an External Handler for an object.  This can be called
 * anytime after the object has been created.  A AddTranslations()
 * call should be made to insert the new translations into the database
 * to use these functions, if desired.
 */
#define Cvo_EXTHANDLER(object, translation, function) { \
    void function(Cvo_Object *, XEvent *, int, char **); \
    static Cvo_ExtHandleFunction _handler(translation,  function); \
    object->Register(CvoBindEvent, _Cvo_ObjectAddBinding, &_handler); \
}   
#endif
