//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Action.cc,v 1.3 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

Cvo_Action::Cvo_Action(Cvo_Action **root)
{   CVO_ENTER
    next = 0;
    if (!*root) {
        prev = this;
        *root = this;
    } else {
        prev = (*root)->prev;
        prev->next = this;
	(*root)->prev = this;
    }

    symbolic_name = 0;
    numparams = 0;
    params = NULL;
    function = NULL;
    warned = 0;
}

Cvo_Action *
Cvo_Action::Duplicate()
{   CVO_ENTER
    Cvo_Action *r = 0;
    Cvo_Action *a = this;                       
    while (a) {
	Cvo_Action *n = new Cvo_Action(&r);
	*n = *a;
	a = a->next;
    }                         
    CVO_RETURN(r)
}

void
Cvo_Action::Delete(Cvo_Action **root)
{   CVO_ENTER
    if (*root == this) {
        *root = next;
        if (next)
            next->prev = prev;
    } else if (next) {
        prev->next = next;
        next->prev = prev;
    } else {
        prev->next = 0;
        (*root)->prev = prev;
    }
    delete [] symbolic_name;
    for (int i = 0; i < numparams; i++)
        delete params[i];
    delete [] params;
    delete this;
    CVO_VOID_RETURN
}

void
Cvo_Action::Interrogate()
{   CVO_ENTER
    fprintf(stderr, "\t%s(", symbolic_name);
    for (int i = 0; i < numparams; i++)
	fprintf(stderr,"%s%s", i ? ", " : "", params[i]);
    fprintf(stderr, ")\n");
    CVO_VOID_RETURN
}

void
Cvo_Action::AddList(char *string, int len)
{   CVO_ENTER

    while (isspace(*string)) {
	++string;
	--len;
    }

    char *e = string + len;

    while (len > 0 && isspace(string[len - 1]))
	--len;

    if (numparams++ == 0) {
        params = new char *[2];
    } else {
        char **np = new char *[numparams+1];
	for (int k = 0; k < numparams-1; ++k)
	    np[k] = params[k];
        delete [] params;
        params = np;
    }
    params[numparams - 1] = new char[len + 1];

    if (len)
	strncpy(params[numparams - 1], string, len);
    params[numparams - 1][len] = '\0';

    params[numparams] = 0;
    CVO_VOID_RETURN
}

int
Cvo_Action::Parse(char *string)
{   CVO_ENTER
    char *start;

    while (isspace(*string))
        string++;

    start = string;

    while (*string && *string != '(')
	++string;
    if (*string != '(')
        CVO_RETURN(False)			// Error! no paren included.

    symbolic_name = new char[string - start + 1];
    strncpy(symbolic_name, start, string - start);
    symbolic_name[string - start] = '\0';

    //
    // Get the arguments, if any 
    //
    start = ++string;
    while (*string && *string != ')') {
        if (*string == ',') {		// time for next argument
            AddList(start, string - start);
	    start = ++string;
        } else {
	    ++string;
        }
    }

    if (start != string)
	AddList(start, string - start);

    if (*string != ')') {
        delete [] symbolic_name;
        symbolic_name = NULL;
        CVO_RETURN(False)		// Error! no closing paren included.
    }
    CVO_RETURN(True)
}

void
Cvo_Action::Bind(Cvo_HandleFunction *map)
{   CVO_ENTER
    if (function == 0 && !strcmp(map->symbol, symbolic_name))
	function = map;
}
