//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Application.cc,v 1.4 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Application.h++>
#include <Cvo/Confirm.h++>

static Cvo_Default def[] = {
        "*CvoApplication.Chamfer:0",
        "*CvoApplication.LayoutPad:0",
        "*CvoApplication.InternalPad:0",
        "*CvoApplication.Pad:0",
        "*CvoApplication.BorderWidth:0",
};

static Cvo_MenuItem file_menu [] = {
    { CvoM_Quit,	Cvo_MenuQuit, },
    { 0, },
};

static Cvo_MenuBarList menu_bar [] = {
    { CvoMB_File,	file_menu, },
    { 0, },
};

Cvo_Application::Cvo_Application(char *n)
	       : Cvo_Window(n, "CvoApplication", Cvo_MAINWINDOW)
{
    _Init();
}

Cvo_Application::Cvo_Application(char *n, Cvo_MenuBarList *mb)
	       : Cvo_Window(n, "CvoApplication", Cvo_MAINWINDOW)
{
    _Init(mb);
}

CONSTRUCTORS(Cvo_Application, Cvo_Window, "CvoApplication")
CONSTRUCTORS_1ARG(Cvo_Application, Cvo_Window, "CvoApplication", Cvo_MenuBarList *)

void
Cvo_Application::_Init()
{   CVO_ENTER
    type = CvoT_Application;
    VerticalChildren();
    new Cvo_MenuBar("menu-bar", this, menu_bar);
    Register(CvoDeleteWindowEvent, Cvo_MenuQuit);
    CVO_VOID_RETURN
}

void
Cvo_Application::_Init(Cvo_MenuBarList *mb)
{   CVO_ENTER
    type = CvoT_Application;
    VerticalChildren();
    if (menu_bar)
	bar = new Cvo_MenuBar("menu-bar", this, mb);
    else
	bar = 0;
    Register(CvoDeleteWindowEvent, Cvo_MenuQuit);
    CVO_VOID_RETURN
}

void
Cvo_MenuQuit(Cvo_Object *w, XEvent *, void *)
{   CVO_ENTER

    if (w->RootObject()->Unmapped()
	||!w->RootObject()->GetResourceTruth("quitConfirm", "QuitConfirm", True)
        || Cvo_Confirm(CvoC_ReallyQuit, w->RootObject()))
        Cvo_Exit(0);
    CVO_VOID_RETURN
}

void
Cvo_MenuDismiss(Cvo_Object *w, XEvent *, void *)
{   CVO_ENTER

    delete w->RootObject();
    CVO_VOID_RETURN
}
