//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Base.cc,v 1.8 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <memory.h>
#if	defined(__NEED_BSTRING__)
#include <bstring.h>
#endif
#if	defined(__NEED_BZERO_DEF__)
extern "C" int bzero(char *, unsigned int);
#endif

Cvo_DisplayList * Cvo_DisplayList::root = 0;
Cvo_Base _Cvo_Base;

static void Cvo_InputEventHandler(EvIOEvent *, void *);

//
// Number of buttons pressed based on xbutton.state (used in _Includes.h++)
//
extern CARD8 _cvo_butbitcnt[] =
	{ 0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4,
	  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, };

Cvo_Atom CvoA_PRIMARY;
Cvo_Atom CvoA_STRING;
Cvo_Atom CvoA_SELECTION;

Cvo_DisplayList::Cvo_DisplayList(Display *_dpy)
{   CVO_ENTER

    if (!CvoA_PRIMARY.Initialized()) {
	CvoA_PRIMARY = "PRIMARY";
	CvoA_STRING = "STRING";
	CvoA_SELECTION = "CUT_BUFFER0";
    }
    dpy = _dpy;
    if (next = root)
        root->prev = this;
    prev = 0;
    root = this;
    refcnt = 1;
    main = 0;
    fonts = 0;
    accelerators = 0;
    modifiermap = 0;
#if !defined(X11R4)
    input_method = 0;
#endif
    ReadResources();
    associatedData[CvoA_PRIMARY] = XInternAtom(dpy, "PRIMARY", False);
    associatedData[CvoA_STRING] = XInternAtom(dpy, "STRING", False);
//  associatedData[CvoA_SELECTION] = XInternAtom(dpy, "_XT_SELECTION_0", False);
    associatedData[CvoA_SELECTION] = XInternAtom(dpy, "CUT_BUFFER0", False);

    protocols = new Atom[int(CvoP_LAST)];

    protocols[CvoP_DELETE_WINDOW] = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
    protocols[CvoA_MOTIF_WM_HINTS] = XInternAtom(dpy, _XA_MOTIF_WM_HINTS, False);
#if 0
    protocols[CvoA_MOTIF_WM_MESSAGES] = XInternAtom(dpy, _XA_MOTIF_WM_MESSAGES, False);
    protocols[CvoA_MOTIF_WM_OFFSET] = XInternAtom(dpy, _XA_MOTIF_WM_OFFSET, False);
    protocols[CvoA_MOTIF_WM_MENU] = XInternAtom(dpy, _XA_MOTIF_WM_MENU, False);
    protocols[CvoA_MOTIF_BINDINGS] = XInternAtom(dpy, _XA_MOTIF_BINDINGS, False);
#endif

    loadingfont = False;
    ineventloop = False;
    kbdgrabbed = False;
    mousegrabbed = False;
    focus = 0;
    colors = 0;
    clicktotype = False;
    clickrate = GetResourceInt("multiClickTime", "MultiClickTime", 250);
    clickmove = GetResourceInt("multiClickDistance", "MultiClickDistance", 3);

    fwindow = 0;
    revert_to = 0;

    tt_procid = 0;
    tt_refcnt = 0;
    CVO_VOID_RETURN
}

Cvo_DisplayList::~Cvo_DisplayList()
{   CVO_ENTER
    delete ei;
    if (next)
        next->prev = prev;
    if (prev)
        prev->next = next;
    else
        root = next;
    CVO_DONE
}

int
Cvo_DisplayList::Remove(Display *_dpy)
{   CVO_ENTER
    Cvo_DisplayList *d = Cvo_DisplayList::root;
    while (d && d->dpy != _dpy)
        d = d->next;
    if (d) {
        if (!--d->refcnt) {
            delete d;
            CVO_RETURN(0)
        }
    }
    CVO_RETURN(1)
}

int
Cvo_DisplayList::Add(Display *_dpy)
{   CVO_ENTER
    Cvo_DisplayList *d = Cvo_DisplayList::root;
    while (d && d->dpy != _dpy)
        d = d->next;
    if (d) {
        d->refcnt++;
    } else {
        d = new Cvo_DisplayList(_dpy);
	d->ei = new EvInputEvent(ConnectionNumber(_dpy), Cvo_InputEventHandler,
			         _dpy);
    }
    CVO_RETURN(d->refcnt - 1)
}

Display *
Cvo_DisplayList::FindDisplay(int fd)
{   CVO_ENTER
    Cvo_DisplayList *d = Cvo_DisplayList::root;
    while (d && ConnectionNumber(d->dpy) != fd)
        d = d->next;
    CVO_RETURN(d ? d->dpy : 0)
}

Cvo_DisplayList *
Cvo_DisplayList::FindDisplayList(Display *dpy)
{   CVO_ENTER
    Cvo_DisplayList *d = Cvo_DisplayList::root;
    while (d && d->dpy != dpy)
        d = d->next;
    CVO_RETURN(d)
}

//
// Clean up after losing focus
//
void
Cvo_DisplayList::OutFocus()
{
    Cvo_Object *obj = focus;

    if (obj && obj->infocus) {
	Cvo_AnyEvent ev;
	obj->infocus = False;
	obj->LoseFocus();
	obj->SendEvent(CvoFocusOutEvent, &ev);
    }
}

//
// Do what we need to do if we get focus
//
void
Cvo_DisplayList::InFocus(Cvo_Object *obj)
{
    Cvo_AnyEvent ev;

    focus = obj->focus ? obj->focus : obj;
    focus->infocus = True;
    focus->FocusInput();
    focus->SendEvent(CvoFocusInEvent, &ev);

    obj->RootObject()->focus = obj;
}

//
// GiveFocus() is used to try and give the focus to a new window
//
void
Cvo_DisplayList::GiveFocus(Cvo_Object *obj, int)
{
    if (!obj->Mapped() || !obj->IsValid() || (focus == obj && focus->infocus))
	return;

    //
    // Check to see if there is some HoldWindow on one of our parents,
    // If so, we can't take focus.
    //
    for (Cvo_Object *o = obj; o; o = o->Parent()) {
	if (o->holder && o->holder->Mapped())
	    return;
    }

    if (focus) {
    	OutFocus();
	focus = 0;
    }

    if (obj->Inputonly())
	return;

    InFocus(obj);
    XFlush(obj->Dpy());
}

void
Cvo_DisplayList::BRelease(Cvo_Object *obj, _Cvo_XButtonEvent *event)
{
        if (event->button > 0 && event->button < 6)
            buttons[event->button-1].Release(obj, event);
	else {
	    event->count = 0;
	    event->multiclick = False;
	}
}

void
Cvo_DisplayList::BCount(Cvo_Object *obj, _Cvo_XButtonEvent *event)
{
        if (event->button > 0 && event->button < 6)
            buttons[event->button-1].Count(obj, event);
	else {
	    event->count = 0;
	    event->multiclick = False;
	}
}

void
_Cvo_ButtonData::Release(Cvo_Object *obj, _Cvo_XButtonEvent *event)
{
	if (lastobject == obj) {
		event->count = count;
		event->multiclick = multiclick;
	} else {
		event->count = 0;
		event->multiclick = False;
	}
        lastobject = obj;
        lastrelease = event->time;
        lastx = event->x;
        lasty = event->y;
        laststate = (event->state | (1 << (event->button + 7)));
}

void
_Cvo_ButtonData::Count(Cvo_Object *obj, _Cvo_XButtonEvent *event)
{
	int cm = obj->DisplayList()->ClickMove();

        if (lastobject == obj &&
            event->time - lastrelease < obj->DisplayList()->ClickRate() &&
            laststate == (event->state | (1 << (event->button + 7))) &&
            event->x - lastx > -cm &&
            event->x - lastx < cm &&
            event->y - lasty > -cm &&
            event->y - lasty < cm) {
		if (int(++count) >  obj->maxbuttoncnt)
		    count = 0;
		multiclick = True;
        } else {
            lastobject = 0;
            count = 0;
	    multiclick = False;
        }
	event->count = count;
	event->multiclick = multiclick;
}

Cvo_Base::Cvo_Base()
{   CVO_ENTER
    FD_ZERO(&selectMask);
    InstanceName = 0;
    ProgramName = 0;
    ClassName = 0;
    ResourceName = 0;
    DisplayName = 0;
    rdb = 0;
    ddb = 0;
    XrmInitialize();    // Pretty early... before main
    CVO_VOID_RETURN
}

Cvo_DisplayList *
Cvo_Base::AddDisplay(Display *dpy)
{   CVO_ENTER
    Cvo_DisplayList::root->Add(dpy);
    CVO_RETURN(FindDisplayList(dpy))
}
void
Cvo_Base::RemoveDisplay(Display *dpy)
{   CVO_ENTER
    Cvo_DisplayList::root->Remove(dpy);
    CVO_VOID_RETURN
}

Display *
Cvo_Base::FindDisplay(int fd)
{   CVO_ENTER
    CVO_RETURN(Cvo_DisplayList::root->FindDisplay(fd))
}

Cvo_DisplayList *
Cvo_Base::FindDisplayList(Display *dpy)
{   CVO_ENTER
    CVO_RETURN(Cvo_DisplayList::root->FindDisplayList(dpy))
}

extern Cvo_Base _Cvo_Base;

static void
Cvo_InputEventHandler(EvIOEvent *, void *d)
{   CVO_ENTER
    XEvent ev;
    do {
	XNextEvent((Display *)d, &ev);
	_Cvo_event(&ev);
    } while (XPending((Display *)d));
    CVO_VOID_RETURN
}

void
Cvo_FlushDisplays()
{   CVO_ENTER
    Cvo_DisplayList *d = Cvo_DisplayList::root;

    while (d) {
	XFlush(d->Dpy());
        d = d->Next();
    }
    CVO_VOID_RETURN
}

void
Cvo_ScanDisplays()
{   CVO_ENTER
    BOOL r;

    do {
	Cvo_DisplayList *d = Cvo_DisplayList::root;

	r = False;
	while (d) {
	    XFlush(d->Dpy());
	    d->ineventloop = True;
	    while (XPending(d->Dpy())) {
		XEvent ev;
		XNextEvent(d->Dpy(), &ev);
		_Cvo_event(&ev);
		r = True;
	    }
	    d->ineventloop = False;
	    d = d->Next();
	}
    } while (r);
    CVO_VOID_RETURN
}
