//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Buffer.cc,v 1.6 1994/08/31 18:43:06 prb Exp $"); }

#include <Cvo/_ctype.h>
#include <stdlib.h>
#include <string.h>
#include <Cvo/_Machine.h++>
#include <Cvo/Buffer.h++>
#include <Cvo/util.h++>

Cvo_CharacterBuffer::Cvo_CharacterBuffer()      
{   CVO_ENTER
    usenarrow = 0;
    usewide = 0;
    CVO_VOID_RETURN
}

Cvo_CharacterBuffer::Cvo_CharacterBuffer(const char *s)
{   CVO_ENTER
    usenarrow = 0;
    usewide = 0;
    Set(s, -1);
    CVO_VOID_RETURN
}

Cvo_CharacterBuffer &
Cvo_CharacterBuffer::operator = (const Cvo_CharacterBuffer &rhs)
{   CVO_ENTER
    usenarrow = 0;
    usewide = 0;
    if (rhs.usenarrow) {
	Set(rhs.narrow.Value(), rhs.narrow.Length());
    } else {
	Set(rhs.wide.Value(), rhs.wide.Length());
    }
    return(*this);
}

Cvo_CharacterBuffer &
Cvo_CharacterBuffer::operator = (const char *rhs)
{   CVO_ENTER
    Set(rhs, -1);
    return(*this);
}

Cvo_CharacterBuffer &
Cvo_CharacterBuffer::operator = (const wchar_t *rhs)
{   CVO_ENTER
    Set(rhs, -1);
    return(*this);
}

Cvo_CharacterBuffer::Cvo_CharacterBuffer(const char *s, int len)
{   CVO_ENTER
    usenarrow = 0;
    usewide = 0;
    Set(s, len);
    CVO_VOID_RETURN
}

Cvo_CharacterBuffer::Cvo_CharacterBuffer(const wchar_t *s, int len)
{   CVO_ENTER
    usenarrow = 0;
    usewide = 0;
    Set(s, len);
    CVO_VOID_RETURN
}

Cvo_CharacterBuffer::~Cvo_CharacterBuffer()      
{   CVO_ENTER
    // This gets rid of a warning about ~Cvo_CharacterBuffer being to
    // big to inline...
    CVO_DONE
}

void
Cvo_CharacterBuffer::Narrow::Set(const char *s, int len)
{   CVO_ENTER
    if (len == -1)
	len = strlen(s);
    if (len < 0)
	len = 0;
    if (s == value) {
	length = len;
	CVO_VOID_RETURN
    }
    if (len + 1> maxlen) {
	delete [] value;
	value = new char[maxlen = len + 1];
    }
    length = len;
    if (length)
	strncpy(value, s, length);
    value[length] = 0;
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Narrow::Set(const wchar_t *s, int len)
{   CVO_ENTER
    if (len == -1) {
	len = 0;
	while (s[len])
	    ++len;
    }

    if (len < 0)
	len = 0;

    if (len + 1 > maxlen) {
	delete [] value;
	value = new char[maxlen = len + 1];
    }

    if (s[len]) {
	static wchar_t *tmpstr;
	static int tmpstrlen = 0;

	if (len >= tmpstrlen) {
	    delete tmpstr;
	    tmpstrlen = len + 1;
	    tmpstr = new wchar_t [ tmpstrlen];
	}
	memcpy(tmpstr, s, len * sizeof(wchar_t));
	tmpstr[len] = 0;
	s = tmpstr;
		
    }
    length = _Cvo_wcstombs(&value, s, &maxlen);
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Narrow::Append(const char *s, int len)
{   CVO_ENTER
    if (len == -1)
	len = strlen(s);
    if (len < 0)
	len = 0;

    if (length + len + 1 > maxlen) {
	char *nv = new char[maxlen = length + len + 1];
	memcpy(nv, value, length);
	delete [] value;
	value = nv;
    }
    memcpy(value + length, s, len);
    length += len;
    value[length] = 0;
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Narrow::Append(const wchar_t *s, int len)
{   CVO_ENTER
    if (len == -1) {
	len = 0;
	while (s[len])
	    ++len;
    }

    if (len < 0)
	len = 0;

    if (length + len + 1 > maxlen) {
	char *nv = new char[maxlen = length + len + 1];
	memcpy(nv, value, length);
	delete [] value;
	value = nv;
    }
    if (s[len]) {
	static wchar_t *tmpstr;
	static int tmpstrlen = 0;

	if (len >= tmpstrlen) {
	    delete tmpstr;
	    tmpstrlen = len + 1;
	    tmpstr = new wchar_t [ tmpstrlen];
	}
	memcpy(tmpstr, s, len * sizeof(wchar_t));
	tmpstr[len] = 0;
	s = tmpstr;
		
    }
    int nl = _Cvo_wcstombs(&value, length, s, &maxlen);
    length += nl;
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Narrow::Insert(int col, const char *s, int len)
{   CVO_ENTER

    if (len == -1)
	len = strlen(s);
    if (len < 0)
	len = 0;

    if (length + len + 1 > maxlen) {
	char *nv = new char[maxlen = length + len + 1];
	memcpy(nv, value, length);
	delete [] value;
	value = nv;
    }
    if (col >= length)
	col = length;
    else
	memmove(value + col + len, value + col, length - col);
    memcpy(value + col, s, len);
    length += len;
    value[length] = 0;
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Narrow::Delete(int col, int len)
{   CVO_ENTER

    if (len <= 0)
	return;

    if (len >= length) {
	length = 0;
	if (value)
	    value[length] = 0;
    }
    if (col + len < length) {
	memmove(value + col, value + col + len, length - (col+len));
	length -= len;
    } else
	length = col;
    value[length] = 0;
    CVO_VOID_RETURN
}

wchar_t Cvo_CharacterBuffer::Wide::null = 0;

void
Cvo_CharacterBuffer::Wide::Set(const wchar_t *s, int len)
{   CVO_ENTER
    if (len == -1) {
	len = 0;
	while (s[len])
	    ++len;
    }
    if (len < 0)
	len = 0;
    if (s == value) {
	length = len;
	CVO_VOID_RETURN
    }
    if (len + 1> maxlen) {
	delete [] value;
	value = new wchar_t[(maxlen = len + 1) + 1];
    }
    length = len;

    wchar_t *w = value;
    while (len-- > 0)
	*w++ = *s++;
    *w = 0;
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Wide::Set(const char *s, int len)
{   CVO_ENTER
    if (len == -1)
	len = strlen(s);
    if (len < 0)
	len = 0;

    if (len + 1 > maxlen) {
	delete [] value;
	value = new wchar_t[(maxlen = len + 1) + 1];
    }

    if (s[len]) {
	static char *tmpstr;
	static int tmpstrlen = 0;

	if (len >= tmpstrlen) {
	    delete tmpstr;
	    tmpstrlen = len + 1;
	    tmpstr = new char [ tmpstrlen];
	}
	memcpy(tmpstr, s, len * sizeof(char));
	tmpstr[len] = 0;
	s = tmpstr;
		
    }
    length = _Cvo_mbstowcs(&value, s, &maxlen);
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Wide::Append(const wchar_t *s, int len)
{   CVO_ENTER

    if (len == -1) {
	len = 0;
	while (s[len])
	    ++len;
    }
    if (len < 0)
	len = 0;
    if (s == value) {
	length = len;
	CVO_VOID_RETURN
    }
    if (length + len + 1> maxlen) {
	wchar_t *nv = new wchar_t[(maxlen = length + len + 1) + 1];
	memcpy(nv, value, length * sizeof(wchar_t));
	delete [] value;
	value = nv;
    }

    memcpy(value + length, s, len * sizeof(wchar_t));
    length += len;
    value[length] = 0;
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Wide::Append(const char *s, int len)
{   CVO_ENTER
    if (len == -1)
	len = strlen(s);
    if (len < 0)
	len = 0;

    if (length + len + 1 > maxlen) {
	wchar_t *nv = new wchar_t[(maxlen = length + len + 1) + 1];
	memcpy(nv, value, length * sizeof(wchar_t));
	delete [] value;
	value = nv;
    }

    if (s[len]) {
	static char *tmpstr;
	static int tmpstrlen = 0;

	if (len >= tmpstrlen) {
	    delete tmpstr;
	    tmpstrlen = len + 1;
	    tmpstr = new char [ tmpstrlen];
	}
	memcpy(tmpstr, s, len * sizeof(char));
	tmpstr[len] = 0;
	s = tmpstr;
		
    }

    int nl = _Cvo_mbstowcs(&value, length, s, &maxlen);
    length += nl;
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Wide::Insert(int col, const wchar_t *s, int len)
{   CVO_ENTER

    if (len == -1) {
	len = 0;
	while (s[len])
	    ++len;
    }

    if (len < 0)
	len = 0;

    if (length + len + 1 > maxlen) {
	wchar_t *nv = new wchar_t[maxlen = length + len + 1];
	memcpy(nv, value, length * sizeof(wchar_t));
	delete [] value;
	value = nv;
    }
    if (col >= length)
	col = length;
    else
	memmove(value + col + len, value + col,
		(length - col) * sizeof(wchar_t));
    memcpy(value + col, s, len * sizeof(wchar_t));
    length += len;
    value[length] = 0;
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::Wide::Delete(int col, int len)
{   CVO_ENTER

    if (len <= 0)
	return;

    if (len >= length) {
	length = 0;
	if (value)
	    value[length] = 0;
    }
    if (col + len < length) {
	memmove(value + col, value + col + len,
		(length - (col+len)) * sizeof(wchar_t));
	length -= len;
    } else
	length = col;
    value[length] = 0;
    CVO_VOID_RETURN
}
