//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
#if	!defined(_CVO_WINDOW_TO_PIXMAP_)
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Chamfer.cc,v 1.6 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#else
#include <Cvo/Pixmap.h++>
#define	Cvo_Window	Cvo_Pixmap
#define	XWidth		Width
#define	XHeight		Height
#endif


#if	!defined(_CVO_WINDOW_TO_PIXMAP_)
void
Cvo_Window::_drawChamfer()
{   CVO_ENTER
    XSegment	s[32];

    int r = chamfer;
    int down = 0;

    if (r == 0)
	CVO_VOID_RETURN

    if (r > 32)
	r = 32;

    Cvo_Lock lock;

    if (!sunken && etched) {
	if (r > 1 && (r & 1))
	    _clearChamfer();
	r >>= 1;
	if (!r)
	    r = 1;
    }

    int w = XWidth();
    int h = XHeight();
    int i = 0;

    if (haveoutline) {
	if (drawoutline) {
	    SetForeground(Foreground());
	} else if (Parent() && Parent()->ToWindow()) {
	    SetForeground(Parent()->ToWindow()->CurrentBackground());
    	} else {
	    SetForeground(Background());
    	}
	XDrawRectangle(Dpy(), Object(), gc, i, i, w-1, h-1);

	++i;
	w -= 2;
	h -= 2;
    }

    if (moat) {
	int ms = moatEdge + moatChamfer + moat;
    	
    	Cvo_Color c = Parent() && Parent()->ToWindow() ?
		      Parent()->ToWindow()->CurrentBackground() :
		      Background();

	if (CurrentBackground() != c) {
	    SetForeground(c);
	    XFillRectangle(Dpy(), Object(), gc, i, i, w, ms);
	    XFillRectangle(Dpy(), Object(), gc, i, h - ms + i, w, ms);
	    XFillRectangle(Dpy(), Object(), gc, i, i, ms, h);
	    XFillRectangle(Dpy(), Object(), gc, w - ms + i, i, ms, h);
	}
	w -= 2 * moatEdge;
	h -= 2 * moatEdge;
	i += moatEdge;
	if (!hidemoat) {
	    _sdraw(c->Lower(), moatChamfer, s, 0, i, i, w, h);
	    _sdraw(c->Upper(), moatChamfer, s, 1, i, i, w, h);
    	}
	w -= 2 * (moatChamfer + moat);
	h -= 2 * (moatChamfer + moat);
	i += moatChamfer + moat;
    }

    if (1 || r > i) {
	if (!sunken && etched) {
	    _edraw(background->Lower(), r, s, 0, i, i, w, h);
	    _edraw(background->Upper(), r, s, 1, i, i, w, h);
	} else {
	    _sdraw(background->Upper(), r, s, sunken, i, i, w, h);
	    _sdraw(background->Lower(), r, s, !sunken, i, i, w, h);
	}
    }
else printf("%d <= %d\n", r, i);

    CVO_VOID_RETURN
}
#endif

void
Cvo_Window::DrawRaisedChamfer(int r, int x, int y, int w, int h, const Cvo_Color &c)
{   CVO_ENTER

    if (c.Empty())
	CVO_VOID_RETURN

    if (r < 1)
	CVO_VOID_RETURN
    if (r > 32)
	r = 32;

    XSegment	s[32];

    x -= r;
    y -= r;
    w += 2 * r;
    h += 2 * r;

#if	!defined(_CVO_WINDOW_TO_PIXMAP_)
    ToXCoord(&x, &y);
#endif
    _sdraw(c->Upper(), r, s, 0, x, y, w, h);
    _sdraw(c->Lower(), r, s, 1, x, y, w, h);
    CVO_VOID_RETURN
}

void
Cvo_Window::DrawLoweredChamfer(int r, int x, int y, int w, int h, const Cvo_Color &c)
{   CVO_ENTER

    if (c.Empty())
	CVO_VOID_RETURN

    XSegment	s[32];

    x -= r;
    y -= r;
    w += 2 * r;
    h += 2 * r;


#if	!defined(_CVO_WINDOW_TO_PIXMAP_)
    ToXCoord(&x, &y);
#endif

    if (r < 1)
	CVO_VOID_RETURN
    if (r > 32)
	r = 32;

    _sdraw(c->Upper(), r, s, 1, x, y, w, h);
    _sdraw(c->Lower(), r, s, 0, x, y, w, h);
    CVO_VOID_RETURN
}

void
Cvo_Window::DrawEtchedChamfer(int r, int x, int y, int w, int h, const Cvo_Color &c)
{   CVO_ENTER

    if (c.Empty())
	CVO_VOID_RETURN

    XSegment	s[32];

    x -= r;
    y -= r;
    w += 2 * r;
    h += 2 * r;

#if	!defined(_CVO_WINDOW_TO_PIXMAP_)
    ToXCoord(&x, &y);
#endif

    if (r < 1)
	CVO_VOID_RETURN
    if (r > 32)
	r = 32;

    _edraw(c->Lower(), r, s, 0, x, y, w, h);
    _edraw(c->Upper(), r, s, 1, x, y, w, h);
    CVO_VOID_RETURN
}

void
Cvo_Window::ClearChamfer(int r, int x, int y, int w, int h)
{   CVO_ENTER
    XSegment	s[32];

    x -= r;
    y -= r;
    w += 2 * r;
    h += 2 * r;

#if	!defined(_CVO_WINDOW_TO_PIXMAP_)
    ToXCoord(&x, &y);
#endif

    if (r < 1)
        CVO_VOID_RETURN
    if (r > 32)
        r = 32;

    _sdraw(CurrentBackground(), r, s, 0, x, y, w, h);
    _sdraw(CurrentBackground(), r, s, 1, x, y, w, h);
    CVO_VOID_RETURN
}

#if	!defined(_CVO_WINDOW_TO_PIXMAP_)
void
Cvo_Window::_clearChamfer()
{   CVO_ENTER
    XSegment	s[32];

    int r = chamfer;

    if (r == 0)
	CVO_VOID_RETURN

    if (r > 32)
	r = 32;

    r += moat + moatChamfer + moatEdge;

    Cvo_Lock lock;

    if (haveoutline)
	++r;

    _sdraw(CurrentBackground(), r, s, 0);
    _sdraw(CurrentBackground(), r, s, 1);

    CVO_VOID_RETURN
}
#endif

void
Cvo_Window::_sdraw(const Cvo_Color &c, int r, XSegment *s, int t, int sx, int sy, int w, int h)
{   CVO_ENTER
    int x;

    if (!w)
	w = XWidth();
    if (!h)
	h = XHeight();

    if (c == CurrentBackground() && c->UsePixmap()) {
	if (t) {
	    XClearArea(Dpy(), Object(), sx, sy + h - r, w, r, False);
	    XClearArea(Dpy(), Object(), sx + w - r, sy, r, h, False);
	} else {
	    XClearArea(Dpy(), Object(), sx, sy, w, r, False);
	    XClearArea(Dpy(), Object(), sx, sy, r, h, False);
	}
	CVO_VOID_RETURN
    }
    SetForeground(c);
    if (Monochrome() && c->UsePixmap())
	SetForegroundOnly(CurrentForeground());

    for (x = 0; x < r; ++x) {
	if (t) {
	    s[x].x1 = w - 1 - x + sx;
	    s[x].x2 = w - 1 - x + sx;
	} else {
	    s[x].x1 = x + sx;
	    s[x].x2 = x + sx;
	}
	s[x].y1 = x + sy;
	s[x].y2 = h - x - 1 + sy;
    }
    XDrawSegments(Dpy(), Object(), gc, s, r);
    
    for (x = 0; x < r; ++x) {
	s[x].x1 = x + sx;
	s[x].x2 = w - x - 1 + sx;
	if (t) {
	    s[x].y1 = h - 1 - x + sy;
	    s[x].y2 = h - 1 - x + sy;
	} else {
	    s[x].y1 = x + sy;
	    s[x].y2 = x + sy;
	}
    }
    XDrawSegments(Dpy(), Object(), gc, s, r);
    CVO_VOID_RETURN
}

void
Cvo_Window::_edraw(const Cvo_Color &c, int r, XSegment *s, int t, int sx, int sy, int w, int h)
{   CVO_ENTER
    int x;

    if (!w)
	w = XWidth();
    if (!h)
	h = XHeight();

    SetForeground(c);
    if (Monochrome() && c->UsePixmap())
	SetForegroundOnly(CurrentForeground());

    //
    // Top line
    //
    for (x = 0; x < r; ++x) {
	s[x].y1 = x + sy;
	s[x].x1 = 0 + sx;
	s[x].x2 = w - x + sx;
	if (t) {
	    s[x].x1 += r;
	    s[x].y1 += r;
	    s[x].x2 -= (r+x);
	}
	s[x].y2 = s[x].y1;
    }
    XDrawSegments(Dpy(), Object(), gc, s, r);
    //
    // Bottom line
    //
    for (x = 0; x < r; ++x) {
	s[x].y1 = h - x - 1 + sy;
	s[x].x1 = x + 1 + sx;
	s[x].x2 = w - 1 + sx;
	if (!t) {
	    s[x].x1 += r;
	    s[x].y1 -= r;
	    s[x].x2 -= r;
	}
	s[x].y2 = s[x].y1;
    }
    XDrawSegments(Dpy(), Object(), gc, s, r);
    //
    // Right line
    //
    for (x = 0; x < r; ++x) {
	s[x].y1 = 0 + sy;
	s[x].x1 = x + sx;
	s[x].y2 = h - x + sy;
	if (t) {
	    s[x].y1 += r;
	    s[x].x1 += r;
	    s[x].y2 -= (r+1);
	}
	s[x].x2 = s[x].x1;
    }
    XDrawSegments(Dpy(), Object(), gc, s, r);
    //
    // Left line
    //
    for (x = 0; x < r; ++x) {
	s[x].y1 = x+1 + sy;
	s[x].x1 = w - 1 - x + sx;
	s[x].y2 = h - 1 + sy;
	if (!t) {
	    s[x].y1 += (r-1);
	    s[x].y2 -= r;
	    s[x].x1 -= r;
	}
	s[x].x2 = s[x].x1;
    }
    XDrawSegments(Dpy(), Object(), gc, s, r);
    CVO_VOID_RETURN
}
