//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Create.cc,v 1.8 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/Image.h++>

//
// These are the two basic create routines
// Note that they do not call each other as one creates an InputOutput
// window while the other creates an InputOnly window.
//

static void
blowoff(Cvo_Object *obj, XEvent *, void *)
{
    delete obj;
}

void
Cvo_Window::_Create()
{   CVO_ENTER
    _cvo_debug(CvoDebug_Create, "Cvo_Create(%s, %s)\n", Name(), Class());

    Window pwin;
    XSetWindowAttributes xat;
    CARD32 xatmask = 0;
    XGCValues xgcv;
    char *xrp;

    if (Object())
	CVO_VOID_RETURN
    Cvo_Lock lock;

    Cvo_Window *wp = parent ? parent->ToWindow() : 0;
    Cvo_LayoutWindow *lp = parent ? parent->ToLayoutWindow() : 0;


    if (parent) {
	if (lp && !lp->Win())
	    lp->Create();
	pwin = parent->Win();
	xat.override_redirect = True;
    } else {
	pwin = DefaultRootWindow(Dpy());
	xat.override_redirect = override ? True : False;
    }

    xatmask = CWOverrideRedirect;

    if (frame) {
	if (wp) {
	    sunken = wp->sunken;
	    background = wp->background;
	    foreground = wp->foreground;
	    border = wp->border;
	}
    }

    xatmask |= CWBackPixel|CWBorderPixel;

    if (background->UsePixmap()) {
	if (wp && wp->Background() == background)
	    xat.background_pixmap = ParentRelative;
	else
	    xat.background_pixmap = background->GetPixmap();
	xatmask &= ~CWBackPixel;
	xatmask |= CWBackPixmap;
    } else
	xat.background_pixel = background->Pixel();

    if (border->UsePixmap()) {
	xat.border_pixmap = border->GetPixmap();
	xatmask &= ~CWBorderPixel;
	xatmask |= CWBorderPixmap;
    } else
	xat.border_pixel = border->Pixel();

    xgcv.graphics_exposures = False;

    xgcv.background = background->UsePixmap()
			? White()
			: background->Pixel();
    gc = XCreateGC(Dpy(),
		   RootWindow(Dpy(), XScreen()),
		   GCBackground|GCGraphicsExposures, &xgcv);

    if (!parent)
	raise = 0;

    if (!parent && ToLayoutWindow())
	ToLayoutWindow()->NewLayout(1);

    int LDW = layout.desired.width - 2 * verticalPad;
    if (LDW < 0)
	LDW = 0;
    int LDH = layout.desired.height - 2 * horizontalPad;
    if (LDH < 0)
	LDH = 0;

    ForceResizeWindow(width  ? width  : LDW ? LDW : horizontalPad ? 0 : 1,
		      height ? height : LDH ? LDH : verticalPad ? 0 : 1);

    if (!parent && !positioned
		&& (xrp = GetResource(_Qgeometry, _QGeometry))) {
	int x, y;
        unsigned int w, h;
        int flags = XParseGeometry(xrp, &x, &y, &w, &h);

	if (flags & (XValue|YValue)) {
	    if (!(flags & XValue))
		x = 0;
	    if (!(flags & YValue))
		y = 0;

	    ForceMoveWindow(0, 0, x, y, flags);
	}
    }

    ComputeLocation();
    int x = layout.x;
    int y = layout.y;

    if (parent)
	ToXExtCoord(&x, &y);

    //
    // Assure that X will have at least 1 pixel in height and width
    //
    if (XWidth() <= 0 && XHeight() <= 0)
	ForceResizeWindow(1 + width - XWidth(), 1 + height - XHeight());
    else if (XWidth() <= 0)
	ForceResizeWindow(1 + width - XWidth(), height);
    else if (XHeight() <= 0)
	ForceResizeWindow(width, 1 + height - XHeight());

    if (!frame && raise) {
	XSetWindowAttributes xat;

	xat.border_pixel = Black();
	xat.background_pixel = Black();

	shadow = XCreateWindow(Dpy(), pwin,
			x + raise, y + raise, XWidth(), XHeight(),
			borderWidth,
			(int)CopyFromParent,		// Depth
			InputOutput,
			CopyFromParent, 		// Visual
			CWBackPixel | CWBorderPixel, &xat);
	if (!shadow) {
	    Cvo_Failure(CvoE_WARN, CvoE_CANTOPEN,
			"Cannot create window ``%s(%s)''\n",
			Name(), Class());
	}
    }

    window = XCreateWindow(Dpy(), pwin,
			   x, y, XWidth(), XHeight(),
			   borderWidth,
			   (int)CopyFromParent,		// Depth
			   InputOutput,
			   CopyFromParent,		// Visual
			   xatmask, &xat);
    if (!Object()) {
	Cvo_Failure(CvoE_FATAL, CvoE_CANTOPEN,
		    "Cannot create window ``%s(%s)''\n",
		     Name(), Class());
    }
    InsertIntoHashList();

    //
    // Okay, try and get all the Window Manager hints set...
    //
    if (!parent) {
	XClassHint ch;
	XTextProperty win_name;
	XTextProperty icon_name;
	XSizeHints size_hints;
	XWMHints wm_hints;

	if (!parent) {
	    ch.res_name = _Cvo_Base.ResourceName;
	    ch.res_class = _Cvo_Base.ClassName;
	} else {
	    ch.res_name = Name();
	    ch.res_class = Class();
	}
	
	xrp = GetResource(_Qtitle, _QTitle, _Cvo_Base.InstanceName);
	xrp = ExpandName(xrp);
	XStringListToTextProperty(&xrp, 1, &win_name);
	delete [] xrp;

	xrp = GetResource(_QiconTitle, _QIconTitle, _Cvo_Base.InstanceName);
	xrp = ExpandName(xrp);
	XStringListToTextProperty(&xrp, 1, &icon_name);
	delete [] xrp;

	size_hints.flags = 0;
	if (GetResourceTruth("iconic", "Iconic", False))
	    wm_hints.initial_state = IconicState;
	else
	    wm_hints.initial_state = NormalState;

	wm_hints.input = True;
	// wm_hints.icon_pixmap	Pixmap
	// wm_hints.icon_mask	Pixmap
	// wm_hints.icon_window	Window
	// wm_hints.icon_x		int
	// wm_hints.icon_y		int
	// wm_hints.window_group	XID
	wm_hints.flags = InputHint | StateHint;

	iconPixmap = new Cvo_Image(this, 0, "iconPixmap");

	if (wm_hints.icon_pixmap = iconPixmap->GetPixmap(depth)) {
	    wm_hints.flags |= IconPixmapHint;

	    iconMask = new Cvo_Image(this, 0, "iconMask");
	    if (wm_hints.icon_mask = iconMask->GetPixmap(depth)) {
		wm_hints.flags |= IconMaskHint;
	    } else {
		delete iconMask;
		iconMask = 0;
	    }
	} else {
	    delete iconPixmap;
	    iconPixmap = 0;
	}

	if (xrp = GetResource("iconGeometry", "IconGeometry")) {
	    int x, y;
	    unsigned int w, h;
	    int flags = XParseGeometry(xrp, &x, &y, &w, &h);
	    if ((flags & (XValue|YValue)) == (XValue|YValue)) {
		if (flags & XNegative)
		    x += DisplayWidth(Dpy(), XScreen());
		if (flags & YNegative)
		    y += DisplayHeight(Dpy(), XScreen());
		wm_hints.icon_x = x;
		wm_hints.icon_y = y;
		wm_hints.flags |= IconPositionHint;
	    }
	}

	if (positioned) {
	    XMoveWindow(Dpy(), Object(), layout.x, layout.y);
	    size_hints.x = layout.x;
	    size_hints.y = layout.y;
	    size_hints.flags |= USPosition;
	}

	size_hints.width = XWidth();
	size_hints.height = XHeight();
	size_hints.flags |= USSize;

	wm_hints.flags |= WindowGroupHint;
	wm_hints.window_group = DisplayList()->GetGroup(this)->Object();

	if (transient) {
	    Cvo_Motif_MWM_Hints mwmh;

	    Atom mwha = DisplayList()->protocols[CvoA_MOTIF_WM_HINTS];

	    mwmh.flags = MWM_HINTS_DECORATIONS;
	    mwmh.decorations = MWM_DECOR_BORDER | MWM_DECOR_RESIZEH;
	

	    XChangeProperty(Dpy(), Object(), mwha, mwha, 32,
			    PropModeReplace, (unsigned char *)&mwmh,
			    Cvo_Motif_MWM_Hints_size);

	    Register(CvoDeleteWindowEvent, blowoff);

	    // XSetTransientForHint(Dpy(), Object(), transient->Object());
	    wm_hints.window_group = transient->Object();
	}

	XSetWMProperties(Dpy(), Object(), &win_name, &icon_name,
			 _Cvo_Base.argv, _Cvo_Base.argc, &size_hints,
			 &wm_hints, &ch);
	XFree(_xfree_t win_name.value);
	XFree(_xfree_t icon_name.value);

	SetNormalHints();
    }
    
    if (Sunken() && !DontSink())
	SelectBackground();

    selectMask |= ExposureMask | StructureNotifyMask | SubstructureNotifyMask;

    XSelectInput(Dpy(), Object(), selectMask);
    _PassOnSelectMask(selectMask);		// This should always be a NOP

    //
    // XXX -- Really should try and use parents cursor and not set it
    //        all the time.
    //
    if (!frame)
	if (xrp = GetResource(_Qcursor, _QCursor)) 
	    SetCursor(xrp);
    if (lp && cursor.Empty())
	SetCursor(lp->GetCursor());
    if (cursor.Empty())
	SetCursor("Diamond Cross");

    if (xrp = GetResource(_Qtranslations, _QTranslations))
	AddTranslations(xrp, XLATE_REPLACE);

    Bind();

    if (input_context)
	InitializeFocus();

    if (!Parent()) {
	XSetWMProtocols(Dpy(), Object(),
			DisplayList()->protocols,
			int(CvoP_LAST_PROTOCOL));
    }

    CVO_VOID_RETURN
}

void
Cvo_Window::SetIconPixmap(Cvo_Image *image)
{
    if (iconPixmap || !Win())
	return;

    XWMHints *wm;

    wm = XGetWMHints(Dpy(), Win()); 

    if (wm->icon_pixmap = image->GetPixmap(depth)) {
	iconPixmap = image;
	wm->flags |= IconPixmapHint;
	XSetWMHints(Dpy(), Win(), wm);
    }
    XFree(_xfree_t wm);
}

void
Cvo_Window::SetIconMask(Cvo_Image *image)
{
    if (iconPixmap || !Win())
	return;

    XWMHints *wm;

    wm = XGetWMHints(Dpy(), Win()); 

    if (wm->icon_mask = image->GetPixmap(depth)) {
	iconMask = image;
	wm->flags |= IconMaskHint;
	XSetWMHints(Dpy(), Win(), wm);
    }
    XFree(_xfree_t wm);
}
